/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.bizentity;

import java.math.BigDecimal;
import kd.bos.service.ctbotp.track.bizentity.CtRow;
import kd.bos.service.ctbotp.track.bizentity.CtWSRow;
import kd.bos.service.ctbotp.track.bizentity.CtWSRows;
import kd.bos.service.ctbotp.track.bizentity.NullEqualResult;

public class CtWRule {
    private CtRow parent;
    private Long ruleVerId;
    private Long ruleItemId;
    private Object cval;
    private BigDecimal val;
    private int scale;
    private CtWSRows currSourceRows = new CtWSRows(this);
    private CtWSRows historySourceRows = new CtWSRows(this);
    private CtWSRows executeSourceRows = new CtWSRows(this);
    private CtWSRows resultSourceRows = new CtWSRows(this);

    public CtWRule() {
        this.val = new BigDecimal(0L);
    }

    public CtWRule(CtWRule oldWRule) {
        this();
        this.parent = oldWRule.getParent();
        this.ruleVerId = oldWRule.getRuleVerId();
        this.ruleItemId = oldWRule.getRuleItemId();
        this.val = oldWRule.getVal();
        this.cval = oldWRule.getCVal();
        this.scale = oldWRule.getScale();
    }

    public CtRow getParent() {
        return this.parent;
    }

    public void setParent(CtRow parent) {
        this.parent = parent;
    }

    public Long getRuleVerId() {
        return this.ruleVerId;
    }

    public void setRuleVerId(Long ruleVerId) {
        this.ruleVerId = ruleVerId;
    }

    public Long getRuleItemId() {
        return this.ruleItemId;
    }

    public void setRuleItemId(Long ruleItemId) {
        this.ruleItemId = ruleItemId;
    }

    public Object getCVal() {
        return this.cval;
    }

    public void setCVal(Object cval) {
        this.cval = cval;
    }

    public BigDecimal getVal() {
        return this.val;
    }

    public void setVal(BigDecimal val) {
        this.val = val;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public CtWSRows getCurrSourceRows() {
        return this.currSourceRows;
    }

    public void setCurrSourceRows(CtWSRows currSourceRows) {
        this.currSourceRows = currSourceRows;
    }

    public CtWSRows getHistorySourceRows() {
        return this.historySourceRows;
    }

    public void setHistorySourceRows(CtWSRows historySourceRows) {
        this.historySourceRows = historySourceRows;
    }

    public CtWSRows getExecuteSourceRows() {
        return this.executeSourceRows;
    }

    public void setExecuteSourceRows(CtWSRows executeSourceRows) {
        this.executeSourceRows = executeSourceRows;
    }

    public CtWSRows getResultSourceRows() {
        return this.resultSourceRows;
    }

    public void setResultSourceRows(CtWSRows resultSourceRows) {
        this.resultSourceRows = resultSourceRows;
    }

    public String toString() {
        return "{\"ruleVerId\":" + this.ruleVerId.toString() + ",\"ruleItemId\":" + this.ruleItemId.toString() + ",\"val\":" + this.val.toString() + ",\"cval\":" + this.cval + ",\"scale\":" + String.valueOf(this.scale) + ",\"currSourceRows\":" + this.currSourceRows.toString() + ",\"historySourceRows\":" + this.historySourceRows.toString() + ",\"executeSourceRows\":" + this.executeSourceRows.toString() + ",\"resultSourceRows\":" + this.resultSourceRows.toString() + ",}";
    }

    public static CtWRule mergeHistoryRow(CtWRule currWRule, CtWRule historyWRule) {
        CtWRule merge = null;
        if (null == currWRule && null == historyWRule) {
            return merge;
        }
        if (null == currWRule) {
            merge = new CtWRule(historyWRule);
            merge.setVal(new BigDecimal(0));
            merge.setCVal(null);
            merge.getCurrSourceRows().clear();
            merge.getHistorySourceRows().clear();
            merge.getExecuteSourceRows().clear();
            merge.getResultSourceRows().clear();
            CtWRule.copyHistoryWRule(merge, historyWRule);
        } else if (null == historyWRule) {
            merge = currWRule;
            merge.getHistorySourceRows().clear();
        } else {
            merge = currWRule;
            merge.getHistorySourceRows().clear();
            CtWRule.copyHistoryWRule(merge, historyWRule);
        }
        return merge;
    }

    private static void copyHistoryWRule(CtWRule currWRule, CtWRule historyWRule) {
        for (CtWSRow ctWsRow : historyWRule.getHistorySourceRows().values()) {
            CtWSRow copyRow = new CtWSRow(ctWsRow);
            currWRule.historySourceRows.put(copyRow.getSId(), copyRow);
            currWRule.resultSourceRows.put(copyRow.getSId(), new CtWSRow(copyRow));
        }
    }

    public static boolean equalsWithoutAmount(CtWRule x, CtWRule y) {
        NullEqualResult nullEqualResult = new NullEqualResult();
        if (CtWRule.nullEquals(x, y, nullEqualResult)) {
            return nullEqualResult.getResult();
        }
        if (!x.getRuleVerId().equals(y.getRuleVerId())) {
            return false;
        }
        return x.getRuleItemId().equals(y.getRuleItemId());
    }

    private static boolean nullEquals(Object x, Object y, NullEqualResult result) {
        if (x == null && y == null) {
            result.setResult(true);
            return true;
        }
        if (x == null || y == null) {
            result.setResult(false);
            return true;
        }
        result.setResult(false);
        return false;
    }
}

