/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.distlogic;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.service.ctbotp.track.distlogic.AbstractCtCtDistributeLogic;
import kd.bos.service.ctbotp.track.distlogic.CtDistributeRow;

public class CtTopDownLogic
extends AbstractCtCtDistributeLogic {
    private BigDecimal zero = new BigDecimal(0);

    @Override
    public void Distribute() {
        ArrayList<CtDistributeRow> lstPositive = new ArrayList<CtDistributeRow>();
        ArrayList<CtDistributeRow> lstNegative = new ArrayList<CtDistributeRow>();
        for (CtDistributeRow row : this.getCtDistributeRows()) {
            if (row.getMaxAmount().compareTo(this.zero) >= 0) {
                lstPositive.add(row);
                continue;
            }
            lstNegative.add(row);
        }
        if (this.getTotalAmount().compareTo(this.zero) == 0) {
            for (CtDistributeRow row : this.getCtDistributeRows()) {
                row.setDistAmount(this.zero);
            }
        } else if (this.getTotalAmount().compareTo(this.zero) > 0) {
            this.distributeWithPriority(lstNegative, lstPositive);
        } else {
            this.distributeWithPriority(lstPositive, lstNegative);
        }
    }

    private void distributeWithPriority(List<CtDistributeRow> firsList, List<CtDistributeRow> secondList) {
        BigDecimal rowAmount;
        int rowsCount = firsList.size() + secondList.size();
        int seqForAll = 1;
        BigDecimal hadDistAmount = this.zero;
        for (CtDistributeRow item : firsList) {
            rowAmount = item.getMaxAmount();
            if (seqForAll == rowsCount || this.isOver(hadDistAmount.add(rowAmount))) {
                rowAmount = this.getTotalAmount().subtract(hadDistAmount);
            }
            item.setDistAmount(rowAmount);
            hadDistAmount = hadDistAmount.add(rowAmount);
            ++seqForAll;
        }
        for (CtDistributeRow item : secondList) {
            rowAmount = item.getMaxAmount();
            if (seqForAll == rowsCount || this.isOver(hadDistAmount.add(rowAmount))) {
                rowAmount = this.getTotalAmount().subtract(hadDistAmount);
            }
            item.setDistAmount(rowAmount);
            hadDistAmount = hadDistAmount.add(rowAmount);
            ++seqForAll;
        }
    }

    private boolean isOver(BigDecimal hadDistAmount) {
        if (this.getTotalAmount().compareTo(this.zero) >= 0) {
            return hadDistAmount.compareTo(this.getTotalAmount()) >= 0;
        }
        return hadDistAmount.compareTo(this.getTotalAmount()) <= 0;
    }
}

