/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.helper;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.ctbotp.CtBusinessFlowDataService;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.ctbotp.link.CtBillLk;
import kd.bos.entity.ctbotp.runtime.CtAllBusEntityCountInfo;
import kd.bos.entity.ctbotp.runtime.CtBFRow;
import kd.bos.entity.ctbotp.runtime.CtBFRowId;
import kd.bos.entity.ctbotp.runtime.CtBFRowLinkUpNode;
import kd.bos.logorm.LogORM;
import kd.bos.orm.ORM;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ctbotp.track.CtBFTrackerContext;
import kd.bos.service.ctbotp.track.helper.CtTrackerTypes;
import kd.bos.servicehelper.CtConvertMetaServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;

public class CtBFTrackerDbService {
    private static final String FTBILL_ID = ":FTBillId";
    private CtTrackerTypes ctTrackerTypes;
    private BillEntityType targetSubMainType;
    private Map<Long, Long> mainTableIds = new HashMap<Long, Long>();
    private Map<Long, TableDefine> tableDefines = new HashMap<Long, TableDefine>();
    private Map<Long, Map<Long, Map<CtBFRowId, CtBFRowLinkUpNode>>> sourceBFRows = new HashMap<Long, Map<Long, Map<CtBFRowId, CtBFRowLinkUpNode>>>();
    private Map<Long, Map<Long, Map<CtBFRowId, CtBFRowLinkUpNode>>> sourceBFSRows = new HashMap<Long, Map<Long, Map<CtBFRowId, CtBFRowLinkUpNode>>>();
    private Map<Long, Map<Long, Map<Long, Long>>> snapshotIds = new HashMap<Long, Map<Long, Map<Long, Long>>>();

    public CtTrackerTypes getCtTrackerTypes() {
        return this.ctTrackerTypes;
    }

    public void setCtTrackerTypes(CtTrackerTypes ctTrackerTypes) {
        this.ctTrackerTypes = ctTrackerTypes;
    }

    public BillEntityType getTargetSubMainType() {
        return this.targetSubMainType;
    }

    public void setTargetSubMainType(BillEntityType targetSubMainType) {
        this.targetSubMainType = targetSubMainType;
    }

    @Deprecated
    public List<Object> readBillTracker(Long mainTableId, Long[] billIds) {
        StringBuilder sBuilder = new StringBuilder();
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        sBuilder.append("SELECT FId ");
        sBuilder.append("FROM  ").append(this.ctTrackerTypes.getBillTrackerType().getAlias()).append(' ');
        sBuilder.append("WHERE FTTableId = ? ");
        params.add(new SqlParameter(":FTTableId", -5, (Object)mainTableId));
        if (billIds.length == 1) {
            sBuilder.append("AND FTBillId = ? ");
            params.add(new SqlParameter(FTBILL_ID, -5, (Object)billIds[0]));
        } else {
            sBuilder.append("AND FTBillId in (? ");
            params.add(new SqlParameter(":FTBillId0", -5, (Object)billIds[0]));
            for (int i = 1; i < billIds.length; ++i) {
                sBuilder.append(",?");
                params.add(new SqlParameter(FTBILL_ID + String.valueOf(i), -5, (Object)billIds[i]));
            }
            sBuilder.append(')');
        }
        ResultSetHandler<List<Object>> action = new ResultSetHandler<List<Object>>(){

            public List<Object> handle(ResultSet rs) throws Exception {
                ArrayList<Object> ids = new ArrayList<Object>(10);
                while (rs.next()) {
                    Long id = rs.getLong(1);
                    ids.add(id);
                }
                return ids;
            }
        };
        List ids = (List)DB.query((DBRoute)new DBRoute(this.ctTrackerTypes.getBillTrackerType().getDBRouteKey()), (String)sBuilder.toString(), (Object[])params.toArray(new SqlParameter[params.size()]), (ResultSetHandler)action);
        if (ids.size() == 0) {
            return new ArrayList<Object>();
        }
        IDataManager datamanager = DataManagerUtils.getDataManager((IDataEntityType)this.ctTrackerTypes.getBillTrackerType());
        List objects = datamanager.select(ids);
        return objects;
    }

    public List<Object> readBillTracker(Set<Long> sMainTableIds, Set<Long> sBillIds, Long tMainTableId, Long[] tBillIds) {
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)this.ctTrackerTypes.getBillTrackerType().getAlias(), (HintCondition[])new HintCondition[]{new HintCondition("fstableid", FilterType.in_range, sMainTableIds), new HintCondition("fsbillid", FilterType.in_range, sBillIds)});){
            List<Object> list = this.readBillTracker(tMainTableId, tBillIds);
            return list;
        }
    }

    public Set<Long> readEntryIds(Long[] billIds, EntryType entryType) {
        BillEntityType mainType = null;
        EntryType parentType = null;
        parentType = entryType instanceof SubEntryType ? (EntryType)entryType.getParent() : entryType;
        mainType = (BillEntityType)parentType.getParent();
        ResultSetHandler<Set<Long>> action = new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet<Long> ids = new HashSet<Long>(16);
                while (rs.next()) {
                    Long id = rs.getLong(1);
                    ids.add(id);
                }
                return ids;
            }
        };
        StringBuilder sql_readEntryIds = new StringBuilder();
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
        sql_readEntryIds.append("SELECT ").append(parentType.getPrimaryKey().getAlias()).append(" entryid ");
        sql_readEntryIds.append("  FROM ").append(parentType.getAlias());
        sql_readEntryIds.append(" WHERE ");
        if (billIds.length == 1) {
            sql_readEntryIds.append(mainType.getPrimaryKey().getAlias()).append(" = ? ");
            params.add(new SqlParameter(":FId", -5, (Object)billIds[0]));
        } else {
            sql_readEntryIds.append(mainType.getPrimaryKey().getAlias()).append(" in (? ");
            params.add(new SqlParameter(":FId0", -5, (Object)billIds[0]));
            for (int i = 1; i < billIds.length; ++i) {
                sql_readEntryIds.append(",?");
                params.add(new SqlParameter(":FId" + String.valueOf(i), -5, (Object)billIds[i]));
            }
            sql_readEntryIds.append(") ");
        }
        Set entryIds = (Set)DB.query((DBRoute)new DBRoute(mainType.getDBRouteKey()), (String)sql_readEntryIds.toString(), (Object[])params.toArray(new SqlParameter[0]), (ResultSetHandler)action);
        if (parentType.equals((Object)entryType) || entryIds.isEmpty()) {
            return entryIds;
        }
        StringBuilder sql_readSubEntryIds = new StringBuilder();
        params.clear();
        sql_readSubEntryIds.append("SELECT ").append(entryType.getPrimaryKey().getAlias()).append(" detailid ");
        sql_readSubEntryIds.append("  FROM ").append(entryType.getAlias());
        sql_readSubEntryIds.append(" WHERE ");
        sql_readSubEntryIds.append(parentType.getPrimaryKey().getAlias()).append(" in ( ");
        int i = 0;
        for (Long entryId : entryIds) {
            if (i == 0) {
                sql_readSubEntryIds.append('?');
            } else {
                sql_readSubEntryIds.append(",?");
            }
            params.add(new SqlParameter(":FEntryId" + String.valueOf(i), -5, (Object)entryId));
            ++i;
        }
        sql_readSubEntryIds.append(") ");
        return (Set)DB.query((DBRoute)new DBRoute(mainType.getDBRouteKey()), (String)sql_readSubEntryIds.toString(), (Object[])params.toArray(new SqlParameter[0]), (ResultSetHandler)action);
    }

    public DynamicObject[] readBillHeadObj(MainEntityType mainType, Long[] billIds) {
        return BusinessDataReader.load((Object[])billIds, (DynamicObjectType)mainType, (Boolean)Boolean.TRUE);
    }

    public DynamicObject[] readEntryRows(EntryType entryType, Long linkTableId, Set<Long> linkEntryIds) {
        HashSet<Long> entryIds = new HashSet<Long>();
        TableDefine tableDefine = this.loadTableDefine(linkTableId);
        if (StringUtils.equals((CharSequence)tableDefine.getEntityKey(), (CharSequence)entryType.getName())) {
            entryIds.addAll(linkEntryIds);
        } else {
            String subEntryPKName = entryType.getName() + "." + tableDefine.getEntityKey() + ".id";
            String selectString = "id, " + entryType.getName() + ".id f1";
            QFilter qFilter = new QFilter(subEntryPKName, "in", linkEntryIds);
            ORM orm = ORM.create();
            try (DataSet dSet = orm.queryDataSet("BFTrackerDbService.readEntryRows", entryType.getParent().getName(), selectString, new QFilter[]{qFilter});){
                while (dSet.hasNext()) {
                    Row row = dSet.next();
                    entryIds.add(row.getLong("f1"));
                }
            }
        }
        return BusinessDataReader.load((Object[])entryIds.toArray(), (DynamicObjectType)entryType, (Boolean)Boolean.TRUE);
    }

    public boolean existSnapshot(Long[] billIds) {
        this.doReadSnapshotIdsFromDB(billIds);
        boolean exist = false;
        for (Long billId : billIds) {
            if (!this.snapshotIds.containsKey(billId) || this.snapshotIds.get(billId).isEmpty()) continue;
            exist = true;
            break;
        }
        return exist;
    }

    public Set<Long> readSnapshotTIds(Long[] billIds, Long tableId) {
        this.doReadSnapshotIdsFromDB(billIds);
        return this.doReadSnapshotTIdsFromMemory(billIds, tableId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, List<DynamicObject>> readSnapshot(Long[] billIds, Long tableId) {
        this.doReadSnapshotIdsFromDB(billIds);
        TableDefine tableDefine = this.loadTableDefine(tableId);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)tableDefine.getEntityNumber());
        List<Object> objects = null;
        ShardingHintContext ctx = ShardingHinter.tryHint((IDataEntityType)mainType, (Object[])billIds);
        if (ctx != null) {
            try {
                ctx.set();
                objects = this.doReadSnapshot(billIds, tableId);
            }
            finally {
                ctx.close();
            }
        } else {
            objects = this.doReadSnapshot(billIds, tableId);
        }
        DynamicProperty tBillIdProp = this.ctTrackerTypes.getSS_tBillIdProp();
        HashMap<Long, List<DynamicObject>> snapshotList = new HashMap<Long, List<DynamicObject>>();
        for (Object object : objects) {
            Long tBillId = (Long)tBillIdProp.getValueFast(object);
            if (!snapshotList.containsKey(tBillId)) {
                ArrayList list = new ArrayList();
                snapshotList.put(tBillId, list);
            }
            ((List)snapshotList.get(tBillId)).add((DynamicObject)object);
        }
        return snapshotList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, List<DynamicObject>> readSnapshot(Long[] billIds, Long tableId, Set<Long> entryIds) {
        this.doReadSnapshotIdsFromDB(billIds);
        TableDefine tableDefine = this.loadTableDefine(tableId);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)tableDefine.getEntityNumber());
        List<Object> objects = null;
        ShardingHintContext ctx = ShardingHinter.tryHint((IDataEntityType)mainType, (Object[])billIds);
        if (ctx != null) {
            try {
                ctx.set();
                objects = this.doReadSnapshot(tableId, entryIds);
            }
            finally {
                ctx.close();
            }
        } else {
            objects = this.doReadSnapshot(tableId, entryIds);
        }
        DynamicProperty tBillIdProp = this.ctTrackerTypes.getSS_tBillIdProp();
        HashMap<Long, List<DynamicObject>> snapshotList = new HashMap<Long, List<DynamicObject>>();
        for (Object object : objects) {
            Long tBillId = (Long)tBillIdProp.getValueFast(object);
            if (!snapshotList.containsKey(tBillId)) {
                ArrayList list = new ArrayList();
                snapshotList.put(tBillId, list);
            }
            ((List)snapshotList.get(tBillId)).add((DynamicObject)object);
        }
        return snapshotList;
    }

    public Map<CtBFRowId, CtBFRowLinkUpNode> readSourceRowIds(Map<Long, Set<Long>> tableInfo4Sid, Map<Long, Set<Long>> tableInfo4SbillId, CtAllBusEntityCountInfo allBusEntityCountInfo) {
        HashMap<CtBFRowId, CtBFRowLinkUpNode> allSRows = new HashMap<CtBFRowId, CtBFRowLinkUpNode>();
        for (Map.Entry<Long, Set<Long>> table : tableInfo4Sid.entrySet()) {
            Map existBillSRows = this.sourceBFSRows.computeIfAbsent(table.getKey(), v -> new HashMap());
            for (Long sid2 : table.getValue()) {
                if (!existBillSRows.containsKey(sid2)) continue;
                allSRows.putAll((Map)existBillSRows.get(sid2));
            }
            Long[] entryIds = (Long[])table.getValue().stream().filter(sid -> !existBillSRows.containsKey(sid)).toArray(Long[]::new);
            Set<Long> billIds = tableInfo4SbillId.get(table.getKey());
            Map<Long, Map<CtBFRowId, CtBFRowLinkUpNode>> entryNodes = this.doReadSourceRowIds(table.getKey(), billIds.toArray(new Long[0]), entryIds, allBusEntityCountInfo);
            for (Map.Entry<Long, Map<CtBFRowId, CtBFRowLinkUpNode>> entry : entryNodes.entrySet()) {
                existBillSRows.computeIfAbsent(entry.getKey(), v -> new HashMap()).putAll(entry.getValue());
                allSRows.putAll(entry.getValue());
            }
        }
        return allSRows;
    }

    public Map<CtBFRowId, CtBFRowLinkUpNode> readSourceRowIds(Map<Long, Set<Long>> billIds) {
        CtAllBusEntityCountInfo allBusEntityCountInfo = new CtAllBusEntityCountInfo();
        return this.readSourceRowIds(billIds, allBusEntityCountInfo);
    }

    public Map<CtBFRowId, CtBFRowLinkUpNode> readSourceRowIds(Map<Long, Set<Long>> billIds, CtAllBusEntityCountInfo allBusEntityCountInfo) {
        HashMap<CtBFRowId, CtBFRowLinkUpNode> allSRows = new HashMap<CtBFRowId, CtBFRowLinkUpNode>();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Map.Entry<Long, Set<Long>> table : billIds.entrySet()) {
            if (!this.sourceBFRows.containsKey(table.getKey())) {
                this.sourceBFRows.put(table.getKey(), new HashMap());
            }
            allBusEntityCountInfo.getAllBusEntityCountInfo().add(table.getKey());
            Map<Long, Map<CtBFRowId, CtBFRowLinkUpNode>> existBillSRows = this.sourceBFRows.get(table.getKey());
            for (Long billId : table.getValue()) {
                Map<CtBFRowId, CtBFRowLinkUpNode> upNodeMap = existBillSRows.get(billId);
                if (upNodeMap != null) {
                    allSRows.putAll(upNodeMap);
                    continue;
                }
                existBillSRows.put(billId, new HashMap());
                ids.add(billId);
            }
            if (!ids.isEmpty()) {
                Map<Long, Map<CtBFRowId, CtBFRowLinkUpNode>> billNodes = this.doReadSourceRowIds(table.getKey(), ids.toArray(new Long[0]), allBusEntityCountInfo);
                for (Map.Entry<Long, Map<CtBFRowId, CtBFRowLinkUpNode>> bill : billNodes.entrySet()) {
                    existBillSRows.get(bill.getKey()).putAll(bill.getValue());
                    allSRows.putAll(bill.getValue());
                }
            }
            ids.clear();
        }
        return allSRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReadSnapshotIdsFromDB(Long[] billIds) {
        final ArrayList<Long> ids = new ArrayList<Long>(billIds.length);
        for (Long id : billIds) {
            if (this.snapshotIds.containsKey(id)) continue;
            ids.add(id);
        }
        if (ids.isEmpty()) {
            return;
        }
        SqlBuilder sBuilder = new SqlBuilder();
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        sBuilder.append("SELECT FId, FTBillId, FTTableId, FTId ", new Object[0]);
        sBuilder.append("FROM  ", new Object[0]).append(this.ctTrackerTypes.getSnapshotType().getAlias(), new Object[0]).append(" ", new Object[0]);
        if (billIds.length == 1) {
            sBuilder.append("WHERE FTBillId = ? ", new Object[0]);
            params.add(new SqlParameter(FTBILL_ID, -5, (Object)billIds[0]));
        } else {
            sBuilder.append("WHERE ", new Object[0]);
            sBuilder.appendIn("FTBillId", (Object[])billIds);
        }
        sBuilder.append(" ", params.toArray(new Object[params.size()]));
        ResultSetHandler<Map<Long, Map<Long, Map<Long, Long>>>> action = new ResultSetHandler<Map<Long, Map<Long, Map<Long, Long>>>>(){

            public Map<Long, Map<Long, Map<Long, Long>>> handle(ResultSet rs) throws Exception {
                HashMap<Long, Map<Long, Map<Long, Long>>> map1 = new HashMap<Long, Map<Long, Map<Long, Long>>>(ids.size());
                while (rs.next()) {
                    HashMap<Long, Long> tableMap;
                    Long id = rs.getLong(1);
                    Long billId = rs.getLong(2);
                    Long tableId = rs.getLong(3);
                    Long entryId = rs.getLong(4);
                    HashMap<Long, HashMap<Long, Long>> billMap = (HashMap<Long, HashMap<Long, Long>>)map1.get(billId);
                    if (billMap == null) {
                        billMap = new HashMap<Long, HashMap<Long, Long>>(1);
                        map1.put(billId, billMap);
                    }
                    if ((tableMap = (HashMap<Long, Long>)billMap.get(tableId)) == null) {
                        tableMap = new HashMap<Long, Long>();
                        billMap.put(tableId, tableMap);
                    }
                    tableMap.put(id, entryId);
                }
                return map1;
            }
        };
        ShardingHintContext ctx = ShardingHinter.tryHint((IDataEntityType)this.targetSubMainType, (Object[])billIds);
        Map map2 = null;
        if (ctx != null) {
            try {
                ctx.set();
                map2 = (Map)DB.query((DBRoute)new DBRoute(this.ctTrackerTypes.getSnapshotType().getDBRouteKey()), (SqlBuilder)sBuilder, (ResultSetHandler)action);
            }
            finally {
                ctx.close();
            }
        } else {
            map2 = (Map)DB.query((DBRoute)new DBRoute(this.ctTrackerTypes.getSnapshotType().getDBRouteKey()), (SqlBuilder)sBuilder, (ResultSetHandler)action);
        }
        this.snapshotIds.putAll(map2);
        for (Long billId : billIds) {
            if (this.snapshotIds.containsKey(billId)) continue;
            this.snapshotIds.put(billId, new HashMap(0));
        }
    }

    private List<Object> doReadSnapshot(Long[] billIds, Long tableId) {
        Set<Long> ids = this.doReadSnapshotIdsFromMemory(billIds, tableId);
        if (ids.size() == 0) {
            return new ArrayList<Object>();
        }
        IDataManager datamanager = DataManagerUtils.getDataManager((IDataEntityType)this.ctTrackerTypes.getSnapshotType());
        List objects = datamanager.select(new ArrayList<Long>(ids));
        return objects;
    }

    private List<Object> doReadSnapshot(Long tableId, Set<Long> entryIds) {
        Set<Long> ids = this.doReadSnapshotIdsFromMemory(tableId, entryIds);
        if (ids.size() == 0) {
            return new ArrayList<Object>();
        }
        IDataManager datamanager = DataManagerUtils.getDataManager((IDataEntityType)this.ctTrackerTypes.getSnapshotType());
        List objects = datamanager.select(new ArrayList<Long>(ids));
        return objects;
    }

    private Set<Long> doReadSnapshotIdsFromMemory(Long[] billIds, Long tableId) {
        HashSet<Long> ids = new HashSet<Long>();
        for (Long billId : billIds) {
            Map<Long, Long> tableMap;
            Map<Long, Map<Long, Long>> billMap = this.snapshotIds.get(billId);
            if (billMap == null || (tableMap = billMap.get(tableId)) == null) continue;
            ids.addAll(tableMap.keySet());
        }
        return ids;
    }

    private Set<Long> doReadSnapshotIdsFromMemory(Long tableId, Set<Long> entryIds) {
        HashSet<Long> ids = new HashSet<Long>();
        for (Map<Long, Map<Long, Long>> billMap : this.snapshotIds.values()) {
            Map<Long, Long> tableMap = billMap.get(tableId);
            if (tableMap == null) continue;
            for (Map.Entry<Long, Long> item : tableMap.entrySet()) {
                if (!entryIds.contains(item.getValue())) continue;
                ids.add(item.getKey());
            }
        }
        return ids;
    }

    private Set<Long> doReadSnapshotTIdsFromMemory(Long[] billIds, Long tableId) {
        HashSet<Long> entryIds = new HashSet<Long>();
        for (Long billId : billIds) {
            Map<Long, Long> tableMap;
            Map<Long, Map<Long, Long>> billMap = this.snapshotIds.get(billId);
            if (billMap == null || (tableMap = billMap.get(tableId)) == null) continue;
            entryIds.addAll(tableMap.values());
        }
        return entryIds;
    }

    private Map<Long, Map<CtBFRowId, CtBFRowLinkUpNode>> doReadSourceRowIds(Long tableId, Long[] billIds, Long[] entryIds, CtAllBusEntityCountInfo allBusEntityCountInfo) {
        CtBusinessFlowDataService dataService = new CtBusinessFlowDataService();
        Long mainTableId = this.loadMainTableId(tableId);
        TableDefine mainTableDefine = this.loadTableDefine(mainTableId);
        TableDefine tableDefine = this.loadTableDefine(tableId);
        List allSRows = dataService.loadSourceRowIds(mainTableDefine.getEntityKey(), tableDefine.getEntityKey(), billIds, entryIds, null);
        HashMap<CtBFRowId, CtBFRowLinkUpNode> allNodes = new HashMap<CtBFRowId, CtBFRowLinkUpNode>();
        for (CtBFRow sRow : allSRows) {
            CtBFRowId sRowId;
            this.collectSourceEntityIds(allBusEntityCountInfo, sRow);
            CtBFRowId ctBFRowId = sRow.getId();
            if (!allNodes.containsKey(ctBFRowId)) {
                CtBFRowLinkUpNode node = new CtBFRowLinkUpNode(ctBFRowId);
                allNodes.put(ctBFRowId, node);
            }
            if (allNodes.containsKey(sRowId = sRow.getSId())) continue;
            CtBFRowLinkUpNode node = new CtBFRowLinkUpNode(sRowId);
            allNodes.put(sRowId, node);
        }
        for (CtBFRow sRow : allSRows) {
            CtBFRowLinkUpNode ctBFRowLinkUpNode = (CtBFRowLinkUpNode)allNodes.get(sRow.getId());
            if (ctBFRowLinkUpNode.getSNodes().containsKey(sRow.getSId())) continue;
            CtBFRowLinkUpNode sNode = (CtBFRowLinkUpNode)allNodes.get(sRow.getSId());
            ctBFRowLinkUpNode.getSNodes().put(sRow.getSId(), sNode);
        }
        HashMap<Long, Map<CtBFRowId, CtBFRowLinkUpNode>> billNodes = new HashMap<Long, Map<CtBFRowId, CtBFRowLinkUpNode>>(billIds.length);
        for (Long billId : billIds) {
            billNodes.put(billId, new HashMap());
        }
        for (Map.Entry entry : allNodes.entrySet()) {
            CtBFRowId rowId = (CtBFRowId)entry.getKey();
            if (Long.compare(rowId.getMainTableId(), mainTableId) != 0 || !billNodes.containsKey(rowId.getBillId())) continue;
            ((Map)billNodes.get(rowId.getBillId())).put(entry.getKey(), entry.getValue());
        }
        return billNodes;
    }

    private Map<Long, Map<CtBFRowId, CtBFRowLinkUpNode>> doReadSourceRowIds(Long mainTableId, Long[] billIds, CtAllBusEntityCountInfo allBusEntityCountInfo) {
        CtBusinessFlowDataService dataService = new CtBusinessFlowDataService();
        TableDefine tableDefine = this.loadTableDefine(mainTableId);
        List allSRows = dataService.loadSourceRowIds(tableDefine.getEntityNumber(), "", billIds);
        HashMap<CtBFRowId, CtBFRowLinkUpNode> allNodes = new HashMap<CtBFRowId, CtBFRowLinkUpNode>();
        for (CtBFRow sRow : allSRows) {
            CtBFRowId sRowId;
            this.collectSourceEntityIds(allBusEntityCountInfo, sRow);
            CtBFRowId ctBFRowId = sRow.getId();
            if (!allNodes.containsKey(ctBFRowId)) {
                CtBFRowLinkUpNode node = new CtBFRowLinkUpNode(ctBFRowId);
                allNodes.put(ctBFRowId, node);
            }
            if (allNodes.containsKey(sRowId = sRow.getSId())) continue;
            CtBFRowLinkUpNode node = new CtBFRowLinkUpNode(sRowId);
            allNodes.put(sRowId, node);
        }
        for (CtBFRow sRow : allSRows) {
            CtBFRowLinkUpNode ctBFRowLinkUpNode = (CtBFRowLinkUpNode)allNodes.get(sRow.getId());
            if (ctBFRowLinkUpNode.getSNodes().containsKey(sRow.getSId())) continue;
            CtBFRowLinkUpNode sNode = (CtBFRowLinkUpNode)allNodes.get(sRow.getSId());
            ctBFRowLinkUpNode.getSNodes().put(sRow.getSId(), sNode);
        }
        HashMap<Long, Map<CtBFRowId, CtBFRowLinkUpNode>> billNodes = new HashMap<Long, Map<CtBFRowId, CtBFRowLinkUpNode>>(billIds.length);
        for (Long billId : billIds) {
            billNodes.put(billId, new HashMap());
        }
        for (Map.Entry entry : allNodes.entrySet()) {
            CtBFRowId rowId = (CtBFRowId)entry.getKey();
            if (Long.compare(rowId.getMainTableId(), mainTableId) != 0 || !billNodes.containsKey(rowId.getBillId())) continue;
            ((Map)billNodes.get(rowId.getBillId())).put(entry.getKey(), entry.getValue());
        }
        return billNodes;
    }

    private void collectSourceEntityIds(CtAllBusEntityCountInfo allBusEntityCountInfo, CtBFRow sRow) {
        if (sRow == null) {
            return;
        }
        if (sRow.getId() != null && sRow.getId().getMainTableId() != null) {
            allBusEntityCountInfo.getAllBusEntityCountInfo().add(sRow.getId().getMainTableId());
        }
        if (sRow.getSId() != null && sRow.getSId().getMainTableId() != null) {
            allBusEntityCountInfo.getAllBusEntityCountInfo().add(sRow.getSId().getMainTableId());
        }
    }

    private Map<Long, Map<CtBFRowId, CtBFRowLinkUpNode>> doReadSourceRowIds(Long mainTableId, Long[] billIds) {
        CtBusinessFlowDataService dataService = new CtBusinessFlowDataService();
        TableDefine tableDefine = this.loadTableDefine(mainTableId);
        List allSRows = dataService.loadSourceRowIds(tableDefine.getEntityNumber(), "", billIds);
        HashMap<CtBFRowId, CtBFRowLinkUpNode> allNodes = new HashMap<CtBFRowId, CtBFRowLinkUpNode>();
        for (CtBFRow sRow : allSRows) {
            CtBFRowId sRowId;
            CtBFRowId ctBFRowId = sRow.getId();
            if (!allNodes.containsKey(ctBFRowId)) {
                CtBFRowLinkUpNode node = new CtBFRowLinkUpNode(ctBFRowId);
                allNodes.put(ctBFRowId, node);
            }
            if (allNodes.containsKey(sRowId = sRow.getSId())) continue;
            CtBFRowLinkUpNode node = new CtBFRowLinkUpNode(sRowId);
            allNodes.put(sRowId, node);
        }
        for (CtBFRow sRow : allSRows) {
            CtBFRowLinkUpNode ctBFRowLinkUpNode = (CtBFRowLinkUpNode)allNodes.get(sRow.getId());
            if (ctBFRowLinkUpNode.getSNodes().containsKey(sRow.getSId())) continue;
            CtBFRowLinkUpNode sNode = (CtBFRowLinkUpNode)allNodes.get(sRow.getSId());
            ctBFRowLinkUpNode.getSNodes().put(sRow.getSId(), sNode);
        }
        HashMap<Long, Map<CtBFRowId, CtBFRowLinkUpNode>> billNodes = new HashMap<Long, Map<CtBFRowId, CtBFRowLinkUpNode>>(billIds.length);
        for (Long billId : billIds) {
            billNodes.put(billId, new HashMap());
        }
        for (Map.Entry entry : allNodes.entrySet()) {
            CtBFRowId rowId = (CtBFRowId)entry.getKey();
            if (Long.compare(rowId.getMainTableId(), mainTableId) != 0 || !billNodes.containsKey(rowId.getBillId())) continue;
            ((Map)billNodes.get(rowId.getBillId())).put(entry.getKey(), entry.getValue());
        }
        return billNodes;
    }

    public void saveBillTrackers(List<CtBillLk> billTrackerObjs) {
        if (billTrackerObjs.size() == 0) {
            return;
        }
        SaveServiceHelper.save((IDataEntityType)this.ctTrackerTypes.getBillTrackerType(), (Object[])billTrackerObjs.toArray());
    }

    public void saveEntryTrackers(List<DynamicObject> entryTrackerObjs) {
        if (entryTrackerObjs.size() == 0) {
            return;
        }
        SaveServiceHelper.save((IDataEntityType)this.ctTrackerTypes.getEntryTrackerType(), (Object[])entryTrackerObjs.toArray(new DynamicObject[0]));
    }

    public void saveWBSnap(List<DynamicObject> wbsnapObjs) {
        if (wbsnapObjs.size() == 0) {
            return;
        }
        SaveServiceHelper.save((IDataEntityType)this.ctTrackerTypes.getWbItemType(), (Object[])wbsnapObjs.toArray(new DynamicObject[0]));
    }

    public void saveBotpLinkLog(CtBFTrackerContext bfTrackerContext, List<DynamicObject> linkLogObjs) {
        if (linkLogObjs.size() == 0) {
            return;
        }
        LogORM logORM = LogORM.create();
        logORM.insert(linkLogObjs);
    }

    public void deleteBillTrackers(List<Long> billTrackerIds) {
        if (billTrackerIds.size() == 0) {
            return;
        }
        DeleteServiceHelper.delete((IDataEntityType)this.ctTrackerTypes.getBillTrackerType(), (Object[])billTrackerIds.toArray());
    }

    public void deleteEntryTrackers(List<Long> entryTrackerIds) {
        if (entryTrackerIds.size() == 0) {
            return;
        }
        DeleteServiceHelper.delete((IDataEntityType)this.ctTrackerTypes.getEntryTrackerType(), (Object[])entryTrackerIds.toArray());
    }

    public void deleteWBSnap(List<Long> wbEntryIds) {
        if (wbEntryIds.size() == 0) {
            return;
        }
        DeleteServiceHelper.delete((IDataEntityType)this.ctTrackerTypes.getWbItemType(), (Object[])wbEntryIds.toArray());
    }

    public TableDefine loadTableDefine(Long tableId) {
        return this.tableDefines.computeIfAbsent(tableId, key -> CtConvertMetaServiceHelper.loadTableDefine((Long)key));
    }

    public Long loadMainTableId(Long entityTableId) {
        Long mainTableId = this.mainTableIds.get(entityTableId);
        if (mainTableId == null) {
            TableDefine entityTableDefine = this.loadTableDefine(entityTableId);
            TableDefine mainTableDefine = CtConvertMetaServiceHelper.loadTableDefine((String)entityTableDefine.getEntityNumber(), (String)entityTableDefine.getEntityNumber());
            mainTableId = mainTableDefine.getTableId();
            this.mainTableIds.put(entityTableId, mainTableId);
            if (!this.tableDefines.containsKey(mainTableId)) {
                this.tableDefines.put(mainTableId, mainTableDefine);
            }
        }
        return mainTableId;
    }
}

