/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.ctbotp.link.CtBillLk;
import kd.bos.entity.param.CustomParam;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.impl.ParameterReaderServiceImpl;
import kd.bos.service.ctbotp.track.CtBFTrackerContext;
import kd.bos.service.ctbotp.track.CtBFTrackerLog;
import kd.bos.service.ctbotp.track.CtBFTrackerResult;
import kd.bos.service.ctbotp.track.helper.CtBFTrackerDbService;
import kd.bos.service.ctbotp.track.helper.CtTrackerTypes;
import kd.bos.servicehelper.DBServiceHelper;
import org.apache.commons.collections.MapUtils;

public class CtSaveBotpLinkLog {
    private static final Log log = LogFactory.getLog(CtSaveBotpLinkLog.class);
    private static final String KEY_ID = "id";
    private static final String KEY_USERNAME = "username";
    private static final String KEY_OPNAME = "opname";
    private static final String KEY_LOGTYPE = "logtype";
    private static final String KEY_UEERID = "userid";
    private static final String KEY_OPTYPE = "optype";
    private static final String KEY_SENTITYNUMBER = "sentitynumber";
    private static final String KEY_STABLEID = "stableid";
    private static final String KEY_SBILLID = "sbillid";
    private static final String KEY_SBILLNO = "sbillno";
    private static final String KEY_SID = "sid";
    private static final String KEY_TENTITYNUMBER = "tentitynumber";
    private static final String KEY_TTABLEID = "ttableid";
    private static final String KEY_TBILLID = "tbillid";
    private static final String KEY_TBILLNO = "tbillno";
    private static final String KEY_TID = "tid";
    private static final String KEY_OPDATE = "opdate";
    private static final String KEY_OPDESC = "opdesc";
    private static final String KEY_ISOPEN = "BOS_BOTP_LINK_LOG";
    private long userId = RequestContext.get().getCurrUserId();

    public void addBotpLinkLog(CtBFTrackerContext trackerContext, CtBFTrackerResult trackerResult, List<CtBillLk> delBillTrackers, List<DynamicObject> delEntryTrackers, CtBFTrackerDbService dbService, String sTraceId) {
        try {
            if (!trackerContext.isBotpLinkLog()) {
                return;
            }
            MainEntityType botpLinkEntityType = trackerContext.getBotpLinkLogType();
            if (botpLinkEntityType == null) {
                log.info("\u5b9e\u4f53\u5bf9\u8c61\u4e3a\u7a7a");
                return;
            }
            ArrayList<DynamicObject> botpLinkLogs = new ArrayList<DynamicObject>();
            String traceId = RequestContext.get().getTraceId();
            Date date = new Date();
            if (!CollectionUtils.isEmpty(delBillTrackers)) {
                for (CtBillLk billTracker : delBillTrackers) {
                    botpLinkLogs.add(this.buildBotpLinkLogObj(billTracker, botpLinkEntityType, trackerContext, trackerResult, date, traceId, sTraceId));
                }
            }
            if (!CollectionUtils.isEmpty(delEntryTrackers)) {
                CtTrackerTypes ctTrackerTypes = trackerContext.getTrackerTypes();
                for (DynamicObject dynamicObject : delEntryTrackers) {
                    botpLinkLogs.add(this.buildBotpLinkLogObj(dynamicObject, botpLinkEntityType, trackerContext, trackerResult, ctTrackerTypes, date, traceId, sTraceId));
                }
            }
            if (!CollectionUtils.isEmpty(botpLinkLogs)) {
                dbService.saveBotpLinkLog(trackerContext, botpLinkLogs);
            }
        }
        catch (Exception e) {
            log.info("\u8bb0\u5f55botp\u5220\u9664\u5173\u8054\u5173\u7cfb\u8bb0\u5f55\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    public boolean isBotpLinkLogOpen() {
        try {
            ParameterReaderServiceImpl parameterReaderService = new ParameterReaderServiceImpl();
            CustomParam customParam = new CustomParam();
            HashSet<String> keySets = new HashSet<String>(1);
            keySets.add(KEY_ISOPEN);
            customParam.setSearchKeySet(keySets);
            Map customParams = parameterReaderService.loadCustomParameterFromCache(customParam);
            if (MapUtils.isNotEmpty((Map)customParams)) {
                String value = (String)customParams.get(KEY_ISOPEN);
                if (StringUtils.isEmpty((CharSequence)value)) {
                    return true;
                }
                return Boolean.parseBoolean(value);
            }
            return true;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return true;
        }
    }

    private DynamicObject buildBotpLinkLogObj(CtBillLk billTracker, MainEntityType botpLinkEntityType, CtBFTrackerContext trackerContext, CtBFTrackerResult trackerResult, Date date, String traceId, String sTraceId) {
        DynamicObject trackerObj = new DynamicObject((DynamicObjectType)botpLinkEntityType);
        long id = DBServiceHelper.genGlobalLongId();
        trackerObj.set(KEY_ID, (Object)id);
        trackerObj.set(KEY_USERNAME, (Object)RequestContext.get().getUserName());
        trackerObj.set(KEY_UEERID, (Object)this.userId);
        trackerObj.set(KEY_OPTYPE, (Object)this.getOpType(trackerContext));
        trackerObj.set(KEY_SENTITYNUMBER, (Object)this.getEntityNumber(billTracker.getSTableId()));
        trackerObj.set(KEY_STABLEID, (Object)billTracker.getSTableId());
        trackerObj.set(KEY_SBILLID, (Object)billTracker.getSBillId());
        trackerObj.set(KEY_SBILLNO, (Object)trackerResult.getTrackerLog().getBillNo(billTracker.getSTableId(), billTracker.getSBillId()));
        trackerObj.set(KEY_TENTITYNUMBER, (Object)this.getEntityNumber(billTracker.getTTableId()));
        trackerObj.set(KEY_TTABLEID, (Object)billTracker.getTTableId());
        trackerObj.set(KEY_TBILLID, (Object)billTracker.getTBillId());
        trackerObj.set(KEY_TBILLNO, (Object)trackerResult.getTrackerLog().getBillNo(billTracker.getTTableId(), billTracker.getTBillId()));
        trackerObj.set(KEY_OPDATE, (Object)date);
        trackerObj.set(KEY_OPDESC, (Object)this.buildDesc(traceId, sTraceId));
        return trackerObj;
    }

    private DynamicObject buildBotpLinkLogObj(DynamicObject dynamicObject, MainEntityType botpLinkEntityType, CtBFTrackerContext trackerContext, CtBFTrackerResult trackerResult, CtTrackerTypes ctTrackerTypes, Date date, String traceId, String sTraceId) {
        DynamicObject trackerObj = new DynamicObject((DynamicObjectType)botpLinkEntityType);
        long id = DBServiceHelper.genGlobalLongId();
        Long stableId = dynamicObject.get((IDataEntityProperty)ctTrackerTypes.getTC_sTableIdProp()) == null ? null : Long.valueOf(Long.parseLong(dynamicObject.get((IDataEntityProperty)ctTrackerTypes.getTC_sTableIdProp()).toString()));
        Long ttableId = dynamicObject.get((IDataEntityProperty)ctTrackerTypes.getTC_tTableIdProp()) == null ? null : Long.valueOf(Long.parseLong(dynamicObject.get((IDataEntityProperty)ctTrackerTypes.getTC_tTableIdProp()).toString()));
        Long sbillId = dynamicObject.get((IDataEntityProperty)ctTrackerTypes.getTC_sBillIdProp()) == null ? null : Long.valueOf(Long.parseLong(dynamicObject.get((IDataEntityProperty)ctTrackerTypes.getTC_sBillIdProp()).toString()));
        Long tbillId = dynamicObject.get((IDataEntityProperty)ctTrackerTypes.getTC_tBillIdProp()) == null ? null : Long.valueOf(Long.parseLong(dynamicObject.get((IDataEntityProperty)ctTrackerTypes.getTC_tBillIdProp()).toString()));
        trackerObj.set(KEY_ID, (Object)id);
        trackerObj.set(KEY_USERNAME, (Object)RequestContext.get().getUserName());
        trackerObj.set(KEY_UEERID, (Object)this.userId);
        trackerObj.set(KEY_OPTYPE, (Object)this.getOpType(trackerContext));
        trackerObj.set(KEY_SENTITYNUMBER, (Object)this.getEntityNumber(stableId));
        trackerObj.set(KEY_STABLEID, (Object)stableId);
        trackerObj.set(KEY_SBILLID, (Object)sbillId);
        trackerObj.set(KEY_SBILLNO, (Object)trackerResult.getTrackerLog().getBillNo(stableId, sbillId));
        trackerObj.set(KEY_SID, dynamicObject.get((IDataEntityProperty)ctTrackerTypes.getTC_sIdProp()));
        trackerObj.set(KEY_TENTITYNUMBER, (Object)this.getEntityNumber(ttableId));
        trackerObj.set(KEY_TTABLEID, (Object)ttableId);
        trackerObj.set(KEY_TBILLID, (Object)tbillId);
        trackerObj.set(KEY_TBILLNO, (Object)trackerResult.getTrackerLog().getBillNo(ttableId, tbillId));
        trackerObj.set(KEY_TID, dynamicObject.get((IDataEntityProperty)ctTrackerTypes.getTC_tIdProp()));
        trackerObj.set(KEY_OPDATE, (Object)date);
        trackerObj.set(KEY_OPDESC, (Object)this.buildDesc(traceId, sTraceId));
        return trackerObj;
    }

    private String buildDesc(String traceId, String sTraceId) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("traceId:");
        stringBuilder.append(traceId);
        if (StringUtils.isNotEmpty((CharSequence)sTraceId) && !sTraceId.equals(traceId)) {
            stringBuilder.append(";");
            stringBuilder.append("sTraceId:");
            stringBuilder.append(sTraceId);
        }
        return stringBuilder.toString();
    }

    private String getOpType(CtBFTrackerContext bfTrackerContext) {
        String opType = "";
        String opMetaType = null;
        if (bfTrackerContext.getOpMeta() != null) {
            opMetaType = (String)bfTrackerContext.getOpMeta().get("type");
        }
        if (StringUtils.isNotBlank(opMetaType) && CtBFTrackerLog.OPTYPES.containsKey(opMetaType)) {
            return CtBFTrackerLog.OPTYPES.get(opMetaType);
        }
        switch (bfTrackerContext.getOpType()) {
            case Save: {
                opType = "S";
                break;
            }
            case Draft: {
                opType = "S";
                break;
            }
            case Delete: {
                opType = "D";
                break;
            }
            case Audit: {
                opType = "A";
                break;
            }
            case UnAudit: {
                opType = "U";
                break;
            }
            case UnCancel: {
                opType = "V";
                break;
            }
            case Cancel: {
                opType = "I";
                break;
            }
        }
        return opType;
    }

    private String getEntityNumber(Long tableId) {
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((Long)tableId);
        if (tableDefine != null) {
            return tableDefine.getEntityNumber();
        }
        return "";
    }
}

