/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.helper;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.link.CtBillLk;
import kd.bos.entity.ctbotp.log.CtBOTPLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.service.ctbotp.track.CtBFTrackerContext;
import kd.bos.service.ctbotp.track.CtBFTrackerResult;
import kd.bos.service.ctbotp.track.bizentity.CtBillCloseItem;
import kd.bos.service.ctbotp.track.bizentity.CtSourceBillInfo;
import kd.bos.service.ctbotp.track.helper.CtBFTrackerDbService;
import kd.bos.service.ctbotp.track.helper.CtSaveTrackerAnsyResult;
import kd.bos.service.ctbotp.track.helper.ICtSaveTracker;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;

public class CtSaveTrackerRunnable
implements Runnable,
Callable<CtSaveTrackerAnsyResult> {
    private static final Log log = LogFactory.getLog(CtSaveTrackerRunnable.class);
    private RequestContext rc;
    private static final String OPNAME_SAVEBILLTRACKER = "billtracker";
    private static final String OPNAME_SAVESRCBILL = "srcbill";
    private String opName;
    private CtBFTrackerContext trackerContext;
    private List<CtBillLk> saveBillTrackers;
    private List<Long> delBillTrackerIds;
    private CtSourceBillInfo sourceBillInfo;
    private BillEntityType srcSubMainType;
    private DynamicObject[] srcDataEntities;
    private Map<EntityType, DynamicObject[]> srcEntryRows;
    private Set<CtBillCloseItem> billCloseItems;
    private CtBFTrackerResult bfTrackerResult;
    private CtBFTrackerDbService dbService;
    private String sTraceId;

    public void saveBillTracker(RequestContext rc, CtBFTrackerContext trackerContext, List<CtBillLk> saveBillTrackers, List<Long> delBillTrackerIds) {
        this.rc = rc;
        this.opName = OPNAME_SAVEBILLTRACKER;
        this.trackerContext = trackerContext;
        this.saveBillTrackers = saveBillTrackers;
        this.delBillTrackerIds = delBillTrackerIds;
    }

    public void saveBillTracker(RequestContext rc, CtBFTrackerContext trackerContext, List<CtBillLk> saveBillTrackers, List<Long> delBillTrackerIds, CtBFTrackerResult bfTrackerResult, CtBFTrackerDbService dbService, String sTraceId) {
        this.saveBillTracker(rc, trackerContext, saveBillTrackers, delBillTrackerIds);
        this.bfTrackerResult = bfTrackerResult;
        this.dbService = dbService;
        this.sTraceId = sTraceId;
    }

    public void saveSrcBill(RequestContext rc, CtBFTrackerContext trackerContext, BillEntityType srcSubMainType, DynamicObject[] srcDataEntities, Set<CtBillCloseItem> billCloseItems) {
        this.rc = rc;
        this.opName = OPNAME_SAVESRCBILL;
        this.trackerContext = trackerContext;
        this.srcSubMainType = srcSubMainType;
        this.srcDataEntities = srcDataEntities;
        this.billCloseItems = billCloseItems;
    }

    public void saveSrcBill(RequestContext rc, CtBFTrackerContext trackerContext, BillEntityType srcSubMainType, DynamicObject[] srcDataEntities, Map<EntityType, DynamicObject[]> srcEntryRows, Set<CtBillCloseItem> billCloseItems) {
        this.rc = rc;
        this.opName = OPNAME_SAVESRCBILL;
        this.trackerContext = trackerContext;
        this.srcSubMainType = srcSubMainType;
        this.srcDataEntities = srcDataEntities;
        this.srcEntryRows = srcEntryRows;
        this.billCloseItems = billCloseItems;
    }

    public void saveSrcBill(RequestContext rc, CtBFTrackerContext trackerContext, BillEntityType srcSubMainType, DynamicObject[] srcDataEntities, Map<EntityType, DynamicObject[]> srcEntryRows, Set<CtBillCloseItem> billCloseItems, CtBFTrackerResult bfTrackerResult, CtBFTrackerDbService dbService) {
        this.saveSrcBill(rc, trackerContext, srcSubMainType, srcDataEntities, srcEntryRows, billCloseItems);
        this.bfTrackerResult = bfTrackerResult;
        this.dbService = dbService;
    }

    public CtSourceBillInfo getSourceBillInfo() {
        return this.sourceBillInfo;
    }

    public void setSourceBillInfo(CtSourceBillInfo sourceBillInfo) {
        this.sourceBillInfo = sourceBillInfo;
    }

    public boolean isSaveBillTracker() {
        return StringUtils.equals((CharSequence)this.opName, (CharSequence)OPNAME_SAVEBILLTRACKER);
    }

    public boolean isSaveSrcBill() {
        return StringUtils.equals((CharSequence)this.opName, (CharSequence)OPNAME_SAVESRCBILL);
    }

    @Override
    public CtSaveTrackerAnsyResult call() throws Exception {
        CtSaveTrackerAnsyResult saveResult = new CtSaveTrackerAnsyResult();
        try {
            saveResult = this.save();
        }
        catch (Throwable ex) {
            saveResult.setException(ex);
            log.error(ex);
            this.writeBOTPErrorLog(ex);
        }
        finally {
            if (this.sourceBillInfo != null && this.isSaveSrcBill()) {
                this.sourceBillInfo.releaseDataMutex(new StringBuilder());
            }
        }
        return saveResult;
    }

    @Override
    public void run() {
        try {
            this.save();
        }
        catch (Throwable ex) {
            log.error(ex);
            this.writeBOTPErrorLog(ex);
            throw ex;
        }
        finally {
            if (this.sourceBillInfo != null && this.isSaveSrcBill()) {
                this.sourceBillInfo.releaseDataMutex(new StringBuilder());
            }
        }
    }

    private CtSaveTrackerAnsyResult save() {
        RequestContext.copyAndSet((RequestContext)this.rc);
        if (this.isSaveSrcBill()) {
            this.saveSrcBill();
        } else if (this.isSaveBillTracker()) {
            this.saveBillTracker();
        }
        CtSaveTrackerAnsyResult saveResult = new CtSaveTrackerAnsyResult();
        saveResult.setSuccess(true);
        return saveResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSrcBill() {
        try (TXHandle h = TX.requiresNew();){
            try {
                ICtSaveTracker.ansyFireBeforeSaveSourceBill(this.trackerContext, this.srcSubMainType, this.srcDataEntities);
                if (this.srcDataEntities != null) {
                    SaveServiceHelper.save((IDataEntityType)this.srcSubMainType, (Object[])this.srcDataEntities);
                }
                if (this.srcEntryRows != null) {
                    ShardingHintContext ctx = null;
                    if (this.srcDataEntities != null && this.srcSubMainType != null && ShardingHinter.isSharding((String)this.srcSubMainType.getAlias())) {
                        Object[] pks = new Object[this.srcDataEntities.length];
                        for (int i = 0; i < this.srcDataEntities.length; ++i) {
                            pks[i] = this.srcDataEntities[i].getPkValue();
                        }
                        ctx = ShardingHinter.tryHint((IDataEntityType)this.srcSubMainType, (Object[])pks);
                        ctx.set();
                    }
                    try {
                        for (Map.Entry<EntityType, DynamicObject[]> entry : this.srcEntryRows.entrySet()) {
                            SaveServiceHelper.save((IDataEntityType)((IDataEntityType)entry.getKey()), (Object[])entry.getValue());
                        }
                    }
                    finally {
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                }
                ICtSaveTracker.updateBillCloseStatus(this.trackerContext, (MainEntityType)this.srcSubMainType, this.srcDataEntities, this.billCloseItems);
                ICtSaveTracker.ansyFireAfterSaveSourceBill(this.trackerContext, this.srcSubMainType, this.srcDataEntities);
                ICtSaveTracker.saveWriteBackLogs(this.trackerContext, this.sourceBillInfo);
            }
            catch (Throwable exp) {
                h.markRollback();
                throw exp;
            }
        }
        ICtSaveTracker.updateWBLogFinishStatus(this.trackerContext, this.sourceBillInfo);
        if (this.srcSubMainType != null && this.srcDataEntities != null && this.srcDataEntities.length > 0) {
            String msg = String.format(ResManager.loadKDString((String)"\u53cd\u5199\u5f15\u64ce\uff0c\u5f02\u6b65\u4fdd\u5b58\u6e90\u5355\u5b8c\u6bd5\uff1a%1$s, %2$s(%3$s bills)", (String)"SaveTrackerRunnable_0", (String)"bos-mservice-botp", (Object[])new Object[0]), this.srcSubMainType.getName(), this.srcDataEntities[0].getPkValue(), this.srcDataEntities.length);
            log.info(msg);
        }
    }

    private void saveBillTracker() {
        IDataEntityType billTrackerType = OrmUtils.getDataEntityType(CtBillLk.class);
        try (TXHandle h = TX.requiresNew();){
            if (this.saveBillTrackers != null && !this.saveBillTrackers.isEmpty()) {
                SaveServiceHelper.save((IDataEntityType)billTrackerType, (Object[])this.saveBillTrackers.toArray());
            }
            if (this.delBillTrackerIds != null && !this.delBillTrackerIds.isEmpty()) {
                DeleteServiceHelper.delete((IDataEntityType)billTrackerType, (Object[])this.delBillTrackerIds.toArray());
            }
        }
        log.info("\u53cd\u5199\u5f15\u64ce\uff0c\u5f02\u6b65\u4fdd\u5b58\u5173\u8054\u5173\u7cfb\u5b8c\u6bd5");
    }

    private void writeBOTPErrorLog(Throwable exp) {
    }

    private void fillErrLogId(List<CtBOTPLog> errLogs) {
        long[] ids = DB.genGlobalLongIds((int)errLogs.size());
        for (int i = 0; i < errLogs.size(); ++i) {
            errLogs.get(i).setId(ids[i]);
        }
    }
}

