/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.ctbotp.CtConvertDataService;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.CtLinkEntryType;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.ctbotp.plugin.tracker.args.CtAfterCalcWriteValueEventArgs;
import kd.bos.entity.ctbotp.plugin.tracker.args.CtBeforeCreateArticulationRowEventArgs;
import kd.bos.entity.ctbotp.plugin.tracker.args.CtBeforeExecWriteBackRuleEventArgs;
import kd.bos.entity.ctbotp.plugin.tracker.args.CtBeforeTrackEventArgs;
import kd.bos.entity.ctbotp.runtime.CtBFRowId;
import kd.bos.entity.ctbotp.runtime.CtBFRowLinkUpNode;
import kd.bos.entity.ctbotp.runtime.CtWriteBackType;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.service.ctbotp.track.CtBFTrackerContext;
import kd.bos.service.ctbotp.track.CtLinkItemContext;
import kd.bos.service.ctbotp.track.bizentity.CtAED;
import kd.bos.service.ctbotp.track.bizentity.CtRow;
import kd.bos.service.ctbotp.track.bizentity.CtRowId;
import kd.bos.service.ctbotp.track.bizentity.CtRowLinkId;
import kd.bos.service.ctbotp.track.bizentity.CtSheet;
import kd.bos.service.ctbotp.track.bizentity.CtWRule;
import kd.bos.service.ctbotp.track.bizentity.CtWRuleItemId;
import kd.bos.service.ctbotp.track.bizentity.CtWSRow;
import kd.bos.service.ctbotp.track.distlogic.CtDistributeRow;
import kd.bos.service.ctbotp.track.distlogic.CtTopDownLogic;
import kd.bos.service.ctbotp.track.helper.CtBFTrackerDbService;
import kd.bos.service.ctbotp.track.helper.CtWRuleCompiler;
import kd.bos.service.ctbotp.track.helper.CtWRuleItemCompiler;
import kd.bos.service.ctbotp.track.helper.CtWRuleItemFunBatchPreCall;
import kd.bos.servicehelper.DBServiceHelper;

public class CtSheetBuilder {
    private CtBFTrackerContext trackerContext;
    private CtBFTrackerDbService dbService;
    protected Map<Long, Set<String>> sourceEntityKeys = new HashMap<Long, Set<String>>();
    private Map<String, BigDecimal> sRowLeavingAmount = new HashMap<String, BigDecimal>();

    public CtSheetBuilder(CtBFTrackerContext trackerContext, CtBFTrackerDbService dbService) {
        this.trackerContext = trackerContext;
        this.dbService = dbService;
    }

    public CtSheet createSheet(CtLinkItemContext linkItemContext, DynamicObject dataEntity) {
        ExtendedDataEntity[] extEntityRows;
        Long billId = this.getPKValue(dataEntity);
        CtSheet sheet = new CtSheet();
        sheet.setBillId(billId);
        CtBeforeTrackEventArgs eventArgs = new CtBeforeTrackEventArgs(dataEntity);
        this.trackerContext.getPlugInProxy().fireBeforeTrack(eventArgs);
        if (eventArgs.isCancel()) {
            return sheet;
        }
        this.sRowLeavingAmount.clear();
        ExtendedDataEntitySet extDataSet = new ExtendedDataEntitySet();
        extDataSet.Parse(new DynamicObject[]{dataEntity}, (MainEntityType)this.trackerContext.getTargetSubMainType());
        for (ExtendedDataEntity extEntityRow : extEntityRows = extDataSet.FindByEntityKey(linkItemContext.getEntityType().getName())) {
            this.createEntityRow(linkItemContext, sheet, extEntityRow.getDataEntity());
        }
        return sheet;
    }

    private void createEntityRow(CtLinkItemContext linkItemContext, CtSheet sheet, DynamicObject entityRow) {
        Long entityId = this.getPKValue(entityRow);
        DynamicObjectCollection linkEntryRows = (DynamicObjectCollection)linkItemContext.getLinkEntryProp().getValue((Object)entityRow);
        CtBeforeCreateArticulationRowEventArgs eventArgs = new CtBeforeCreateArticulationRowEventArgs(linkItemContext.getEntityType(), entityRow, linkEntryRows);
        this.trackerContext.getPlugInProxy().fireBeforeCreateArticulationRow(eventArgs);
        if (eventArgs.isCancel()) {
            return;
        }
        if (!CtSheetBuilder.isPush(linkItemContext.getLinkEntryType(), linkEntryRows)) {
            return;
        }
        if (!eventArgs.isCancelReDistributeAmount()) {
            this.reDistributeAmountFields(linkItemContext, entityRow, linkEntryRows);
        }
        for (DynamicObject linkEntryRow : linkEntryRows) {
            this.createLinkRow(linkItemContext, sheet, entityRow, entityId, linkEntryRow);
        }
    }

    private void createLinkRow(CtLinkItemContext linkItemContext, CtSheet sheet, DynamicObject entityRow, long entityId, DynamicObject linkEntryRow) {
        CtRow row = new CtRow();
        row.setId(new CtRowId("", "", linkItemContext.getMainTableId(), sheet.getBillId(), linkItemContext.getEntityTableId(), entityId));
        Long sBillId = CtSheetBuilder.getLongValue(linkEntryRow, (IDataEntityProperty)linkItemContext.getLinkEntryType().getSBillIdProp());
        Long sTableId = CtSheetBuilder.getLongValue(linkEntryRow, (IDataEntityProperty)linkItemContext.getLinkEntryType().getSTableIdProp());
        Long sId = CtSheetBuilder.getLongValue(linkEntryRow, (IDataEntityProperty)linkItemContext.getLinkEntryType().getSIdProp());
        Long sMainTableId = this.dbService.loadMainTableId(sTableId);
        row.setSId(new CtRowId("", "", sMainTableId, sBillId, sTableId, sId));
        row.setEntityRow(entityRow);
        row.setLinkEntryRow(linkEntryRow);
        CtRowLinkId linkId = new CtRowLinkId(sTableId, sId, linkItemContext.getEntityTableId(), entityId);
        sheet.getCtRows().put(linkId, row);
    }

    public void createWRules(CtLinkItemContext linkItemContext, Map<Long, CtWRuleCompiler> currRuleVers, Map<CtRowId, CtBFRowLinkUpNode> rowLinkUpNodes, CtAED<CtRow> aedRows) {
        CtBeforeExecWriteBackRuleEventArgs eventArgs = new CtBeforeExecWriteBackRuleEventArgs();
        for (CtWRuleCompiler ctWRuleCompiler : currRuleVers.values()) {
            for (CtWRuleItemCompiler itemCompiler : ctWRuleCompiler.getItems().values()) {
                eventArgs.setContext(ctWRuleCompiler.getRule(), itemCompiler.getItem());
                this.trackerContext.getPlugInProxy().fireBeforeExecWriteBackRule(eventArgs);
                itemCompiler.setCancelByPlug(eventArgs.isCancel());
            }
        }
        ArrayList<CtRow> rows = new ArrayList<CtRow>(aedRows.getAddList().size() + aedRows.getEditList().size());
        rows.addAll(aedRows.getAddList());
        for (Tuple<CtRow, CtRow> tuple : aedRows.getEditList()) {
            CtRow row = (CtRow)tuple.item1;
            rows.add(row);
        }
        RowDataModel rowDataModel = new RowDataModel(linkItemContext.getLinkEntryType().getName(), (MainEntityType)this.trackerContext.getTargetSubMainType());
        CtWRuleItemFunBatchPreCall.createWRulePreCall(rows, rowDataModel, currRuleVers, linkItemContext);
        for (CtRow row : rows) {
            rowDataModel.setRowContext(row.getLinkEntryRow());
            for (CtWRuleCompiler ruleCompiler : currRuleVers.values()) {
                for (CtWRuleItemCompiler itemCompiler : ruleCompiler.getItems().values()) {
                    this.createWRule(linkItemContext, rowLinkUpNodes, rowDataModel, row, ruleCompiler, itemCompiler);
                }
            }
        }
    }

    private void createWRule(CtLinkItemContext linkItemContext, Map<CtRowId, CtBFRowLinkUpNode> rowLinkUpNodes, RowDataModel rowDataModel, CtRow row, CtWRuleCompiler ruleCompiler, CtWRuleItemCompiler itemCompiler) {
        if (itemCompiler.isCancelByPlug() || !this.isValidRuleItem(linkItemContext, rowDataModel, itemCompiler)) {
            return;
        }
        CtWRule wRule = new CtWRule();
        wRule.setRuleVerId(ruleCompiler.getVerId());
        wRule.setRuleItemId(itemCompiler.getItemId());
        BigDecimal val = itemCompiler.calcFormula(rowDataModel);
        Object cVal = itemCompiler.calcCoverVal(rowDataModel);
        wRule.setVal(val);
        wRule.setCVal(cVal);
        CtWRuleItemId id = new CtWRuleItemId(ruleCompiler.getVerId(), itemCompiler.getItemId());
        row.getWrules().put(id, wRule);
        this.createWRows(linkItemContext, rowLinkUpNodes, row, wRule, ruleCompiler, itemCompiler);
    }

    private void createWRows(CtLinkItemContext linkItemContext, Map<CtRowId, CtBFRowLinkUpNode> rowLinkUpNodes, CtRow row, CtWRule wRule, CtWRuleCompiler ruleCompiler, CtWRuleItemCompiler itemCompiler) {
        ArrayList<CtBFRowId> sRowIds = new ArrayList<CtBFRowId>();
        Long sRowMainTableId = this.dbService.loadMainTableId(row.getSId().getTableId());
        if (sRowMainTableId.equals(ruleCompiler.getSrcMainTableId())) {
            sRowIds.add(row.getSId());
        } else {
            CtBFRowLinkUpNode node = rowLinkUpNodes.get((Object)row.getSId());
            List sNodes = node.findSourceNodes(ruleCompiler.getSrcMainTableId());
            for (CtBFRowLinkUpNode sNode : sNodes) {
                sRowIds.add(sNode.getRowId());
            }
        }
        for (CtBFRowId rowId : sRowIds) {
            if (!this.isCommitEntity(rowId, ruleCompiler, itemCompiler)) continue;
            Object wsRow = new CtWSRow();
            CtRowId sId = new CtRowId("", "", rowId.getMainTableId(), rowId.getBillId(), rowId.getTableId(), rowId.getEntryId());
            ((CtWSRow)wsRow).setSId(sId);
            ((CtWSRow)wsRow).setVal(wRule.getVal());
            ((CtWSRow)wsRow).setCVal(wRule.getCVal());
            wRule.getCurrSourceRows().put(sId, (CtWSRow)wsRow);
        }
        if (wRule.getCurrSourceRows().size() > 1) {
            for (Object wsRow : wRule.getCurrSourceRows().values()) {
                ((CtWSRow)wsRow).setVal(BigDecimal.ZERO);
            }
        }
        CtAfterCalcWriteValueEventArgs eventArgs = new CtAfterCalcWriteValueEventArgs(linkItemContext.getEntityType(), row.getEntityRow(), ruleCompiler.getRule(), itemCompiler.getItem(), wRule.getVal(), wRule.getCVal());
        for (Object wsRow : wRule.getCurrSourceRows().values()) {
            eventArgs.getSrcRowVal().put(((CtWSRow)wsRow).getSId(), ((CtWSRow)wsRow).getVal());
        }
        this.trackerContext.getPlugInProxy().fireAfterCalcWriteValue(eventArgs);
        if (wRule.getCurrSourceRows().size() > 1 && itemCompiler.getItem().getWriteBackType() != CtWriteBackType.Cover) {
            boolean assign = false;
            for (CtWSRow wsRow : wRule.getCurrSourceRows().values()) {
                BigDecimal plugValue = (BigDecimal)eventArgs.getSrcRowVal().get((Object)wsRow.getSId());
                if (plugValue == null || BigDecimal.ZERO.compareTo(plugValue) == 0) continue;
                assign = true;
                break;
            }
            if (!assign) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5408\u5e76\u4e0b\u63a8\u540e\u8de8\u7ea7\u53cd\u5199\uff0c\u5fc5\u987b\u81ea\u884c\u5f00\u53d1\u63d2\u4ef6\u5206\u914d\u53cd\u5199\u91cf\uff0c\u4e14\u5206\u914d\u603b\u989d\u4e0e\u8ba1\u7b97\u989d\u76f8\u7b49", (String)"SheetBuilder_0", (String)"bos-mservice-botp", (Object[])new Object[0]));
            }
        }
        for (Object wsRow : wRule.getCurrSourceRows().values()) {
            if (!eventArgs.getSrcRowVal().containsKey((Object)((CtWSRow)wsRow).getSId())) continue;
            ((CtWSRow)wsRow).setVal((BigDecimal)eventArgs.getSrcRowVal().get((Object)((CtWSRow)wsRow).getSId()));
        }
    }

    private void reDistributeAmountFields(CtLinkItemContext linkItemContext, DynamicObject entityRow, DynamicObjectCollection linkEntryRows) {
        for (Map.Entry entry : linkItemContext.getLinkEntryType().getCtrlFieldProps().entrySet()) {
            String ctrlFieldKey = (String)entry.getKey();
            DynamicProperty ctrlField = (DynamicProperty)linkItemContext.getEntityType().findProperty(ctrlFieldKey);
            DynamicProperty ctrlField_new = (DynamicProperty)entry.getValue();
            DynamicProperty ctrlField_old = (DynamicProperty)linkItemContext.getLinkEntryType().getOldCtrlFieldProps().get(ctrlFieldKey);
            if (linkEntryRows.size() == 1) {
                ctrlField_new.setValueFast(linkEntryRows.get(0), ctrlField.getValueFast((Object)entityRow));
                continue;
            }
            this.reDistributeAmountField(linkItemContext, ctrlField, ctrlField_old, ctrlField_new, entityRow, linkEntryRows);
        }
    }

    private void reDistributeAmountField(CtLinkItemContext linkItemContext, DynamicProperty ctrlField, DynamicProperty ctrlField_old, DynamicProperty ctrlField_new, DynamicObject entityRow, DynamicObjectCollection linkEntryRows) {
        BigDecimal distributeAmount;
        DynamicProperty sTableIdProp = linkItemContext.getLinkEntryType().getSTableIdProp();
        DynamicProperty sIdProp = linkItemContext.getLinkEntryType().getSIdProp();
        boolean isHasLinkCopy = false;
        BigDecimal entityRowAmount = (BigDecimal)ctrlField.getValue((Object)entityRow);
        BigDecimal linkRowsAmount = new BigDecimal(0);
        CtTopDownLogic distributeLogic = new CtTopDownLogic();
        for (DynamicObject linkEntryRow : linkEntryRows) {
            BigDecimal oldAmount = (BigDecimal)ctrlField_old.getValue((Object)linkEntryRow);
            distributeAmount = (BigDecimal)ctrlField_new.getValue((Object)linkEntryRow);
            linkRowsAmount = linkRowsAmount.add(distributeAmount);
            String cid = String.format("%s,%d,%d", ctrlField.getName(), (Long)sTableIdProp.getValueFast((Object)linkEntryRow), (Long)sIdProp.getValueFast((Object)linkEntryRow));
            BigDecimal leafAmount = this.sRowLeavingAmount.get(cid);
            if (leafAmount != null) {
                isHasLinkCopy = true;
            } else {
                leafAmount = oldAmount;
            }
            distributeLogic.getCtDistributeRows().add(new CtDistributeRow(leafAmount));
            this.sRowLeavingAmount.put(cid, leafAmount.subtract(distributeAmount));
        }
        distributeLogic.setTotalAmount(entityRowAmount);
        if (!isHasLinkCopy && entityRowAmount.compareTo(linkRowsAmount) == 0) {
            return;
        }
        distributeLogic.Distribute();
        int i = 0;
        for (DynamicObject linkEntryRow : linkEntryRows) {
            distributeAmount = (BigDecimal)ctrlField_new.getValueFast((Object)linkEntryRow);
            BigDecimal reDistributeAmount = distributeLogic.getCtDistributeRows().get(i).getDistAmount();
            String cid = String.format("%s,%d,%d", ctrlField.getName(), (Long)sTableIdProp.getValueFast((Object)linkEntryRow), (Long)sIdProp.getValueFast((Object)linkEntryRow));
            ctrlField_new.setValueFast((Object)linkEntryRow, (Object)reDistributeAmount);
            BigDecimal leafAmount = this.sRowLeavingAmount.get(cid);
            if (leafAmount != null) {
                if ((leafAmount = leafAmount.subtract(reDistributeAmount).add(distributeAmount)).compareTo(new BigDecimal(0)) < 0) {
                    leafAmount = new BigDecimal(0);
                }
                this.sRowLeavingAmount.put(cid, leafAmount);
            }
            ++i;
        }
    }

    private static boolean isPush(CtLinkEntryType linkEntryType, DynamicObjectCollection linkEntryRows) {
        if (linkEntryRows.size() == 0) {
            return false;
        }
        Long sid = CtSheetBuilder.getLongValue((DynamicObject)linkEntryRows.get(0), (IDataEntityProperty)linkEntryType.getSIdProp());
        return sid != null && Long.compare(sid, 0L) != 0;
    }

    private boolean isValidRuleItem(CtLinkItemContext linkItemContext, RowDataModel rowDataModel, CtWRuleItemCompiler itemCompiler) {
        if (itemCompiler.getItem().isDisabled() || !linkItemContext.getTargetEntityKeys().contains(itemCompiler.getTargetEntityKey())) {
            return false;
        }
        return itemCompiler.checkWriteCondition(rowDataModel);
    }

    private boolean isCommitEntity(CtBFRowId sRowId, CtWRuleCompiler ruleCompiler, CtWRuleItemCompiler itemCompiler) {
        Set<String> entityKeys = this.getSourceEntitys(ruleCompiler.getSourceMainType(), sRowId.getTableId());
        return entityKeys.contains(itemCompiler.getSourceEntityKey());
    }

    private Set<String> getSourceEntitys(BillEntityType srcMainType, Long sTableId) {
        return this.sourceEntityKeys.computeIfAbsent(sTableId, key -> {
            HashSet<String> newEntitys = new HashSet<String>();
            CtConvertDataService reader = new CtConvertDataService();
            TableDefine tableDefine = reader.loadTableDefine(key);
            for (EntityType entityType = (EntityType)srcMainType.getAllEntities().get(tableDefine.getEntityKey()); entityType != null; entityType = (EntityType)entityType.getParent()) {
                newEntitys.add(entityType.getName());
            }
            return newEntitys;
        });
    }

    private Long getPKValue(DynamicObject dataEntity) {
        Long id = (Long)dataEntity.getPkValue();
        if (id == null || Long.compare(id, 0L) == 0) {
            id = DBServiceHelper.genGlobalLongId();
            dataEntity.set((IDataEntityProperty)dataEntity.getDataEntityType().getPrimaryKey(), (Object)id);
        }
        return id;
    }

    private static Long getLongValue(DynamicObject obj, IDataEntityProperty prop) {
        if (obj == null) {
            return null;
        }
        Object value = prop.getValueFast((Object)obj);
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return Long.valueOf(value.toString());
    }
}

