/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.helper;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.service.ctbotp.track.CtBFTrackerContext;
import kd.bos.service.ctbotp.track.CtLinkItemContext;
import kd.bos.service.ctbotp.track.bizentity.CtRow;
import kd.bos.service.ctbotp.track.bizentity.CtRowId;
import kd.bos.service.ctbotp.track.bizentity.CtRowLinkId;
import kd.bos.service.ctbotp.track.bizentity.CtSheet;
import kd.bos.service.ctbotp.track.bizentity.CtSheets;
import kd.bos.service.ctbotp.track.bizentity.CtWRule;
import kd.bos.service.ctbotp.track.bizentity.CtWRuleItemId;
import kd.bos.service.ctbotp.track.bizentity.CtWSRow;
import kd.bos.service.ctbotp.track.helper.CtBFTrackerDbService;
import kd.bos.service.ctbotp.track.helper.CtTrackerTypes;

public class CtSheetSnapBuilder {
    private CtBFTrackerContext trackerContext;
    private CtBFTrackerDbService dbService;
    private CtTrackerTypes ctTrackerTypes;

    public CtSheetSnapBuilder(CtBFTrackerContext trackerContext, CtBFTrackerDbService dbService) {
        this.trackerContext = trackerContext;
        this.dbService = dbService;
        this.ctTrackerTypes = this.trackerContext.getTrackerTypes();
    }

    public CtSheets createSheets(CtLinkItemContext linkItemContext, Map<Long, List<DynamicObject>> snapshotObjs) {
        CtSheets sheets = new CtSheets(linkItemContext.getLinkSetItem().getCtParentEntityKey(), linkItemContext.getLinkSetItem().getCtLinkEntityKey());
        for (Map.Entry<Long, List<DynamicObject>> entry : snapshotObjs.entrySet()) {
            Long billId = entry.getKey();
            List<DynamicObject> list = entry.getValue();
            CtSheet sheet = new CtSheet();
            sheet.setBillId(billId);
            sheets.put(billId, sheet);
            for (DynamicObject snapshotObj : list) {
                this.createRow(sheet, linkItemContext.getMainTableId(), linkItemContext.getEntityTableId(), snapshotObj);
            }
        }
        return sheets;
    }

    private void createRow(CtSheet sheet, Long mainTableId, Long tableId, DynamicObject snapshotObj) {
        Long sBillId = (Long)this.ctTrackerTypes.getSS_sBillIdProp().getValueFast((Object)snapshotObj);
        Long sTableId = (Long)this.ctTrackerTypes.getSS_sTableIdProp().getValueFast((Object)snapshotObj);
        Long sId = (Long)this.ctTrackerTypes.getSS_sIdProp().getValueFast((Object)snapshotObj);
        Long tId = (Long)this.ctTrackerTypes.getSS_tIdProp().getValueFast((Object)snapshotObj);
        Long sMainTableId = this.dbService.loadMainTableId(sTableId);
        CtRowLinkId linkId = new CtRowLinkId(sTableId, sId, tableId, tId);
        CtRow row = (CtRow)sheet.getCtRows().get(linkId);
        if (row == null) {
            row = new CtRow();
            row.setEntryTrackerId((Long)snapshotObj.getPkValue());
            CtRowId rowId = new CtRowId("", "", mainTableId, sheet.getBillId(), tableId, tId);
            row.setId(rowId);
            CtRowId sRowId = new CtRowId("", "", sMainTableId, sBillId, sTableId, sId);
            row.setSId(sRowId);
            sheet.getCtRows().put(linkId, row);
        }
        DynamicObjectCollection wbEntryRows = (DynamicObjectCollection)this.ctTrackerTypes.getSS_wbEntryProp().getValueFast((Object)snapshotObj);
        for (DynamicObject wbEntryRow : wbEntryRows) {
            this.createWRule(row, wbEntryRow);
        }
    }

    private void createWRule(CtRow row, DynamicObject wbEntryRow) {
        Long ruleVerId = (Long)this.ctTrackerTypes.getSS_ruleVerIdProp().getValueFast((Object)wbEntryRow);
        Long ruleItemId = (Long)this.ctTrackerTypes.getSS_ruleItemIdProp().getValueFast((Object)wbEntryRow);
        CtWRuleItemId itemId = new CtWRuleItemId(ruleVerId, ruleItemId);
        CtWRule wRule = (CtWRule)row.getWrules().get(itemId);
        if (wRule == null) {
            wRule = new CtWRule();
            wRule.setRuleItemId(ruleItemId);
            wRule.setRuleVerId(ruleVerId);
            row.getWrules().put(itemId, wRule);
        }
        Long wb_SBillId = (Long)this.ctTrackerTypes.getSS_wbEntry_sBillIdProp().getValueFast((Object)wbEntryRow);
        Long wb_STableId = (Long)this.ctTrackerTypes.getSS_wbEntry_sTableIdProp().getValueFast((Object)wbEntryRow);
        Long wb_SId = (Long)this.ctTrackerTypes.getSS_wbEntry_sIdProp().getValueFast((Object)wbEntryRow);
        BigDecimal wb_value = (BigDecimal)this.ctTrackerTypes.getSS_wbEntry_valueProp().getValueFast((Object)wbEntryRow);
        Long wb_SMainTableId = this.dbService.loadMainTableId(wb_STableId);
        CtWSRow wsRow = new CtWSRow();
        wsRow.setWBEntryId((Long)wbEntryRow.getPkValue());
        CtRowId sId = new CtRowId("", "", wb_SMainTableId, wb_SBillId, wb_STableId, wb_SId);
        wsRow.setSId(sId);
        wsRow.setVal(wb_value);
        wRule.getHistorySourceRows().put(sId, wsRow);
    }
}

