/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.helper;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.ctbotp.runtime.CtWriteBackFormula;
import kd.bos.entity.ctbotp.runtime.CtWriteBackType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.exception.KDBizException;
import kd.bos.service.ctbotp.track.CtBFTrackerContext;
import kd.bos.service.ctbotp.track.CtWriteBackContext;
import kd.bos.service.ctbotp.track.bizentity.CtWSRow;
import kd.bos.service.ctbotp.track.getvaluemode.CtFieldValueTypeConvert;
import kd.bos.service.ctbotp.track.getvaluemode.CtFieldVariable;
import kd.bos.service.ctbotp.track.getvaluemode.CtGetConstValue;
import kd.bos.service.ctbotp.track.getvaluemode.CtGetFieldValue;
import kd.bos.service.ctbotp.track.getvaluemode.CtGetFormulaValue;
import kd.bos.service.ctbotp.track.getvaluemode.CtReplaceVerValue;
import kd.bos.service.ctbotp.track.getvaluemode.ICtGetValueMode;
import kd.bos.service.ctbotp.track.helper.CtWRuleCompiler;
import kd.bos.service.ctbotp.track.wblogicunit.ICtWriteBack;

public class CtWRuleItemCompiler {
    private CtBFTrackerContext trackerContext;
    private CtWRuleCompiler ruleCompiler;
    private CtWriteBackFormula item;
    private ICtGetValueMode gridFilterExecuter;
    private ICtGetValueMode expressionExecuter;
    private ICtGetValueMode formulaExecuter;
    private ICtGetValueMode coverValExecuter;
    private String targetEntityKey;
    private Map<String, IDataEntityProperty> targetFields = new HashMap<String, IDataEntityProperty>();
    private Map<String, String> targetCtrlFldKeys = new HashMap<String, String>();
    private String sourceEntityKey;
    private DynamicProperty sourceField;
    private ICtGetValueMode scaleGetHandler;
    private ICtGetValueMode defScaleGetHandler;
    private ICtWriteBack writeBackExecuter;
    private CtFieldValueTypeConvert valueTypeConvert;
    private boolean cancelByPlug = false;
    private static final int DEFAULTSCALE = 10;

    public CtWRuleItemCompiler(CtBFTrackerContext trackerContext, CtWRuleCompiler ruleCompiler, CtWriteBackFormula item) {
        this.trackerContext = trackerContext;
        this.ruleCompiler = ruleCompiler;
        this.item = item;
        this.compile();
    }

    public CtWRuleItemCompiler(CtBFTrackerContext trackerContext, CtWRuleCompiler ruleCompiler, CtWriteBackFormula item, boolean isAfterPrepareProperty) {
        this.trackerContext = trackerContext;
        this.ruleCompiler = ruleCompiler;
        this.item = item;
        this.afterPreparePropertyCompile();
    }

    public CtWriteBackFormula getItem() {
        return this.item;
    }

    public Long getItemId() {
        return this.item.getId();
    }

    public String getTargetEntityKey() {
        return this.targetEntityKey;
    }

    public Map<String, IDataEntityProperty> getTargetFields() {
        return this.targetFields;
    }

    public String getSourceEntityKey() {
        return this.sourceEntityKey;
    }

    public DynamicProperty getSourceField() {
        return this.sourceField;
    }

    public ICtGetValueMode getScaleGetHandler() {
        return this.scaleGetHandler;
    }

    public boolean isCancelByPlug() {
        return this.cancelByPlug;
    }

    public void setCancelByPlug(boolean cancelByPlug) {
        this.cancelByPlug = cancelByPlug;
    }

    public ICtGetValueMode getGridFilterExecuter() {
        return this.gridFilterExecuter;
    }

    public void setGridFilterExecuter(ICtGetValueMode gridFilterExecuter) {
        this.gridFilterExecuter = gridFilterExecuter;
    }

    public ICtGetValueMode getExpressionExecuter() {
        return this.expressionExecuter;
    }

    public void setExpressionExecuter(ICtGetValueMode expressionExecuter) {
        this.expressionExecuter = expressionExecuter;
    }

    public ICtGetValueMode getFormulaExecuter() {
        return this.formulaExecuter;
    }

    public void setFormulaExecuter(ICtGetValueMode formulaExecuter) {
        this.formulaExecuter = formulaExecuter;
    }

    public ICtGetValueMode getCoverValExecuter() {
        return this.coverValExecuter;
    }

    public void setCoverValExecuter(ICtGetValueMode coverValExecuter) {
        this.coverValExecuter = coverValExecuter;
    }

    public boolean checkWriteCondition(RowDataModel rowDataModel) {
        return (Boolean)this.gridFilterExecuter.getValue(rowDataModel) != false && (Boolean)this.expressionExecuter.getValue(rowDataModel) != false;
    }

    public BigDecimal calcFormula(RowDataModel rowDataModel) {
        BigDecimal value;
        CtReplaceVerValue replaceVerValue = this.getReplaceVerValue();
        try {
            Object calcValue = this.formulaExecuter.getValue(rowDataModel, replaceVerValue);
            if (StringUtils.isBlank((Object)calcValue)) {
                return BigDecimal.ZERO;
            }
            value = new BigDecimal(String.valueOf(calcValue));
        }
        catch (NumberFormatException e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53cd\u5199\u89c4\u5219\u6807\u8bc6[%1s]\uff0c\u53cd\u5199\u516c\u5f0f[%2s]\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u89e3\u6790\u5230\u6709\u6548\u6570\u636e\u3002", (String)"WRuleItemCompiler_3", (String)"bos-mservice-botp", (Object[])new Object[0]), this.ruleCompiler.getRule().getId(), this.formulaExecuter instanceof CtGetFormulaValue ? ((CtGetFormulaValue)this.formulaExecuter).getFormula() : ""));
        }
        return value;
    }

    public CtReplaceVerValue getReplaceVerValue() {
        CtReplaceVerValue replaceVerValue = new CtReplaceVerValue(){

            @Override
            public Object replace(RowDataModel rowDataModel, String var, Object oldValue) {
                Object value = oldValue;
                String ctrlFldKey = (String)CtWRuleItemCompiler.this.targetCtrlFldKeys.get(var);
                DynamicObject activeRow = (DynamicObject)rowDataModel.getActiveRow();
                if (ctrlFldKey != null && activeRow.getDataEntityType().getProperties().containsKey((Object)ctrlFldKey)) {
                    value = rowDataModel.getValue((String)CtWRuleItemCompiler.this.targetCtrlFldKeys.get(var));
                }
                return value;
            }
        };
        return replaceVerValue;
    }

    public Object calcCoverVal(RowDataModel rowDataModel) {
        Object value = this.coverValExecuter.getValue(rowDataModel);
        return value;
    }

    public int calcScale(RowDataModel rowDataModel) {
        Object scale = this.scaleGetHandler.getValue(rowDataModel);
        if (scale != null) {
            return (Integer)scale;
        }
        return (Integer)this.defScaleGetHandler.getValue(rowDataModel);
    }

    @Deprecated
    public synchronized void doWriteBack(RowDataModel rowDataModel, CtWSRow wsRow) {
        int scale = this.calcScale(rowDataModel);
        this.writeBackExecuter.doWriteBack(rowDataModel, this.item.getSourceCommitFieldKey(), wsRow.getVal(), wsRow.getCVal(), scale);
    }

    public synchronized void doWriteBack(CtWriteBackContext writebackContext, RowDataModel rowDataModel, CtWSRow wsRow) {
        int scale = this.calcScale(rowDataModel);
        this.writeBackExecuter.doWriteBack(writebackContext, this, rowDataModel, wsRow, scale);
    }

    private void compile() {
        this.compileCondition();
        this.compileFormula();
        this.compileSrcCommitField();
        BillEntityType e1 = this.trackerContext.getTargetMainType();
        for (IDataEntityProperty property : this.targetFields.values()) {
            EntityType e2 = (EntityType)property.getParent();
            e1 = this.compareEntity((EntityType)e1, e2);
        }
        this.targetEntityKey = e1.getName();
    }

    private void afterPreparePropertyCompile() {
        this.compileCondition();
        this.compileFormula();
        BillEntityType e1 = this.trackerContext.getTargetMainType();
        for (IDataEntityProperty property : this.targetFields.values()) {
            EntityType e2 = (EntityType)property.getParent();
            e1 = this.compareEntity((EntityType)e1, e2);
        }
        this.targetEntityKey = e1.getName();
    }

    private void compileCondition() {
        if (this.item.getCondition() == null) {
            this.gridFilterExecuter = new CtGetConstValue(Boolean.TRUE);
            this.expressionExecuter = new CtGetConstValue(Boolean.TRUE);
        } else {
            FilterBuilder filterBuilder;
            String[] filterScripts;
            BillEntityType mainType = this.trackerContext.getTargetMainType();
            String gridFilterString = "";
            String expression = this.item.getCondition().getExpression();
            FilterCondition filterCondition = this.item.getCondition().getFilterCondition();
            this.gridFilterExecuter = filterCondition == null || filterCondition.getFilterRow().size() == 0 ? new CtGetConstValue(Boolean.TRUE) : (StringUtils.isBlank((CharSequence)(gridFilterString = (filterScripts = (filterBuilder = new FilterBuilder((MainEntityType)mainType, this.item.getCondition().getFilterCondition())).buildFilterScript())[0])) ? new CtGetConstValue(Boolean.TRUE) : new CtGetFormulaValue(mainType, gridFilterString, this.trackerContext.getFuncLib()));
            this.expressionExecuter = StringUtils.isBlank((CharSequence)expression) ? new CtGetConstValue(Boolean.TRUE) : new CtGetFormulaValue(mainType, expression, this.trackerContext.getFuncLib());
        }
        this.addTargetField(this.gridFilterExecuter.getVars());
        this.addTargetField(this.expressionExecuter.getVars());
    }

    private void compileFormula() {
        if (this.item.getFormula() == null || StringUtils.isBlank((CharSequence)this.item.getFormula().getExpression())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53cd\u5199\u89c4\u5219[%s]\u6ca1\u6709\u914d\u7f6e\u53cd\u5199\u503c\u8ba1\u7b97\u516c\u5f0f", (String)"WRuleItemCompiler_0", (String)"bos-mservice-botp", (Object[])new Object[0]), this.ruleCompiler.getRule().getName().toString()));
        }
        BillEntityType mainType = this.trackerContext.getTargetMainType();
        HashMap allCtrlFldKeys = new HashMap();
        for (EntityType entityType : mainType.getAllEntities().values()) {
            if (!(entityType instanceof LinkEntryType)) continue;
            LinkEntryType linkEntryType = (LinkEntryType)entityType;
            allCtrlFldKeys.putAll(linkEntryType.getCtrlFieldProps());
        }
        ICtGetValueMode valueModel = null;
        this.targetCtrlFldKeys.clear();
        String formula = this.getItem().getFormula().getExpression().trim();
        IDataEntityProperty formulaProp = mainType.findProperty(formula);
        if (formulaProp != null) {
            String fldKey = formula;
            if (allCtrlFldKeys.containsKey(formulaProp.getName())) {
                fldKey = ((DynamicProperty)allCtrlFldKeys.get(fldKey)).getName();
            }
            valueModel = new CtGetFieldValue(mainType, fldKey);
        } else {
            valueModel = new CtGetFormulaValue(this.trackerContext.getTargetMainType(), formula, this.trackerContext.getFuncLib());
            for (CtFieldVariable var : valueModel.getVars()) {
                String varString = var.getVar();
                String fldKey = var.getFieldProp().getName();
                DynamicProperty dynamicProperty = (DynamicProperty)allCtrlFldKeys.get(fldKey);
                if (dynamicProperty == null || this.targetCtrlFldKeys.containsKey(varString)) continue;
                this.targetCtrlFldKeys.put(varString, dynamicProperty.getName());
            }
        }
        this.addTargetField(valueModel.getVars());
        if (this.item.getWriteBackType() == CtWriteBackType.Cover) {
            this.formulaExecuter = new CtGetConstValue(BigDecimal.ZERO);
            this.coverValExecuter = valueModel;
        } else {
            this.formulaExecuter = valueModel;
            this.coverValExecuter = new CtGetConstValue(null);
        }
    }

    private void compileSrcCommitField() {
        BillEntityType mainType = this.ruleCompiler.getSourceMainType();
        this.sourceField = (DynamicProperty)mainType.findProperty(this.item.getSourceCommitFieldKey());
        if (this.sourceField == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53cd\u5199\u89c4\u5219[%1$s]\u914d\u7f6e\u9519\u8bef\uff1a\u5728\u6e90\u5355[%2$s]\u4e0a\uff0c\u627e\u4e0d\u5230\u53cd\u5199\u5b57\u6bb5[%3$s]", (String)"WRuleItemCompiler_2", (String)"bos-mservice-botp", (Object[])new Object[0]), this.ruleCompiler.getRule().getName().toString(), this.ruleCompiler.getSourceMainType().getDisplayName().toString(), this.item.getSourceCommitFieldKey()));
        }
        this.sourceEntityKey = this.sourceField.getParent().getName();
        if (this.item.getWriteBackType() == CtWriteBackType.Cover) {
            this.scaleGetHandler = new CtGetConstValue(10);
        } else if (!(this.sourceField instanceof DecimalProp)) {
            this.scaleGetHandler = new CtGetConstValue(10);
        } else {
            DecimalProp decimalProp = (DecimalProp)this.sourceField;
            this.defScaleGetHandler = new CtGetConstValue(decimalProp.getScale());
            if (StringUtils.isBlank((CharSequence)decimalProp.getControlPropName())) {
                this.scaleGetHandler = new CtGetConstValue(decimalProp.getScale());
            } else if (this.sourceField instanceof PriceProp) {
                String scalePropName = decimalProp.getControlPropName() + "." + "priceprecision";
                this.scaleGetHandler = new CtGetFieldValue(mainType, scalePropName);
            } else if (this.sourceField instanceof AmountProp) {
                String scalePropName = decimalProp.getControlPropName() + "." + "amtprecision";
                this.scaleGetHandler = new CtGetFieldValue(mainType, scalePropName);
            } else if (this.sourceField instanceof QtyProp) {
                String scalePropName = decimalProp.getControlPropName() + "." + "precision";
                this.scaleGetHandler = new CtGetFieldValue(mainType, scalePropName);
            } else {
                this.scaleGetHandler = new CtGetConstValue(decimalProp.getScale());
            }
        }
        this.writeBackExecuter = ICtWriteBack.create(this.item.getWriteBackType());
        Class fldValType = this.sourceField.getPropertyType();
        this.createSrcFldTypeConvert();
        this.writeBackExecuter.setFieldValueType(fldValType);
        this.writeBackExecuter.setFieldValueTypeConvert(this.valueTypeConvert);
    }

    private void createSrcFldTypeConvert() {
        Class fieldValueType = this.sourceField.getPropertyType();
        this.valueTypeConvert = this.item.getWriteBackType() == CtWriteBackType.Cover ? new CtFieldValueTypeConvert(){

            @Override
            public Object convert(Object value, Class<?> fldValType) {
                return CtFieldValueTypeConvert.super.convert(value, fldValType);
            }
        } : (fieldValueType.isAssignableFrom(Long.class) ? new CtFieldValueTypeConvert(){

            @Override
            public Object convert(Object value, Class<?> fldValType) {
                Long newValue = ((BigDecimal)value).longValue();
                return newValue;
            }
        } : (fieldValueType.isAssignableFrom(Integer.class) ? new CtFieldValueTypeConvert(){

            @Override
            public Object convert(Object value, Class<?> fldValType) {
                Integer newValue = ((BigDecimal)value).intValue();
                return newValue;
            }
        } : (fieldValueType.isAssignableFrom(BigDecimal.class) ? new CtFieldValueTypeConvert(){

            @Override
            public Object convert(Object value, Class<?> fldValType) {
                return value;
            }
        } : new CtFieldValueTypeConvert(){

            @Override
            public Object convert(Object value, Class<?> fldValType) {
                return CtFieldValueTypeConvert.super.convert(value, fldValType);
            }
        })));
    }

    private EntityType compareEntity(EntityType e1, EntityType e2) {
        int l2;
        if (e1 == null) {
            return e2;
        }
        if (e2 == null) {
            return e1;
        }
        int l1 = this.getEntityLevel(e1);
        if (l1 > (l2 = this.getEntityLevel(e2))) {
            return e1;
        }
        if (l2 > l1) {
            return e2;
        }
        return e1;
    }

    private int getEntityLevel(EntityType e1) {
        if (e1 == null) {
            return -1;
        }
        if (e1 instanceof LinkEntryType) {
            int parentLevel = this.getEntityLevel((EntityType)e1.getParent());
            return parentLevel + 1;
        }
        if (e1 instanceof SubEntryType) {
            return 3;
        }
        if (e1 instanceof EntryType) {
            return 2;
        }
        if (e1 instanceof MainEntityType) {
            return 1;
        }
        return 99;
    }

    private void addTargetField(List<CtFieldVariable> vars) {
        for (CtFieldVariable var : vars) {
            if (this.targetFields.containsKey(var.getFieldProp().getName())) continue;
            this.targetFields.put(var.getFieldProp().getName(), var.getFieldProp());
        }
    }
}

