/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.track.CtLinkItemContext;
import kd.bos.service.ctbotp.track.bizentity.CtRow;
import kd.bos.service.ctbotp.track.getvaluemode.CtReplaceVerValue;
import kd.bos.service.ctbotp.track.helper.CtWRuleCompiler;
import kd.bos.service.ctbotp.track.helper.CtWRuleItemCompiler;

public class CtWRuleItemFunBatchPreCall {
    private static Log log = LogFactory.getLog(CtWRuleItemFunBatchPreCall.class);

    public static void createWRulePreCall(List<CtRow> rows, RowDataModel rowDataModel, Map<Long, CtWRuleCompiler> currRuleVers, CtLinkItemContext linkItemContext) {
        try {
            HashMap<String, Boolean> preCallMap = new HashMap<String, Boolean>(16);
            for (CtRow row : rows) {
                String key = CtWRuleItemFunBatchPreCall.getKey(row);
                if (preCallMap.get(key) != null && !((Boolean)preCallMap.get(key)).booleanValue()) continue;
                rowDataModel.setRowContext(row.getLinkEntryRow());
                boolean isCreateWRulePreCall = false;
                for (CtWRuleCompiler ruleCompiler : currRuleVers.values()) {
                    for (CtWRuleItemCompiler itemCompiler : ruleCompiler.getItems().values()) {
                        if (!CtWRuleItemFunBatchPreCall.createWRulePreCall(linkItemContext, rowDataModel, itemCompiler)) continue;
                        isCreateWRulePreCall = true;
                    }
                }
                preCallMap.put(key, isCreateWRulePreCall);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private static String getKey(CtRow row) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(row.getSId().getMainTableId());
        stringBuilder.append(row.getSId().getTableId());
        stringBuilder.append(row.getId().getMainTableId());
        stringBuilder.append(row.getId().getTableId());
        return stringBuilder.toString();
    }

    private static boolean createWRulePreCall(CtLinkItemContext linkItemContext, RowDataModel rowDataModel, CtWRuleItemCompiler itemCompiler) {
        if (itemCompiler.isCancelByPlug() || itemCompiler.getItem().isDisabled() || !linkItemContext.getTargetEntityKeys().contains(itemCompiler.getTargetEntityKey())) {
            return false;
        }
        return CtWRuleItemFunBatchPreCall.checkWriteConditionPreCall(itemCompiler, rowDataModel) || CtWRuleItemFunBatchPreCall.calcFormulaPreCall(itemCompiler, rowDataModel);
    }

    private static boolean calcFormulaPreCall(CtWRuleItemCompiler itemCompiler, RowDataModel rowDataModel) {
        CtReplaceVerValue replaceVerValue = itemCompiler.getReplaceVerValue();
        boolean isBatchPreCall = itemCompiler.getFormulaExecuter().batchPreCall(rowDataModel, replaceVerValue);
        return isBatchPreCall;
    }

    private static boolean checkWriteConditionPreCall(CtWRuleItemCompiler itemCompiler, RowDataModel rowDataModel) {
        return itemCompiler.getGridFilterExecuter().batchPreCall(rowDataModel) || itemCompiler.getExpressionExecuter().batchPreCall(rowDataModel);
    }
}

