/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.opcontroller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.ctbotp.runtime.CtBFRowLinkUpNode;
import kd.bos.entity.ctbotp.runtime.CtWriteBackRuleElement;
import kd.bos.service.botp.track.BFTrackerOpType;
import kd.bos.service.ctbotp.track.CtBFTrackerContext;
import kd.bos.service.ctbotp.track.CtLinkItemContext;
import kd.bos.service.ctbotp.track.bizentity.CtAED;
import kd.bos.service.ctbotp.track.bizentity.CtRow;
import kd.bos.service.ctbotp.track.bizentity.CtRowId;
import kd.bos.service.ctbotp.track.bizentity.CtSheet;
import kd.bos.service.ctbotp.track.bizentity.CtSheets;
import kd.bos.service.ctbotp.track.bizentity.CtWRule;
import kd.bos.service.ctbotp.track.helper.CtBFTrackerDbService;
import kd.bos.service.ctbotp.track.helper.CtSheetBuilder;
import kd.bos.service.ctbotp.track.helper.CtSheetSnapBuilder;
import kd.bos.service.ctbotp.track.helper.CtWRuleCompiler;
import kd.bos.service.ctbotp.track.opcontroller.ICtOpController;

class AbstractCtOpController
implements ICtOpController {
    private BFTrackerOpType opType;
    protected CtBFTrackerContext trackerContext;
    protected CtBFTrackerDbService dbService;
    protected CtSheetBuilder sheetBuilder;
    protected CtSheetSnapBuilder sheetSnapBuilder;

    AbstractCtOpController() {
    }

    @Override
    public BFTrackerOpType getOpType() {
        return this.opType;
    }

    @Override
    public void setOpType(BFTrackerOpType opType) {
        this.opType = opType;
    }

    @Override
    public void setContext(CtBFTrackerContext trackerContext, CtBFTrackerDbService dbService) {
        this.trackerContext = trackerContext;
        this.dbService = dbService;
        this.sheetBuilder = new CtSheetBuilder(trackerContext, this.dbService);
        this.sheetSnapBuilder = new CtSheetSnapBuilder(this.trackerContext, this.dbService);
    }

    @Override
    public Set<Long> readOtherEntryIds(CtLinkItemContext linkItemContext, Long[] billIds) {
        EntryType entryType = (EntryType)linkItemContext.getEntityType();
        return this.dbService.readEntryIds(billIds, entryType);
    }

    @Override
    public Set<Long> readSnapshotOtherEntryIds(CtLinkItemContext linkItemContext, Long[] billIds) {
        return this.dbService.readSnapshotTIds(billIds, linkItemContext.getEntityTableId());
    }

    @Override
    public CtSheets createSheets(CtLinkItemContext linkItemContext, DynamicObject[] dataEntities) {
        CtSheets sheets = new CtSheets(linkItemContext.getLinkSetItem().getCtParentEntityKey(), linkItemContext.getLinkSetItem().getCtLinkEntityKey());
        for (DynamicObject dataEntity : dataEntities) {
            CtSheet sheet = this.sheetBuilder.createSheet(linkItemContext, dataEntity);
            if (sheet == null) continue;
            sheets.put(sheet.getBillId(), sheet);
        }
        return sheets;
    }

    @Override
    public CtSheets createSubSheets(CtLinkItemContext linkItemContext, DynamicObject[] dataEntities, Long[] billIds, Set<Long> entryIds) {
        EntryType currEntryType = this.trackerContext.getLocalSubEntryTypes().get(linkItemContext.getEntryKey());
        DynamicObject[] entryRows = this.dbService.readEntryRows(currEntryType, linkItemContext.getEntityTableId(), entryIds);
        HashMap billRows = new HashMap();
        DynamicProperty billProp = currEntryType.getProperty("billid");
        for (DynamicObject row : entryRows) {
            Long billId = (Long)billProp.getValueFast((Object)row);
            if (!billRows.containsKey(billId)) {
                billRows.put(billId, new ArrayList());
            }
            ((List)billRows.get(billId)).add(row);
        }
        ArrayList<DynamicObject> billObjs = new ArrayList<DynamicObject>(billIds.length);
        for (Map.Entry billItem : billRows.entrySet()) {
            DynamicObject headObj = linkItemContext.getTrackerOpContext().getHeadObj((Long)billItem.getKey());
            DynamicObjectCollection rows = headObj.getDynamicObjectCollection(currEntryType.getName());
            rows.clear();
            rows.getDeleteRows().clear();
            for (DynamicObject row : (List)billItem.getValue()) {
                rows.add((Object)row);
            }
            billObjs.add(headObj);
        }
        CtSheets sheets = new CtSheets(linkItemContext.getLinkSetItem().getCtParentEntityKey(), linkItemContext.getLinkSetItem().getCtLinkEntityKey());
        for (DynamicObject dataEntity : billObjs) {
            CtSheet sheet = this.sheetBuilder.createSheet(linkItemContext, dataEntity);
            if (sheet == null) continue;
            sheets.put(sheet.getBillId(), sheet);
        }
        return sheets;
    }

    @Override
    public CtSheets createSubSnapshotSheets(CtLinkItemContext linkItemContext, Set<Long> entryIds) {
        Map<Long, List<DynamicObject>> snapshotObjs = this.dbService.readSnapshot(linkItemContext.getTrackerOpContext().getBillIds(), linkItemContext.getEntityTableId(), entryIds);
        return this.sheetSnapBuilder.createSheets(linkItemContext, snapshotObjs);
    }

    @Override
    public void createWRules(CtLinkItemContext linkItemContext, Map<Long, CtWRuleCompiler> currRuleVers, Map<CtRowId, CtBFRowLinkUpNode> rowLinkUpNodes, CtAED<CtRow> aedRows) {
        this.sheetBuilder.createWRules(linkItemContext, currRuleVers, rowLinkUpNodes, aedRows);
    }

    @Override
    public boolean isOpValidRule(CtWriteBackRuleElement rule) {
        return true;
    }

    @Override
    public void checkCanWriteBack(CtWRule wrule) {
    }

    @Override
    public void calcRealAmount(CtWRule wrule) {
    }
}

