/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.opcontroller;

import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ctbotp.runtime.CtBFRowLinkUpNode;
import kd.bos.entity.ctbotp.runtime.CtWriteBackRuleElement;
import kd.bos.service.botp.track.BFTrackerOpType;
import kd.bos.service.ctbotp.track.CtBFTrackerContext;
import kd.bos.service.ctbotp.track.CtLinkItemContext;
import kd.bos.service.ctbotp.track.bizentity.CtAED;
import kd.bos.service.ctbotp.track.bizentity.CtRow;
import kd.bos.service.ctbotp.track.bizentity.CtRowId;
import kd.bos.service.ctbotp.track.bizentity.CtSheets;
import kd.bos.service.ctbotp.track.bizentity.CtWRule;
import kd.bos.service.ctbotp.track.helper.CtBFTrackerDbService;
import kd.bos.service.ctbotp.track.helper.CtWRuleCompiler;
import kd.bos.service.ctbotp.track.opcontroller.AbstractCtOpController;
import kd.bos.service.ctbotp.track.opcontroller.CtAuditController;
import kd.bos.service.ctbotp.track.opcontroller.CtCancelController;
import kd.bos.service.ctbotp.track.opcontroller.CtDeleteController;
import kd.bos.service.ctbotp.track.opcontroller.CtDraftController;
import kd.bos.service.ctbotp.track.opcontroller.CtSaveController;
import kd.bos.service.ctbotp.track.opcontroller.CtUnAuditController;

public interface ICtOpController {
    default public BFTrackerOpType getOpType() {
        return BFTrackerOpType.Save;
    }

    default public void setOpType(BFTrackerOpType opType) {
    }

    public void setContext(CtBFTrackerContext var1, CtBFTrackerDbService var2);

    public Set<Long> readOtherEntryIds(CtLinkItemContext var1, Long[] var2);

    public Set<Long> readSnapshotOtherEntryIds(CtLinkItemContext var1, Long[] var2);

    public CtSheets createSheets(CtLinkItemContext var1, DynamicObject[] var2);

    public CtSheets createSubSheets(CtLinkItemContext var1, DynamicObject[] var2, Long[] var3, Set<Long> var4);

    public CtSheets createSubSnapshotSheets(CtLinkItemContext var1, Set<Long> var2);

    public void createWRules(CtLinkItemContext var1, Map<Long, CtWRuleCompiler> var2, Map<CtRowId, CtBFRowLinkUpNode> var3, CtAED<CtRow> var4);

    public boolean isOpValidRule(CtWriteBackRuleElement var1);

    public void checkCanWriteBack(CtWRule var1);

    public void calcRealAmount(CtWRule var1);

    public static ICtOpController create(BFTrackerOpType opType) {
        AbstractCtOpController op = null;
        switch (opType) {
            case Draft: {
                op = new CtDraftController();
                break;
            }
            case Save: {
                op = new CtSaveController();
                break;
            }
            case Audit: {
                op = new CtAuditController();
                break;
            }
            case UnAudit: {
                op = new CtUnAuditController();
                break;
            }
            case Delete: {
                op = new CtDeleteController();
                break;
            }
            case Cancel: {
                op = new CtCancelController();
                break;
            }
            default: {
                op = new CtDraftController();
            }
        }
        op.setOpType(opType);
        return op;
    }
}

