/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.wblogicunit;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.ctbotp.plugin.tracker.CtExcessCheckType;
import kd.bos.entity.ctbotp.plugin.tracker.args.CtAfterExcessCheckEventArgs;
import kd.bos.entity.ctbotp.plugin.tracker.args.CtBeforeExcessCheckEventArgs;
import kd.bos.entity.ctbotp.runtime.CtWriteBackType;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.service.ctbotp.track.CtWriteBackContext;
import kd.bos.service.ctbotp.track.bizentity.CtRowId;
import kd.bos.service.ctbotp.track.bizentity.CtWRule;
import kd.bos.service.ctbotp.track.bizentity.CtWSRow;
import kd.bos.service.ctbotp.track.helper.CtWRuleCompiler;
import kd.bos.service.ctbotp.track.helper.CtWRuleItemCompiler;
import kd.bos.service.ctbotp.track.wblogicunit.AbstractCtCtWriteBackLogicUnit;

class CtExcessCheckLogic
extends AbstractCtCtWriteBackLogicUnit {
    public CtExcessCheckLogic(CtWriteBackContext writeBackContext) {
        super(writeBackContext);
    }

    @Override
    public void doWriteBack(RowDataModel rowDataModel, List<CtWRule> wRules) {
        Map<Long, CtWRuleCompiler> rules = this.writeBackContext.getRules();
        LinkedHashMap<CtRowId, ArrayList<CtWSRow>> dctByRowId = new LinkedHashMap<CtRowId, ArrayList<CtWSRow>>(wRules.size());
        for (CtWRule wRule : wRules) {
            if (!this.isCheck(wRule)) continue;
            for (CtWSRow wsRow : wRule.getExecuteSourceRows().values()) {
                ArrayList<CtWSRow> list = (ArrayList<CtWSRow>)dctByRowId.get((Object)wsRow.getSId());
                if (list == null) {
                    list = new ArrayList<CtWSRow>();
                    dctByRowId.put(wsRow.getSId(), list);
                }
                list.add(wsRow);
            }
        }
        ArrayList<String> checkErrorMessages = new ArrayList<String>(8);
        ArrayList<Integer> checkExcessSids = new ArrayList<Integer>(10);
        HashSet<Long> ruleVerIds = new HashSet<Long>();
        for (Map.Entry entry : dctByRowId.entrySet()) {
            List list = (List)entry.getValue();
            rowDataModel.setRowContext(((CtWSRow)list.get(0)).getSrcActiveRow());
            for (CtWSRow wsRow : list) {
                Optional<CtAfterExcessCheckEventArgs> checkEventArgs;
                if (checkExcessSids.contains(wsRow.getSId().hashCode()) || !(checkEventArgs = this.excessCheckForWSRow(rowDataModel, rules, ruleVerIds, list, wsRow)).isPresent() || !checkEventArgs.get().isExcess()) continue;
                checkExcessSids.add(wsRow.getSId().hashCode());
                String excesscheckMsgLot = System.getProperty("botp_excesscheck_msg_lot", String.valueOf(true));
                if (String.valueOf(true).equals(excesscheckMsgLot)) {
                    checkErrorMessages.add(checkEventArgs.get().getMessage());
                    continue;
                }
                throw new KDBizException(checkEventArgs.get().getMessage());
            }
            ruleVerIds.clear();
        }
        if (!checkErrorMessages.isEmpty()) {
            throw new KDBizException(this.getExcessCheckMessage(checkErrorMessages));
        }
    }

    private String getExcessCheckMessage(List<String> checkErrorMessages) {
        StringBuilder stb = new StringBuilder();
        for (int i = 0; i < checkErrorMessages.size(); ++i) {
            if (i >= 200) {
                stb.append("......");
                break;
            }
            stb.append(checkErrorMessages.get(i)).append("\r\n");
        }
        return stb.toString();
    }

    private Optional<CtAfterExcessCheckEventArgs> excessCheckForWSRow(RowDataModel rowDataModel, Map<Long, CtWRuleCompiler> rules, HashSet<Long> ruleVerIds, List<CtWSRow> list, CtWSRow wsRow) {
        Long ruleVerId = wsRow.getParent().getRuleVerId();
        if (ruleVerIds.contains(ruleVerId)) {
            return Optional.empty();
        }
        ruleVerIds.add(ruleVerId);
        CtWRuleCompiler rule = rules.get(ruleVerId);
        CtBeforeExcessCheckEventArgs beforeEventArgs = this.firePlugBeforeEvent(rule, wsRow);
        if (beforeEventArgs.isCancel()) {
            return Optional.empty();
        }
        boolean excess = rule.checkExcess(rowDataModel, new HashMap<String, BigDecimal>());
        if (excess) {
            excess = this.doCheckAgain(rowDataModel, rules, rule, list);
        }
        HashSet<DynamicObject> activeRowSet = new HashSet<DynamicObject>(1);
        ArrayList<DynamicObject> activeRowList = new ArrayList<DynamicObject>(1);
        if (excess) {
            for (CtWSRow wsRow2 : list) {
                DynamicObject activeRow;
                if (Long.compare(ruleVerId, wsRow2.getParent().getRuleVerId()) != 0 || (activeRow = wsRow2.getParent().getParent().getEntityRow()) == null || !activeRowSet.add(activeRow)) continue;
                activeRowList.add(activeRow);
            }
        }
        CtAfterExcessCheckEventArgs afterEventArgs = this.firePlugAfterEvent(rule, wsRow, activeRowList.toArray(new DynamicObject[0]), excess);
        return Optional.of(afterEventArgs);
    }

    private boolean isCheck(CtWRule wRule) {
        return true;
    }

    private boolean doCheckAgain(RowDataModel rowDataModel, Map<Long, CtWRuleCompiler> rules, CtWRuleCompiler rule, List<CtWSRow> wsRows) {
        boolean excess = true;
        if (this.checkAgain(rule)) {
            boolean isRollback = true;
            HashMap<String, BigDecimal> writeValues = new HashMap<String, BigDecimal>();
            for (CtWSRow wsRow : wsRows) {
                CtWSRow resultRow;
                CtWRuleCompiler currRule = rules.get(wsRow.getParent().getRuleVerId());
                CtWRuleItemCompiler currRuleItem = currRule.getItems().get(wsRow.getParent().getRuleItemId());
                String srcField = currRuleItem.getSourceField().getName();
                if (currRuleItem.getItem().getWriteBackType() == CtWriteBackType.Cover) continue;
                if (currRuleItem.getItem().getWriteBackType() == CtWriteBackType.Add) {
                    isRollback = isRollback && wsRow.getVal().compareTo(BigDecimal.ZERO) <= 0;
                } else if (currRuleItem.getItem().getWriteBackType() == CtWriteBackType.Lessen) {
                    boolean bl = isRollback = isRollback && wsRow.getVal().compareTo(BigDecimal.ZERO) >= 0;
                }
                if ((resultRow = (CtWSRow)wsRow.getParent().getResultSourceRows().get((Object)wsRow.getSId())) == null) continue;
                BigDecimal bigDecimal = (BigDecimal)writeValues.get(srcField);
                bigDecimal = bigDecimal == null ? resultRow.getVal() : bigDecimal.add(resultRow.getVal());
                writeValues.put(srcField, bigDecimal);
            }
            if (isRollback) {
                return false;
            }
            excess = rule.checkExcess(rowDataModel, writeValues);
        }
        return excess;
    }

    private boolean checkAgain(CtWRuleCompiler rule) {
        if (rule.getRule().getExcessCheckType() == CtExcessCheckType.CanExcessOneTime) {
            return true;
        }
        return rule.getRule().getExcessCheckType() == CtExcessCheckType.SelectByFormula && (rule.getRule().getExcessSelectTrue() == CtExcessCheckType.CanExcessOneTime || rule.getRule().getExcessSelectFalse() == CtExcessCheckType.CanExcessOneTime);
    }

    private CtBeforeExcessCheckEventArgs firePlugBeforeEvent(CtWRuleCompiler rule, CtWSRow wsRow) {
        CtBeforeExcessCheckEventArgs eventArgs = new CtBeforeExcessCheckEventArgs(rule.getRule(), this.writeBackContext.getSrcSubMainType(), this.getSrcEntityType(wsRow), wsRow.getSrcActiveRow(), this.writeBackContext.getCtLinkItemContext().getEntityType(), wsRow.getParent().getParent().getEntityRow());
        this.writeBackContext.getTrackerContext().getPlugInProxy().fireBeforeExcessCheck(eventArgs);
        return eventArgs;
    }

    private CtAfterExcessCheckEventArgs firePlugAfterEvent(CtWRuleCompiler rule, CtWSRow wsRow, DynamicObject[] activeRows, boolean excess) {
        CtAfterExcessCheckEventArgs eventArgs = new CtAfterExcessCheckEventArgs(rule.getRule(), this.writeBackContext.getSrcSubMainType(), this.getSrcEntityType(wsRow), wsRow.getSrcActiveRow(), this.writeBackContext.getCtLinkItemContext().getEntityType(), wsRow.getParent().getParent().getEntityRow());
        eventArgs.setExcess(excess);
        if (excess) {
            eventArgs.setMessage(this.buildExcessMessage(rule, wsRow, activeRows));
        }
        this.writeBackContext.getTrackerContext().getPlugInProxy().fireAfterExcessCheck(eventArgs);
        return eventArgs;
    }

    private String buildExcessMessage(CtWRuleCompiler rule, CtWSRow wsRow, DynamicObject[] activeRows) {
        String targetRowInfo = "";
        targetRowInfo = activeRows == null || activeRows.length == 0 ? String.format("%s (%s)", this.writeBackContext.getTrackerContext().getTargetMainType().getDisplayName().toString(), this.writeBackContext.getCtLinkItemContext().getTrackerOpContext().getBillNo(wsRow.getParent().getParent().getId().getBillId())) : this.buildDataInfo(activeRows);
        String message = String.format(ResManager.loadKDString((String)"[%1$s] \u53cd\u5199 [%2$s]", (String)"ExcessCheckLogic_0", (String)"bos-mservice-botp", (Object[])new Object[0]), targetRowInfo, this.buildDataInfo(new DynamicObject[]{wsRow.getSrcActiveRow()}));
        if (rule.getRule().getExcessCheckMessage() != null) {
            return message + ": " + rule.getRule().getExcessCheckMessage();
        }
        return message;
    }

    private String buildDataInfo(DynamicObject[] activeRows) {
        ArrayList<String> rowInfos = new ArrayList<String>();
        if (activeRows == null || ((DynamicObject[])activeRows).length == 0) {
            return "";
        }
        DynamicObject billObj = null;
        if (activeRows[0].getDataEntityType() instanceof SubEntryType) {
            ArrayList<DynamicObject> subEntryRows = new ArrayList<DynamicObject>(((DynamicObject[])activeRows).length);
            DynamicObject entryRow = null;
            for (DynamicObject activeRow : activeRows) {
                if (entryRow != null && !entryRow.equals(activeRow.getParent())) continue;
                entryRow = (DynamicObject)activeRow.getParent();
                subEntryRows.add(activeRow);
            }
            String rowInfo = this.buildRowInfo(subEntryRows.toArray(new DynamicObject[0]));
            rowInfos.add(rowInfo);
            if (entryRow != null) {
                rowInfo = this.buildRowInfo(new DynamicObject[]{entryRow});
                rowInfos.add(rowInfo);
                billObj = (DynamicObject)entryRow.getParent();
            }
        } else if (activeRows[0].getDataEntityType() instanceof EntryType) {
            ArrayList<DynamicObject> entryRows = new ArrayList<DynamicObject>(((DynamicObject[])activeRows).length);
            for (DynamicObject activeRow : activeRows) {
                if (billObj != null && !billObj.equals(activeRow.getParent())) continue;
                billObj = (DynamicObject)activeRow.getParent();
                entryRows.add(activeRow);
            }
            String rowInfo = this.buildRowInfo(entryRows.toArray(new DynamicObject[0]));
            rowInfos.add(rowInfo);
        } else if (activeRows[0].getDataEntityType() instanceof MainEntityType) {
            billObj = activeRows[0];
        }
        if (billObj != null) {
            BillEntityType mainType = (BillEntityType)billObj.getDataEntityType();
            String billName = mainType.getDisplayName().toString();
            IDataEntityProperty billNoProp = null;
            if (StringUtils.isNotBlank((CharSequence)mainType.getBillNo())) {
                billNoProp = (IDataEntityProperty)mainType.getProperties().get((Object)mainType.getBillNo());
            }
            String billNo = billNoProp != null ? (String)billNoProp.getValueFast((Object)billObj) : billObj.getPkValue().toString();
            String billInfo = String.format("%s (%s)", billName, billNo);
            rowInfos.add(billInfo);
        }
        Collections.reverse(rowInfos);
        return StringUtils.join((Object[])rowInfos.toArray(), (String)",");
    }

    private String buildRowInfo(DynamicObject[] activeRows) {
        EntryType entryType = (EntryType)activeRows[0].getDataEntityType();
        String entryName = entryType.getDisplayName().toString();
        if (activeRows.length == 1) {
            int seq = this.getRowSeq(activeRows[0]);
            String seqStr = String.valueOf(seq);
            String rowInfo = String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c", (String)"ExcessCheckLogic_3", (String)"bos-mservice-botp", (Object[])new Object[0]), entryName, seqStr);
            return rowInfo;
        }
        ArrayList<Integer> seqs = new ArrayList<Integer>(activeRows.length);
        for (DynamicObject activeRow : activeRows) {
            seqs.add(this.getRowSeq(activeRow));
        }
        seqs.sort(new Comparator<Integer>(){

            @Override
            public int compare(Integer i1, Integer i2) {
                return i1 - i2;
            }
        });
        int showCount = 5;
        if (seqs.size() <= showCount) {
            String seqStr = StringUtils.join((Object[])seqs.toArray(), (String)",");
            String rowInfo = String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c", (String)"ExcessCheckLogic_3", (String)"bos-mservice-botp", (Object[])new Object[0]), entryName, seqStr);
            return rowInfo;
        }
        StringBuilder seqStrBuf = new StringBuilder();
        for (int i = 0; i < showCount && i < seqs.size(); ++i) {
            if (i > 0) {
                seqStrBuf.append(',');
            }
            seqStrBuf.append(String.valueOf(seqs.get(i)));
        }
        String rowInfo = MessageFormat.format(ResManager.loadKDString((String)"{0}\u7b2c{1}...(\u5171{2}\u884c)", (String)"ExcessCheckLogic_2", (String)"bos-mservice-botp", (Object[])new Object[0]), entryName, seqStrBuf.toString(), seqs.size());
        return rowInfo;
    }

    private int getRowSeq(DynamicObject activeRow) {
        int seq = 0;
        IDataEntityProperty seqProp = (IDataEntityProperty)activeRow.getDataEntityType().getProperties().get((Object)"seq");
        if (seqProp != null) {
            seq = (Integer)seqProp.getValueFast((Object)activeRow);
        } else {
            DynamicObject parent = (DynamicObject)activeRow.getParent();
            DynamicObjectCollection rows = parent.getDynamicObjectCollection(activeRow.getDataEntityType().getName());
            seq = rows.indexOf((Object)activeRow) + 1;
        }
        return seq;
    }
}

