/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation.validate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.service.ctbotp.service.CtBillLkServiceHelper;

public class CtBillExistValidator
extends AbstractValidator {
    private static final String PARAM_CHECK_CT_TBILL = "checkCtTBill";
    private static final String PARAM_CHECK_CT_SBILL = "checkCtSBill";
    private Boolean checkCtTBill;
    private Boolean checkCtSBill;

    public void validate() {
        String msg;
        Boolean hasCtBillLkEntryValue;
        Long pk;
        Map<Long, Boolean> hasCtBillLkMap;
        if (!(this.getValidateContext().getBillEntityType().getPrimaryKey() instanceof LongProp)) {
            return;
        }
        ExtendedDataEntity[] dynCol = this.getDataEntities();
        if (dynCol == null || dynCol.length == 0) {
            return;
        }
        ArrayList<Long> pkList = new ArrayList<Long>(dynCol.length);
        HashMap<Long, ExtendedDataEntity> extendedDataEntityMap = new HashMap<Long, ExtendedDataEntity>(dynCol.length);
        for (ExtendedDataEntity extendedDataEntity : dynCol) {
            DynamicObject dyn = extendedDataEntity.getDataEntity();
            if (!(dyn.getPkValue() instanceof Long)) continue;
            pkList.add((Long)dyn.getPkValue());
            extendedDataEntityMap.put((Long)dyn.getPkValue(), extendedDataEntity);
        }
        String operationName = this.getOperationName();
        String tenantCode = RequestContext.get().getTenantCode();
        String accountId = RequestContext.get().getAccountId();
        if (this.isCheckCtSBill()) {
            hasCtBillLkMap = CtBillLkServiceHelper.hasCtBillLksUp(tenantCode, accountId, this.entityKey, pkList);
            for (Map.Entry<Long, Boolean> hasCtBillLkEntry : hasCtBillLkMap.entrySet()) {
                pk = hasCtBillLkEntry.getKey();
                hasCtBillLkEntryValue = hasCtBillLkEntry.getValue();
                if (!hasCtBillLkEntryValue.booleanValue()) continue;
                msg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u8de8\u79df\u6237\u6e90\u5355\uff0c\u4e0d\u5141\u8bb8%1$s\u3002", (String)"OperateSyncFacade_1", (String)"bos-mservice-ctbotp", (Object[])new Object[0]), operationName);
                this.addFatalErrorMessage((ExtendedDataEntity)extendedDataEntityMap.get(pk), msg);
            }
        }
        if (this.isCheckCtTBill()) {
            hasCtBillLkMap = CtBillLkServiceHelper.hasCtBillLksDown(tenantCode, accountId, this.entityKey, pkList);
            for (Map.Entry<Long, Boolean> hasCtBillLkEntry : hasCtBillLkMap.entrySet()) {
                pk = hasCtBillLkEntry.getKey();
                hasCtBillLkEntryValue = hasCtBillLkEntry.getValue();
                if (!hasCtBillLkEntryValue.booleanValue()) continue;
                msg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u8de8\u79df\u6237\u76ee\u6807\u5355\uff0c\u4e0d\u5141\u8bb8%1$s\u3002", (String)"OperateSyncFacade_2", (String)"bos-mservice-ctbotp", (Object[])new Object[0]), operationName);
                this.addFatalErrorMessage((ExtendedDataEntity)extendedDataEntityMap.get(pk), msg);
            }
        }
    }

    private boolean isCheckCtTBill() {
        if (this.checkCtTBill == null) {
            Object checkCtTBillVal = this.getValidation().get(PARAM_CHECK_CT_TBILL);
            this.checkCtTBill = StringUtils.isBlank(checkCtTBillVal) ? Boolean.valueOf(false) : Boolean.valueOf(checkCtTBillVal.toString());
        }
        return this.checkCtTBill;
    }

    private boolean isCheckCtSBill() {
        if (this.checkCtSBill == null) {
            Object checkCtSBillVal = this.getValidation().get(PARAM_CHECK_CT_SBILL);
            this.checkCtSBill = StringUtils.isBlank(checkCtSBillVal) ? Boolean.valueOf(false) : Boolean.valueOf(checkCtSBillVal.toString());
        }
        return this.checkCtSBill;
    }
}

