/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.ctbotp;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ctbotp.CtBillTypeMapItem;
import kd.bos.entity.ctbotp.CtBillTypeMapPolicy;
import kd.bos.entity.ctbotp.constants.SyncNodeEnum;

public class CtBillTypeMapParser {
    private static final String BILL_TYPE_KEY_STATUS = "status";
    private static final String BILL_TYPE_KEY_ENABLE = "enable";
    private static final String BillType_Key_IsDefault = "isdefault";
    private Long defBillTypeId = null;
    private Set<Long> validBillTypeIds = new ConcurrentSkipListSet<Long>();
    private boolean canPushAll = false;
    private boolean cannotPushAnyOne = false;
    private boolean canDrawAll = false;
    private boolean cannotDrawAnyOne = false;
    private List<Long> outBillTypeIds = new ArrayList<Long>();
    private Set<Long> outCannotPushBillTypeIds = new HashSet<Long>();
    private Set<Long> outCannotDrawBillTypeIds = new HashSet<Long>();

    public boolean isCanPushAll() {
        return this.canPushAll;
    }

    public boolean isCannotPushAnyOne() {
        return this.cannotPushAnyOne;
    }

    public boolean isCanDrawAll() {
        return this.canDrawAll;
    }

    public boolean isCannotDrawAnyOne() {
        return this.cannotDrawAnyOne;
    }

    public List<Long> getOutBillTypeIds() {
        return this.outBillTypeIds;
    }

    public Set<Long> getOutCannotPushBillTypeIds() {
        return this.outCannotPushBillTypeIds;
    }

    public Set<Long> getOutCannotDrawBillTypeIds() {
        return this.outCannotDrawBillTypeIds;
    }

    public boolean tryGetTargetBillTypeIds(CtBillTypeMapPolicy policy, Long srcBillTypeId, DynamicObject[] targetBillTypeObjs, SyncNodeEnum syncNodeEnum) {
        this.initLocalVar();
        if (syncNodeEnum.name().equals(SyncNodeEnum.TARGET.name())) {
            this.parseBillTypeObjs(targetBillTypeObjs);
        }
        List<CtBillTypeMapItem> mapItems = this.sortBillTypeMapItems(policy);
        HashSet<Long> specSrcIds = new HashSet<Long>();
        boolean hasSearchAll = false;
        boolean selected = false;
        for (CtBillTypeMapItem mapItem : mapItems) {
            if (!mapItem.isValid()) continue;
            boolean itemSelected = false;
            if (StringUtils.equalsIgnoreCase((CharSequence)mapItem.getSourceType(), (CharSequence)"All")) {
                itemSelected = true;
                hasSearchAll = true;
            } else if (StringUtils.equalsIgnoreCase((CharSequence)mapItem.getSourceType(), (CharSequence)"Others")) {
                itemSelected = !hasSearchAll && !specSrcIds.contains(srcBillTypeId);
            } else {
                specSrcIds.add(mapItem.getSourceBillTypeId());
                if (srcBillTypeId != null && Long.compare(mapItem.getSourceBillTypeId(), srcBillTypeId) == 0) {
                    itemSelected = true;
                }
            }
            boolean bl = selected = selected || itemSelected;
            if (!itemSelected) continue;
            RefObject outBillTypeValue = new RefObject();
            if (!this.tryGetTargetBillTypeId(mapItem, (RefObject<Long>)outBillTypeValue)) break;
            if (outBillTypeValue.getValue() == null) continue;
            this.outBillTypeIds.add((Long)outBillTypeValue.getValue());
        }
        if (!selected) {
            this.canPushAll = true;
        }
        if (!this.cannotPushAnyOne && this.canPushAll) {
            this.addAllValidTargetBillTypes();
        }
        return true;
    }

    public boolean tryGetSourceBillTypeIds(CtBillTypeMapPolicy policy, DynamicObject targetBillTypeObj) {
        this.initLocalVar();
        List<CtBillTypeMapItem> mapItems = this.sortBillTypeMapItems(policy);
        long targetBillTypeId = targetBillTypeObj == null ? 0L : (Long)targetBillTypeObj.getPkValue();
        HashSet<Long> specSrcIds = new HashSet<Long>();
        boolean allPushOther = false;
        boolean selected = false;
        this.canDrawAll = true;
        for (CtBillTypeMapItem mapItem : mapItems) {
            if (!mapItem.isValid()) continue;
            if (StringUtils.equalsIgnoreCase((CharSequence)mapItem.getPushType(), (CharSequence)"Random")) {
                selected = true;
                if (StringUtils.equalsIgnoreCase((CharSequence)mapItem.getSourceType(), (CharSequence)"All")) {
                    this.canDrawAll = true;
                    break;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)mapItem.getSourceType(), (CharSequence)"Others")) {
                    this.canDrawAll = true;
                    this.outCannotDrawBillTypeIds.addAll(specSrcIds);
                    break;
                }
                this.outBillTypeIds.add(mapItem.getSourceBillTypeId());
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)mapItem.getPushType(), (CharSequence)"None")) {
                if (StringUtils.equalsIgnoreCase((CharSequence)mapItem.getSourceType(), (CharSequence)"All")) {
                    this.cannotDrawAnyOne = this.cannotDrawAnyOne || this.outBillTypeIds.isEmpty();
                    this.canDrawAll = false;
                    selected = true;
                    break;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)mapItem.getSourceType(), (CharSequence)"Others")) {
                    this.cannotDrawAnyOne = this.cannotDrawAnyOne || this.outBillTypeIds.isEmpty();
                    this.canDrawAll = false;
                    selected = true;
                    break;
                }
                this.outCannotDrawBillTypeIds.add(mapItem.getSourceBillTypeId());
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)mapItem.getPushType(), (CharSequence)"NoSpec")) {
                if (Long.compare(targetBillTypeId, mapItem.getTargetBillTypeId()) != 0) continue;
                selected = true;
                if (StringUtils.equalsIgnoreCase((CharSequence)mapItem.getSourceType(), (CharSequence)"All")) {
                    this.cannotDrawAnyOne = this.cannotDrawAnyOne || this.outBillTypeIds.isEmpty();
                    this.canDrawAll = false;
                    break;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)mapItem.getSourceType(), (CharSequence)"Others")) {
                    this.cannotDrawAnyOne = this.cannotDrawAnyOne || this.outBillTypeIds.isEmpty();
                    this.canDrawAll = false;
                    break;
                }
                this.outCannotDrawBillTypeIds.add(mapItem.getSourceBillTypeId());
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)mapItem.getPushType(), (CharSequence)"Spec")) continue;
            if (Long.compare(targetBillTypeId, mapItem.getTargetBillTypeId()) != 0) {
                if (StringUtils.equalsIgnoreCase((CharSequence)mapItem.getSourceType(), (CharSequence)"All") || StringUtils.equalsIgnoreCase((CharSequence)mapItem.getSourceType(), (CharSequence)"Others")) {
                    allPushOther = true;
                    this.canDrawAll = false;
                    continue;
                }
                specSrcIds.add(mapItem.getSourceBillTypeId());
                continue;
            }
            selected = true;
            if (StringUtils.equalsIgnoreCase((CharSequence)mapItem.getSourceType(), (CharSequence)"All")) {
                this.canDrawAll = true;
                break;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)mapItem.getSourceType(), (CharSequence)"Others")) {
                this.canDrawAll = true;
                this.outCannotDrawBillTypeIds.addAll(specSrcIds);
                break;
            }
            this.outBillTypeIds.add(mapItem.getSourceBillTypeId());
        }
        if (!selected) {
            if (allPushOther) {
                this.cannotDrawAnyOne = true;
            } else {
                this.canDrawAll = true;
            }
        }
        if (!this.cannotDrawAnyOne && this.canDrawAll) {
            this.outCannotDrawBillTypeIds.addAll(specSrcIds);
        }
        return true;
    }

    private void initLocalVar() {
        this.defBillTypeId = null;
        this.validBillTypeIds = new ConcurrentSkipListSet<Long>();
        this.canPushAll = false;
        this.cannotPushAnyOne = false;
        this.canDrawAll = false;
        this.cannotDrawAnyOne = false;
        this.outBillTypeIds = new ArrayList<Long>();
        this.outCannotPushBillTypeIds = new HashSet<Long>();
        this.outCannotDrawBillTypeIds = new HashSet<Long>();
    }

    private List<CtBillTypeMapItem> sortBillTypeMapItems(CtBillTypeMapPolicy policy) {
        ArrayList<CtBillTypeMapItem> list = new ArrayList<CtBillTypeMapItem>();
        if (policy != null) {
            list.addAll(policy.getItems());
        }
        list.sort(new Comparator<CtBillTypeMapItem>(){

            @Override
            public int compare(CtBillTypeMapItem o1, CtBillTypeMapItem o2) {
                return o1.getSeq() - o2.getSeq();
            }
        });
        return list;
    }

    private boolean tryGetTargetBillTypeId(CtBillTypeMapItem mapItem, RefObject<Long> outValue) {
        switch (mapItem.getPushType()) {
            case "Random": {
                this.canPushAll = true;
                break;
            }
            case "None": {
                if (this.outBillTypeIds.isEmpty()) {
                    this.cannotPushAnyOne = true;
                }
                return false;
            }
            case "Spec": {
                if (!this.validBillTypeIds.contains(mapItem.getTargetBillTypeId()) || this.outCannotPushBillTypeIds.contains(mapItem.getTargetBillTypeId())) break;
                outValue.setValue((Object)mapItem.getTargetBillTypeId());
                break;
            }
            case "NoSpec": {
                this.canPushAll = true;
                this.outCannotPushBillTypeIds.add(mapItem.getTargetBillTypeId());
                break;
            }
        }
        return true;
    }

    private void parseBillTypeObjs(DynamicObject[] billTypeObjs) {
        for (DynamicObject obj : billTypeObjs) {
            boolean isDefault = obj.getBoolean(BillType_Key_IsDefault);
            Long id = (Long)obj.getPkValue();
            if (isDefault) {
                this.defBillTypeId = id;
            }
            this.validBillTypeIds.add(id);
        }
    }

    private void addAllValidTargetBillTypes() {
        HashSet<Long> set = new HashSet<Long>();
        ArrayList<Long> outList = new ArrayList<Long>(this.outBillTypeIds);
        this.outBillTypeIds.clear();
        for (Long id : outList) {
            if (this.outCannotPushBillTypeIds.contains(id)) continue;
            this.outBillTypeIds.add(id);
            set.add(id);
        }
        if (this.defBillTypeId != null && !this.outCannotPushBillTypeIds.contains(this.defBillTypeId)) {
            this.outBillTypeIds.add(this.defBillTypeId);
            set.add(this.defBillTypeId);
        }
        for (Long validId : this.validBillTypeIds) {
            if (this.outCannotPushBillTypeIds.contains(validId)) continue;
            this.outBillTypeIds.add(validId);
            set.add(validId);
        }
    }
}

