/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.ctbotp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.ctbotp.CtConvertRuleElement;
import kd.bos.entity.gray.AppGroupUtils;

class CtConvertRuleLocalCache {
    private static final String TYPE_CR_RULE = "ct_cr_rule_";
    public static final long CHECK_VERSION_TIME_MILLIS = 10000L;
    public static final long TIME_OUT_MILLIS = 600000L;
    private static final CacheConfigInfo info = new CacheConfigInfo();

    CtConvertRuleLocalCache() {
    }

    private static LocalMemoryCache getLocalCache() {
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), "CtConvertRuleLocalCache", info);
    }

    public static void clearAllConvertRuleCache() {
        CtConvertRuleLocalCache.getLocalCache().clear();
    }

    public static CtConvertRuleElement getConvertRule(String ruleId) {
        String cacheKey = CtConvertRuleLocalCache.makeCacheKey(TYPE_CR_RULE, ruleId);
        return (CtConvertRuleElement)CtConvertRuleLocalCache.getLocalCache().get(cacheKey);
    }

    public static Map<String, CtConvertRuleElement> getConvertRules(String ... ruleIds) {
        if (ruleIds.length == 0) {
            return new HashMap<String, CtConvertRuleElement>(16);
        }
        ArrayList<String> cacheKeys = new ArrayList<String>(10);
        for (String ruleId : ruleIds) {
            cacheKeys.add(CtConvertRuleLocalCache.makeCacheKey(TYPE_CR_RULE, ruleId));
        }
        Map map = CtConvertRuleLocalCache.getLocalCache().get(cacheKeys.toArray(new String[0]));
        HashMap<String, CtConvertRuleElement> map2 = new HashMap<String, CtConvertRuleElement>(16);
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            CtConvertRuleElement rule = (CtConvertRuleElement)entry.getValue();
            map2.put(rule.getId(), rule);
        }
        return map2;
    }

    public static void putConvertRule(String ruleId, CtConvertRuleElement rule) {
        String cacheKey = CtConvertRuleLocalCache.makeCacheKey(TYPE_CR_RULE, ruleId);
        CtConvertRuleLocalCache.getLocalCache().put(cacheKey, (Object)rule);
    }

    public static void removeConverRule(String ruleId) {
        String cacheKey = CtConvertRuleLocalCache.makeCacheKey(TYPE_CR_RULE, ruleId);
        CtConvertRuleLocalCache.getLocalCache().remove(new String[]{ruleId});
    }

    private static String makeCacheKey(String type, String key) {
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        if (StringUtils.isNotBlank((CharSequence)appGroup) && !"defaultGroup".equals(appGroup)) {
            return String.format("%s.%s.%s", appGroup, key, type).toLowerCase();
        }
        return String.format("%s.%s", key, type).toLowerCase();
    }

    static {
        info.setTimeout(43200);
        info.setMaxItemSize(10000);
    }
}

