/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.ctbotp;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ctbotp.CtDataEntity;
import kd.bos.entity.ctbotp.CtDataEntityField;
import kd.bos.entity.validate.ValidataErrorCode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class CtExtendedDataEntity {
    private int dataEntityIndex;
    private int rowIndex;
    private int subRowIndex;
    private DynamicObject dataEntity;
    private CtDataEntity ctDataEntity;
    private String billNo;
    private ConcurrentMap<String, Object> _extendedObjects;
    private ValidataErrorCode validataErrorCode;
    private Long id;

    public CtExtendedDataEntity(DynamicObject dataEntity, int dataEntityIndex, int rowIndex) {
        this(dataEntity, dataEntityIndex, rowIndex, 0, "");
    }

    public CtExtendedDataEntity(CtDataEntity dataEntity, int dataEntityIndex, int rowIndex) {
        this(dataEntity, dataEntityIndex, rowIndex, 0, "");
    }

    public CtExtendedDataEntity(DynamicObject dataEntity, int dataEntityIndex, int rowIndex, String billNo) {
        this(dataEntity, dataEntityIndex, rowIndex, 0, billNo);
    }

    public CtExtendedDataEntity(DynamicObject dataEntity, int dataEntityIndex, int rowIndex, int subRowIndex, String billNo) {
        if (dataEntity == null) {
            throw new KDException(BosErrorCode.variableNotValid, new Object[]{"obj"});
        }
        if (dataEntityIndex < 0) {
            throw new KDException(BosErrorCode.variableNotValid, new Object[]{"dataEntityIndex"});
        }
        if (rowIndex < 0) {
            throw new KDException(BosErrorCode.variableNotValid, new Object[]{"rowIndex"});
        }
        this.dataEntity = dataEntity;
        this.dataEntityIndex = dataEntityIndex;
        this.rowIndex = rowIndex;
        this.subRowIndex = subRowIndex;
        this.billNo = billNo;
        this._extendedObjects = new ConcurrentHashMap<String, Object>();
    }

    public CtExtendedDataEntity(CtDataEntity dataEntity, int dataEntityIndex, int rowIndex, int subRowIndex, String billNo) {
        if (dataEntity == null) {
            throw new KDException(BosErrorCode.variableNotValid, new Object[]{"obj"});
        }
        if (dataEntityIndex < 0) {
            throw new KDException(BosErrorCode.variableNotValid, new Object[]{"dataEntityIndex"});
        }
        if (rowIndex < 0) {
            throw new KDException(BosErrorCode.variableNotValid, new Object[]{"rowIndex"});
        }
        this.ctDataEntity = dataEntity;
        this.ctDataEntity.setFields(new ArrayList<CtDataEntityField>(16));
        this.dataEntityIndex = dataEntityIndex;
        this.rowIndex = rowIndex;
        this.subRowIndex = subRowIndex;
        this.billNo = billNo;
        this._extendedObjects = new ConcurrentHashMap<String, Object>();
    }

    @Deprecated
    public CtExtendedDataEntity(DynamicObject dataEntity, int dataEntityIndex, int rowIndex, String billNo, String billStatusKey, String forbidStatusKey) {
        this(dataEntity, dataEntityIndex, rowIndex, 0, billNo);
    }

    @Deprecated
    public CtExtendedDataEntity(DynamicObject dataEntity, int dataEntityIndex, int rowIndex, int subRowIndex, String billNo, String billStatusKey, String forbidStatusKey) {
        this(dataEntity, dataEntityIndex, rowIndex, subRowIndex, billNo);
    }

    public CtDataEntity getCtDataEntity() {
        return this.ctDataEntity;
    }

    public void setCtDataEntity(CtDataEntity ctDataEntity) {
        this.ctDataEntity = ctDataEntity;
    }

    @KSMethod
    public int getDataEntityIndex() {
        return this.dataEntityIndex;
    }

    public void setDataEntityIndex(int dataEntityIndex) {
        this.dataEntityIndex = dataEntityIndex;
    }

    @KSMethod
    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    @KSMethod
    public int getSubRowIndex() {
        return this.subRowIndex;
    }

    public void setSubRowIndex(int subRowIndex) {
        this.subRowIndex = subRowIndex;
    }

    @KSMethod
    public String getBillNo() {
        return this.billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    @KSMethod
    public DynamicObject getDataEntity() {
        return this.dataEntity;
    }

    public void setDataEntity(DynamicObject dataEntity) {
        this.dataEntity = dataEntity;
    }

    public Object getBillPkId() {
        DynamicObject parentObj = this.dataEntity;
        while (parentObj.getParent() != null) {
            parentObj = (DynamicObject)parentObj.getParent();
        }
        return parentObj.getPkValue();
    }

    @Deprecated
    public Object getObjectByName(String name) {
        return this.getValue(name);
    }

    @Deprecated
    public void setObjectByName(String name, Object value) {
        this.setValue(name, value);
    }

    @KSMethod
    public Object getValue(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new KDException(BosErrorCode.variableNotValid, new Object[]{"name"});
        }
        if (this._extendedObjects.containsKey(name)) {
            return this._extendedObjects.get(name);
        }
        DynamicProperty prop = this.dataEntity.getDynamicObjectType().getProperty(name);
        if (prop == null) {
            return null;
        }
        return prop.getValue((Object)this.dataEntity);
    }

    @KSMethod
    public void setValue(String name, Object value) {
        this._extendedObjects.put(name, value);
    }

    @KSMethod
    public void setValueExt(String name, Object value) {
        this._extendedObjects.put(name, value);
    }

    public ValidataErrorCode getValidataErrorCode() {
        return this.validataErrorCode;
    }

    public void setValidataErrorCode(ValidataErrorCode validataErrorCode) {
        this.validataErrorCode = validataErrorCode;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}

