/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.ctbotp.plugin.convert;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.CRPlugin;
import kd.bos.entity.ctbotp.CtConvertRuleElement;
import kd.bos.entity.ctbotp.plugin.convert.ICtConvertPlugIn;
import kd.bos.entity.ctbotp.plugin.convert.args.CtAfterConvertEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.ScriptExecutor;

public class CtConvertPlugInProxy {
    private static final Log log = LogFactory.getLog(CtConvertPlugInProxy.class);
    ScriptExecutor scriptExecutor;
    protected List<ICtConvertPlugIn> plugIns = new ArrayList<ICtConvertPlugIn>();
    private static final String TYPE = "CtCONVERTPLUGIN";

    public CtConvertPlugInProxy() {
    }

    public final List<ICtConvertPlugIn> getPlugIns() {
        return this.plugIns;
    }

    public CtConvertPlugInProxy(List<CRPlugin> plugins) {
        this.scriptExecutor = ScriptExecutor.getOrCreate();
        for (CRPlugin plugin : plugins) {
            Object classType;
            if (!plugin.isEnabled()) continue;
            int type = plugin.getType();
            String jsClassName = plugin.getClassName();
            if (0 != type || !((classType = TypesContainer.createInstance((String)jsClassName)) instanceof ICtConvertPlugIn)) continue;
            this.plugIns.add((ICtConvertPlugIn)classType);
        }
    }

    public void setContext(BillEntityType srcMainType, CtConvertRuleElement rule) {
        for (ICtConvertPlugIn plugIn : this.plugIns) {
            plugIn.setContext(srcMainType, rule);
        }
    }

    public void fireCtAfterConvert(CtAfterConvertEventArgs e) {
        for (ICtConvertPlugIn plugIn : this.plugIns) {
            EntityTraceSpan span = EntityTracer.create((String)TYPE, (String)"ConvertPlugInProxy.fireCtAfterConvert", (EntityTraceHint)new EntityTraceHint(false));
            Throwable throwable = null;
            try {
                try {
                    if (span.isRealtime()) {
                        span.addTag("pluginName", plugIn.getClass().getSimpleName());
                    }
                }
                catch (Exception exception) {
                    log.error((Throwable)exception);
                }
                plugIn.ctAfterConvert(e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }
}

