/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.ctbotp.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.ctbotp.runtime.CtBFRow;
import kd.bos.entity.ctbotp.runtime.CtBFRowId;
import kd.bos.entity.ctbotp.runtime.CtBFRowLinkDownNode;
import kd.bos.entity.ctbotp.runtime.CtBFRowLinkUpNode;

public class CtBFRowComparator
implements Comparator<CtBFRow> {
    private Map<String, Set<String>> childBills = new HashMap<String, Set<String>>(8);
    private static final int MAX_SIZE_SORT = 100;

    public CtBFRowComparator(List<CtBFRow> rows) {
        String tBill;
        if (rows.size() > 100) {
            return;
        }
        LinkedHashMap<String, Set<String>> parentBills = new LinkedHashMap<String, Set<String>>(rows.size());
        for (CtBFRow row : rows) {
            String sBill = this.billIdToString(row.getSId());
            if (this.isCircle(parentBills, sBill, tBill = this.billIdToString(row.getId()))) continue;
            if (!parentBills.containsKey(tBill)) {
                parentBills.put(tBill, new HashSet(1));
            }
            ((Set)parentBills.get(tBill)).add(sBill);
            Set<String> set = this.childBills.get(sBill);
            if (set == null) {
                set = new HashSet<String>(8);
                this.childBills.put(sBill, set);
            }
            set.add(tBill);
        }
        for (int i = 0; i < parentBills.size() - 1; ++i) {
            for (Map.Entry item : parentBills.entrySet()) {
                tBill = (String)item.getKey();
                for (String sBill : (Set)item.getValue()) {
                    Set<String> parentSet = this.childBills.get(sBill);
                    Set<String> childSet = this.childBills.get(tBill);
                    if (childSet == null || childSet.contains(sBill)) continue;
                    if (parentSet == null) {
                        parentSet = new HashSet<String>(8);
                        this.childBills.put(sBill, parentSet);
                    }
                    parentSet.addAll(childSet);
                }
            }
        }
    }

    @Override
    public int compare(CtBFRow row1, CtBFRow row2) {
        String bill1 = this.billIdToString(row1.getSId());
        String bill2 = this.billIdToString(row2.getSId());
        Set<String> bill1Childs = this.childBills.get(bill1);
        Set<String> bill2Childs = this.childBills.get(bill2);
        if (bill1Childs != null && bill1Childs.contains(bill2) && bill2Childs != null && bill2Childs.contains(bill1)) {
            return 0;
        }
        if (bill1Childs != null && bill1Childs.contains(bill2)) {
            return -1;
        }
        if (bill2Childs != null && bill2Childs.contains(bill1)) {
            return 1;
        }
        return 0;
    }

    public static List<CtBFRow> compareLinkUpNodes(List<CtBFRowLinkUpNode> linkUpNodes) {
        ArrayList<CtBFRowLinkUpNode> parentNodes = new ArrayList<CtBFRowLinkUpNode>();
        for (CtBFRowLinkUpNode ctBFRowLinkUpNode : linkUpNodes) {
            parentNodes.add(ctBFRowLinkUpNode);
            parentNodes.addAll(ctBFRowLinkUpNode.findAllSourceNodes());
        }
        Collections.reverse(parentNodes);
        ArrayList<CtBFRow> rows = new ArrayList<CtBFRow>(parentNodes.size());
        for (CtBFRowLinkUpNode node : parentNodes) {
            if (node.getSNodes() == null || node.getSNodes().isEmpty()) continue;
            for (Map.Entry<CtBFRowId, CtBFRowLinkUpNode> entry : node.getSNodes().entrySet()) {
                CtBFRow row = new CtBFRow();
                row.setSId(entry.getKey());
                row.setId(node.getRowId());
                rows.add(row);
            }
        }
        try {
            CtBFRowComparator ctBFRowComparator = new CtBFRowComparator(rows);
            rows.sort(ctBFRowComparator);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return rows;
    }

    public static List<CtBFRow> compareLinkDownNodes(List<CtBFRowLinkDownNode> linkDownNodes) {
        ArrayList<CtBFRowLinkDownNode> childNodes = new ArrayList<CtBFRowLinkDownNode>();
        for (CtBFRowLinkDownNode ctBFRowLinkDownNode : linkDownNodes) {
            childNodes.add(ctBFRowLinkDownNode);
            childNodes.addAll(ctBFRowLinkDownNode.findAllChildNodes());
        }
        ArrayList<CtBFRow> rows = new ArrayList<CtBFRow>(childNodes.size());
        for (CtBFRowLinkDownNode node : childNodes) {
            if (node.getTNodes() == null || node.getTNodes().isEmpty()) continue;
            for (Map.Entry<CtBFRowId, CtBFRowLinkDownNode> entry : node.getTNodes().entrySet()) {
                CtBFRow row = new CtBFRow();
                row.setSId(node.getRowId());
                row.setId(entry.getKey());
                rows.add(row);
            }
        }
        try {
            CtBFRowComparator ctBFRowComparator = new CtBFRowComparator(rows);
            rows.sort(ctBFRowComparator);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return rows;
    }

    private String billIdToString(CtBFRowId rowId) {
        return String.format("%s,%s", rowId.getMainTableId(), rowId.getBillId());
    }

    private boolean isCircle(Map<String, Set<String>> parentBills, String sBillId, String tBillId) {
        Set<String> sBillId2s = parentBills.get(sBillId);
        if (sBillId2s == null) {
            return false;
        }
        if (sBillId2s.contains(tBillId)) {
            return true;
        }
        for (String sBillId2 : sBillId2s) {
            boolean circle2 = this.isCircle(parentBills, sBillId2, tBillId);
            if (!circle2) continue;
            return true;
        }
        return false;
    }
}

