/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.ctbotp.runtime;

import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.gray.AppGroupUtils;

class CtWriteBackRuleRedisCache {
    private static final String WR_DISTRIBUTE = "WriteBackRule";
    private static final String Type_WriteBackRule = "WriteBackRule";
    private static final String Type_CacheVersion = "WriteBackRuleCacheVersion";
    private static final String Type_WriteBackRuleList = "WriteBackRuleList";

    CtWriteBackRuleRedisCache() {
    }

    private static DistributeSessionlessCache getDistributeCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("WriteBackRule", new DistributeCacheHAPolicy(true, true));
    }

    private static String buildCacheType(String type) {
        String accountId = CacheKeyUtil.getAcctId();
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        if (StringUtils.isNotBlank((CharSequence)appGroup) && !"defaultGroup".equals(appGroup)) {
            return String.format("%s_%s_%s", accountId, appGroup, type);
        }
        return String.format("%s_%s", accountId, type);
    }

    public static void clearAllRuleCache() {
        DistributeSessionlessCache cache = CtWriteBackRuleRedisCache.getDistributeCache();
        cache.remove(CtWriteBackRuleRedisCache.buildCacheType("WriteBackRule"));
        cache.remove(CtWriteBackRuleRedisCache.buildCacheType(Type_CacheVersion));
        cache.remove(CtWriteBackRuleRedisCache.buildCacheType(Type_WriteBackRuleList));
    }

    public static String getRule(String ruleId) {
        String type = CtWriteBackRuleRedisCache.buildCacheType("WriteBackRule");
        return (String)CtWriteBackRuleRedisCache.getDistributeCache().get(type, ruleId);
    }

    public static void putRule(String ruleId, String ruleString) {
        String type = CtWriteBackRuleRedisCache.buildCacheType("WriteBackRule");
        CtWriteBackRuleRedisCache.getDistributeCache().put(type, ruleId, (Object)ruleString);
    }

    public static String getRuleIds(String targetEntityNumber) {
        String type = CtWriteBackRuleRedisCache.buildCacheType(Type_WriteBackRuleList);
        return (String)CtWriteBackRuleRedisCache.getDistributeCache().get(type, targetEntityNumber);
    }

    public static void putRuleIds(String targetEntityNumber, String ruleIds) {
        String type = CtWriteBackRuleRedisCache.buildCacheType(Type_WriteBackRuleList);
        CtWriteBackRuleRedisCache.getDistributeCache().put(type, targetEntityNumber, (Object)ruleIds);
    }

    public static String getRuleVer(long verId) {
        String type = CtWriteBackRuleRedisCache.buildCacheType("WriteBackRule");
        String strVerId = String.valueOf(verId);
        return (String)CtWriteBackRuleRedisCache.getDistributeCache().get(type, strVerId);
    }

    public static void putRuleVer(long verId, String ruleString) {
        String type = CtWriteBackRuleRedisCache.buildCacheType("WriteBackRule");
        String strVerId = String.valueOf(verId);
        CtWriteBackRuleRedisCache.getDistributeCache().put(type, strVerId, (Object)ruleString);
    }

    public static String getCacheVersion(String ruleId) {
        String type = CtWriteBackRuleRedisCache.buildCacheType(Type_CacheVersion);
        return (String)CtWriteBackRuleRedisCache.getDistributeCache().get(type, ruleId);
    }

    public static List<String> batchGetCacheVersion(String[] ruleIds) {
        String type = CtWriteBackRuleRedisCache.buildCacheType(Type_CacheVersion);
        return CtWriteBackRuleRedisCache.getDistributeCache().get(type, ruleIds);
    }

    public static void putCacheVersion(String ruleId, String cacheVersion) {
        String type = CtWriteBackRuleRedisCache.buildCacheType(Type_CacheVersion);
        CtWriteBackRuleRedisCache.getDistributeCache().put(type, ruleId, (Object)cacheVersion);
    }
}

