/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.botp;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.constants.ReportStatusEnum;
import kd.bos.entity.botp.report.ConvertWatchReport;

public class BOTPCovertReportService {
    private static final String FORMID_BOTP_CONVERTWATCH = "botp_convertwatch";
    private static final String KEY_ID = "id";
    private static final String KEY_SBILLNO = "sbillno";
    private static final String KEY_SBILLID = "sbillid";
    private static final String KEY_SENTITYNUMBER = "sentitynumber";
    private static final String KEY_TASKID = "taskid";
    private static final String KEY_CONVERTRULEID = "convertruleid";
    private static final String KEY_STATUS = "status";
    private static final String KEY_MOUDLEKEY = "moudlekey";
    private static final String KEY_UNIQUEKEY = "uniquekey";
    private static final String KEY_URL = "url";
    private static final String KEY_TRACEID = "traceid";
    private static final String KEY_DESC = "desc";
    private static final String KEY_CREATETIME = "createtime";
    private static final String KEY_MODIFYTIME = "modifytime";

    public static void addConvertReport(ConvertWatchReport convertReport) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)FORMID_BOTP_CONVERTWATCH);
        DynamicObject dynamicObject = BOTPCovertReportService.buildConvertReportObject(mainEntityType, convertReport);
        try (TXHandle h = TX.requiresNew();){
            try {
                BusinessDataWriter.save((IDataEntityType)mainEntityType, (Object[])new DynamicObject[]{dynamicObject});
            }
            catch (Throwable e) {
                h.markRollback();
            }
        }
    }

    public static void updateStatusAndUrl(String status, String moudleKey, String uniqueKey, String url, String desc) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("update t_botp_convert_watch set ");
        sqlBuilder.append("fstatus = ?, fmodifytime = ?");
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            sqlBuilder.append(", furl = ?");
        }
        if (StringUtils.isNotEmpty((CharSequence)desc)) {
            sqlBuilder.append(", fdesc = ?");
        }
        sqlBuilder.append(" where fmoudlekey = ? and funiquekey = ?");
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter("fstatus", 1, (Object)status));
        params.add(new SqlParameter("fmodifytime", 91, (Object)new Date()));
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            params.add(new SqlParameter("furl", 12, (Object)url));
        }
        if (StringUtils.isNotEmpty((CharSequence)desc)) {
            params.add(new SqlParameter("fdesc", 12, (Object)desc));
        }
        params.add(new SqlParameter("fmoudlekey", 12, (Object)moudleKey));
        params.add(new SqlParameter("funiquekey", 12, (Object)uniqueKey));
        try (TXHandle h = TX.requiresNew();){
            DB.update((DBRoute)DBRoute.meta, (String)sqlBuilder.toString(), (Object[])params.toArray(new SqlParameter[params.size()]));
        }
    }

    public static List<ConvertWatchReport> getConvertWatchReports(List<Long> ids) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)FORMID_BOTP_CONVERTWATCH);
        DynamicObject[] dynamicObjects = BusinessDataReader.load((Object[])ids.toArray(), (DynamicObjectType)mainEntityType, (Boolean)false);
        ArrayList<ConvertWatchReport> convertWatchReports = new ArrayList<ConvertWatchReport>(dynamicObjects.length);
        DynamicObject[] var4 = dynamicObjects;
        int var5 = dynamicObjects.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            DynamicObject dynamicObject = var4[var6];
            ConvertWatchReport convertWatchReport = BOTPCovertReportService.buildConvertWatchReport(dynamicObject);
            convertWatchReports.add(convertWatchReport);
        }
        return convertWatchReports;
    }

    private static DynamicObject buildConvertReportObject(MainEntityType mainType, ConvertWatchReport convertWatchReport) {
        DynamicObject obj = new DynamicObject((DynamicObjectType)mainType);
        obj.set(KEY_ID, (Object)convertWatchReport.getId());
        obj.set(KEY_SBILLNO, (Object)convertWatchReport.getSbillno());
        obj.set(KEY_TASKID, (Object)convertWatchReport.getTaskId());
        obj.set(KEY_SENTITYNUMBER, (Object)convertWatchReport.getSentityNumber());
        obj.set(KEY_SBILLID, (Object)convertWatchReport.getSbillId());
        obj.set(KEY_CONVERTRULEID, (Object)convertWatchReport.getConvertRuleId());
        obj.set(KEY_STATUS, (Object)convertWatchReport.getStatus());
        obj.set(KEY_MOUDLEKEY, (Object)convertWatchReport.getMoudlekey());
        obj.set(KEY_UNIQUEKEY, (Object)convertWatchReport.getUniquekey());
        obj.set(KEY_URL, (Object)convertWatchReport.getUrl());
        obj.set(KEY_TRACEID, (Object)convertWatchReport.getTraceId());
        obj.set(KEY_DESC, (Object)convertWatchReport.getDesc());
        obj.set(KEY_CREATETIME, (Object)convertWatchReport.getCreateTime());
        obj.set(KEY_MODIFYTIME, (Object)convertWatchReport.getModifyTime());
        return obj;
    }

    public static ConvertWatchReport buildConvertWatchReport(Long taskId, Long sBillId, Long ruleId, String sEntityNumber, String billNo, String moudledkey, String uniqueKey, ReportStatusEnum reportStatusEnum) {
        ConvertWatchReport convertWatchReport = new ConvertWatchReport();
        convertWatchReport.setSbillId(sBillId);
        convertWatchReport.setConvertRuleId(ruleId);
        convertWatchReport.setSentityNumber(sEntityNumber);
        convertWatchReport.setSbillno(billNo);
        convertWatchReport.setTaskId(taskId);
        convertWatchReport.setMoudlekey(moudledkey);
        convertWatchReport.setUniquekey(uniqueKey);
        convertWatchReport.setStatus(reportStatusEnum.name());
        convertWatchReport.setTraceId(RequestContext.get().getTraceId());
        convertWatchReport.setCreateTime(new Date());
        convertWatchReport.setModifyTime(new Date());
        return convertWatchReport;
    }

    public static ConvertWatchReport buildConvertWatchReport(DynamicObject obj) {
        ConvertWatchReport convertWatchReport = new ConvertWatchReport();
        convertWatchReport.setId((Long)obj.getPkValue());
        convertWatchReport.setSbillId(Long.valueOf(obj.getLong(KEY_SBILLID)));
        convertWatchReport.setConvertRuleId(Long.valueOf(obj.getLong(KEY_CONVERTRULEID)));
        convertWatchReport.setSentityNumber(obj.getString(KEY_SENTITYNUMBER));
        convertWatchReport.setSbillno(obj.getString(KEY_SBILLNO));
        convertWatchReport.setTaskId(Long.valueOf(obj.getLong(KEY_TASKID)));
        convertWatchReport.setMoudlekey(obj.getString(KEY_MOUDLEKEY));
        convertWatchReport.setUniquekey(obj.getString(KEY_UNIQUEKEY));
        convertWatchReport.setUrl(obj.getString(KEY_URL));
        convertWatchReport.setStatus(obj.getString(KEY_STATUS));
        convertWatchReport.setModifyTime(obj.getDate(KEY_MODIFYTIME));
        convertWatchReport.setCreateTime(obj.getDate(KEY_CREATETIME));
        convertWatchReport.setTraceId(obj.getString(KEY_TRACEID));
        return convertWatchReport;
    }
}

