/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.botp;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.constants.ReportStatusEnum;
import kd.bos.entity.botp.report.WriteBackWatchReport;

public class BOTPWriteBackReportService {
    private static final String FORMID_BOTP_WRITEBACKWATCH = "botp_writebackwatch";
    private static final String KEY_ID = "id";
    private static final String KEY_SBILLNO = "sbillno";
    private static final String KEY_SBILLID = "sbillid";
    private static final String KEY_SENTITYNUMBER = "sentitynumber";
    private static final String KEY_TBILLNO = "tbillno";
    private static final String KEY_TBILLID = "tbillid";
    private static final String KEY_TENTITYNUMBER = "tentitynumber";
    private static final String KEY_TASKID = "taskid";
    private static final String KEY_CONVERTRULEID = "convertruleid";
    private static final String KEY_STATUS = "status";
    private static final String KEY_MOUDLEKEY = "moudlekey";
    private static final String KEY_UNIQUEKEY = "uniquekey";
    private static final String KEY_URL = "url";
    private static final String KEY_TRACEID = "traceid";
    private static final String KEY_DESC = "desc";
    private static final String KEY_CREATETIME = "createtime";
    private static final String KEY_MODIFYTIME = "modifytime";

    public static void addWriteBackReport(WriteBackWatchReport writeBackWatchReport) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)FORMID_BOTP_WRITEBACKWATCH);
        DynamicObject dynamicObject = BOTPWriteBackReportService.buildWriteBackReportObject(mainEntityType, writeBackWatchReport);
        try (TXHandle h = TX.requiresNew();){
            try {
                BusinessDataWriter.save((IDataEntityType)mainEntityType, (Object[])new DynamicObject[]{dynamicObject});
            }
            catch (Throwable e) {
                h.markRollback();
            }
        }
    }

    public static void updateStatusAndUrl(String status, String moudleKey, String uniqueKey, String url, String desc) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("update t_botp_writeback_watch set ");
        sqlBuilder.append("fstatus = ?, fmodifytime = ?");
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            sqlBuilder.append(", furl = ?");
        }
        if (StringUtils.isNotEmpty((CharSequence)desc)) {
            sqlBuilder.append(", fdesc = ?");
        }
        sqlBuilder.append(" where fmoudlekey = ? and funiquekey = ?");
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter("fstatus", 1, (Object)status));
        params.add(new SqlParameter("fmodifytime", 91, (Object)new Date()));
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            params.add(new SqlParameter("furl", 12, (Object)url));
        }
        if (StringUtils.isNotEmpty((CharSequence)desc)) {
            params.add(new SqlParameter("fdesc", 12, (Object)desc));
        }
        params.add(new SqlParameter("fmoudlekey", 12, (Object)moudleKey));
        params.add(new SqlParameter("funiquekey", 12, (Object)uniqueKey));
        try (TXHandle h = TX.requiresNew();){
            DB.update((DBRoute)DBRoute.meta, (String)sqlBuilder.toString(), (Object[])params.toArray(new SqlParameter[params.size()]));
        }
    }

    public static List<WriteBackWatchReport> getWriteBackWatchReports(List<Long> ids) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)FORMID_BOTP_WRITEBACKWATCH);
        DynamicObject[] dynamicObjects = BusinessDataReader.load((Object[])ids.toArray(), (DynamicObjectType)mainEntityType, (Boolean)false);
        ArrayList<WriteBackWatchReport> writeBackWatchReports = new ArrayList<WriteBackWatchReport>(dynamicObjects.length);
        DynamicObject[] var4 = dynamicObjects;
        int var5 = dynamicObjects.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            DynamicObject dynamicObject = var4[var6];
            WriteBackWatchReport writeBackWatchReport = BOTPWriteBackReportService.buildWriteBackWatchReport(dynamicObject);
            writeBackWatchReports.add(writeBackWatchReport);
        }
        return writeBackWatchReports;
    }

    private static DynamicObject buildWriteBackReportObject(MainEntityType mainType, WriteBackWatchReport writeBackWatchReport) {
        DynamicObject obj = new DynamicObject((DynamicObjectType)mainType);
        obj.set(KEY_ID, (Object)writeBackWatchReport.getId());
        obj.set(KEY_TBILLNO, (Object)writeBackWatchReport.getTbillno());
        obj.set(KEY_TASKID, (Object)writeBackWatchReport.getTaskId());
        obj.set(KEY_TENTITYNUMBER, (Object)writeBackWatchReport.getTentityNumber());
        obj.set(KEY_TBILLID, (Object)writeBackWatchReport.getTbillId());
        obj.set(KEY_STATUS, (Object)writeBackWatchReport.getStatus());
        obj.set(KEY_MOUDLEKEY, (Object)writeBackWatchReport.getMoudlekey());
        obj.set(KEY_UNIQUEKEY, (Object)writeBackWatchReport.getUniquekey());
        obj.set(KEY_URL, (Object)writeBackWatchReport.getUrl());
        obj.set(KEY_TRACEID, (Object)writeBackWatchReport.getTraceId());
        obj.set(KEY_DESC, (Object)writeBackWatchReport.getDesc());
        obj.set(KEY_CREATETIME, (Object)writeBackWatchReport.getCreateTime());
        obj.set(KEY_MODIFYTIME, (Object)writeBackWatchReport.getModifyTime());
        return obj;
    }

    public static WriteBackWatchReport buildWriteBackWatchReport(Long taskId, Long tBillId, String tEntityNumber, String tBillNo, String moudledkey, String uniqueKey, ReportStatusEnum reportStatusEnum) {
        WriteBackWatchReport writeBackWatchReport = new WriteBackWatchReport();
        writeBackWatchReport.setTbillId(tBillId);
        writeBackWatchReport.setTbillno(tBillNo);
        writeBackWatchReport.setTentityNumber(tEntityNumber);
        writeBackWatchReport.setTaskId(taskId);
        writeBackWatchReport.setMoudlekey(moudledkey);
        writeBackWatchReport.setUniquekey(uniqueKey);
        writeBackWatchReport.setStatus(reportStatusEnum.name());
        writeBackWatchReport.setTraceId(RequestContext.get().getTraceId());
        writeBackWatchReport.setCreateTime(new Date());
        writeBackWatchReport.setModifyTime(new Date());
        return writeBackWatchReport;
    }

    public static WriteBackWatchReport buildWriteBackWatchReport(DynamicObject obj) {
        WriteBackWatchReport writeBackWatchReport = new WriteBackWatchReport();
        writeBackWatchReport.setId((Long)obj.getPkValue());
        writeBackWatchReport.setSbillId(Long.valueOf(obj.getLong(KEY_SBILLID)));
        writeBackWatchReport.setSentityNumber(obj.getString(KEY_SENTITYNUMBER));
        writeBackWatchReport.setSbillno(obj.getString(KEY_SBILLNO));
        writeBackWatchReport.setTbillId(Long.valueOf(obj.getLong(KEY_TBILLID)));
        writeBackWatchReport.setTentityNumber(obj.getString(KEY_TENTITYNUMBER));
        writeBackWatchReport.setTbillno(obj.getString(KEY_TBILLNO));
        writeBackWatchReport.setTaskId(Long.valueOf(obj.getLong(KEY_TASKID)));
        writeBackWatchReport.setMoudlekey(obj.getString(KEY_MOUDLEKEY));
        writeBackWatchReport.setUniquekey(obj.getString(KEY_UNIQUEKEY));
        writeBackWatchReport.setUrl(obj.getString(KEY_URL));
        writeBackWatchReport.setStatus(obj.getString(KEY_STATUS));
        writeBackWatchReport.setModifyTime(obj.getDate(KEY_MODIFYTIME));
        writeBackWatchReport.setCreateTime(obj.getDate(KEY_CREATETIME));
        writeBackWatchReport.setTraceId(obj.getString(KEY_TRACEID));
        return writeBackWatchReport;
    }
}

