/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.botp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.botp.BillTrackReader;
import kd.bos.botp.ConvertDataService;
import kd.bos.botp.EntryTrackReader;
import kd.bos.botp.LinkTreeBuilder;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;

public class BusinessFlowDataService {
    private static final String BOOLEAN_TRUE = String.valueOf(true);
    private static final String BOOLEAN_FALSE = String.valueOf(false);
    private BillTrackReader billTrackReader;
    private EntryTrackReader entryTrackReader;
    private LinkTreeBuilder linkTreeBuilder;

    private BillTrackReader getBillTrackReader() {
        if (this.billTrackReader == null) {
            this.billTrackReader = new BillTrackReader();
        }
        return this.billTrackReader;
    }

    private EntryTrackReader getEntryTrackReader() {
        if (this.entryTrackReader == null) {
            this.entryTrackReader = new EntryTrackReader();
        }
        return this.entryTrackReader;
    }

    private LinkTreeBuilder getLinkTreeBuilder() {
        if (this.linkTreeBuilder == null) {
            this.linkTreeBuilder = new LinkTreeBuilder();
        }
        return this.linkTreeBuilder;
    }

    @Deprecated
    public List<BFRowLinkUpNode> loadLinkUpNodes(String entityNumber, String entryKey, Long[] entryIds) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || entryIds == null || entryIds.length == 0) {
            return new ArrayList<BFRowLinkUpNode>();
        }
        List<BFRow> myEntryBFRows = this.getEntryTrackReader().readUpEntryBFRows(entityNumber, entryKey, entryIds, false);
        ArrayList<BFRowId> srcBFRowIds = new ArrayList<BFRowId>(16);
        for (BFRow row : myEntryBFRows) {
            srcBFRowIds.add(row.getSId());
        }
        List<BFRow> allEntryBFRows = this.loadSourceRowIds(srcBFRowIds);
        return this.getLinkTreeBuilder().buildLinkUpNodes(allEntryBFRows, myEntryBFRows);
    }

    @Deprecated
    public List<BFRowLinkUpNode> loadDirtLinkUpNodes(String entityNumber, String entryKey, Long[] entryIds) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || entryIds == null || entryIds.length == 0) {
            return new ArrayList<BFRowLinkUpNode>();
        }
        List<BFRow> myEntryBFRows = this.getEntryTrackReader().readUpEntryBFRows(entityNumber, entryKey, entryIds, false);
        return this.getLinkTreeBuilder().buildDirtLinkUpNodes(myEntryBFRows);
    }

    public List<BFRowLinkUpNode> loadLinkUpNodes(String targetEntityNumber, Long[] targetBillIds, OperateOption option) {
        boolean isBillLink;
        if (StringUtils.isBlank((CharSequence)targetEntityNumber) || targetBillIds == null || targetBillIds.length == 0) {
            return new ArrayList<BFRowLinkUpNode>(0);
        }
        boolean isDirtLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_dirt_link", BOOLEAN_FALSE));
        boolean bl = isBillLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_bill_link", BOOLEAN_FALSE));
        if (isBillLink) {
            Map<Long, BFRowLinkUpNode> billLinkUpNodes = this.loadBillLinkUpNodes(targetEntityNumber, targetBillIds, isDirtLink);
            return new ArrayList<BFRowLinkUpNode>(billLinkUpNodes.values());
        }
        List<BFRow> myEntryBFRows = this.getEntryTrackReader().readUpEntryBFRows(targetEntityNumber, targetBillIds);
        if (isDirtLink) {
            return this.getLinkTreeBuilder().buildDirtLinkUpNodes(myEntryBFRows);
        }
        ArrayList<BFRowId> srcBFRowIds = new ArrayList<BFRowId>(16);
        for (BFRow row : myEntryBFRows) {
            srcBFRowIds.add(row.getSId());
        }
        List<BFRow> allEntryBFRows = this.loadSourceRowIds(srcBFRowIds);
        return this.getLinkTreeBuilder().buildLinkUpNodes(allEntryBFRows, myEntryBFRows);
    }

    public List<BFRowLinkUpNode> loadLinkUpNodes(String targetEntityNumber, String targetEntryKey, Long[] targetBillIds, Long[] targetEntryIds, OperateOption option) {
        boolean searchEntry;
        if (StringUtils.isBlank((CharSequence)targetEntityNumber) || targetEntryIds == null || targetEntryIds.length == 0) {
            return new ArrayList<BFRowLinkUpNode>(0);
        }
        boolean isDirtLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_dirt_link", BOOLEAN_FALSE));
        boolean bl = searchEntry = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_search_entry", BOOLEAN_FALSE));
        if (isDirtLink) {
            List<BFRow> myEntryBFRows = this.getEntryTrackReader().readUpEntryBFRows(targetEntityNumber, targetEntryKey, targetBillIds, targetEntryIds, searchEntry);
            return this.getLinkTreeBuilder().buildDirtLinkUpNodes(myEntryBFRows);
        }
        List<BFRow> allEntryBFRows = this.getEntryTrackReader().readFullUpEntryBFRows(targetEntityNumber, targetEntryKey, targetBillIds, targetEntryIds, searchEntry);
        TableDefine tableDefine = this.getEntryTrackReader().loadTableDefine(targetEntityNumber, targetEntryKey);
        return this.getLinkTreeBuilder().buildLinkUpNodes(allEntryBFRows, tableDefine.getTableId(), targetEntryIds);
    }

    public Map<Long, BFRowLinkUpNode> loadBillLinkUpNodes(String entityNumber, Long[] billIds, boolean onlyDirtSource) {
        List<BFRow> allRows = this.loadBillLinkUp(entityNumber, billIds, onlyDirtSource);
        return this.getLinkTreeBuilder().buildBillLinkUpNodes(entityNumber, billIds, allRows);
    }

    @Deprecated
    public List<BFRowLinkDownNode> loadLinkDownNodes(String srcEntityNumber, String srcEntryKey, Long[] srcEntryIds) {
        if (StringUtils.isBlank((CharSequence)srcEntityNumber) || srcEntryIds == null || srcEntryIds.length == 0) {
            return new ArrayList<BFRowLinkDownNode>();
        }
        List<Object> allEntryBFRows = new ArrayList(0);
        if (StringUtils.isBlank((CharSequence)srcEntryKey)) {
            allEntryBFRows = this.loadTargetRowIds(srcEntityNumber, srcEntryIds, null);
        } else {
            HashSet<Long> myBillIds = this.getEntryTrackReader().readBillIds(srcEntityNumber, srcEntryKey, srcEntryIds);
            allEntryBFRows = this.loadTargetRowIds(srcEntityNumber, srcEntryKey, myBillIds.toArray(new Long[0]), srcEntryIds, null);
        }
        return this.getLinkTreeBuilder().buildLinkDownNodes(srcEntityNumber, srcEntryKey, srcEntryIds, allEntryBFRows);
    }

    @Deprecated
    public List<BFRowLinkDownNode> loadDirtLinkDownNodes(String entityNumber, String entryKey, Long[] entryIds) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || entryIds == null || entryIds.length == 0) {
            return new ArrayList<BFRowLinkDownNode>();
        }
        List<Object> allEntryBFRows = new ArrayList(0);
        if (StringUtils.isBlank((CharSequence)entryKey)) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("botp_track_only_dirt_link", BOOLEAN_TRUE);
            allEntryBFRows = this.loadTargetRowIds(entityNumber, entryIds, option);
        } else {
            HashSet<Long> myBillIds = this.getEntryTrackReader().readBillIds(entityNumber, entryKey, entryIds);
            OperateOption option = OperateOption.create();
            option.setVariableValue("botp_track_only_dirt_link", BOOLEAN_TRUE);
            allEntryBFRows = this.loadTargetRowIds(entityNumber, entryKey, myBillIds.toArray(new Long[0]), entryIds, option);
        }
        return this.getLinkTreeBuilder().buildLinkDownNodes(entityNumber, entryKey, entryIds, allEntryBFRows);
    }

    public List<BFRowLinkDownNode> loadLinkDownNodes(String srcEntityNumber, Long[] srcBillIds, OperateOption option) {
        boolean onlyBillLink;
        if (StringUtils.isBlank((CharSequence)srcEntityNumber) || srcBillIds == null || srcBillIds.length == 0) {
            return new ArrayList<BFRowLinkDownNode>(0);
        }
        boolean onlyDirtLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_dirt_link", BOOLEAN_FALSE));
        boolean bl = onlyBillLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_bill_link", BOOLEAN_FALSE));
        if (onlyBillLink) {
            Map<Long, BFRowLinkDownNode> map = this.loadBillLinkDownNodes(srcEntityNumber, srcBillIds, onlyDirtLink);
            return new ArrayList<BFRowLinkDownNode>(map.values());
        }
        List<BFRow> allEntryBFRows = this.loadTargetRowIds(srcEntityNumber, srcBillIds, option);
        return this.getLinkTreeBuilder().buildLinkDownNodes(srcEntityNumber, "", srcBillIds, allEntryBFRows);
    }

    public List<BFRowLinkDownNode> loadLinkDownNodes(String srcEntityNumber, String srcEntryKey, Long[] srcBillIds, Long[] srcEntryIds, OperateOption option) {
        if (StringUtils.isBlank((CharSequence)srcEntityNumber) || srcEntryIds == null || srcEntryIds.length == 0) {
            return new ArrayList<BFRowLinkDownNode>(0);
        }
        List<BFRow> allEntryBFRows = this.loadTargetRowIds(srcEntityNumber, srcEntryKey, srcBillIds, srcEntryIds, option);
        return this.getLinkTreeBuilder().buildLinkDownNodes(srcEntityNumber, srcEntryKey, srcEntryIds, allEntryBFRows);
    }

    public Map<Long, BFRowLinkDownNode> loadBillLinkDownNodes(String entityNumber, Long[] billIds, boolean onlyDirtTarget) {
        List<BFRow> allRows = this.loadBillLinkDown(entityNumber, billIds, onlyDirtTarget);
        return this.getLinkTreeBuilder().buildBillLinkDownNodes(entityNumber, billIds, allRows);
    }

    @Deprecated
    public List<BFRow> loadSourceRowIds(String targetEntityNumber, String targetEntryKey, Long[] targetEntryIds) {
        if (StringUtils.isBlank((CharSequence)targetEntityNumber) || targetEntryIds == null || targetEntryIds.length == 0) {
            return new ArrayList<BFRow>(0);
        }
        List<BFRow> myEntryBFRows = this.getEntryTrackReader().readUpEntryBFRows(targetEntityNumber, targetEntryKey, targetEntryIds, false);
        ArrayList<BFRowId> srcBFRowIds = new ArrayList<BFRowId>(16);
        for (BFRow row : myEntryBFRows) {
            srcBFRowIds.add(row.getSId());
        }
        List<BFRow> srcEntryBFRows = this.loadSourceRowIds(srcBFRowIds);
        ArrayList<BFRow> allEntryBFRows = new ArrayList<BFRow>();
        allEntryBFRows.addAll(myEntryBFRows);
        allEntryBFRows.addAll(srcEntryBFRows);
        return allEntryBFRows;
    }

    public List<BFRow> loadSourceRowIds(String targetEntityNumber, Long[] targetBillIds, OperateOption option) {
        if (StringUtils.isBlank((CharSequence)targetEntityNumber) || targetBillIds == null || targetBillIds.length == 0) {
            return new ArrayList<BFRow>(0);
        }
        boolean onlyDirtLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_dirt_link", BOOLEAN_FALSE));
        return this.getEntryTrackReader().readFullUpEntryBFRows(targetEntityNumber, targetBillIds, onlyDirtLink);
    }

    public List<BFRow> loadSourceRowIds(String targetEntityNumber, String targetEntryKey, Long[] targetBillIds, Long[] targetEntryIds, OperateOption option) {
        boolean isDirtLink;
        if (StringUtils.isBlank((CharSequence)targetEntityNumber) || targetEntryIds == null || targetEntryIds.length == 0) {
            return new ArrayList<BFRow>(0);
        }
        boolean bl = isDirtLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_dirt_link", BOOLEAN_FALSE));
        if (isDirtLink) {
            List<BFRow> myEntryBFRows = this.getEntryTrackReader().readUpEntryBFRows(targetEntityNumber, targetEntryKey, targetBillIds, targetEntryIds, false);
            return myEntryBFRows;
        }
        List<BFRow> allEntryBFRows = this.getEntryTrackReader().readFullUpEntryBFRows(targetEntityNumber, targetEntryKey, targetBillIds, targetEntryIds, false);
        return allEntryBFRows;
    }

    public List<BFRow> loadSourceRowIds(List<BFRowId> entryRowIds) {
        HashMap allSrcBillIds = new HashMap(entryRowIds.size());
        HashMap srcBillIds = new HashMap(entryRowIds.size());
        for (BFRowId entryRowId : entryRowIds) {
            if (!this.getEntryTrackReader().addToMap(allSrcBillIds, entryRowId.getMainTableId(), entryRowId.getBillId())) continue;
            this.getEntryTrackReader().addToMap(srcBillIds, entryRowId.getMainTableId(), entryRowId.getBillId());
        }
        ArrayList<BFRow> allEntryBFRows = new ArrayList<BFRow>(entryRowIds.size());
        ArrayList<BFRow> entryBFRows = new ArrayList<BFRow>(entryRowIds.size());
        int count = 0;
        while (srcBillIds.size() > 0 && count < 100) {
            ++count;
            entryBFRows.clear();
            for (Map.Entry entry : srcBillIds.entrySet()) {
                Long targetMainTableId = (Long)entry.getKey();
                Set tergetBillIds = (Set)entry.getValue();
                entryBFRows.addAll(this.getEntryTrackReader().readUpEntryBFRows(targetMainTableId, tergetBillIds.toArray(new Long[0])));
            }
            srcBillIds.clear();
            for (BFRow bfRow : entryBFRows) {
                if (!this.getEntryTrackReader().addToMap(allSrcBillIds, bfRow.getSId().getMainTableId(), bfRow.getSId().getBillId())) continue;
                this.getEntryTrackReader().addToMap(srcBillIds, bfRow.getSId().getMainTableId(), bfRow.getSId().getBillId());
            }
            allEntryBFRows.addAll(entryBFRows);
        }
        return allEntryBFRows;
    }

    @Deprecated
    public List<BFRow> loadTargetRowIds(String srcEntityNumber, String srcEntryKey, Long[] srcEntryIds) {
        if (StringUtils.isBlank((CharSequence)srcEntityNumber) || srcEntryIds == null || srcEntryIds.length == 0) {
            return new ArrayList<BFRow>();
        }
        if (StringUtils.isBlank((CharSequence)srcEntryKey)) {
            return this.loadTargetRowIds(srcEntityNumber, srcEntryIds, null);
        }
        HashSet<Long> myBillIds = this.getEntryTrackReader().readBillIds(srcEntityNumber, srcEntryKey, srcEntryIds);
        return this.loadTargetRowIds(srcEntityNumber, srcEntryKey, myBillIds.toArray(new Long[0]), srcEntryIds, null);
    }

    public List<BFRow> loadTargetRowIds(String srcEntityNumber, Long[] srcBillIds, OperateOption option) {
        if (StringUtils.isBlank((CharSequence)srcEntityNumber) || srcBillIds == null || srcBillIds.length == 0) {
            return new ArrayList<BFRow>();
        }
        ConvertDataService reader = new ConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(srcEntityNumber, srcEntityNumber);
        Long myMainTableId = mainTableDefine.getTableId();
        boolean onlyDirtLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_dirt_link", BOOLEAN_FALSE));
        return this.getBillTrackReader().readFullDownEntryBFRows(myMainTableId, srcBillIds, onlyDirtLink);
    }

    public List<BFRow> loadTargetRowIds(String srcEntityNumber, String srcEntryKey, Long[] srcBillIds, Long[] srcEntryIds, OperateOption option) {
        if (StringUtils.isBlank((CharSequence)srcEntityNumber) || srcEntryIds == null || srcEntryIds.length == 0) {
            return new ArrayList<BFRow>();
        }
        ConvertDataService reader = new ConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(srcEntityNumber, srcEntityNumber);
        Long myMainTableId = mainTableDefine.getTableId();
        TableDefine entryTableDefine = reader.loadTableDefine(srcEntityNumber, srcEntryKey);
        Long myEntryTableId = entryTableDefine.getTableId();
        HashSet<Long> myEntryIds = new HashSet<Long>(srcEntryIds.length);
        for (Long entryId : srcEntryIds) {
            myEntryIds.add(entryId);
        }
        boolean onlyDirtLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_dirt_link", BOOLEAN_FALSE));
        boolean searchEntry = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_search_entry", BOOLEAN_FALSE));
        return this.getBillTrackReader().readFullDownEntryBFRows(myMainTableId, myEntryTableId, srcBillIds, myEntryIds, onlyDirtLink, searchEntry);
    }

    public List<BFRow> loadBillLinkUp(String entityNumber, Long[] billIds, boolean onlyDirtSource) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || billIds == null || billIds.length == 0) {
            return new ArrayList<BFRow>(0);
        }
        if (onlyDirtSource) {
            Set<BFRow> myRows = this.getEntryTrackReader().readUpBillBFRows(entityNumber, billIds);
            return new ArrayList<BFRow>(myRows);
        }
        Set<BFRow> allRows = this.getEntryTrackReader().readFullUpBillBFRows(entityNumber, billIds);
        return new ArrayList<BFRow>(allRows);
    }

    public List<BFRow> loadBillLinkDown(String entityNumber, Long[] billIds, boolean onlyDirtTarget) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || billIds == null || billIds.length == 0) {
            return new ArrayList<BFRow>(0);
        }
        ConvertDataService reader = new ConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(entityNumber, entityNumber);
        Long mainTableId = mainTableDefine.getTableId();
        if (onlyDirtTarget) {
            return this.getBillTrackReader().readDownBillBFRows(mainTableId, billIds);
        }
        return this.getBillTrackReader().readFullDownBillBFRows(mainTableId, billIds);
    }

    public Map<String, HashSet<Long>> findLinkBills(String entityNumber, Long[] billIds) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || billIds == null || billIds.length == 0) {
            return new HashMap<String, HashSet<Long>>();
        }
        Map<String, HashSet<Long>> sourceBills = this.findSourceBills(entityNumber, billIds);
        Map<String, HashSet<Long>> targetBills = this.findTargetBills(entityNumber, billIds);
        LinkedHashMap<String, HashSet<Long>> linkBills = new LinkedHashMap<String, HashSet<Long>>();
        linkBills.putAll(sourceBills);
        linkBills.putAll(targetBills);
        return linkBills;
    }

    public Map<String, HashSet<Long>> findSourceBills(String entityNumber, Long[] billIds) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || billIds == null || billIds.length == 0) {
            return new HashMap<String, HashSet<Long>>();
        }
        ConvertDataService reader = new ConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(entityNumber, entityNumber);
        Long myMainTableId = mainTableDefine.getTableId();
        HashSet<Long> myBillIds = new HashSet<Long>();
        for (Long billId : billIds) {
            myBillIds.add(billId);
        }
        if (myBillIds.size() == 0) {
            return new LinkedHashMap<String, HashSet<Long>>();
        }
        LinkedHashMap allLinkBills = new LinkedHashMap();
        HashMap<Long, HashSet<Long>> srcBillIds = new HashMap<Long, HashSet<Long>>();
        srcBillIds.put(myMainTableId, myBillIds);
        int count = 0;
        HashSet<BFRow> allBillLinkRows = new HashSet<BFRow>();
        while (srcBillIds.size() > 0 && count < 100) {
            ++count;
            allBillLinkRows.clear();
            for (Map.Entry entry : srcBillIds.entrySet()) {
                Long targetMainTableId = (Long)entry.getKey();
                Long[] targetBillIds = ((Set)entry.getValue()).toArray(new Long[0]);
                Set<BFRow> billLinkRows = this.getEntryTrackReader().readUpBillBFRows(targetMainTableId, targetBillIds);
                allBillLinkRows.addAll(billLinkRows);
            }
            srcBillIds.clear();
            for (BFRow billLinkRow : allBillLinkRows) {
                Long sMainTableId = billLinkRow.getSId().getMainTableId();
                Long sBillId = billLinkRow.getSId().getBillId();
                if (!this.getEntryTrackReader().addToMap(allLinkBills, sMainTableId, sBillId)) continue;
                this.getEntryTrackReader().addToMap(srcBillIds, sMainTableId, sBillId);
            }
        }
        LinkedHashMap<String, HashSet<Long>> linkBills = new LinkedHashMap<String, HashSet<Long>>();
        for (Map.Entry item : allLinkBills.entrySet()) {
            Long sMainTableId = (Long)item.getKey();
            TableDefine tableDefine = reader.loadTableDefine(sMainTableId);
            if (tableDefine == null) continue;
            HashSet sBillIds = new HashSet((Collection)item.getValue());
            linkBills.put(tableDefine.getEntityNumber(), sBillIds);
        }
        return linkBills;
    }

    public Map<String, HashSet<Long>> findTargetBills(String entityNumber, Long[] billIds) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || billIds == null || billIds.length == 0) {
            return new HashMap<String, HashSet<Long>>();
        }
        ConvertDataService reader = new ConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(entityNumber, entityNumber);
        Long myMainTableId = mainTableDefine.getTableId();
        HashSet<Long> myBillIds = new HashSet<Long>(16);
        for (Long billId : billIds) {
            myBillIds.add(billId);
        }
        if (myBillIds.size() == 0) {
            return new LinkedHashMap<String, HashSet<Long>>();
        }
        LinkedHashMap allLinkBills = new LinkedHashMap();
        HashMap<Long, HashSet<Long>> tgtBillIds = new HashMap<Long, HashSet<Long>>();
        tgtBillIds.put(myMainTableId, myBillIds);
        int count = 0;
        while (tgtBillIds.size() > 0 && count < 100) {
            ++count;
            ArrayList<BFRowId> allBillRowIds = new ArrayList<BFRowId>();
            for (Map.Entry entry : tgtBillIds.entrySet()) {
                Long sMainTableId = (Long)entry.getKey();
                Long[] sBillIds = ((Set)entry.getValue()).toArray(new Long[((Set)entry.getValue()).size()]);
                List<BFRowId> billRowIds = this.getBillTrackReader().readDownBillBFRowIds(sMainTableId, sBillIds);
                allBillRowIds.addAll(billRowIds);
            }
            tgtBillIds.clear();
            for (BFRowId billRowId : allBillRowIds) {
                if (!this.getEntryTrackReader().addToMap(allLinkBills, billRowId.getTableId(), billRowId.getBillId())) continue;
                this.getEntryTrackReader().addToMap(tgtBillIds, billRowId.getTableId(), billRowId.getBillId());
            }
        }
        LinkedHashMap<String, HashSet<Long>> linkBills = new LinkedHashMap<String, HashSet<Long>>();
        for (Map.Entry item : allLinkBills.entrySet()) {
            HashSet<Long> existBillIds;
            Long mainTableId = (Long)item.getKey();
            TableDefine tableDefine = reader.loadTableDefine(mainTableId);
            if (tableDefine == null || (existBillIds = this.getEntryTrackReader().readExistsBillIds(tableDefine.getEntityNumber(), ((Set)item.getValue()).toArray(new Long[0]))).isEmpty()) continue;
            linkBills.put(tableDefine.getEntityNumber(), existBillIds);
        }
        return linkBills;
    }

    public Map<Long, List<BFRow>> findDirtTargetBills(String srcEntityNumber, Long[] srcBillIds) {
        Long tMainTableId;
        HashMap<Long, List<BFRow>> result = new HashMap<Long, List<BFRow>>(srcBillIds.length);
        HashSet<Long> myBillIds = new HashSet<Long>(10);
        for (Long billId : srcBillIds) {
            myBillIds.add(billId);
        }
        ConvertDataService reader = new ConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(srcEntityNumber, srcEntityNumber);
        Long myMainTableId = mainTableDefine.getTableId();
        List<BFRowId> targetBillRowIds = this.getBillTrackReader().readDownBillBFRowIds(myMainTableId, srcBillIds);
        if (targetBillRowIds.isEmpty()) {
            return result;
        }
        HashMap tgtBillIds = new HashMap();
        for (BFRowId bFRowId : targetBillRowIds) {
            tMainTableId = bFRowId.getMainTableId();
            Long tBillId = bFRowId.getBillId();
            this.getEntryTrackReader().addToMap(tgtBillIds, tMainTableId, tBillId);
        }
        for (Map.Entry entry : tgtBillIds.entrySet()) {
            tMainTableId = (Long)entry.getKey();
            Long[] tBillIds = ((Set)entry.getValue()).toArray(new Long[0]);
            Set<BFRow> linkRows = this.getEntryTrackReader().readUpBillBFRows(tMainTableId, tBillIds);
            for (BFRow linkRow : linkRows) {
                Long srcBillId = linkRow.getSId().getBillId();
                if (Long.compare(myMainTableId, linkRow.getSId().getMainTableId()) != 0 || !myBillIds.contains(srcBillId)) continue;
                if (!result.containsKey(srcBillId)) {
                    result.put(srcBillId, new ArrayList());
                }
                ((List)result.get(srcBillId)).add(linkRow);
            }
        }
        return result;
    }

    public Map<Long, List<BFRow>> findDirtSourceBills(String targetEntityNumber, Long[] targetBillIds) {
        if (StringUtils.isBlank((CharSequence)targetEntityNumber) || targetBillIds == null || targetBillIds.length == 0) {
            return new HashMap<Long, List<BFRow>>(0);
        }
        List<BFRow> myEntryBFRows = this.getEntryTrackReader().readUpEntryBFRows(targetEntityNumber, targetBillIds);
        HashMap<Long, List<BFRow>> result = new HashMap<Long, List<BFRow>>(targetBillIds.length);
        for (BFRow myRow : myEntryBFRows) {
            List bfRows = result.computeIfAbsent(myRow.getId().getBillId(), s -> new ArrayList());
            bfRows.add(myRow);
        }
        return result;
    }

    public boolean isPush(String srcEntityNumber, Long srcBillId) {
        ConvertDataService reader = new ConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(srcEntityNumber, srcEntityNumber);
        Long myMainTableId = mainTableDefine.getTableId();
        List<BFRowId> targetBillRowIds = this.getBillTrackReader().readDownBillBFRowIds(myMainTableId, new Long[]{srcBillId});
        if (targetBillRowIds.isEmpty()) {
            return false;
        }
        HashMap tgtBillIds = new HashMap();
        for (BFRowId bFRowId : targetBillRowIds) {
            this.getEntryTrackReader().addToMap(tgtBillIds, bFRowId.getMainTableId(), bFRowId.getBillId());
        }
        for (Map.Entry entry : tgtBillIds.entrySet()) {
            Long targetMainTableId = (Long)entry.getKey();
            Long[] targetBillIds = ((Set)entry.getValue()).toArray(new Long[((Set)entry.getValue()).size()]);
            Set<BFRow> bfRows = this.getEntryTrackReader().readUpBillBFRows(targetMainTableId, targetBillIds);
            if (bfRows.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean isPush(String srcEntityNumber, String srcEntryKey, Long srcEntryId) {
        boolean isEntry = StringUtils.isNotBlank((CharSequence)srcEntryKey);
        if (isEntry) {
            HashSet<Long> myBillIds = this.getEntryTrackReader().readBillIds(srcEntityNumber, srcEntryKey, new Long[]{srcEntryId});
            if (myBillIds.isEmpty()) {
                return false;
            }
            return this.isPush(srcEntityNumber, srcEntryKey, myBillIds.iterator().next(), srcEntryId);
        }
        return this.isPush(srcEntityNumber, srcEntryId);
    }

    public boolean isPush(String srcEntityNumber, String srcEntryKey, Long srcBillId, Long srcEntryId) {
        ConvertDataService reader = new ConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(srcEntityNumber, srcEntityNumber);
        Long myMainTableId = mainTableDefine.getTableId();
        List<BFRowId> targetBillRowIds = this.getBillTrackReader().readDownBillBFRowIds(myMainTableId, new Long[]{srcBillId});
        if (targetBillRowIds.isEmpty()) {
            return false;
        }
        TableDefine tableDefine = reader.loadTableDefine(srcEntityNumber, srcEntryKey);
        Long myEntryTableId = tableDefine.getTableId();
        HashMap tgtBillIds = new HashMap();
        for (BFRowId bFRowId : targetBillRowIds) {
            this.getEntryTrackReader().addToMap(tgtBillIds, bFRowId.getMainTableId(), bFRowId.getBillId());
        }
        for (Map.Entry entry : tgtBillIds.entrySet()) {
            Long targetMainTableId = (Long)entry.getKey();
            Long[] targetBillIds = ((Set)entry.getValue()).toArray(new Long[((Set)entry.getValue()).size()]);
            Long searchTableId = myEntryTableId;
            Long searchId = srcEntryId;
            boolean existEntryTracker = this.getEntryTrackReader().isExistsEntryTracker(searchTableId, searchId, true, targetMainTableId, targetBillIds);
            if (!existEntryTracker) continue;
            return true;
        }
        return false;
    }
}

