/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.botp;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.ConvertBill;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.ConvertPath;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.lang.Lang;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkService;

@SdkService(name="ConvertDataService")
public class ConvertDataService {
    private static final String FROMBOTPCONVERTRULE = "FROM T_BOTP_ConvertRule t0 ";

    public List<ConvertPath> loadAllConvertPaths() {
        String localeId = Lang.get().toString();
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT t0.FSourceEntityNumber, t1_l.FName AS FSourceEntityName ");
        sBuilder.append("      ,t0.FTargetEntityNumber, t2_l.FName AS FTargetEntityName ");
        sBuilder.append("      ,t0.FBizAppId ");
        sBuilder.append("      ,t1.FBizAppId AS FSourceBizAppId, t2.FBizAppId AS FTargetBizAppId ");
        sBuilder.append(FROMBOTPCONVERTRULE);
        sBuilder.append("LEFT JOIN T_META_EntityDesign t1 ON (t0.FSourceEntityNumber = t1.FNumber) ");
        sBuilder.append("LEFT JOIN T_META_EntityDesign t2 ON (t0.FTargetEntityNumber = t2.FNumber) ");
        sBuilder.append("LEFT JOIN T_META_EntityDesign_L t1_l ON (t0.FSourceEntityNumber = t1_l.FNumber and t1_l.FLocaleId = '").append(localeId).append("') ");
        sBuilder.append("LEFT JOIN T_META_EntityDesign_L t2_l ON (t0.FTargetEntityNumber = t2_l.FNumber and t2_l.FLocaleId = '").append(localeId).append("') ");
        sBuilder.append("WHERE t0.FType <> '2'");
        ResultSetHandler<Set<ConvertPath>> action = new ResultSetHandler<Set<ConvertPath>>(){

            public Set<ConvertPath> handle(ResultSet rs) throws SQLException {
                HashSet<ConvertPath> paths = new HashSet<ConvertPath>(16);
                while (rs.next()) {
                    ConvertPath path = new ConvertPath();
                    path.setSourceEntityNumber(rs.getString("FSourceEntityNumber"));
                    path.setSourceEntityName(rs.getString("FSourceEntityName"));
                    path.setTargetEntityNumber(rs.getString("FTargetEntityNumber"));
                    path.setTargetEntityName(rs.getString("FTargetEntityName"));
                    path.setBizAppId(rs.getString("FBizAppId"));
                    path.setSourceBizAppId(rs.getString("FSourceBizAppId"));
                    path.setTargetBizAppId(rs.getString("FTargetBizAppId"));
                    paths.add(path);
                }
                return paths;
            }
        };
        Set convertPaths = (Set)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), null, (ResultSetHandler)action);
        return new ArrayList<ConvertPath>(convertPaths);
    }

    public List<ConvertBill> loadConvertBills(String entityNumber, ConvertOpType opType) {
        String localeId = Lang.get().toString();
        Object[] parameters = new SqlParameter[1];
        StringBuilder sBuilder = new StringBuilder();
        switch (opType) {
            case Draw: 
            case SpecDraw: 
            case BeforeDraw: {
                sBuilder.append("SELECT t0.FSourceEntityNumber AS FEntityNumber, t1_l.FName AS FEntityName ");
                sBuilder.append(FROMBOTPCONVERTRULE);
                sBuilder.append("LEFT JOIN T_META_MAINENTITYINFO_L t1_l ON (t0.FSourceEntityNumber = t1_l.FID and t1_l.FLocaleId = '").append(localeId).append("') ");
                sBuilder.append("WHERE t0.FTargetEntityNumber =  ? ");
                sBuilder.append("and t0.FType <> '2'");
                sBuilder.append("GROUP BY t0.FSourceEntityNumber, t1_l.FName ");
                parameters[0] = new SqlParameter(":FTargetEntityNumber", 12, (Object)entityNumber);
                break;
            }
            default: {
                sBuilder.append("SELECT t0.FTargetEntityNumber AS FEntityNumber, t2_l.FName AS FEntityName ");
                sBuilder.append(FROMBOTPCONVERTRULE);
                sBuilder.append("LEFT JOIN T_META_MAINENTITYINFO_L t2_l ON (t0.FTargetEntityNumber = t2_l.FId and t2_l.FLocaleId = '").append(localeId).append("') ");
                sBuilder.append("WHERE FSourceEntityNumber = ? ");
                sBuilder.append("and t0.FType <> '2'");
                sBuilder.append("GROUP BY t0.FTargetEntityNumber, t2_l.FName ");
                parameters[0] = new SqlParameter(":FSourceEntityNumber", 12, (Object)entityNumber);
            }
        }
        ResultSetHandler<List<ConvertBill>> action = new ResultSetHandler<List<ConvertBill>>(){

            public List<ConvertBill> handle(ResultSet rs) throws SQLException {
                ArrayList<ConvertBill> bills = new ArrayList<ConvertBill>(16);
                while (rs.next()) {
                    ConvertBill bill = new ConvertBill();
                    String number = rs.getString("FEntityNumber");
                    String name = rs.getString("FEntityName");
                    if (StringUtils.isBlank((CharSequence)name)) {
                        name = number;
                    }
                    bill.setEntityNumber(number);
                    bill.setEntityName(name);
                    bills.add(bill);
                }
                return bills;
            }
        };
        List convertBills = (List)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])parameters, (ResultSetHandler)action);
        return convertBills;
    }

    public List<ConvertBill> loadThirdConvertBills(final String sourceEntityNumber, String targetEntityNumber) {
        String localeId = Lang.get().toString();
        Object[] parameters = new SqlParameter[2];
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT t0.FTargetEntityNumber AS FEntityNumber, t2_l.FName AS FEntityName ");
        sBuilder.append(FROMBOTPCONVERTRULE);
        sBuilder.append("LEFT JOIN T_META_MAINENTITYINFO_L t2_l ON (t0.FTargetEntityNumber = t2_l.FId and t2_l.FLocaleId = '").append(localeId).append("') ");
        sBuilder.append("WHERE t0.FTargetEntityNumber =  ? ");
        sBuilder.append("and t0.FSourceEntityNumber = ? ");
        sBuilder.append("and t0.FType <> '2'");
        sBuilder.append("GROUP BY t0.FTargetEntityNumber, t2_l.FName ");
        parameters[0] = new SqlParameter(":FTargetEntityNumber", 12, (Object)targetEntityNumber);
        parameters[1] = new SqlParameter(":FSourceEntityNumber", 12, (Object)sourceEntityNumber);
        ResultSetHandler<List<ConvertBill>> action = new ResultSetHandler<List<ConvertBill>>(){

            public List<ConvertBill> handle(ResultSet rs) throws SQLException {
                ArrayList<ConvertBill> bills = new ArrayList<ConvertBill>(16);
                while (rs.next()) {
                    ConvertBill bill = new ConvertBill();
                    String number = rs.getString("FEntityNumber");
                    String name = rs.getString("FEntityName");
                    if (StringUtils.isBlank((CharSequence)name)) {
                        name = number;
                    }
                    bill.setEntityNumber(number);
                    bill.setEntityName(name);
                    bill.setSourceEntityNumber(sourceEntityNumber);
                    bill.setThirdPush(Boolean.TRUE);
                    bills.add(bill);
                }
                return bills;
            }
        };
        List convertBills = (List)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])parameters, (ResultSetHandler)action);
        return convertBills;
    }

    public TableDefine loadTableDefine(String entityNumber, String entityKey) {
        return EntityMetadataCache.loadTableDefine((String)entityNumber, (String)entityKey);
    }

    public TableDefine loadTableDefine(Long tableId) {
        return EntityMetadataCache.loadTableDefine((Long)tableId);
    }

    @Deprecated
    @SdkInternal
    public List<String> loadConvertRuleIdsAppId(String appId) {
        return this.loadConvertRuleIdsByAppId(appId);
    }

    public List<String> loadConvertRuleIdsByAppId(String appId) {
        String sql = "SELECT FID FROM T_BOTP_ConvertRule where fbizappid = ?";
        Object[] parameters = new SqlParameter[]{new SqlParameter(":fbizappid", 12, (Object)appId)};
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> paths = new ArrayList<String>(16);
                while (rs.next()) {
                    paths.add(rs.getString("FID"));
                }
                return paths;
            }
        };
        List convertPaths = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])parameters, (ResultSetHandler)action);
        return convertPaths;
    }
}

