/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.botp.linkquery;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.linkquery.LinkTrackerPo;
import kd.bos.entity.botp.linkquery.QueryTrackerLinkArgs;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.xdb.hint.ShardingHintContext;

public class LinkTrackerDataQueryService {
    private static String COMMA_CODE = ",";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> loadLinkTrackerMap(QueryTrackerLinkArgs args) {
        ShardingHintContext ctx;
        if (args.getSourceBillIds().size() == 0 && args.getTargetBillIds().size() == 0) {
            return new HashMap<String, String>(16);
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)args.getTargetNumber());
        ResultSetHandler<Map<String, String>> action = new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws SQLException {
                HashMap<String, String> map = new HashMap<String, String>(16);
                while (rs.next()) {
                    map.put(rs.getString("fsbillid") + "," + rs.getString("ftbillid"), rs.getString("fid"));
                    map.put("," + rs.getString("ftbillid"), rs.getString("fid"));
                    map.put(rs.getString("fsbillid") + ",", rs.getString("fid"));
                }
                return map;
            }
        };
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("select fid,fsbillid,ftbillid ");
        sBuilder.append("FROM t_botp_billtracker");
        sBuilder.append(" where 1 = 1 ");
        if (args.getSourceBillIds() != null && args.getSourceBillIds().size() > 0 && args.getTargetBillIds() != null && args.getTargetBillIds().size() > 0) {
            sBuilder.append(" and fsbillid in(").append(String.join((CharSequence)COMMA_CODE, args.getSourceBillIds())).append(") ");
            sBuilder.append(" or ftbillid in(").append(String.join((CharSequence)COMMA_CODE, args.getTargetBillIds())).append(") ");
        } else if (args.getSourceBillIds() != null && args.getSourceBillIds().size() > 0) {
            sBuilder.append("and fsbillid in(").append(String.join((CharSequence)COMMA_CODE, args.getSourceBillIds())).append(") ");
        } else {
            sBuilder.append("and ftbillid in(").append(String.join((CharSequence)COMMA_CODE, args.getTargetBillIds())).append(") ");
        }
        sBuilder.append("order by fcreatetime desc ");
        ArrayList targetBillIds = args.getTargetBillIds();
        if (targetBillIds == null) {
            targetBillIds = new ArrayList(16);
        }
        if (args.getSourceBillIds() != null && args.getSourceBillIds().size() > 0) {
            targetBillIds.addAll(args.getSourceBillIds());
        }
        if ((ctx = ShardingHinter.tryHint((IDataEntityType)targetMainType, (Object[])targetBillIds.toArray())) != null) {
            try {
                ctx.set();
                Map map = (Map)DB.query((DBRoute)DBRoute.base, (String)sBuilder.toString(), (ResultSetHandler)action);
                return map;
            }
            finally {
                ctx.close();
            }
        }
        return (Map)DB.query((DBRoute)DBRoute.base, (String)sBuilder.toString(), (ResultSetHandler)action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LinkTrackerPo> loadLinkTracker(QueryTrackerLinkArgs args) {
        ShardingHintContext ctx;
        if (args.getSourceBillIds().size() == 0 && args.getTargetBillIds().size() == 0) {
            return new ArrayList<LinkTrackerPo>(16);
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)args.getTargetNumber());
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("select fid,fstableid,fsbillid,fttableid,ftbillid,fcreatetime ");
        sBuilder.append("FROM t_botp_billtracker");
        sBuilder.append(" where 1 = 1 ");
        if (args.getSourceBillIds() != null && args.getSourceBillIds().size() > 0 && args.getTargetBillIds() != null && args.getTargetBillIds().size() > 0) {
            sBuilder.append(" and fsbillid in(").append(String.join((CharSequence)COMMA_CODE, args.getSourceBillIds())).append(") ");
            if (args.getSourceBillIds().size() == args.getTargetBillIds().size()) {
                sBuilder.append(" and ftbillid in(").append(String.join((CharSequence)COMMA_CODE, args.getTargetBillIds())).append(") ");
            } else {
                sBuilder.append(" or ftbillid in(").append(String.join((CharSequence)COMMA_CODE, args.getTargetBillIds())).append(") ");
            }
        } else if (args.getSourceBillIds() != null && args.getSourceBillIds().size() > 0) {
            sBuilder.append("and fsbillid in(").append(String.join((CharSequence)COMMA_CODE, args.getSourceBillIds())).append(") ");
        } else {
            sBuilder.append("and ftbillid in(").append(String.join((CharSequence)COMMA_CODE, args.getTargetBillIds())).append(") ");
        }
        sBuilder.append("order by fcreatetime desc ");
        ArrayList targetBillIds = args.getTargetBillIds();
        if (args.getTargetBillIds() == null) {
            targetBillIds = new ArrayList(16);
        }
        if (args.getSourceBillIds() != null) {
            targetBillIds.addAll(args.getSourceBillIds());
        }
        if ((ctx = ShardingHinter.tryHint((IDataEntityType)targetMainType, (Object[])targetBillIds.toArray())) != null) {
            try {
                ctx.set();
                List list = (List)DB.query((DBRoute)DBRoute.base, (String)sBuilder.toString(), this.getAction());
                return list;
            }
            finally {
                ctx.close();
            }
        }
        return (List)DB.query((DBRoute)DBRoute.base, (String)sBuilder.toString(), this.getAction());
    }

    public List<LinkTrackerPo> loadLinkTracker(List<String> fids) {
        if (fids == null || fids.size() == 0) {
            return new ArrayList<LinkTrackerPo>(16);
        }
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("select fid,fstableid,fsbillid,fttableid,ftbillid,fcreatetime ");
        sBuilder.append("FROM t_botp_billtracker ");
        sBuilder.append("where fid in(").append(String.join((CharSequence)COMMA_CODE, fids)).append(") ");
        sBuilder.append("order by fcreatetime desc ");
        return (List)DB.query((DBRoute)DBRoute.base, (String)sBuilder.toString(), this.getAction());
    }

    private ResultSetHandler<List<LinkTrackerPo>> getAction() {
        ResultSetHandler<List<LinkTrackerPo>> action = new ResultSetHandler<List<LinkTrackerPo>>(){

            public List<LinkTrackerPo> handle(ResultSet rs) throws SQLException {
                ArrayList<LinkTrackerPo> queryLinkTcs = new ArrayList<LinkTrackerPo>(16);
                while (rs.next()) {
                    LinkTrackerPo linkTrackerPo = new LinkTrackerPo();
                    linkTrackerPo.setFid(rs.getString("fid"));
                    linkTrackerPo.setFstableid(rs.getString("fstableid"));
                    linkTrackerPo.setFsbillid(rs.getString("fsbillid"));
                    linkTrackerPo.setFttableid(rs.getString("fttableid"));
                    linkTrackerPo.setFtbillid(rs.getString("ftbillid"));
                    linkTrackerPo.setFcreatetime((Date)rs.getTimestamp("fcreatetime"));
                    queryLinkTcs.add(linkTrackerPo);
                }
                return queryLinkTcs;
            }
        };
        return action;
    }
}

