/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.attachment.manage;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.attachment.manage.AttachIdentify;
import kd.bos.attachment.manage.AttachInfo;
import kd.bos.attachment.manage.AttachStatus;
import kd.bos.attachment.manage.IAttachManageService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.attachment.FileSource;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.codec.digest.DigestUtils;

public class AttachManageService
implements IAttachManageService {
    private static final String ENTITY_NAME = "bos_svc_attachment";
    protected Log log = LogFactory.getLog(this.getClass());

    public String saveAttach(AttachInfo attachInfo) {
        List<String> attachNoList = this.saveAttach(Collections.singletonList(attachInfo));
        return attachNoList.get(0);
    }

    @Override
    public List<String> saveAttach(List<AttachInfo> attachList) {
        ArrayList<String> attachNoList = new ArrayList<String>(attachList.size());
        ArrayList<DynamicObject> attachDyList = new ArrayList<DynamicObject>(attachList.size());
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)ENTITY_NAME);
        for (AttachInfo attachInfo : attachList) {
            String bizAppId;
            Long orgId;
            String attachNum;
            Long attachId;
            String attachName = attachInfo.getName();
            String fileExt = attachInfo.getExt();
            if (StringUtils.isBlank((CharSequence)fileExt)) {
                fileExt = attachName.substring(attachName.lastIndexOf(".") + 1);
                attachInfo.setExt(fileExt);
            }
            if ((attachId = attachInfo.getId()) == null) {
                attachId = ID.genLongId();
                attachInfo.setId(attachId);
            }
            if ((attachNum = attachInfo.getNumber()) == null) {
                attachNum = this.genAttachNum(attachId);
                attachInfo.setNumber(attachNum);
            }
            attachNoList.add(attachNum);
            Long creatorId = attachInfo.getCreatorid();
            if (creatorId == null) {
                creatorId = RequestContext.get().getCurrUserId();
            }
            if ((orgId = attachInfo.getOrgId()) == null) {
                orgId = RequestContext.get().getOrgId();
            }
            if (StringUtils.isEmpty((CharSequence)(bizAppId = attachInfo.getBizAppId()))) {
                bizAppId = " ";
            }
            long attachSize = attachInfo.getSize();
            DynamicObject dyObj = new DynamicObject((DynamicObjectType)dataEntityType);
            dyObj.set("id", (Object)attachId);
            dyObj.set("number", (Object)attachNum);
            dyObj.set("name", (Object)attachName);
            dyObj.set("size", (Object)attachSize);
            dyObj.set("source", (Object)attachInfo.getSource());
            dyObj.set("identify", (Object)attachInfo.getIdentify());
            dyObj.set("path", (Object)attachInfo.getPath());
            dyObj.set("ext", (Object)fileExt);
            dyObj.set("creator", (Object)creatorId);
            dyObj.set("createtime", (Object)new Date());
            dyObj.set("org", (Object)orgId);
            dyObj.set("bizappid", (Object)bizAppId);
            dyObj.set("enable", (Object)Character.valueOf(AttachStatus.USABLE.getCode()));
            dyObj.set("status", (Object)"C");
            dyObj.set("disktype", (Object)this.getDiskType());
            attachDyList.add(dyObj);
        }
        try (TXHandle h = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])attachDyList.toArray(new DynamicObject[0]));
        }
        return attachNoList;
    }

    @Override
    public String getAttachPath(String attachOriNo) {
        if (StringUtils.isBlank((CharSequence)attachOriNo) || this.isFilePath(attachOriNo)) {
            return attachOriNo;
        }
        String attachNo = this.handlePath(attachOriNo);
        AttachInfo attachInfo = this.getAttachInfo(attachNo);
        if (attachInfo != null) {
            return attachInfo.getPath();
        }
        String attachPath = this.getPathFromPathMapping(attachNo, true);
        if (StringUtils.isBlank((CharSequence)attachPath)) {
            return attachOriNo;
        }
        return attachPath;
    }

    public String queryIdentifyWithSave(AttachInfo attachInfo, String queryPath) {
        String realPath;
        String attachNo = this.handlePath(queryPath);
        QFilter qFilter = new QFilter("number", "=", (Object)attachNo);
        qFilter.or(new QFilter("path", "=", (Object)queryPath));
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_NAME, (QFilter[])qFilters);
        if (dynamicObject != null) {
            String identify = dynamicObject.getString("identify");
            if (StringUtils.isBlank((CharSequence)identify)) {
                try (TXHandle h = TX.requiresNew();){
                    String path = dynamicObject.getString("path");
                    dynamicObject.set("identify", (Object)this.computeDigest(path));
                    SaveServiceHelper.update((DynamicObject)dynamicObject);
                }
                catch (Exception e) {
                    this.log.error("\u8ba1\u7b97\u6587\u4ef6\u6458\u8981\u5931\u8d25\uff1a", (Throwable)e);
                    return null;
                }
            }
            return dynamicObject.getString("identify");
        }
        if (this.isFilePath(queryPath)) {
            realPath = queryPath;
            attachInfo.setPath(queryPath);
        } else {
            attachInfo.setNumber(attachNo);
            realPath = this.getPathFromPathMapping(attachNo, false);
            attachInfo.setPath(realPath);
        }
        try {
            String identify = this.computeDigest(realPath);
            attachInfo.setIdentify(identify);
            this.saveAttach(attachInfo);
        }
        catch (Exception e) {
            this.log.error("\u8ba1\u7b97\u6587\u4ef6\u6458\u8981\u5931\u8d25\uff1a", (Throwable)e);
            return null;
        }
        return attachInfo.getIdentify();
    }

    @Override
    public AttachIdentify removeAttach(String fileNo) {
        int attachNum = 1;
        String attachNo = this.handlePath(fileNo);
        AttachIdentify res = new AttachIdentify();
        res.setCount(attachNum);
        res.setPath(attachNo);
        QFilter qFilter = this.isFilePath(attachNo) ? new QFilter("path", "=", (Object)attachNo) : new QFilter("number", "=", (Object)attachNo);
        QFilter[] qFilters = new QFilter[]{qFilter};
        AttachInfo attachInfo = this.getAttachInfo(qFilters);
        if (attachInfo == null) {
            return res;
        }
        res.setPath(attachInfo.getPath());
        String identify = attachInfo.getIdentify();
        if (StringUtils.isNotBlank((CharSequence)identify)) {
            attachNum = this.getAttachRefCount(identify, attachInfo.getPath());
            res.setCount(attachNum);
        }
        try (TXHandle h = TX.requiresNew();){
            DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{qFilter});
        }
        return res;
    }

    protected String getPathFromPathMapping(String attachNo, boolean withSave) {
        Object[] params = new SqlParameter[1];
        String sql = "select ffileid,fpath from t_bas_filepathmapping where ffileid=?";
        params[0] = new SqlParameter("ffileid", 12, (Object)attachNo);
        String attachPath = (String)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, rs -> {
            String path = null;
            while (rs.next()) {
                path = rs.getString("fpath");
            }
            return path;
        });
        if (StringUtils.isNotBlank((CharSequence)attachPath) && withSave) {
            AttachInfo attachInfo = new AttachInfo();
            attachInfo.setNumber(attachNo);
            attachInfo.setPath(attachPath);
            String fileName = attachPath.substring(attachPath.lastIndexOf("/") + 1);
            attachInfo.setPath(attachPath);
            attachInfo.setName(fileName);
            attachInfo.setIdentify(" ");
            attachInfo.setSource(FileSource.Unknown.getCode());
            this.saveAttach(attachInfo);
        }
        return attachPath;
    }

    private String computeDigest(String path) throws IOException {
        InputStream inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(path);
        String md5 = DigestUtils.md5Hex((InputStream)inputStream);
        return md5;
    }

    @Override
    public AttachInfo getAttachInfo(String attachNo) {
        QFilter[] qFilters = this.isFilePath(attachNo) ? new QFilter[]{new QFilter("path", "=", (Object)attachNo)} : new QFilter[]{new QFilter("number", "=", (Object)attachNo)};
        return this.getAttachInfo(qFilters);
    }

    private AttachInfo getAttachInfo(QFilter[] qFilters) {
        DynamicObject attachDyobj = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_NAME, (String)"id,number,name,size,identify,source,path,disktype", (QFilter[])qFilters);
        if (attachDyobj == null) {
            return null;
        }
        AttachInfo attachInfo = new AttachInfo();
        attachInfo.setId(attachDyobj.getLong("id"));
        attachInfo.setNumber(attachDyobj.getString("number"));
        attachInfo.setName(attachDyobj.getString("name"));
        attachInfo.setSize(attachDyobj.getInt("size"));
        attachInfo.setIdentify(attachDyobj.getString("identify"));
        attachInfo.setSource(attachDyobj.getString("source"));
        attachInfo.setPath(attachDyobj.getString("path"));
        attachInfo.setDiskType(attachDyobj.getString("disktype"));
        return attachInfo;
    }

    private int getAttachRefCount(String identify, String path) {
        String sql = "select fid,fnumber,fname,fsize,fidentify count from t_svc_attachment where fnumber = ? and fpath=?";
        Object[] params = new SqlParameter[]{new SqlParameter("fidentify", 12, (Object)identify), new SqlParameter("fpath", 12, (Object)path)};
        return (Integer)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, rs -> {
            int count = 0;
            while (rs.next()) {
                count = rs.getInt("count");
            }
            return count;
        });
    }

    protected String handlePath(String attachNo) {
        if (StringUtils.isBlank((CharSequence)attachNo)) {
            return attachNo;
        }
        if (this.isFilePath(attachNo)) {
            return attachNo;
        }
        try {
            attachNo = URLDecoder.decode(attachNo, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.log.error((Throwable)e);
        }
        int lastIndex = attachNo.lastIndexOf(47);
        if (lastIndex > -1 && attachNo.length() > lastIndex + 1) {
            attachNo = attachNo.substring(lastIndex + 1);
        }
        return attachNo;
    }

    public boolean isFilePath(String attachNo) {
        return attachNo.contains(".") || attachNo.contains("&") || attachNo.contains("=");
    }

    protected String getDiskType() {
        return "0";
    }

    private String genAttachNum(Long attachId) {
        String attachNum = Long.toHexString(attachId);
        return attachNum;
    }
}

