/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.attachment.manage;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import kd.bos.attachment.manage.AttachInfo;
import kd.bos.attachment.manage.AttachManageService;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.service.attachment.FileSource;

public class ImageManageService
extends AttachManageService {
    public String getThumbnailPathByOri(String pathOrId) {
        if (StringUtils.isBlank((CharSequence)pathOrId) || this.isFilePath(pathOrId)) {
            return pathOrId;
        }
        if (!pathOrId.contains("_thumbnails_")) {
            return pathOrId;
        }
        int index = pathOrId.indexOf("_thumbnails_");
        String uuidPath = pathOrId.substring(0, index);
        String suffix = pathOrId.substring(index);
        String realPath = this.getAttachPath(uuidPath = uuidPath.replace("/", ""));
        if (this.isFilePath(realPath) && StringUtils.isNotBlank((CharSequence)realPath)) {
            realPath = realPath.substring(0, realPath.lastIndexOf("."));
            return realPath + suffix;
        }
        return pathOrId;
    }

    @Override
    protected String handlePath(String attachNo) {
        if (StringUtils.isBlank((CharSequence)attachNo) || this.isFilePath(attachNo)) {
            return attachNo;
        }
        String filedId = attachNo;
        try {
            filedId = URLDecoder.decode(attachNo, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.log.error((Throwable)e);
        }
        int lastIndex = filedId.lastIndexOf("/");
        if (lastIndex > -1 && filedId.length() > lastIndex + 1) {
            filedId = attachNo.substring(lastIndex + 1);
        }
        if (filedId.contains(".")) {
            filedId = filedId.substring(0, filedId.indexOf("."));
        }
        return filedId;
    }

    @Override
    protected String getPathFromPathMapping(String attachNo, boolean withSave) {
        Object[] params = new SqlParameter[1];
        String sql = "select ffileid,fpath from t_bas_imagefilepathmapping where ffileid=?";
        params[0] = new SqlParameter("ffileid", 12, (Object)attachNo);
        String attachPath = (String)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, rs -> {
            String path = null;
            if (rs.next()) {
                path = rs.getString("fpath");
            }
            return path;
        });
        if (StringUtils.isNotBlank((CharSequence)attachPath) && withSave) {
            AttachInfo attachInfo = new AttachInfo();
            attachInfo.setNumber(attachNo);
            attachInfo.setPath(attachPath);
            String fileName = attachPath.substring(attachPath.lastIndexOf("/") + 1);
            attachInfo.setPath(attachPath);
            attachInfo.setName(fileName);
            attachInfo.setIdentify(" ");
            attachInfo.setSource(FileSource.Unknown.getCode());
            this.saveAttach(attachInfo);
        }
        return attachPath;
    }

    @Override
    protected String getDiskType() {
        return "1";
    }

    @Override
    public boolean isFilePath(String path) {
        String resultPath = path;
        while (resultPath.startsWith("/")) {
            resultPath = resultPath.replaceFirst("/", "");
        }
        return resultPath.contains("/");
    }
}

