/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.attachment.common;

import com.google.common.primitives.Ints;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.param.CustomParam;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.attachment.util.ParamUtil;
import kd.bos.form.control.UrlUtil;
import kd.bos.form.control.events.BeforeAttachmentUploadEvent;
import kd.bos.form.control.events.BeforeAttachmentUploadListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.web.actions.utils.FilePremissionUtil;
import org.apache.commons.io.IOUtils;

public class AttachmentKit {
    private static DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));
    private static DistributeSessionlessCache fileInfoRedisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("FILEINFO", new DistributeCacheHAPolicy(true, true));
    private static final String ATT_UID = "uid";
    private static final String ATT_STATUS = "status";
    private static final String ATT_SUCCESS = "success";
    private static final String ATT_URL = "url";
    private static final String ENTITY_NUM = "entityNum";
    private static final String BILL_PK_ID = "billPkId";
    private static final String BOS_SVC_METADATA = "bos-svc-metadata";
    private static final String ATT_ENTRYGRID_UPLOADVIEW_FORMID = "bos_entryattach_upload";
    private static final String ATT_FIELD_MOB = "bos_mobtb_attfield_upload";
    private static final String LOG_APPID = "logAppId";
    private static final String LOG_ENTITY_NUM = "logEntityNum";
    private static Log log = LogFactory.getLog(AttachmentKit.class);

    @Deprecated
    public static void fireBeforeUpload(String key, BeforeAttachmentUploadEvent evt, List<BeforeAttachmentUploadListener> beforeUploadListeners, IClientViewProxy clientViewProxy) {
        for (BeforeAttachmentUploadListener l : beforeUploadListeners) {
            l.beforeAttachmentUpload(evt);
        }
        ArrayList<String> cancelList = new ArrayList<String>();
        if (!evt.isCancel()) {
            return;
        }
        List<Map<String, Object>> sourceAttachments = evt.getSourceAttachments();
        List<Map<String, Object>> cancelAttachments = evt.getCancelAttachments();
        for (Map<String, Object> cancelAttachment : cancelAttachments) {
            for (Map<String, Object> sourceAttachment : sourceAttachments) {
                Object sourceUid = sourceAttachment.get(ATT_UID);
                if (!(sourceUid instanceof String) || !sourceUid.equals(cancelAttachment.get(ATT_UID))) continue;
                cancelList.add((String)sourceUid);
            }
        }
        clientViewProxy.invokeControlMethod(key, "cancelUploadAttachment", new Object[]{cancelList});
    }

    public static void fireBeforeUpload(String key, BeforeAttachmentUploadEvent evt, List<BeforeAttachmentUploadListener> beforeUploadListeners, IClientViewProxy clientViewProxy, IFormView view) {
        AttachmentKit.fireBeforeUpload(key, evt, beforeUploadListeners, clientViewProxy);
        if (!evt.isCancel()) {
            return;
        }
        String cancelMsg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u5141\u8bb8\u4e0a\u4f20\u8be5\u6587\u4ef6\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"AttachmentPanel_1", (String)BOS_SVC_METADATA, (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)evt.getMsg())) {
            cancelMsg = evt.getMsg();
        }
        view.showTipNotification(cancelMsg, Integer.valueOf(3000));
    }

    public static void cacheTempFileParam(Map<String, Object> attach, IFormView view) {
        if (ATT_SUCCESS.equals(attach.get(ATT_STATUS)) && attach.get(ATT_URL).toString().contains("tempfile/download.do?configKey")) {
            String url = (String)attach.get(ATT_URL);
            String tempFileId = UrlUtil.getParam((String)url, (String)"id");
            HashMap<String, Object> refEntitiyMap = new HashMap<String, Object>(2);
            refEntitiyMap.put(ENTITY_NUM, attach.get(ENTITY_NUM).toString());
            refEntitiyMap.put("appId", view.getFormShowParameter().getServiceAppId());
            refEntitiyMap.put(BILL_PK_ID, AttachmentKit.getPermissionBillPkId(view));
            redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), 7200);
            fileInfoRedisCache.put("FileInfo:" + tempFileId, (Object)SerializationUtils.toJsonString(attach), 7200);
        }
    }

    @Deprecated
    public static String getPermissionAppId(IFormView view) {
        String appId;
        String entityNum = view.getModel().getDataEntity().getDataEntityType().getName();
        if (ATT_ENTRYGRID_UPLOADVIEW_FORMID.equals(entityNum) || ATT_FIELD_MOB.equals(entityNum)) {
            FormShowParameter formShowParameter = view.getFormShowParameter();
            appId = (String)formShowParameter.getCustomParam(LOG_APPID);
        } else {
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)entityNum);
            appId = formConfig.getAppId();
            if ("bos".equals(appId)) {
                appId = MetadataDao.getAppNumberByEntityNumber((String)entityNum);
            }
            if (StringUtils.isNotBlank((CharSequence)appId)) {
                appId = appId.substring(appId.lastIndexOf(".") + 1);
            }
        }
        return appId;
    }

    public static String getPermissionEntityNum(IFormView view) {
        String entityNum = view.getModel().getDataEntity().getDataEntityType().getName();
        if (ATT_ENTRYGRID_UPLOADVIEW_FORMID.equals(entityNum) || ATT_FIELD_MOB.equals(entityNum)) {
            FormShowParameter formShowParameter = view.getFormShowParameter();
            entityNum = (String)formShowParameter.getCustomParam(LOG_ENTITY_NUM);
        }
        return entityNum;
    }

    public static Object getPermissionBillPkId(IFormView view) {
        Object billPkId = view.getModel().getDataEntity().getPkValue();
        String entityNum = view.getModel().getDataEntity().getDataEntityType().getName();
        if (ATT_ENTRYGRID_UPLOADVIEW_FORMID.equals(entityNum) || ATT_FIELD_MOB.equals(entityNum)) {
            FormShowParameter formShowParameter = view.getFormShowParameter();
            billPkId = formShowParameter.getCustomParam("billPkIdForPermission");
        }
        if (!view.getModel().getDataEntity().getDataEntityState().getFromDatabase()) {
            billPkId = 0L;
        }
        return billPkId;
    }

    public static void permissionQuery(String key, Map<String, Object> args, IFormView view, IClientViewProxy clientViewProxy) {
        String permissionType = (String)args.get("permissionType");
        String entityNum = AttachmentKit.getPermissionEntityNum(view);
        Object billPkId = view.getModel().getDataEntity().getPkValue();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(ATT_UID, args.get(ATT_UID));
        if (permissionType.equals("preview")) {
            boolean hasPermission = FilePremissionUtil.hasAttachmentOpPermission(null, (String)entityNum, (Object)billPkId, (String)"2NJ5VA7D2ONF", (IFormView)view, (boolean)false);
            result.put("previewPermission", hasPermission);
            clientViewProxy.invokeControlMethod(key, "setAttachmentPermission", new Object[]{result});
        } else {
            boolean hasPermission = FilePremissionUtil.hasAttachmentOpPermission(null, (String)entityNum, (Object)billPkId, (String)"2NJ5XVVCMBCL", (IFormView)view, (boolean)false);
            result.put("downloadPermission", hasPermission);
            clientViewProxy.invokeControlMethod(key, "setAttachmentPermission", new Object[]{result});
        }
    }

    public static Map<String, Object> getAttachmentSysParams() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        AttachmentKit.genEnableNoPermBtnHide(result);
        AttachmentKit.genPreviewLimitSize(result);
        AttachmentKit.genPreviewNewTabForMob(result);
        return result;
    }

    public static void genPreviewNewTabForMob(Map<String, Object> result) {
        Map customParameterFromCache = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam());
        boolean modnewTabParam = Boolean.parseBoolean((String)customParameterFromCache.get("MOB_PREVIEW_NEW_TAB"));
        result.put("mobPreviewNewTab", modnewTabParam);
    }

    private static void genEnableNoPermBtnHide(Map<String, Object> result) {
        AppParam appParam = new AppParam();
        appParam.setAppId("83bfebc8000037ac");
        appParam.setViewType("15");
        appParam.setOrgId(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
        appParam.setActBookId(Long.valueOf(0L));
        Object isEnable = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"enable_nopermbtnhide");
        boolean enableNoPermBtnHide = Boolean.parseBoolean(String.valueOf(isEnable));
        result.put("enableNoPermBtnHide", enableNoPermBtnHide);
    }

    private static void genPreviewLimitSize(Map<String, Object> result) {
        String limitMaxSize;
        String limitSize = System.getProperty("preview.size.limit", "52428800");
        if (!StringUtils.isNumeric((CharSequence)limitSize) || "0".equals(limitSize)) {
            limitSize = "52428800";
        }
        if (!StringUtils.isNumeric((CharSequence)(limitMaxSize = System.getProperty("preview.size.limit.max", "1048576000"))) || "0".equals(limitMaxSize)) {
            limitMaxSize = "1048576000";
        }
        Long previewLimitSize = Math.min(Long.parseLong(limitSize), Long.parseLong(limitMaxSize));
        result.put("previewLimitSize", previewLimitSize);
    }

    public static HashMap<String, Object> getAttExtPreviewSysParams() {
        Object customExt;
        Map param;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<String> customExtList = new ArrayList<String>();
        String previewType = ParamUtil.getPreviewType();
        resultMap.put("previewType", previewType);
        if ("5".equals(previewType) && StringUtils.isNotBlank((Object)(param = ParamUtil.getCustomParam())) && null != (customExt = param.get("customPreviewType")) && StringUtils.isNotEmpty((CharSequence)customExt.toString())) {
            customExtList.addAll(Arrays.asList(customExt.toString().trim().split(",")));
            resultMap.put("customExtList", customExtList);
        }
        return resultMap;
    }

    public static boolean isCustomExtExist(boolean checkResult, String curName) {
        HashMap<String, Object> attExtPreviewSysParams = AttachmentKit.getAttExtPreviewSysParams();
        String previewType = String.valueOf(attExtPreviewSysParams.get("previewType"));
        List customExt = (List)attExtPreviewSysParams.get("customExtList");
        if (null != customExt && "5".equals(previewType)) {
            checkResult = AttachmentKit.isExtExist(curName, customExt);
        }
        return checkResult;
    }

    private static boolean isExtExist(String targetExt, List<String> customExtList) {
        for (String customExt : customExtList) {
            if (!customExt.equalsIgnoreCase(targetExt)) continue;
            return true;
        }
        return false;
    }

    public static FormShowParameter getFormParameterForNewTab(Object attachmentData, int activedIndex, boolean hasPermission) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
        showParameter.setFormId("attachment_preview_newtab");
        showParameter.setCustomParam("attachmentData", attachmentData);
        showParameter.setCustomParam("activedIndex", (Object)activedIndex);
        showParameter.setCustomParam("download", (Object)hasPermission);
        return showParameter;
    }

    public static Map<String, Object> ablePreViewParam(String type, Object size) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", type);
        map.put("size", size);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getInputStreamByUrl(String strUrl, boolean trustSSL) {
        HttpURLConnection conn = null;
        InputStream in = null;
        try {
            if (trustSSL || "true".equals(System.getProperty("https.ignore.ssl", "false"))) {
                AttachmentKit.trustAllHttpsCertificates();
                HttpsURLConnection.setDefaultHostnameVerifier((urlHostName, session) -> {
                    log.warn("Warning: URL Host: " + urlHostName + " vs. " + session.getPeerHost());
                    return true;
                });
            }
            URL url = new URL(strUrl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(20000);
            conn.setReadTimeout(AttachmentKit.readTimeLimit());
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            in = conn.getInputStream();
            IOUtils.copy((InputStream)in, (OutputStream)output);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(output.toByteArray());
            return byteArrayInputStream;
        }
        catch (Exception e) {
            log.error("getInputStreamByUrl \u5f02\u5e38,exception is ", (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private static void trustAllHttpsCertificates() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[1];
        miTM tm = new miTM();
        trustAllCerts[0] = tm;
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(null, trustAllCerts, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    private static int readTimeLimit() {
        Map customParameterFromCache = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam());
        String mobileUrlDownloadTimeLimit = (String)customParameterFromCache.get("MOBILE_URL_DOWNLOAD_TIME_LIMIT");
        int readTimeLimit = Optional.ofNullable(mobileUrlDownloadTimeLimit).map(Ints::tryParse).orElse(3600000);
        return readTimeLimit;
    }

    static class miTM
    implements TrustManager,
    X509TrustManager {
        miTM() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public boolean isServerTrusted(X509Certificate[] certs) {
            return true;
        }

        public boolean isClientTrusted(X509Certificate[] certs) {
            return true;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

