/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.attachment.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Optional;
import kd.bos.attachment.manage.AttachInfo;
import kd.bos.attachment.manage.AttachManageService;
import kd.bos.bill.IBillView;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AttachEncrypt;
import kd.bos.entity.datamodel.AttachEncryptConfirm;
import kd.bos.entity.datamodel.AttachmentEncryptConfig;
import kd.bos.entity.datamodel.Lifecycle;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.UrlUtil;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.svc.util.SystemParamUtil;
import org.apache.commons.codec.digest.DigestUtils;

public class AttachmentManageUtil {
    private static final String JWT_SUBJECT = "kdjwt";
    private static final String JWT_ID = "kd";
    private static final Log log = LogFactory.getLog(AttachmentManageUtil.class);
    private static final AttachManageService attachManageService = new AttachManageService();

    public static String getAttMd5(Map<String, Object> attMap, String fileSource) throws IOException {
        String url = (String)attMap.get("url");
        if (url.contains("tempfile/download.do?configKey")) {
            InputStream in = CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(url);
            return DigestUtils.md5Hex((InputStream)in);
        }
        if (StringUtils.isBlank((CharSequence)url)) {
            log.error("current url is empty");
            return "";
        }
        String path = UrlUtil.getParam((String)url, (String)"path");
        if (StringUtils.isNotBlank((CharSequence)(path = URLDecoder.decode(path, "utf-8")))) {
            while (path.startsWith("//")) {
                path = path.replace("//", "/");
            }
        } else {
            log.error("kd.bos.form.field.AttachmentEdit.getAttMd5 path is blank -- path = " + path + " --- ,url = " + url);
            throw new KDBizException("kd.bos.form.field.AttachmentEdit.getAttMd5 path is blank");
        }
        AttachInfo attachInfo = new AttachInfo();
        String fileName = attMap.get("name").toString();
        attachInfo.setName(fileName);
        if (null != attMap.get("size")) {
            attachInfo.setSize(Long.parseLong(attMap.get("size").toString()));
        }
        attachInfo.setSource(fileSource);
        String md5 = attachManageService.queryIdentifyWithSave(attachInfo, path);
        return md5;
    }

    public static boolean needEncrypt(IFormView formView, boolean isExport) {
        try {
            String formId = "";
            if (formView instanceof IListView) {
                formId = ((IListView)formView).getBillFormId();
            } else if (formView instanceof IBillView) {
                formId = formView.getEntityId();
            }
            return AttachmentManageUtil.needEncrypt(formId, isExport);
        }
        catch (Exception e) {
            log.error("encrypt file get bill param error:", (Throwable)e);
            return false;
        }
    }

    public static boolean needEncrypt(String formId, boolean isExport) {
        boolean encrypt = false;
        String entityId = "";
        try {
            Optional billParam;
            if (StringUtils.isEmpty((CharSequence)formId)) {
                return false;
            }
            String key = "checkdownloadencrypt";
            if (isExport) {
                key = "checkexportencrypt";
            }
            if ((billParam = SystemParamUtil.getBillParam((String)(entityId = FormMetadataCache.getFormConfig((String)formId).getEntityTypeId()), (String)key)).isPresent() && billParam.get() instanceof Boolean) {
                encrypt = (Boolean)billParam.get();
            }
        }
        catch (Exception e) {
            log.error(String.format("encrypt file get bill param error formId is\uff1a%s\uff0cand entityId is:%s", formId, entityId), (Throwable)e);
            return false;
        }
        return encrypt;
    }

    public static FormShowParameter getFormParameterForEncrypt(String encryptType) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("bos_file_encrypt_confirm");
        showParameter.setCustomParam("encryptType", (Object)encryptType);
        return showParameter;
    }

    public static void addAction(IClientViewProxy clientViewProxy, IFormView view) {
        Lifecycle lifecycle = new Lifecycle();
        lifecycle.setBeforeDownload(true);
        AttachmentEncryptConfig encryptConfig = new AttachmentEncryptConfig();
        encryptConfig.setLifecycle(lifecycle);
        encryptConfig.setFileEncrypt(true);
        AttachEncryptConfirm encryptConfirm = new AttachEncryptConfirm();
        encryptConfirm.setAttachmentpanel(encryptConfig);
        encryptConfirm.setAttachmentfield(encryptConfig);
        AttachEncrypt encrypt = new AttachEncrypt();
        encrypt.setConfig(encryptConfirm);
        encrypt.setPageId(view.getPageId());
        clientViewProxy.addAction("setPageConfig", (Object)encrypt);
    }

    public static String getPath(String url, boolean isDownload) {
        try {
            if (url.contains("tempfile/download.do?configKey") || url.contains(URLEncoder.encode("tempfile/download.do?configKey", "UTF-8"))) {
                if (isDownload) {
                    return url.substring(url.indexOf("tempfile/download.do?configKey"));
                }
                String path = UrlUtil.getParam((String)url, (String)"path");
                return "attachment/preview.do?path=" + path + "&isFromCache=true";
            }
            String path = UrlUtil.getParam((String)url, (String)"path");
            if (isDownload) {
                return "attachment/download.do?path=" + path;
            }
            return "attachment/preview.do?path=" + path;
        }
        catch (Exception e) {
            log.error("get path failed:", (Throwable)e);
            return url;
        }
    }
}

