/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.attachment.util;

import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.attachment.util.ParamUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.session.EncreptSessionUtils;

public class AttachmentPreviewUtil {
    private static final Log log = LogFactory.getLog(AttachmentPreviewUtil.class);

    public static boolean isOnlyOfficePreView() {
        return "3".equals(ParamUtil.getPreviewType());
    }

    public static String addFileIdParam(String url, String formId) {
        if (StringUtils.isBlank((CharSequence)formId)) {
            return url;
        }
        return url + "&fId=" + formId + "&fromOnlyOffice=1";
    }

    public static boolean fromOnlyOfficeDownLoad(HttpServletRequest request) {
        boolean isOnlyOffice = false;
        String isFromOnlyOffice = request.getParameter("fromOnlyOffice");
        if (StringUtils.equals((CharSequence)isFromOnlyOffice, (CharSequence)"1")) {
            isOnlyOffice = true;
        }
        return isOnlyOffice;
    }

    public static String setOnlyOfficeDownloadUrl(String url, String entityNumber) {
        String onlyOfficeDownloadUrl = url;
        onlyOfficeDownloadUrl = url.contains("&kdedcba=") ? AttachmentPreviewUtil.addFileIdParam(onlyOfficeDownloadUrl, entityNumber) : AttachmentPreviewUtil.addFileIdParam(EncreptSessionUtils.encryptSession((String)url), entityNumber);
        return AttachmentPreviewUtil.getReplaceUrl(onlyOfficeDownloadUrl, "0", true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getReplaceUrl(String toReplaceUrl, String urlType, boolean isPreview) {
        try {
            String proxyUrl = ParamUtil.getParamByType((String)urlType, (boolean)isPreview);
            if (StringUtils.isNotBlank((CharSequence)proxyUrl)) {
                String[] urlSplit;
                log.info("start replace url");
                URL url = new URL(toReplaceUrl);
                String host = url.getHost();
                int port = url.getPort();
                if (port != -1) {
                    host = host + ":" + port;
                }
                if ((urlSplit = toReplaceUrl.split(host)).length >= 2) return proxyUrl + urlSplit[1];
                log.error("replaceUrl failed");
                return toReplaceUrl;
            } else {
                log.info("get proxy url is empty");
            }
            return toReplaceUrl;
        }
        catch (Exception e) {
            log.error("replace url failed:", (Throwable)e);
        }
        return toReplaceUrl;
    }
}

