/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.attachment.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import kd.bos.form.attachment.util.YozoPreviewConvertEnum;

public class YozoPreviewConvertMapping {
    private static volatile YozoPreviewConvertMapping mapping;
    private static Map<Integer, Function<String, Boolean>> functionMap;

    private YozoPreviewConvertMapping() {
        functionMap = new HashMap<Integer, Function<String, Boolean>>();
        functionMap.put(YozoPreviewConvertEnum.YOZO_PREVIEW_DOC_CONVERT.getCode(), x -> this.checkConvertType(YozoPreviewConvertEnum.YOZO_PREVIEW_DOC_CONVERT.getType(), (String)x));
        functionMap.put(YozoPreviewConvertEnum.YOZO_PREVIEW_ZIP_CONVERT.getCode(), x -> this.checkConvertType(YozoPreviewConvertEnum.YOZO_PREVIEW_ZIP_CONVERT.getType(), (String)x));
        functionMap.put(YozoPreviewConvertEnum.YOZO_PREVIEW_PIC_CONVERT.getCode(), x -> this.checkConvertType(YozoPreviewConvertEnum.YOZO_PREVIEW_PIC_CONVERT.getType(), (String)x));
        functionMap.put(YozoPreviewConvertEnum.YOZO_PREVIEW_PDF_CONVERT.getCode(), x -> this.checkConvertType(YozoPreviewConvertEnum.YOZO_PREVIEW_PDF_CONVERT.getType(), (String)x));
        functionMap.put(YozoPreviewConvertEnum.YOZO_PREVIEW_EPUB_CONVERT.getCode(), x -> this.checkConvertType(YozoPreviewConvertEnum.YOZO_PREVIEW_EPUB_CONVERT.getType(), (String)x));
        functionMap.put(YozoPreviewConvertEnum.YOZO_PREVIEW_DAE_CONVERT.getCode(), x -> this.checkConvertType(YozoPreviewConvertEnum.YOZO_PREVIEW_DAE_CONVERT.getType(), (String)x));
        functionMap.put(YozoPreviewConvertEnum.YOZO_PREVIEW_INDD_CONVERT.getCode(), x -> this.checkConvertType(YozoPreviewConvertEnum.YOZO_PREVIEW_INDD_CONVERT.getType(), (String)x));
        functionMap.put(YozoPreviewConvertEnum.YOZO_PREVIEW_PSD_CONVERT.getCode(), x -> this.checkConvertType(YozoPreviewConvertEnum.YOZO_PREVIEW_PSD_CONVERT.getType(), (String)x));
        functionMap.put(YozoPreviewConvertEnum.YOZO_PREVIEW_AI_CONVERT.getCode(), x -> this.checkConvertType(YozoPreviewConvertEnum.YOZO_PREVIEW_AI_CONVERT.getType(), (String)x));
        functionMap.put(YozoPreviewConvertEnum.YOZO_PREVIEW_CDR_CONVERT.getCode(), x -> this.checkConvertType(YozoPreviewConvertEnum.YOZO_PREVIEW_CDR_CONVERT.getType(), (String)x));
        functionMap.put(YozoPreviewConvertEnum.YOZO_PREVIEW_VIDEO_CONVERT.getCode(), x -> this.checkConvertType(YozoPreviewConvertEnum.YOZO_PREVIEW_VIDEO_CONVERT.getType(), (String)x));
        functionMap.put(YozoPreviewConvertEnum.YOZO_PREVIEW_AUDIO_CONVERT.getCode(), x -> this.checkConvertType(YozoPreviewConvertEnum.YOZO_PREVIEW_AUDIO_CONVERT.getType(), (String)x));
        functionMap.put(YozoPreviewConvertEnum.YOZO_PREVIEW_CAD_CONVERT.getCode(), x -> this.checkConvertType(YozoPreviewConvertEnum.YOZO_PREVIEW_CAD_CONVERT.getType(), (String)x));
        functionMap.put(YozoPreviewConvertEnum.YOZO_PREVIEW_3D_CONVERT.getCode(), x -> this.checkConvertType(YozoPreviewConvertEnum.YOZO_PREVIEW_3D_CONVERT.getType(), (String)x));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static YozoPreviewConvertMapping getInstance() {
        if (mapping != null) return mapping;
        Class<YozoPreviewConvertMapping> clazz = YozoPreviewConvertMapping.class;
        synchronized (YozoPreviewConvertMapping.class) {
            if (mapping != null) return mapping;
            mapping = new YozoPreviewConvertMapping();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mapping;
        }
    }

    public int getConvertType(String fileExt) {
        for (Map.Entry<Integer, Function<String, Boolean>> entry : functionMap.entrySet()) {
            if (!entry.getValue().apply(fileExt).booleanValue()) continue;
            return entry.getKey();
        }
        return YozoPreviewConvertEnum.YOZO_PREVIEW_DOC_CONVERT.getCode();
    }

    private Boolean checkConvertType(String convertType, String fileExt) {
        String[] convertArray;
        for (String type : convertArray = convertType.split(",")) {
            if (!type.equalsIgnoreCase(fileExt)) continue;
            return true;
        }
        return false;
    }
}

