/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import kd.bos.attachment.extend.service.FileServiceExtensionUtil;
import kd.bos.bill.IBillView;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IAttachmentModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.param.CustomParam;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.IPageCache;
import kd.bos.form.TipsSupport;
import kd.bos.form.attachment.common.AttachmentKit;
import kd.bos.form.attachment.util.AttachmentControlUtil;
import kd.bos.form.attachment.util.AttachmentManageUtil;
import kd.bos.form.attachment.util.AttachmentPreviewUtil;
import kd.bos.form.control.AttachBtnOption;
import kd.bos.form.control.UrlUtil;
import kd.bos.form.control.events.AttachmentDownLoadEvent;
import kd.bos.form.control.events.AttachmentDownloadListener;
import kd.bos.form.control.events.AttachmentMarkEvent;
import kd.bos.form.control.events.AttachmentMarkListener;
import kd.bos.form.control.events.AttachmentOperaClickEvent;
import kd.bos.form.control.events.AttachmentOperaClickListener;
import kd.bos.form.control.events.AttachmentPreviewEvent;
import kd.bos.form.control.events.AttachmentPreviewListener;
import kd.bos.form.control.events.AttachmentResultListener;
import kd.bos.form.control.events.BeforeAttachmentRemoveEvent;
import kd.bos.form.control.events.BeforeAttachmentRemoveListener;
import kd.bos.form.control.events.BeforeAttachmentUploadEvent;
import kd.bos.form.control.events.BeforeAttachmentUploadListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.control.events.UploadResultEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.AttachmentInfo;
import kd.bos.mservice.attachment.AttachmentOpType;
import kd.bos.mservice.attachment.AttachmentType;
import kd.bos.mservice.attachment.FieldType;
import kd.bos.mservice.attachment.IAttachmentManagerService;
import kd.bos.mservice.attachment.IAttachmentService;
import kd.bos.mservice.svc.attach.IAttachmentPanel;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.attachment.FileSource;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.url.UrlService;
import kd.bos.web.actions.utils.FilePremissionUtil;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.collections4.CollectionUtils;

@SdkPublic
@KSObject
@DataEntityTypeAttribute(name="kd.bos.form.control.AttachmentPanel")
public class AttachmentPanel
extends TipsSupport
implements IAttachmentPanel {
    private static final Log log = LogFactory.getLog(AttachmentPanel.class);
    private static final String ATT_UID = "uid";
    private static final String ATT_UIDLIST = "uidList";
    private static final String ATT_URL = "url";
    private static final String ATT_STATUS = "status";
    private static final String ATT_SUCCESS = "success";
    private static final String ATT_UPLOADING = "uploading";
    private static final String ATT_MSG = "msg";
    private static final String ATT_MD5 = "md5";
    private static final String CAN_REMOVE = "canRemove";
    private static final String CAN_UPLOAD = "canUpload";
    private static final String I_ATTACHMENT_MANAGER_SERVICE = "IAttachmentManagerService";
    private static final String ENTITY_NUM = "entityNum";
    private static final String APPID = "appid";
    private static final String TAMP_ATT_CACHE = "TampAttCache";
    private static final String BILL_PK_ID = "billPkId";
    private static final String ATT_BILLNO = "billno";
    private static final String PREVIEWURL = "previewurl";
    private static final String DESCRIPTION = "description";
    private static final String NAME = "name";
    private static final String[] SPECIAL_SYMBOLARRAY = "/,\\,*,\",?,:,<,>,|,..\\,../".split(",");
    private static final String LOCAL_ID_KEY = "AttachmentAction:uploadFile:localIds:";
    private static final String DRAGSEQ = "dragseq";
    private static DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));
    private IAttachmentModel attachmentModel;
    protected List<BeforeAttachmentUploadListener> beforeUploadListeners = new ArrayList<BeforeAttachmentUploadListener>(10);
    protected List<UploadListener> uploadListeners = new ArrayList<UploadListener>(10);
    protected List<AttachmentResultListener> resultListeners = new ArrayList<AttachmentResultListener>(10);
    protected List<AttachmentDownloadListener> downloadListener = new ArrayList<AttachmentDownloadListener>(10);
    protected List<AttachmentPreviewListener> previewListener = new ArrayList<AttachmentPreviewListener>(10);
    protected List<BeforeAttachmentRemoveListener> beforeRemoveListeners = new ArrayList<BeforeAttachmentRemoveListener>(10);
    protected List<AttachmentMarkListener> markListeners = new ArrayList<AttachmentMarkListener>(10);
    protected List<AttachmentOperaClickListener> operaClickListener = new ArrayList<AttachmentOperaClickListener>(10);
    private String attachmentCountField;
    private boolean defaultCollapse;
    private boolean dragAtm;
    private String entityId;

    @KSMethod
    public void addBeforeUploadListener(BeforeAttachmentUploadListener listener) {
        this.beforeUploadListeners.add(listener);
    }

    @KSMethod
    public void addUploadListener(UploadListener listener) {
        this.uploadListeners.add(listener);
    }

    @KSMethod
    public void addResultListeners(AttachmentResultListener listener) {
        this.resultListeners.add(listener);
    }

    @KSMethod
    public void addDownloadListener(AttachmentDownloadListener listener) {
        this.downloadListener.add(listener);
    }

    @KSMethod
    public void addPreviewListener(AttachmentPreviewListener listener) {
        this.previewListener.add(listener);
    }

    @KSMethod
    public void addBeforeRemoveListener(BeforeAttachmentRemoveListener listener) {
        this.beforeRemoveListeners.add(listener);
    }

    @KSMethod
    public void addMarkListener(AttachmentMarkListener listener) {
        this.markListeners.add(listener);
    }

    @KSMethod
    public void addOperaClickListener(AttachmentOperaClickListener listener) {
        this.operaClickListener.add(listener);
    }

    public void beforeUpload(List<Map<String, Object>> attachs) {
        if (CollectionUtils.isEmpty(attachs)) {
            return;
        }
        String entityNum = AttachmentKit.getPermissionEntityNum(this.getView());
        Object billPkId = AttachmentKit.getPermissionBillPkId(this.getView());
        FilePremissionUtil.hasAttachmentOpPermission(null, (String)entityNum, (Object)billPkId, (String)"2NJ5SR4NUEJ=", (IFormView)this.getView(), (boolean)false, (String)this.getKey(), (IClientViewProxy)this.clientViewProxy);
        BeforeAttachmentUploadEvent evt = new BeforeAttachmentUploadEvent((Object)this, attachs);
        AttachmentKit.fireBeforeUpload(this.getKey(), evt, this.beforeUploadListeners, this.clientViewProxy, this.getView());
        String cacheKey = "UploadingAtt" + this.getView().getPageId();
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        String uploadingAttJson = cache.get(cacheKey);
        ArrayList<String> uploadingAttList = uploadingAttJson != null ? SerializationUtils.fromJsonStringToList((String)uploadingAttJson, String.class) : new ArrayList<String>(attachs.size());
        for (Map<String, Object> attach : attachs) {
            if (uploadingAttList.contains((String)attach.get(ATT_UID))) continue;
            uploadingAttList.add((String)attach.get(ATT_UID));
        }
        cache.put(cacheKey, SerializationUtils.toJsonString(uploadingAttList));
    }

    public void uploadResult(List<Map<String, Object>> attachs) {
        log.info("kd.bos.form.control.AttachmentPanel.uploadResult attachs : " + SerializationUtils.toJsonString(attachs));
        for (AttachmentResultListener resultListener : this.resultListeners) {
            ArrayList<Map<String, Object>> evtList = new ArrayList<Map<String, Object>>();
            evtList.addAll(attachs);
            UploadResultEvent evt = new UploadResultEvent((Object)this, evtList);
            resultListener.uploadResult(evt);
        }
        String cacheKey = "UploadingAtt" + this.getView().getPageId();
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        String uploadingAttJson = cache.get(cacheKey);
        if (uploadingAttJson != null) {
            List uploadingAttList = SerializationUtils.fromJsonStringToList((String)uploadingAttJson, String.class);
            for (Map<String, Object> attach : attachs) {
                if (!ATT_UPLOADING.equals(attach.get(ATT_STATUS))) {
                    uploadingAttList.remove(attach.get(ATT_UID));
                }
                AttachmentKit.cacheTempFileParam(attach, this.getView());
            }
            if (uploadingAttList.size() == 0) {
                cache.remove(cacheKey);
            } else {
                cache.put(cacheKey, SerializationUtils.toJsonString((Object)uploadingAttList));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void upload(List<Map<String, Object>> attachs) {
        String url;
        log.info("kd.bos.form.control.AttachmentPanel.upload attachs : " + SerializationUtils.toJsonString(attachs));
        IAttachmentManagerService managerService = (IAttachmentManagerService)ServiceFactory.getService((String)I_ATTACHMENT_MANAGER_SERVICE);
        for (Map<String, Object> attach : attachs) {
            void var8_8;
            if (!attach.containsKey("filesource")) {
                attach.put("filesource", 1);
            }
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)this.getModel().getDataEntityType().getName());
            String entityNum = formConfig.getEntityTypeId();
            attach.put(ENTITY_NUM, entityNum);
            Iterator<Map<String, Object>> pkValue = this.getModel().getDataEntity().getPkValue();
            attach.put(BILL_PK_ID, pkValue == null ? "" : pkValue.toString());
            String string = "";
            MainEntityType dataEntityType = this.getModel().getDataEntityType();
            if (dataEntityType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)((BillEntityType)dataEntityType).getBillNo())) {
                String string2 = this.getModel().getDataEntity().getString(((BillEntityType)dataEntityType).getBillNo());
            }
            attach.put(ATT_BILLNO, var8_8);
            boolean isWeb = !"mobile".equals(RequestContext.get().getClient()) && !(this.getView() instanceof IMobileView);
            attach.put("client", isWeb ? "web" : "mobile");
            url = (String)attach.get(ATT_URL);
            String[] split = url.split("id=");
            if (split.length < 2) continue;
            this.setLocalId(attach, split[1]);
        }
        List<AttachmentInfo> infos = this.packageAttachmentInfoList(attachs);
        UploadEvent evt = new UploadEvent((Object)this, attachs.toArray(), this.getKey());
        for (UploadListener l : this.uploadListeners) {
            l.upload(evt);
        }
        if (evt.isCancel()) {
            this.removeCacheUploadingAttachs(attachs);
            String cancelMsg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u5141\u8bb8\u4e0a\u4f20\u8be5\u6587\u4ef6\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"AttachmentPanel_1", (String)"bos-svc-metadata", (Object[])new Object[0]);
            if (StringUtils.isNotBlank((CharSequence)evt.getCancelMsg())) {
                cancelMsg = evt.getCancelMsg();
            }
            this.getView().showTipNotification(cancelMsg, Integer.valueOf(3000));
            ArrayList<String> uidList = new ArrayList<String>();
            for (Map<String, Object> map : attachs) {
                String uid = (String)map.get(ATT_UID);
                uidList.add(uid);
            }
            this.clientViewProxy.invokeControlMethod(this.getKey(), "cancelUploadAttachment", new Object[]{uidList});
            return;
        }
        IDataModel model = this.getModel();
        ISimpleProperty pKey = model.getDataEntityType().getPrimaryKey();
        if (pKey != null) {
            Object pkId = model.getDataEntity().get((IDataEntityProperty)pKey);
            List<Map<String, Object>> list = this.updateAttachListCacheForUpload(attachs);
            this.setAttachmentCountFieldByPk(pkId, list);
        } else {
            List<Map<String, Object>> tempAtts = this.updateAttachListCacheForUpload(attachs);
            if (StringUtils.isNotBlank((CharSequence)this.attachmentCountField)) {
                this.getModel().setValue(this.attachmentCountField, (Object)tempAtts.size());
            }
            Date date = new Date();
            DynamicObject name = UserServiceHelper.getCurrentUser((String)RequestContext.get().getUserName());
            for (Map<String, Object> att : attachs) {
                att.put("createdate", date.getTime());
                if (att.containsKey("uploadTime")) {
                    att.put("createdate", att.get("uploadTime"));
                }
                att.put("creator", name == null ? new LocaleString(RequestContext.get().getUserName()) : name.getLocaleString(NAME));
            }
        }
        this.addCreateTimeStr(attachs);
        for (Map map : attachs) {
            Object previewUrlObj;
            String fileName = String.valueOf(map.get(NAME));
            if (fileName.lastIndexOf(46) < 0) continue;
            String type = fileName.substring(fileName.lastIndexOf(46) + 1);
            map.put("type", type);
            this.setPreviewUrl(map);
            url = map.get(ATT_URL);
            if (null != url) {
                map.put("downloadFilePath", AttachmentManageUtil.getPath(url.toString(), true));
            }
            if (null == (previewUrlObj = map.get(PREVIEWURL))) continue;
            map.put("previewFilePath", AttachmentManageUtil.getPath(previewUrlObj.toString(), false));
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        log.info("kd.bos.form.control.AttachmentPanel.upload addAttachment --- " + SerializationUtils.toJsonString(attachs));
        clientViewProxy.invokeControlMethod(this.getKey(), "addAttachment", new Object[]{attachs});
        managerService.afterDoOperation(infos, AttachmentOpType.Upload);
        for (UploadListener l : this.uploadListeners) {
            l.afterUpload(evt);
        }
        this.uploadResult(attachs);
    }

    private void setAttachmentCountFieldByPk(Object pkId, List<Map<String, Object>> tempAtts) {
        if (pkId instanceof Long ? (Long)pkId > 0L : StringUtils.isNotBlank((Object)pkId)) {
            if (StringUtils.isNotBlank((CharSequence)this.attachmentCountField)) {
                this.getModel().setValue(this.attachmentCountField, (Object)this.getListData().size());
            }
        } else if (StringUtils.isNotBlank((CharSequence)this.attachmentCountField)) {
            this.getModel().setValue(this.attachmentCountField, (Object)tempAtts.size());
        }
    }

    private List<Map<String, Object>> updateAttachListCacheForUpload(List<Map<String, Object>> attachs) {
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        String cacheJsonString = cache.get(TAMP_ATT_CACHE + this.getView().getPageId());
        cacheJsonString = this.getAttachmentModel().getCacheJsonString(this.getKey(), attachs, cacheJsonString);
        cache.put(TAMP_ATT_CACHE + this.getView().getPageId(), cacheJsonString);
        cache.put("AttEntityId" + this.getKey(), this.getEntityId());
        return this.getAttPageCache();
    }

    public void afterReOrder(Map<String, Object> reOrderInfo) {
        Map<String, Object> attMap;
        int i;
        if (!this.getDragAtm()) {
            return;
        }
        if (reOrderInfo.get("sortList") != null) {
            List<Map<String, Object>> attachmentData = this.getAttachmentData();
            List sortList = (List)reOrderInfo.get("sortList");
            attachmentData.sort(Comparator.comparingInt(o -> sortList.indexOf(o.get(ATT_UID))));
            for (int i2 = 0; i2 < attachmentData.size(); ++i2) {
                attachmentData.get(i2).put(DRAGSEQ, i2);
            }
            this.refreshAttDragSeq(attachmentData);
            return;
        }
        if (reOrderInfo.get("startIndex") == null || reOrderInfo.get("destinationIndex") == null) {
            return;
        }
        int startIndex = (Integer)reOrderInfo.get("startIndex");
        int destinationIndex = (Integer)reOrderInfo.get("destinationIndex");
        List<Map<String, Object>> attachmentData = this.getAttachmentData();
        attachmentData.sort(Comparator.comparingInt(o -> (Integer)o.get(DRAGSEQ)));
        if (destinationIndex > startIndex) {
            for (i = 0; i < attachmentData.size(); ++i) {
                attMap = attachmentData.get(i);
                if (startIndex < i && i < destinationIndex) {
                    attMap.put(DRAGSEQ, i - 1);
                    continue;
                }
                if (i != startIndex) continue;
                attMap.put(DRAGSEQ, destinationIndex - 1);
            }
        }
        if (destinationIndex < startIndex) {
            for (i = 0; i < attachmentData.size(); ++i) {
                attMap = attachmentData.get(i);
                if (i == startIndex) {
                    attMap.put(DRAGSEQ, destinationIndex);
                    continue;
                }
                if (i < destinationIndex || i >= startIndex) continue;
                attMap.put(DRAGSEQ, i + 1);
            }
        }
        this.refreshAttDragSeq(attachmentData);
    }

    private void refreshAttDragSeq(List<Map<String, Object>> attachmentData) {
        Map<Boolean, List<Map>> groupByAttPkId = attachmentData.stream().collect(Collectors.groupingBy(i -> i.get("attPkId") == null));
        AttachmentServiceHelper.saveDragSeq(groupByAttPkId.get(false));
        if (CollectionUtils.isNotEmpty((Collection)groupByAttPkId.get(true))) {
            this.setAttPageCache(groupByAttPkId.get(true));
        }
    }

    private void setPreviewUrl(Map<String, Object> attachMap) {
        String previewUrl = null;
        boolean enablePreView = this.getAttachmentModel().ablePreView(attachMap);
        boolean enableYzjPreview = this.enableYzjPreview();
        String url = String.valueOf(attachMap.get(ATT_URL));
        if (StringUtils.isBlank((Object)attachMap.get(PREVIEWURL)) && enablePreView) {
            previewUrl = this.getAttachmentModel().getTempFilePreviewUrl(url);
            if (this.getView() instanceof IMobileView && !String.valueOf(previewUrl).contains("&kdedcba=")) {
                previewUrl = EncreptSessionUtils.encryptSession((String)previewUrl);
            }
            if (enableYzjPreview && this.getView() instanceof IMobileView) {
                previewUrl = this.genYzjMobPreviewUrl(previewUrl);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)url) && enablePreView && AttachmentPreviewUtil.isOnlyOfficePreView()) {
            attachMap.put("onlyOfficeDownloadUrl", AttachmentPreviewUtil.setOnlyOfficeDownloadUrl(url, String.valueOf(attachMap.get(ENTITY_NUM))));
        }
        if (!StringUtils.isBlank(previewUrl)) {
            attachMap.put(PREVIEWURL, previewUrl);
        }
    }

    private void setLocalId(Map<String, Object> attach, String tempFileId) {
        String localId = (String)redisCache.get(LOCAL_ID_KEY + tempFileId);
        if (localId != null) {
            attach.put("localId", localId);
        }
    }

    private void removeCacheUploadingAttachs(List<Map<String, Object>> attachs) {
        String cacheKey = "UploadingAtt" + this.getView().getPageId();
        List uploadingAttList = new ArrayList();
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        String uploadingAttJson = cache.get(cacheKey);
        if (uploadingAttJson != null) {
            uploadingAttList = SerializationUtils.fromJsonStringToList((String)uploadingAttJson, String.class);
        }
        for (Map<String, Object> attach : attachs) {
            uploadingAttList.remove(attach.get(ATT_UID));
        }
        if (uploadingAttList.size() == 0) {
            cache.remove(cacheKey);
        } else {
            cache.put(cacheKey, SerializationUtils.toJsonString(uploadingAttList));
        }
    }

    private List<AttachmentInfo> packageAttachmentInfoList(List<Map<String, Object>> attachs) {
        ArrayList<AttachmentInfo> resultList = new ArrayList<AttachmentInfo>(attachs.size());
        Date now = new Date();
        RequestContext rc = RequestContext.get();
        for (int i = 0; i < attachs.size(); ++i) {
            Map<String, Object> attMap = attachs.get(i);
            AttachmentInfo attachmentInfo = new AttachmentInfo();
            attachmentInfo.setAttSourceType(AttachmentType.attachmentpanel);
            attachmentInfo.setAttKey(this.getKey());
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)this.getModel().getDataEntityType().getName());
            String entityNum = formConfig.getEntityTypeId();
            String appId = formConfig.getAppId();
            attachmentInfo.setEntityNum(entityNum != null ? entityNum : (String)attMap.get(ENTITY_NUM));
            attachmentInfo.setBillPkId((String)attMap.get(BILL_PK_ID));
            attachmentInfo.setAttPkId((Long)attMap.get("attPkId"));
            attachmentInfo.setExt((String)attMap.get("type"));
            attachmentInfo.setFileName((String)attMap.get(NAME));
            attachmentInfo.setFileSize(Long.valueOf(Long.parseLong(attMap.get("size").toString())));
            attachmentInfo.setDownloadUrl(attMap.get(ATT_URL) == null ? "" : (String)attMap.get(ATT_URL));
            attachmentInfo.setPreviewUrl(attachmentInfo.getDownloadUrl().replace("download.do", "preview.do"));
            attachmentInfo.setMark(attMap.get(DESCRIPTION) == null ? "" : (String)attMap.get(DESCRIPTION));
            attachmentInfo.setAppId(appId);
            attachmentInfo.setFieldType(FieldType.AttachmentPanel);
            attachmentInfo.setFieldKey(this.getKey());
            if (attMap.containsKey("createdate")) {
                now = new Date();
                Object createdate = attMap.get("createdate");
                if (createdate instanceof Date) {
                    now = (Date)createdate;
                }
                if (createdate instanceof Long) {
                    now = new Date((Long)createdate);
                }
            }
            if (attMap.containsKey("uploadTime")) {
                now = new Date((Long)attMap.get("uploadTime"));
            }
            attachmentInfo.setCreateTime(now);
            attachmentInfo.setCreateUserId(rc.getUserId());
            attachmentInfo.setModifyTime(now);
            String billno = "";
            MainEntityType dataEntityType = this.getModel().getDataEntityType();
            if (dataEntityType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)((BillEntityType)dataEntityType).getBillNo())) {
                billno = this.getModel().getDataEntity().getString(((BillEntityType)dataEntityType).getBillNo());
            }
            attachmentInfo.setBillno(billno);
            boolean isWeb = !"mobile".equals(RequestContext.get().getClient()) && !(this.getView() instanceof IMobileView);
            attachmentInfo.setClient(isWeb ? "web" : "mobile");
            resultList.add(attachmentInfo);
        }
        return resultList;
    }

    private List<Map<String, Object>> packageAttachmentMapList(List<AttachmentInfo> attachmentInfoList, List<Map<String, Object>> data) {
        boolean visible = true;
        boolean enable = true;
        for (int i = 0; i < attachmentInfoList.size(); ++i) {
            AttachmentInfo attachmentInfo = attachmentInfoList.get(i);
            if (data != null && data.size() == attachmentInfoList.size()) {
                Map<String, Object> attachmentMap = data.get(i);
                String visiablePreview = attachmentInfo.isVisiablePreview() ? "1" : "0";
                String visiableDownload = attachmentInfo.isVisiableDownload() ? "1" : "0";
                String visiableRename = attachmentInfo.isVisiableRename() ? "1" : "0";
                String visiableDelete = attachmentInfo.isVisiableDelete() ? "1" : "0";
                attachmentMap.put("visible", visiablePreview + visiableDownload + visiableRename + visiableDelete);
                attachmentMap.put("hiddenBtn", attachmentInfo.getHiddenBtn());
                Object attPkId = attachmentMap.get("attPkId");
                attachmentMap.put("attPkIdStr", attPkId == null ? null : attPkId.toString());
            }
            if (visible && !attachmentInfo.isVisible()) {
                visible = false;
                this.getView().setVisible(Boolean.valueOf(visible), new String[]{attachmentInfo.getAttKey()});
            }
            if (!enable || attachmentInfo.isEnable()) continue;
            enable = false;
            this.getView().setEnable(Boolean.valueOf(visible), new String[]{attachmentInfo.getAttKey()});
        }
        return data;
    }

    public void beforeRemove(Map<String, Object> attach) {
        Object billPkId;
        String entityNum = AttachmentKit.getPermissionEntityNum(this.getView());
        boolean hasPermission = FilePremissionUtil.hasAttachmentOpPermission(null, (String)entityNum, (Object)(billPkId = AttachmentKit.getPermissionBillPkId(this.getView())), (String)"2NJ5YJOIS+MJ", (IFormView)this.getView(), (boolean)true, (String)this.getKey(), (IClientViewProxy)this.clientViewProxy);
        if (!hasPermission) {
            return;
        }
        BeforeAttachmentRemoveEvent evt = new BeforeAttachmentRemoveEvent((Object)this, attach);
        for (BeforeAttachmentRemoveListener l : this.beforeRemoveListeners) {
            l.beforeAttachmentRemove(evt);
        }
        HashMap<String, Object> removeResult = new HashMap<String, Object>();
        if (evt.isCancel()) {
            removeResult.put(CAN_REMOVE, Boolean.FALSE);
            removeResult.put(ATT_UID, attach.get(ATT_UID));
            if (StringUtils.isNotBlank((CharSequence)evt.getMsg())) {
                removeResult.put(ATT_MSG, evt.getMsg());
            }
            this.clientViewProxy.invokeControlMethod(this.getKey(), "beforeRemove", new Object[]{removeResult});
        } else {
            removeResult.put(CAN_REMOVE, Boolean.TRUE);
            removeResult.put(ATT_UID, attach.get(ATT_UID));
            this.clientViewProxy.invokeControlMethod(this.getKey(), "beforeRemove", new Object[]{removeResult});
        }
    }

    public void attachOperationCount(Map<String, Object> args) {
        List<AttachmentInfo> infos;
        IAttachmentManagerService managerService;
        AttachmentOpType attachmentOpType;
        block16: {
            ArrayList<Map<String, Object>> targetAttachments;
            Object billPkId;
            String entityNum;
            String operationType;
            block15: {
                operationType = (String)args.get("operationType");
                entityNum = AttachmentKit.getPermissionEntityNum(this.getView());
                billPkId = AttachmentKit.getPermissionBillPkId(this.getView());
                List uids = (List)args.get(ATT_UID);
                targetAttachments = new ArrayList<Map<String, Object>>();
                List<Map<String, Object>> atts = this.getAttachmentData();
                for (Map<String, Object> att : atts) {
                    if (!uids.contains(att.get(ATT_UID))) continue;
                    targetAttachments.add(att);
                }
                attachmentOpType = AttachmentOpType.Download;
                switch (operationType) {
                    case "preview": {
                        attachmentOpType = AttachmentOpType.PreView;
                        break;
                    }
                }
                managerService = (IAttachmentManagerService)ServiceFactory.getService((String)I_ATTACHMENT_MANAGER_SERVICE);
                infos = this.packageAttachmentInfoList(targetAttachments);
                if (!operationType.contains("download")) break block15;
                boolean hasPermission = FilePremissionUtil.hasAttachmentOpPermission(null, (String)entityNum, (Object)billPkId, (String)"2NJ5XVVCMBCL", (IFormView)this.getView(), (boolean)true, (String)this.getKey(), (IClientViewProxy)this.clientViewProxy);
                if (!hasPermission) {
                    return;
                }
                AttachmentDownLoadEvent evt = new AttachmentDownLoadEvent((Object)this, targetAttachments);
                for (AttachmentDownloadListener attachmentDownloadListener : this.downloadListener) {
                    attachmentDownloadListener.attachmentAfterDownload(evt);
                }
                StringBuilder sb = new StringBuilder();
                if (this.getView() instanceof IMobileView) break block16;
                for (Map map : targetAttachments) {
                    String[] urlArr = ((String)map.get(ATT_URL)).split("path=");
                    try {
                        if (urlArr.length <= 1 || FileServiceFactory.getAttachmentFileService().exists(URLDecoder.decode(urlArr[1], "utf-8"))) continue;
                        sb.append('[').append(map.get(NAME)).append(']');
                    }
                    catch (Exception e) {
                        throw new KDException(BosErrorCode.storageFileNotExist, new Object[]{e.getMessage()});
                    }
                }
                if (sb.length() <= 0) break block16;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9644\u4ef6%s\u5df2\u4e0d\u5b58\u5728", (String)"AttachmentPanel_0", (String)"bos-svc-metadata", (Object[])new Object[0]), sb.toString()));
                break block16;
            }
            if ("preview".equals(operationType)) {
                boolean hasPermission = FilePremissionUtil.hasAttachmentOpPermission(null, (String)entityNum, (Object)billPkId, (String)"2NJ5VA7D2ONF", (IFormView)this.getView(), (boolean)true, (String)this.getKey(), (IClientViewProxy)this.clientViewProxy);
                if (!hasPermission) {
                    return;
                }
                AttachmentPreviewEvent evt = new AttachmentPreviewEvent((Object)this, targetAttachments);
                for (AttachmentPreviewListener attachmentPreviewListener : this.previewListener) {
                    attachmentPreviewListener.attachmentAfterPreview(evt);
                }
            }
        }
        managerService.afterDoOperation(infos, attachmentOpType);
    }

    public void remove(Map<String, Object> attach) {
        Object billPkId = AttachmentKit.getPermissionBillPkId(this.getView());
        boolean hasPermission = FilePremissionUtil.hasAttachmentOpPermission(null, (String)AttachmentKit.getPermissionEntityNum(this.getView()), (Object)billPkId, (String)"2NJ5YJOIS+MJ", (IFormView)this.getView(), (boolean)true, (String)this.getKey(), (IClientViewProxy)this.clientViewProxy);
        if (!hasPermission) {
            return;
        }
        IAttachmentManagerService managerService = (IAttachmentManagerService)ServiceFactory.getService((String)I_ATTACHMENT_MANAGER_SERVICE);
        ArrayList<Map<String, Object>> attachs = new ArrayList<Map<String, Object>>();
        attachs.add(attach);
        for (Map map : attachs) {
            String entityNum = FormMetadataCache.getFormConfig((String)this.getModel().getDataEntityType().getName()).getEntityTypeId();
            map.put(ENTITY_NUM, entityNum);
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            attach.put(BILL_PK_ID, pkValue == null ? "" : pkValue.toString());
            Object billno = "";
            MainEntityType dataEntityType = this.getModel().getDataEntityType();
            if (dataEntityType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)((BillEntityType)dataEntityType).getBillNo())) {
                billno = this.getModel().getDataEntity().getString(((BillEntityType)dataEntityType).getBillNo());
            }
            attach.put(ATT_BILLNO, billno);
        }
        List<AttachmentInfo> infos = this.packageAttachmentInfoList(attachs);
        Map map = managerService.beforeDoOperation(infos, AttachmentOpType.Remove);
        boolean enable = (Boolean)map.get("enable");
        if (!enable) {
            this.getView().showErrorNotification((String)map.get("cancleMsg"));
            return;
        }
        UploadEvent evt = new UploadEvent((Object)this, attach, this.getKey());
        for (UploadListener l : this.uploadListeners) {
            l.remove(evt);
        }
        if (evt.isCancel()) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject object = model.getDataEntity();
        Object pkId = object.getPkValue();
        boolean isTemp = false;
        List<Map<String, Object>> tempAtts = this.getAttPageCache();
        if (tempAtts != null) {
            for (Map<String, Object> tempAtt : tempAtts) {
                if (!attach.get(ATT_UID).equals(tempAtt.get(ATT_UID))) continue;
                tempAtts.remove(tempAtt);
                Object url = tempAtt.get(ATT_URL);
                if (StringUtils.isNotBlank((Object)url) && url.toString().contains("tempfile/download.do?configKey")) {
                    CacheFactory.getCommonCacheFactory().getTempFileCache().remove(url.toString());
                }
                isTemp = true;
                break;
            }
        }
        if (isTemp) {
            this.setAttPageCache(tempAtts);
        } else if (this.getView() instanceof IBillView) {
            this.getAttachmentModel().remove(model, attach, this.getEntityId());
        }
        this.setAttachmentCountFieldByPk(pkId, tempAtts);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        HashMap<String, Object> removeResult = new HashMap<String, Object>();
        removeResult.put("remove", Boolean.TRUE);
        removeResult.put(ATT_UID, attach.get(ATT_UID));
        clientViewProxy.invokeControlMethod(this.getKey(), "removeAttachment", new Object[]{removeResult});
        managerService.afterDoOperation(infos, AttachmentOpType.Remove);
        for (UploadListener l : this.uploadListeners) {
            l.afterRemove(evt);
        }
    }

    public void mark(String uid, String description) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ATT_UID, uid);
        params.put("content", description);
        this.mark(params);
    }

    public void mark(Map<String, Object> params) {
        Object billPkId;
        String entityNum = AttachmentKit.getPermissionEntityNum(this.getView());
        boolean hasPermission = FilePremissionUtil.hasAttachmentOpPermission(null, (String)entityNum, (Object)(billPkId = AttachmentKit.getPermissionBillPkId(this.getView())), (String)"2NJ5ZK67OB2T", (IFormView)this.getView(), (boolean)true, (String)this.getKey(), (IClientViewProxy)this.clientViewProxy);
        if (!hasPermission) {
            return;
        }
        String uid = params.get(ATT_UID).toString();
        String description = params.get("content").toString();
        String attPkId = null;
        if (null != params.get("attPkId")) {
            attPkId = params.get("attPkId").toString();
        }
        boolean isTemp = false;
        ArrayList<Map<String, Object>> attachs = new ArrayList<Map<String, Object>>();
        List<Map<String, Object>> tempAtts = this.getAttPageCache();
        if (tempAtts != null && tempAtts.size() > 0) {
            for (Map<String, Object> tempAtt : tempAtts) {
                if (!uid.equals(tempAtt.get(ATT_UID))) continue;
                tempAtt.put(DESCRIPTION, description);
                isTemp = true;
                attachs.add(tempAtt);
                break;
            }
        }
        if (!isTemp) {
            for (Map<String, Object> attach : this.getAttachmentData()) {
                if (!uid.equals(attach.get(ATT_UID))) continue;
                attach.put(DESCRIPTION, description);
                attachs.add(attach);
                break;
            }
        }
        List<AttachmentInfo> infos = this.packageAttachmentInfoList(attachs);
        IAttachmentManagerService managerService = (IAttachmentManagerService)ServiceFactory.getService((String)I_ATTACHMENT_MANAGER_SERVICE);
        Map result = managerService.beforeDoOperation(infos, AttachmentOpType.Mark);
        boolean enable = (Boolean)result.get("enable");
        if (!enable) {
            this.getView().showErrorNotification((String)result.get("cancleMsg"));
            return;
        }
        AttachmentMarkEvent evt = new AttachmentMarkEvent((Object)this, uid, description);
        for (AttachmentMarkListener l : this.markListeners) {
            l.mark(evt);
        }
        if (!isTemp) {
            this.getAttachmentModel().mark(uid, description, attPkId);
        } else {
            this.setAttPageCache(tempAtts);
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(ATT_UID, uid);
        parameters.put(DESCRIPTION, description);
        parameters.put("attPkId", attPkId);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(this.getKey(), "mark", new Object[]{parameters});
        managerService.afterDoOperation(infos, AttachmentOpType.Mark);
    }

    public void rename(String uid, String name) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ATT_UID, uid);
        params.put("content", name);
        this.rename(params);
    }

    public void rename(Map<String, Object> params) {
        String oldExt;
        String oldName;
        Object billPkId;
        String entityNum = AttachmentKit.getPermissionEntityNum(this.getView());
        boolean hasPermission = FilePremissionUtil.hasAttachmentOpPermission(null, (String)entityNum, (Object)(billPkId = AttachmentKit.getPermissionBillPkId(this.getView())), (String)"2NJ5W8AA040D", (IFormView)this.getView(), (boolean)true, (String)this.getKey(), (IClientViewProxy)this.clientViewProxy);
        if (!hasPermission) {
            return;
        }
        String name = params.get("content").toString();
        String uid = params.get(ATT_UID).toString();
        String attPkId = null;
        if (null != params.get("attPkId")) {
            attPkId = params.get("attPkId").toString();
        }
        if (!name.contains(".")) {
            return;
        }
        String speSymbol = this.getAttachmentModel().checkSpeSymbol(name);
        if (StringUtils.isNotBlank((CharSequence)speSymbol)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u540d\u4e0d\u80fd\u5305\u542b\u4e0b\u5217\u4efb\u4f55\u5b57\u7b26\uff1a%s\u3002", (String)"AttachmentPanel_18", (String)"bos-svc-metadata", (Object[])new Object[0]), speSymbol));
            return;
        }
        String ext = name.substring(name.lastIndexOf(46) + 1);
        String fileName = name.substring(0, name.lastIndexOf(46));
        fileName = fileName.trim();
        for (String symbol : SPECIAL_SYMBOLARRAY) {
            if (!fileName.contains(symbol)) continue;
            return;
        }
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return;
        }
        if (name.length() > 255) {
            fileName = fileName.substring(0, 255 - ext.length() - 1);
            name = fileName + "." + ext;
        }
        boolean isTemp = false;
        ArrayList<Map<String, Object>> attachs = new ArrayList<Map<String, Object>>();
        List<Map<String, Object>> tempAtts = this.getAttPageCache();
        if (tempAtts != null && tempAtts.size() > 0) {
            for (Map<String, Object> tempAtt : tempAtts) {
                if (!uid.equals(tempAtt.get(ATT_UID))) continue;
                oldName = (String)tempAtt.get(NAME);
                oldExt = oldName.substring(oldName.lastIndexOf(46));
                if (!name.endsWith(oldExt)) {
                    return;
                }
                tempAtt.put(NAME, name);
                isTemp = true;
                attachs.add(tempAtt);
                break;
            }
        }
        if (!isTemp) {
            for (Map<String, Object> attach : this.getAttachmentData()) {
                if (!uid.equals(attach.get(ATT_UID))) continue;
                oldName = (String)attach.get(NAME);
                oldExt = oldName.substring(oldName.lastIndexOf(46));
                if (!name.endsWith(oldExt)) {
                    return;
                }
                attach.put(NAME, name);
                attachs.add(attach);
                break;
            }
        }
        List<AttachmentInfo> infos = this.packageAttachmentInfoList(attachs);
        IAttachmentManagerService managerService = (IAttachmentManagerService)ServiceFactory.getService((String)I_ATTACHMENT_MANAGER_SERVICE);
        Map result = managerService.beforeDoOperation(infos, AttachmentOpType.Rename);
        boolean enable = (Boolean)result.get("enable");
        if (!enable) {
            this.getView().showErrorNotification((String)result.get("cancleMsg"));
            return;
        }
        if (!isTemp) {
            this.getAttachmentModel().rename(uid, name, attPkId);
        } else {
            this.setAttPageCache(tempAtts);
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(ATT_UID, uid);
        parameters.put(NAME, name);
        parameters.put("attPkId", attPkId);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(this.getKey(), "rename", new Object[]{parameters});
        managerService.afterDoOperation(infos, AttachmentOpType.Rename);
    }

    @KSMethod
    public void bindData(List<Map<String, Object>> data) {
        ArrayList<AttachmentInfo> infos;
        IAttachmentManagerService managerService = (IAttachmentManagerService)ServiceFactory.getService((String)I_ATTACHMENT_MANAGER_SERVICE);
        if (data != null && data.size() > 0) {
            infos = this.packageAttachmentInfoList(data);
        } else {
            infos = new ArrayList(1);
            AttachmentInfo attachmentInfo = new AttachmentInfo();
            attachmentInfo.setAttSourceType(AttachmentType.attachmentpanel);
            String string = FormMetadataCache.getFormConfig((String)this.getModel().getDataEntityType().getName()).getEntityTypeId();
            attachmentInfo.setEntityNum(string);
            attachmentInfo.setAttKey(this.getKey());
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            attachmentInfo.setBillPkId(pkValue == null ? "" : pkValue.toString());
            boolean isWeb = !"mobile".equals(RequestContext.get().getClient()) && !(this.getView() instanceof IMobileView);
            attachmentInfo.setClient(isWeb ? "web" : "mobile");
            attachmentInfo.setWriteMapping(false);
            infos.add(attachmentInfo);
        }
        infos = managerService.beforeSendData(infos);
        this.packageAttachmentMapList(infos, data);
        if (data != null) {
            for (Map map : data) {
                AttachmentPanel.dealBotpUrl(map);
                this.getMd54Mobile(map);
            }
            this.addCreateTimeStr(data);
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        Map map = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam());
        if (Boolean.parseBoolean((String)map.get("Attachment_LOG_EXT"))) {
            log.info("kd.bos.form.control.AttachmentPanel.bindData() --- " + SerializationUtils.toJsonString(data));
        }
        clientViewProxy.setEntryProperty(this.getKey(), "data", data);
        if (AttachmentManageUtil.needEncrypt(this.view, false)) {
            AttachmentManageUtil.addAction(clientViewProxy, this.getView());
        }
    }

    private void addCreateTimeStr(List<Map<String, Object>> data) {
        for (Map<String, Object> attachmentMap : data) {
            Object time = attachmentMap.get("createdate");
            if (!(time instanceof Long)) continue;
            String createTimeStr = KDDateFormatUtils.getDateTimeFormat((TimeZone)KDDateUtils.getUserTimeZone()).format(time);
            attachmentMap.put("createtimestr", createTimeStr);
        }
    }

    private void getMd54Mobile(Map<String, Object> att) {
        if (this.getView() instanceof IMobileView) {
            try {
                String path = (String)att.get(ATT_URL);
                att.put(ATT_MD5, AttachmentManageUtil.getAttMd5(att, FileSource.ATTACHMENT_PANEL.getCode()));
                att.put(ATT_URL, FileServiceExtensionUtil.getDownloadUrl((String)path));
            }
            catch (IOException e) {
                log.error("\u83b7\u53d6\u6587\u4ef6MD5\u503c\u5931\u8d25 \uff1a " + att.get(ATT_URL));
            }
        }
    }

    private static void dealBotpUrl(Map<String, Object> attachmentMap) {
        if (null != attachmentMap.get("tempBotpAttachment") && attachmentMap.get("tempBotpAttachment") instanceof Boolean && ((Boolean)attachmentMap.get("tempBotpAttachment")).booleanValue()) {
            log.info("attachment data is from botp");
            String url = (String)attachmentMap.get(ATT_URL);
            String previewUrl = (String)attachmentMap.get(PREVIEWURL);
            String path = UrlUtil.getParam((String)url, (String)"path");
            if (StringUtils.isEmpty((CharSequence)path)) {
                if (StringUtils.isNotBlank((CharSequence)url)) {
                    attachmentMap.put(ATT_URL, UrlService.getAttachmentFullUrl((String)url));
                }
                if (StringUtils.isNotBlank((CharSequence)previewUrl)) {
                    attachmentMap.put(PREVIEWURL, UrlService.getAttachmentPreviewUrl((String)previewUrl));
                }
            }
        }
    }

    public void bindData(BindingContext bctx) {
        IPageCache pageCache = this.getView().getPageCache();
        long currUserId = RequestContext.get().getCurrUserId();
        String entityNum = AttachmentKit.getPermissionEntityNum(this.getView());
        FilePremissionUtil.allPermissionQuery((IPageCache)pageCache, (String)this.getKey(), (Long)currUserId, (String)entityNum, (IClientViewProxy)this.clientViewProxy, (IFormView)this.getView());
        boolean hasPermission = FilePremissionUtil.hasAttachmentOpPermission((String)entityNum, (String)"2NJ6+I0X0CJ8", (IFormView)this.getView(), (boolean)false, (String)this.getKey(), (IClientViewProxy)this.clientViewProxy);
        if (!hasPermission) {
            return;
        }
        List<Map<String, Object>> data = this.getListData();
        this.setInitDragSeq(data);
        this.resortAtt(data);
        this.bindData(data);
        this.clientViewProxy.invokeControlMethod(this.getKey(), "setCollapse", new Object[]{this.isDefaultCollapse() && data.isEmpty()});
        super.bindData(bctx);
    }

    private void resortAtt(List<Map<String, Object>> data) {
        if (this.dragAtm) {
            data.sort(Comparator.comparingInt(o -> (Integer)o.get(DRAGSEQ)));
        }
    }

    private void setInitDragSeq(List<Map<String, Object>> data) {
        boolean needInitSeq;
        boolean bl = needInitSeq = data.stream().filter(i -> i.get(DRAGSEQ) != null && Integer.parseInt(i.get(DRAGSEQ).toString()) == 0).limit(2L).count() > 1L;
        if (needInitSeq) {
            for (int i2 = 0; i2 < data.size(); ++i2) {
                data.get(i2).put(DRAGSEQ, i2);
            }
            AttachmentServiceHelper.saveDragSeq(data);
        }
    }

    @KSMethod
    public void addAttachOperaBtn(List<AttachBtnOption> buttons) {
        this.clientViewProxy.invokeControlMethod(this.getKey(), "addAttachOperaBtn", new Object[]{buttons});
    }

    @KSMethod
    public void attachOperaClick(Map<String, Object> paras) {
        String operaKey = (String)paras.get("operaKey");
        Object attachmentInfo = paras.get("args");
        AttachmentOperaClickEvent e = new AttachmentOperaClickEvent((Object)this, operaKey, attachmentInfo);
        for (AttachmentOperaClickListener l : this.operaClickListener) {
            l.attachmentOperaClick(e);
        }
    }

    public List<Map<String, Object>> getAttachmentData() {
        Long pkId;
        IDataModel model = this.getModel();
        ISimpleProperty priKey = model.getDataEntityType().getPrimaryKey();
        Long l = pkId = priKey == null ? Long.valueOf(0L) : model.getDataEntity().get((IDataEntityProperty)priKey);
        if (StringUtils.isBlank((Object)pkId) || pkId instanceof Long && pkId == 0L) {
            return this.getAttPageCache();
        }
        boolean isMobileView = this.getView() instanceof IMobileView;
        List<Map<String, Object>> data = this.getAttachmentModel().getData(model, this.getKey(), this.entityId, isMobileView, this.getDragAtm());
        List<Map<String, Object>> tempAtts = this.getAttPageCache();
        data.addAll(tempAtts);
        IAttachmentService service = (IAttachmentService)ServiceFactory.getService(IAttachmentService.class);
        Map setting = service.getAttSetting();
        if (Boolean.parseBoolean(String.valueOf(setting.get("yzjprevier"))) && isMobileView) {
            for (Map<String, Object> att : data) {
                if (StringUtils.isBlank((Object)att.get(PREVIEWURL))) continue;
                att.put(PREVIEWURL, this.genYzjMobPreviewUrl(att.get(PREVIEWURL).toString()));
            }
        }
        return data;
    }

    private String genYzjMobPreviewUrl(String url) {
        return url + "&isMobClient=true";
    }

    private List<Map<String, Object>> getListData() {
        if (StringUtils.isNotBlank((CharSequence)this.attachmentCountField)) {
            this.getModel().setValue(this.attachmentCountField, (Object)this.getAttachmentData().size());
        }
        List<Map<String, Object>> listData = this.getAttachmentData();
        for (Map<String, Object> att : listData) {
            String fileName;
            Object name = att.get(NAME);
            if (StringUtils.isBlank((Object)name) || (fileName = String.valueOf(name)).lastIndexOf(46) < 0) continue;
            String type = fileName.substring(fileName.lastIndexOf(46) + 1);
            att.put("type", type);
            this.setPreviewUrl(att);
        }
        return listData;
    }

    private boolean enableYzjPreview() {
        IAttachmentService service = (IAttachmentService)ServiceFactory.getService(IAttachmentService.class);
        Map setting = service.getAttSetting();
        return Boolean.parseBoolean(String.valueOf(setting.get("yzjpreview")));
    }

    private List<Map<String, Object>> getAttPageCache() {
        Map attachmentInfo;
        List tempAtts;
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        String cacheJsonString = cache.get(TAMP_ATT_CACHE + this.getView().getPageId());
        if (!StringUtils.isEmpty((CharSequence)cacheJsonString) && (tempAtts = (List)(attachmentInfo = (Map)SerializationUtils.fromJsonString((String)cacheJsonString, Map.class)).get(this.getKey())) != null) {
            return tempAtts;
        }
        return new ArrayList<Map<String, Object>>();
    }

    private void setAttPageCache(List<Map<String, Object>> tempAtts) {
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        String cacheJsonString = cache.get(TAMP_ATT_CACHE + this.getView().getPageId());
        Map<String, List<Map<String, Object>>> attachmentInfo = new HashMap<String, List<Map<String, Object>>>();
        if (!StringUtils.isEmpty((CharSequence)cacheJsonString)) {
            attachmentInfo = (Map)SerializationUtils.fromJsonString((String)cacheJsonString, Map.class);
        }
        attachmentInfo.put(this.getKey(), tempAtts);
        cacheJsonString = SerializationUtils.toJsonString(attachmentInfo);
        cache.put(TAMP_ATT_CACHE + this.getView().getPageId(), cacheJsonString);
    }

    @KSMethod
    public IAttachmentModel getAttachmentModel() {
        if (this.attachmentModel == null) {
            this.attachmentModel = (IAttachmentModel)TypesContainer.createInstance((String)"kd.bos.mvc.list.AttachmentModel");
        }
        return this.attachmentModel;
    }

    @KSMethod
    @SimplePropertyAttribute
    public String getAttachmentCountField() {
        return this.attachmentCountField;
    }

    @KSMethod
    public void setAttachmentCountField(String attachmentCountField) {
        this.attachmentCountField = attachmentCountField;
    }

    @KSMethod
    @SimplePropertyAttribute(name="DefaultCollapse")
    public boolean isDefaultCollapse() {
        return this.defaultCollapse;
    }

    @KSMethod
    public void setDefaultCollapse(boolean defaultCollapse) {
        this.defaultCollapse = defaultCollapse;
    }

    @SimplePropertyAttribute
    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @SimplePropertyAttribute
    public boolean getDragAtm() {
        return this.dragAtm;
    }

    public void setDragAtm(boolean dragAtm) {
        this.dragAtm = dragAtm;
    }

    @KSMethod
    public void setCollapse(boolean value) {
        this.clientViewProxy.invokeControlMethod(this.getKey(), "setCollapse", new Object[]{value});
    }

    @KSMethod
    public void setCollapseable(boolean value) {
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put("collapsible", value);
        this.getView().updateControlMetadata(this.getKey(), data);
    }

    public void permissionQuery(Map<String, Object> args) {
        AttachmentKit.permissionQuery(this.getKey(), args, this.getView(), this.clientViewProxy);
    }

    public void beforeDownload(Map<String, Object> attach) {
        if (AttachmentManageUtil.needEncrypt(this.getView(), false)) {
            FormShowParameter showParameter = AttachmentManageUtil.getFormParameterForEncrypt("0");
            Object fileInfo = attach.get("fileInfo");
            if (null != fileInfo) {
                showParameter.setCloseCallBack(new CloseCallBack("kd.bos.form.control.AttachmentPanelEncrypt", "encryptDownloadAll"));
                showParameter.setCustomParam("encryptType", (Object)"3");
            } else {
                Object uid = attach.get(ATT_UID);
                showParameter.setCloseCallBack(new CloseCallBack("kd.bos.form.control.AttachmentPanelEncrypt", "encryptDownload"));
                showParameter.setCustomParam(ATT_UID, uid);
            }
            showParameter.setCustomParam("methodKey", (Object)this.getKey());
            this.getView().showForm(showParameter);
        }
    }

    public void previewByNewTab(Map<String, Object> params) {
        int activedIndex = (Integer)params.get("activedIndex");
        List attDatas = (List)params.get("panelData");
        boolean hasPermission = FilePremissionUtil.hasAttachmentOpPermission(null, (String)AttachmentKit.getPermissionEntityNum(this.getView()), (Object)AttachmentKit.getPermissionBillPkId(this.getView()), (String)"2NJ5XVVCMBCL", (IFormView)this.getView(), (boolean)false, (String)this.getKey(), (IClientViewProxy)this.clientViewProxy);
        FormShowParameter formParameterForNewTab = AttachmentKit.getFormParameterForNewTab(attDatas, activedIndex, hasPermission);
        this.getView().showForm(formParameterForNewTab);
    }

    public void getDisposableUrl(Map<String, Object> params) {
        String url = (String)params.get(ATT_URL);
        try {
            url = AttachmentControlUtil.generateDisposableUrl(url, AttachmentKit.getPermissionEntityNum(this.getView()), AttachmentKit.getPermissionBillPkId(this.getView()));
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u4e00\u6b21\u6027\u94fe\u63a5\u51fa\u9519\u3002", (Throwable)e);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put(ATT_URL, url);
        resultMap.put(ATT_UID, params.get(ATT_UID));
        this.clientViewProxy.invokeControlMethod(this.getKey(), "setDisposableUrl", new Object[]{resultMap});
    }
}

