/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.attachment.util.AttachExceptionHandler;
import kd.bos.attachment.util.AttachmentOpLogUtil;
import kd.bos.attachment.util.BillFileMappingWriter;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.form.BindingContext;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.attachment.common.AttachmentKit;
import kd.bos.form.container.Container;
import kd.bos.form.control.UrlUtil;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.control.events.WaterMarkEvent;
import kd.bos.form.control.events.WaterMarkListener;
import kd.bos.form.picture.common.PictureKit;
import kd.bos.mservice.attachment.AttachmentInfo;
import kd.bos.mservice.attachment.AttachmentOpType;
import kd.bos.mservice.attachment.AttachmentType;
import kd.bos.mservice.attachment.FieldType;
import kd.bos.mservice.attachment.IAttachmentManagerService;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.bos.svc.util.ImageUrlUtil;
import kd.bos.web.actions.utils.FilePathUtil;
import kd.sdk.annotation.SdkPublic;
import org.apache.log4j.Logger;

@KSObject
@DataEntityTypeAttribute(name="kd.bos.form.control.ImageList")
@SdkPublic
public class ImageList
extends Container {
    private static Logger log = Logger.getLogger(ImageList.class);
    protected List<UploadListener> uploadListeners = new ArrayList<UploadListener>();
    private static final String I_ATTACHMENT_MANAGER_SERVICE = "IAttachmentManagerService";
    protected List<WaterMarkListener> waterMarkListeners = new ArrayList<WaterMarkListener>();
    private static final String IMAGE_LIST_UPLOADING_KEY = "ImageList_UploadingImg:";

    public void addWaterMarkListener(WaterMarkListener listener) {
        this.waterMarkListeners.add(listener);
    }

    @KSMethod
    public void addUploadListener(UploadListener listener) {
        this.uploadListeners.add(listener);
    }

    public void upload(List<Object> infos) {
        log.info((Object)"\u89e6\u53d1 - > \u4e0a\u4f20\u4e8b\u4ef6");
        ArrayList<String> urls = new ArrayList<String>(10);
        ArrayList<String> names = new ArrayList<String>(10);
        ArrayList<AttachmentInfo> attInfos = new ArrayList<AttachmentInfo>(infos.size());
        for (Object object : infos) {
            Map imageinfo = (Map)object;
            String url = (String)imageinfo.get("url");
            String name = (String)imageinfo.get("name");
            urls.add(url);
            names.add(name);
            AttachmentInfo attInfo = AttachmentOpLogUtil.packageAttachmentInfo((IFormView)this.getView(), (String)this.getKey(), (FieldType)FieldType.Image, (AttachmentType)AttachmentType.image, (String)url);
            attInfos.add(attInfo);
        }
        BillFileMappingWriter.syncWriteFileBillMapping(attInfos);
        for (Object object : urls) {
            if (!(object instanceof String) || !StringUtils.isNotEmpty((CharSequence)object.toString())) continue;
            UrlUtil.cacheTempFilePermissionParam((String)object.toString(), (String)this.view.getFormShowParameter().getFormId(), (String)this.view.getFormShowParameter().getServiceAppId());
        }
        IAttachmentManagerService managerService = (IAttachmentManagerService)ServiceFactory.getService((String)I_ATTACHMENT_MANAGER_SERVICE);
        managerService.afterDoOperation(attInfos, AttachmentOpType.Upload);
        UploadEvent uploadEvent = new UploadEvent((Object)this, urls.toArray(), names.toArray(), null, this.getKey());
        this.fireUpload(uploadEvent);
    }

    public void remove(List<Object> items) {
        String entityNum = AttachmentKit.getPermissionEntityNum(this.getView());
        IPageCache pageCache = this.getView().getPageCache();
        Object pkId = this.getView().getModel().getDataEntity().getPkValue();
        String removeKey = "TempRemoveCache" + this.getView().getPageId();
        List<HashMap> cacheList = new ArrayList(10);
        String removeStr = pageCache.get(removeKey);
        if (StringUtils.isNotBlank((CharSequence)removeStr)) {
            cacheList = (List)SerializationUtils.fromJsonString((String)removeStr, List.class);
        }
        log.info((Object)"\u89e6\u53d1 - > \u5220\u9664\u4e8b\u4ef6");
        ArrayList<String> urls = new ArrayList<String>(10);
        ArrayList indexs = new ArrayList(10);
        for (Object item : items) {
            HashMap imageInfo;
            block5: {
                imageInfo = (HashMap)item;
                String url = String.valueOf(imageInfo.get("url"));
                Object index = imageInfo.get("index");
                indexs.add(index);
                urls.add(url);
                try {
                    url = FilePathUtil.dealPath((String)url, (String)"image");
                }
                catch (KDException e) {
                    if (!AttachExceptionHandler.dealException((KDException)e, (IFormView)this.getView(), (String)entityNum, (String)"permItem").booleanValue()) break block5;
                    return;
                }
            }
            if (!this.getView().getModel().getDataEntity().getDataEntityState().getFromDatabase()) {
                PictureKit.removePicture(imageInfo, pkId, this.getView());
                continue;
            }
            cacheList.add(imageInfo);
            String cacheMapToString = SerializationUtils.toJsonString(cacheList);
            pageCache.put(removeKey, cacheMapToString);
        }
        UploadEvent e = new UploadEvent((Object)this, urls.toArray(), indexs.toArray(), this.getKey());
        this.fireRemove(e);
    }

    public void afterReOrder(Map<String, Object> imageReOrderInfo) {
        int startIndex = (Integer)imageReOrderInfo.get("startIndex");
        int destinationIndex = (Integer)imageReOrderInfo.get("destinationIndex");
        UploadEvent e = new UploadEvent((Object)this, startIndex, destinationIndex);
        this.fireAfterReOrder(e);
    }

    private void fireUpload(UploadEvent e) {
        if (this.uploadListeners != null) {
            for (UploadListener l : this.uploadListeners) {
                l.upload(e);
            }
        }
    }

    private void fireAfterReOrder(UploadEvent e) {
        if (this.uploadListeners != null) {
            for (UploadListener l : this.uploadListeners) {
                l.afterReOrder(e);
            }
        }
    }

    private void fireRemove(UploadEvent e) {
        if (this.uploadListeners != null) {
            for (UploadListener l : this.uploadListeners) {
                l.remove(e);
            }
        }
    }

    public void bindData(BindingContext object) {
        log.info((Object)object);
    }

    @KSMethod
    public void setImageUrls(String[] urls) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setFieldProperty(this.getKey(), "v", (Object)urls);
    }

    public void setShowWaterMark(boolean isShowWaterMark) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("show", isShowWaterMark);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(this.getKey(), "setShowWaterMark", new Object[]{map});
    }

    public void getWaterMarkInfos() {
        if (this.waterMarkListeners != null) {
            WaterMarkEvent evt = new WaterMarkEvent((Object)this);
            for (WaterMarkListener l : this.waterMarkListeners) {
                l.getWaterMarkInfos(evt);
            }
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
            clientViewProxy.invokeControlMethod(this.getKey(), "setWaterMarkInfos", new Object[]{evt.getMap()});
        }
    }

    public void getImagePreviewUrl(List<String> urlList) {
        urlList = ImageUrlUtil.getImageFreeUrl(urlList);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        log.info((Object)("kd.bos.form.control.ImageList#getImagePreviewUrl imageFreeUrl--- " + SerializationUtils.toJsonString((Object)urlList)));
        clientViewProxy.invokeControlMethod(this.getKey(), "imageFreeUrl", new Object[]{urlList});
    }

    public void postBack(Object value) {
        int i;
        super.postBack(value);
        if (value == null) {
            return;
        }
        if (!(value instanceof List)) {
            return;
        }
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        String cacheKey = IMAGE_LIST_UPLOADING_KEY + this.getView().getPageId();
        List postData = (List)value;
        ArrayList<String> uploadingImgList = new ArrayList<String>(10);
        List imageDatas = new ArrayList();
        for (i = 0; i < postData.size(); ++i) {
            Map uploadingImages = (Map)postData.get(i);
            imageDatas = (List)uploadingImages.get("uploading");
        }
        for (i = 0; i < imageDatas.size(); ++i) {
            Map imageData = (Map)imageDatas.get(i);
            String uid = (String)imageData.get("uid");
            uploadingImgList.add(uid);
        }
        if (uploadingImgList.size() == 0) {
            cache.remove(cacheKey);
            return;
        }
        cache.put(cacheKey, SerializationUtils.toJsonString(uploadingImgList));
    }
}

