/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.attachment.util.CacheKey;
import kd.bos.bill.IBillView;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IAttachmentFieldModel;
import kd.bos.entity.param.CustomParam;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.attachment.common.AttachmentKit;
import kd.bos.form.attachment.util.AttachmentControlUtil;
import kd.bos.form.attachment.util.AttachmentManageUtil;
import kd.bos.form.attachment.util.AttachmentPreviewUtil;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AttachBtnOption;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SubEntryGrid;
import kd.bos.form.control.events.AttachmentDownLoadEvent;
import kd.bos.form.control.events.AttachmentDownloadListener;
import kd.bos.form.control.events.AttachmentMarkEvent;
import kd.bos.form.control.events.AttachmentMarkListener;
import kd.bos.form.control.events.AttachmentOperaClickEvent;
import kd.bos.form.control.events.AttachmentOperaClickListener;
import kd.bos.form.control.events.AttachmentPreviewEvent;
import kd.bos.form.control.events.AttachmentPreviewListener;
import kd.bos.form.control.events.BeforeAttachmentRemoveEvent;
import kd.bos.form.control.events.BeforeAttachmentRemoveListener;
import kd.bos.form.control.events.BeforeAttachmentUploadEvent;
import kd.bos.form.control.events.BeforeAttachmentUploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.AttachmentInfo;
import kd.bos.mservice.attachment.AttachmentOpType;
import kd.bos.mservice.attachment.AttachmentRemoveSource;
import kd.bos.mservice.attachment.AttachmentType;
import kd.bos.mservice.attachment.FieldType;
import kd.bos.mservice.attachment.IAttachmentManagerService;
import kd.bos.mservice.attachment.IAttachmentService;
import kd.bos.mservice.svc.attach.IAttachmentEdit;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.attachment.FileSource;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.url.UrlService;
import kd.bos.web.actions.utils.FilePremissionUtil;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.collections4.MapUtils;

@SdkPublic
@KSObject
@DataEntityTypeAttribute(name="kd.bos.form.field.AttachmentEdit")
public class AttachmentEdit
extends MulBasedataEdit
implements IAttachmentEdit {
    private static final Log log = LogFactory.getLog(AttachmentEdit.class);
    private static final String DRAG_SEQ = "dragseq";
    private static DistributeSessionlessCache distributeCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));
    private static final String BOS_SVC_METADATA = "bos-svc-metadata";
    private static final String ATT_DELETE = "delete";
    private static final String ATT_STATUS = "status";
    private static final String ATT_UID = "uid";
    private static final String ATT_UIDLIST = "uidList";
    private static final String ATT_URL = "url";
    private static final String ATT_TYPE = "type";
    private static final String ATT_SIZE = "size";
    private static final String ATT_PREVIEW_URL = "previewurl";
    private static final String ATT_TEMPFILE = "tempfile";
    private static final String ATT_CREATOR = "creator";
    private static final String ATT_DESCRIPTION = "description";
    private static final String ATT_NAME = "name";
    private static final String ATT_MD5 = "md5";
    private static final String ISCHANGED = "isChanged";
    private static final String ROW_INDEX = "rowIndex";
    private static final String ATT_MSG = "msg";
    private static final String CAN_REMOVE = "canRemove";
    private static final String CAN_UPLOAD = "canUpload";
    private static final String ATT_UPLOADING = "uploading";
    private static final String ATT_SUCCESS = "success";
    private static final String ATT_ERROR = "error";
    private static final String ATT_CANCEL = "canceled";
    private static final String ATT_UPLOADING_STATUS = "A";
    private static final String ATT_SUCCESS_STATUS = "B";
    private static final String ATT_ERROR_STATUS = "C";
    private static final String ATT_CANCEL_STATUS = "D";
    private static final String ATT_ENTRYGRID_UPLOADVIEW_FORMID = "bos_entryattach_upload";
    private static final String ATT_ENTRYGRID_CLOSEBACK_KEY = "entrygridattachment";
    private static final String ATT_FIELD_MOB = "bos_mobtb_attfield_upload";
    private static final String ATT_ENTITYID = "bd_attachment";
    private static final String ATT_ID = "id";
    private static final int ATT_OFFICIAL = 1;
    private static final String ENTITY_NUM = "entityNum";
    private static final String LOG_ENTITY_NUM = "logEntityNum";
    private static final String LOG_APPID = "logAppId";
    private static final String APPID = "appid";
    private static final String BILL_PK_ID = "billPkId";
    private static final String ATT_KEY = "attKey";
    private static final String ATT_BILLNO = "billno";
    private static final String BILL_ENTRY_PKID = "billentrypkid";
    private static final String IS_FROM_SUB_ENTRY = "isFromSubEntry";
    private static final String DOWNLOAD_DO = "download.do";
    private static final String PREVIEW_DO = "preview.do";
    private static final String PREVIEWURL = "previewurl";
    private static final String I_ATTACHMENT_MANAGER_SERVICE = "IAttachmentManagerService";
    private static final String[] SPECIAL_SYMBOLARRAY = "/,\\,*,\",?,:,<,>,|,..\\,../".split(",");
    private IAttachmentFieldModel attachmentModel;
    private String tableName;
    private boolean hasDelete = false;
    protected List<BeforeAttachmentUploadListener> beforeUploadListeners = new ArrayList<BeforeAttachmentUploadListener>(10);
    protected List<BeforeAttachmentRemoveListener> beforeRemoveListeners = new ArrayList<BeforeAttachmentRemoveListener>(10);
    protected List<AttachmentMarkListener> markListeners = new ArrayList<AttachmentMarkListener>(10);
    protected List<AttachmentDownloadListener> downloadListener = new ArrayList<AttachmentDownloadListener>(10);
    protected List<AttachmentPreviewListener> previewListener = new ArrayList<AttachmentPreviewListener>(10);
    protected List<AttachmentOperaClickListener> operaClickListener = new ArrayList<AttachmentOperaClickListener>(10);

    @KSMethod
    public void addBeforeUploadListener(BeforeAttachmentUploadListener listener) {
        this.beforeUploadListeners.add(listener);
    }

    @KSMethod
    public void addBeforeRemoveListener(BeforeAttachmentRemoveListener listener) {
        this.beforeRemoveListeners.add(listener);
    }

    @KSMethod
    public void addMarkListener(AttachmentMarkListener listener) {
        this.markListeners.add(listener);
    }

    @KSMethod
    public void addDownloadListener(AttachmentDownloadListener listener) {
        this.downloadListener.add(listener);
    }

    @KSMethod
    public void addPreviewListener(AttachmentPreviewListener listener) {
        this.previewListener.add(listener);
    }

    @KSMethod
    public void addOperaClickListener(AttachmentOperaClickListener listener) {
        this.operaClickListener.add(listener);
    }

    @KSMethod
    public IAttachmentFieldModel getAttachmentModel() {
        if (this.attachmentModel == null) {
            this.attachmentModel = (IAttachmentFieldModel)TypesContainer.createInstance((String)"kd.bos.mvc.attachment.AttachmentFieldModel");
        }
        return this.attachmentModel;
    }

    @SimplePropertyAttribute
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void beforeUpload(List<Map<String, Object>> attachs) {
        if (CollectionUtils.isEmpty(attachs)) {
            return;
        }
        String entityNum = AttachmentKit.getPermissionEntityNum(this.getView());
        Object billPkId = this.getView().getModel().getDataEntity().getPkValue();
        FilePremissionUtil.hasAttachmentOpPermission(null, (String)entityNum, (Object)billPkId, (String)"2NJ5SR4NUEJ=", (IFormView)this.getView(), (boolean)false, (String)this.getKey(), (IClientViewProxy)this.clientViewProxy);
        BeforeAttachmentUploadEvent evt = new BeforeAttachmentUploadEvent((Object)this, attachs);
        AttachmentKit.fireBeforeUpload(this.getKey(), evt, this.beforeUploadListeners, this.clientViewProxy, this.getView());
        this.cacheUploadingAttachs(attachs);
    }

    private void cacheUploadingAttachs(List<Map<String, Object>> attachs) {
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        String cacheKey = "UploadingAtt" + this.getView().getPageId();
        List<String> uploadingAttList = this.getUploadingAttachCacheList(cache, cacheKey);
        for (Map<String, Object> attach : attachs) {
            if (uploadingAttList.contains((String)attach.get(ATT_UID))) continue;
            uploadingAttList.add((String)attach.get(ATT_UID));
        }
        cache.put(cacheKey, SerializationUtils.toJsonString(uploadingAttList));
    }

    private List<String> getUploadingAttachCacheList(IPageCache cache, String cacheKey) {
        String uploadingAttJson = cache.get(cacheKey);
        if (uploadingAttJson != null) {
            return SerializationUtils.fromJsonStringToList((String)uploadingAttJson, String.class);
        }
        return new ArrayList<String>(10);
    }

    public void uploadResult(List<Map<String, Object>> attachs) {
        log.info("kd.bos.form.field.AttachmentEdit.uploadResult attachs : " + SerializationUtils.toJsonString(attachs));
        String cacheKey = "UploadingAtt" + this.getView().getPageId();
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        String uploadingAttJson = cache.get(cacheKey);
        if (uploadingAttJson == null) {
            return;
        }
        List uploadingAttList = SerializationUtils.fromJsonStringToList((String)uploadingAttJson, String.class);
        ArrayList<Map<String, Object>> cancelAtts = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> attach : attachs) {
            if (!ATT_UPLOADING.equals(attach.get(ATT_STATUS))) {
                String attUid = (String)attach.get(ATT_UID);
                uploadingAttList.remove(attUid);
            }
            if (ATT_CANCEL.equals(attach.get(ATT_STATUS))) {
                cancelAtts.add(attach);
            }
            AttachmentKit.cacheTempFileParam(attach, this.getView());
        }
        if (uploadingAttList.size() == 0) {
            cache.remove(cacheKey);
        } else {
            cache.put(cacheKey, SerializationUtils.toJsonString((Object)uploadingAttList));
        }
        this.updateCancelAttStatus(cancelAtts);
    }

    private void updateCancelAttStatus(List<Map<String, Object>> cancelAttachments) {
        if (CollectionUtils.isEmpty(cancelAttachments)) {
            return;
        }
        ArrayList<String> uidAttachments = new ArrayList<String>(cancelAttachments.size());
        for (Map<String, Object> cancelAttachment : cancelAttachments) {
            Object uid = cancelAttachment.get(ATT_UID);
            if (!StringUtils.isNotBlank((Object)uid)) continue;
            uidAttachments.add((String)uid);
        }
        Map dyColl = BusinessDataServiceHelper.loadFromCache((String)ATT_ENTITYID, (QFilter[])new QFilter[]{new QFilter(ATT_UID, "in", uidAttachments)});
        if (MapUtils.isEmpty((Map)dyColl)) {
            return;
        }
        Collection values = dyColl.values();
        for (DynamicObject value : values) {
            value.set(ATT_STATUS, (Object)ATT_CANCEL_STATUS);
        }
        SaveServiceHelper.update((DynamicObject[])((DynamicObject[])values.stream().filter(item -> item.getPkValue() instanceof Long && (Long)item.getPkValue() != 0L).toArray(DynamicObject[]::new)));
    }

    public void postBack(Object value, int rowIndex, int parentRowIndex) {
        log.info("kd.bos.form.field.AttachmentEdit.postBack value : " + SerializationUtils.toJsonString((Object)value) + " , rowIndex : " + rowIndex + " , parentRowIndex : " + parentRowIndex);
        String cachekey = this.getCacheKey(parentRowIndex, rowIndex);
        List<Map<String, Object>> valueList = (List<Map<String, Object>>)value;
        valueList = this.setBillProperty(valueList);
        List<Map<String, Object>> saveValue = this.deleteAttachments(valueList, cachekey, rowIndex);
        List<DynamicObject> attObjs = this.saveTempAttachments(saveValue);
        this.setAttachmentIdString(value, attObjs, rowIndex, cachekey);
        this.uploadResult(valueList);
        if (this.hasDelete) {
            int attIndex = this.getModel().getProperty(this.getFieldKey()).getOrdinal();
            this.getModel().getDataEntity().getDataEntityState().setBizChanged(attIndex, false);
        }
    }

    public void afterReOrder(Map<String, Object> reOrderInfo) {
        String cacheKey;
        DynamicObject attDyn;
        int i;
        AttachmentProp attachmentProp = (AttachmentProp)this.getProperty();
        if (!attachmentProp.getDragAtm()) {
            Object dragAtm = this.getView().getFormShowParameter().getCustomParam("dragAtm");
            if (dragAtm == null) {
                return;
            }
            if (!Boolean.parseBoolean(dragAtm.toString())) {
                return;
            }
        }
        DynamicObjectCollection dynColl = this.getAttachColl(reOrderInfo);
        for (int i2 = 0; i2 < dynColl.size(); ++i2) {
            DynamicObject attDyn2 = (DynamicObject)((DynamicObject)dynColl.get(i2)).get("fbasedataid");
            attDyn2.set(DRAG_SEQ, (Object)i2);
        }
        int startIndex = (Integer)reOrderInfo.get("startIndex");
        int destinationIndex = (Integer)reOrderInfo.get("destinationIndex");
        if (destinationIndex > startIndex) {
            for (i = 0; i < dynColl.size(); ++i) {
                attDyn = (DynamicObject)((DynamicObject)dynColl.get(i)).get("fbasedataid");
                if (startIndex < i && i < destinationIndex) {
                    attDyn.set(DRAG_SEQ, (Object)(i - 1));
                    continue;
                }
                if (i != startIndex) continue;
                attDyn.set(DRAG_SEQ, (Object)(destinationIndex - 1));
            }
        }
        if (destinationIndex < startIndex) {
            for (i = 0; i < dynColl.size(); ++i) {
                attDyn = (DynamicObject)((DynamicObject)dynColl.get(i)).get("fbasedataid");
                if (i == startIndex) {
                    attDyn.set(DRAG_SEQ, (Object)destinationIndex);
                    continue;
                }
                if (i < destinationIndex || i >= startIndex) continue;
                attDyn.set(DRAG_SEQ, (Object)(i + 1));
            }
        }
        dynColl.sort(Comparator.comparingInt(o -> o.getDynamicObject("fbasedataid").getInt(DRAG_SEQ)));
        List<DynamicObject> attObjs = dynColl.stream().map(o -> o.getDynamicObject("fbasedataid")).collect(Collectors.toList());
        if (StringUtils.isNotEmpty((CharSequence)attachmentProp.getParent().getName()) && StringUtils.equals((CharSequence)ATT_ENTRYGRID_UPLOADVIEW_FORMID, (CharSequence)attachmentProp.getParent().getName())) {
            cacheKey = this.getCacheKey(-1, -1);
            Object[] attIds = this.getCacheAttachIds(null, attObjs, cacheKey);
            for (DynamicObject dynamicObject : dynColl) {
                dynamicObject.getDynamicObject("fbasedataid").set(DRAG_SEQ, null);
            }
            Object entryRow = this.getView().getFormShowParameter().getCustomParam("r");
            this.getModel().setValue(this.getFieldKey(), (Object)attIds, ((Integer)entryRow).intValue());
            return;
        }
        cacheKey = this.getCacheKey(-1, -1);
        Object[] attIds = this.getCacheAttachIds(null, attObjs, cacheKey);
        for (DynamicObject dynamicObject : dynColl) {
            dynamicObject.getDynamicObject("fbasedataid").set(DRAG_SEQ, null);
        }
        this.getModel().setValue(this.getFieldKey(), (Object)attIds);
    }

    private DynamicObjectCollection getAttachColl(Map<String, Object> params) {
        DynamicObjectCollection dynColl;
        if (this.isAnyEntryGridField()) {
            String entryKey = this.getEntryKey();
            DynamicObjectCollection entryCollection = this.getModel().getEntryEntity(entryKey);
            DynamicObject curEntryRow = params.get("curEntryRow") != null ? (DynamicObject)entryCollection.get(((Integer)params.get("curEntryRow")).intValue()) : (DynamicObject)entryCollection.get(this.getCurrentRowIndex());
            dynColl = (DynamicObjectCollection)curEntryRow.get(this.getFieldKey());
        } else {
            dynColl = (DynamicObjectCollection)this.getModel().getDataEntity().get(this.getFieldKey());
        }
        return dynColl;
    }

    private List<Map<String, Object>> setBillProperty(List<Map<String, Object>> valueList) {
        String entityNum = "";
        String billPkId = "";
        String attKey = "";
        String billno = "";
        String appId = "";
        boolean isWeb = !"mobile".equals(RequestContext.get().getClient()) && !(this.getView() instanceof IMobileView) && (!ATT_FIELD_MOB.equals(this.getView().getEntityId()) || !(this.getView().getParentView() instanceof IMobileView));
        String entityId = this.getView().getEntityId();
        if (ATT_ENTRYGRID_UPLOADVIEW_FORMID.equals(entityId) || ATT_FIELD_MOB.equals(entityId)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            entityNum = (String)formShowParameter.getCustomParam(LOG_ENTITY_NUM);
            billPkId = (String)formShowParameter.getCustomParam(BILL_PK_ID);
            attKey = (String)formShowParameter.getCustomParam(ATT_KEY);
            billno = (String)formShowParameter.getCustomParam(ATT_BILLNO);
            appId = (String)formShowParameter.getCustomParam(LOG_APPID);
        } else {
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)this.getModel().getDataEntityType().getName());
            entityNum = formConfig.getEntityTypeId();
            appId = formConfig.getAppId();
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            billPkId = pkValue == null ? "" : pkValue.toString();
            MainEntityType dataEntityType = this.getModel().getDataEntityType();
            if (dataEntityType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)((BillEntityType)dataEntityType).getBillNo())) {
                billno = this.getModel().getDataEntity().getString(((BillEntityType)dataEntityType).getBillNo());
            }
            attKey = this.getKey();
        }
        for (int i = 0; i < valueList.size(); ++i) {
            Map<String, Object> attMap = valueList.get(i);
            attMap.put(ENTITY_NUM, entityNum);
            attMap.put(BILL_PK_ID, billPkId);
            attMap.put(ATT_KEY, attKey);
            attMap.put(ATT_BILLNO, billno);
            attMap.put(APPID, appId);
            attMap.put("client", isWeb ? "web" : "mobile");
            if (!attMap.containsKey("filesource")) {
                attMap.put("filesource", 1);
            }
            attMap.putIfAbsent(DRAG_SEQ, i);
        }
        return valueList;
    }

    public void beforeRemove(Map<String, Object> attach) {
        Object billPkId;
        String entityNum = AttachmentKit.getPermissionEntityNum(this.getView());
        boolean hasPermission = FilePremissionUtil.hasAttachmentOpPermission(null, (String)entityNum, (Object)(billPkId = AttachmentKit.getPermissionBillPkId(this.getView())), (String)"2NJ5YJOIS+MJ", (IFormView)this.getView(), (boolean)true, (String)this.getKey(), (IClientViewProxy)this.clientViewProxy);
        if (!hasPermission) {
            return;
        }
        BeforeAttachmentRemoveEvent evt = new BeforeAttachmentRemoveEvent((Object)this, attach);
        for (BeforeAttachmentRemoveListener l : this.beforeRemoveListeners) {
            l.beforeAttachmentRemove(evt);
        }
        int rowIndex = -1;
        IDataEntityProperty property = this.getProperty();
        if (this.isEntryProperty(property)) {
            rowIndex = this.getCurrentRowIndex();
        }
        HashMap<String, Object> removeResult = new HashMap<String, Object>();
        if (evt.isCancel()) {
            removeResult.put(CAN_REMOVE, Boolean.FALSE);
            removeResult.put(ATT_UID, attach.get(ATT_UID));
            if (rowIndex != -1) {
                removeResult.put(ROW_INDEX, rowIndex);
            }
            if (StringUtils.isNotBlank((CharSequence)evt.getMsg())) {
                removeResult.put(ATT_MSG, evt.getMsg());
            }
            if (this.isEntryGridField()) {
                removeResult.put("tileAttField", this.getKey());
            }
        } else {
            removeResult.put(CAN_REMOVE, Boolean.TRUE);
            removeResult.put(ATT_UID, attach.get(ATT_UID));
            if (rowIndex != -1) {
                removeResult.put(ROW_INDEX, rowIndex);
            }
            if (this.isEntryGridField()) {
                removeResult.put("tileAttField", this.getKey());
            }
        }
        if (this.isEntryGridField()) {
            this.clientViewProxy.invokeControlMethod(this.getEntryKey(), "beforeRemove", new Object[]{removeResult});
            return;
        }
        this.clientViewProxy.invokeControlMethod(this.getKey(), "beforeRemove", new Object[]{removeResult});
    }

    @KSMethod
    public void addAttachOperaBtn(List<AttachBtnOption> buttons) {
        this.clientViewProxy.invokeControlMethod(this.getKey(), "addAttachOperaBtn", new Object[]{buttons});
    }

    @KSMethod
    public void attachOperaClick(Map<String, Object> paras) {
        String operaKey = (String)paras.get("operaKey");
        Object attachmentInfo = paras.get("args");
        AttachmentOperaClickEvent e = new AttachmentOperaClickEvent((Object)this, operaKey, attachmentInfo);
        for (AttachmentOperaClickListener l : this.operaClickListener) {
            l.attachmentOperaClick(e);
        }
    }

    public void openEntryUploadView(int row, boolean lock) {
        if (StringUtils.isBlank((CharSequence)this.getEntryKey())) {
            return;
        }
        EntryGrid grid = this.getEntryGrid();
        if (grid == null) {
            return;
        }
        if (grid instanceof CardEntry) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(ATT_ENTRYGRID_UPLOADVIEW_FORMID);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack();
        closeCallBack.setControlKey(this.getKey());
        closeCallBack.setActionId(ATT_ENTRYGRID_CLOSEBACK_KEY);
        formShowParameter.setCloseCallBack(closeCallBack);
        HashMap<String, Object> value = new HashMap<String, Object>(16);
        value.put("k", this.getKey());
        DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)this.getModel().getValue(this.getFieldKey(), row);
        ArrayList<Object> list = new ArrayList<Object>();
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            list.add(dynamicObject.get("fbasedataid_id"));
        }
        AttachmentProp prop = (AttachmentProp)this.getProperty();
        value.put("v", list);
        value.put("r", row);
        value.put("l", lock);
        value.put("tempAttPageId", this.getView().getPageId());
        value.put("maxAtmCount", prop.getMaxAtmCount());
        value.put("maxAtmSize", prop.getMaxAtmSize());
        value.put("extendName", prop.getExtendName());
        value.put("sortField", prop.getSortField());
        value.put("sortType", prop.getSortType());
        value.put("checkDuplicateFileName", prop.getCheckDuplicateFileName());
        value.put("dragAtm", prop.getDragAtm());
        value.put("attachmentPermission", this.getView().getPageCache().get("attachmentPermission"));
        value.put(ENTITY_NUM, this.getModel().getDataEntityType().getName());
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)this.getModel().getDataEntityType().getName());
        String logEntityNum = formConfig.getEntityTypeId();
        value.put(LOG_ENTITY_NUM, logEntityNum);
        value.put(LOG_APPID, formConfig.getAppId());
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        value.put(BILL_PK_ID, pkValue == null ? "" : pkValue.toString());
        value.put("billPkIdForPermission", pkValue == null ? "" : pkValue);
        value.put(ATT_KEY, this.getKey());
        String billno = "";
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        if (dataEntityType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)((BillEntityType)dataEntityType).getBillNo())) {
            billno = this.getModel().getDataEntity().getString(((BillEntityType)dataEntityType).getBillNo());
        }
        value.put(ATT_BILLNO, billno);
        value.put("tableName", this.getTableName());
        value.put(BILL_ENTRY_PKID, this.getModel().getEntryRowEntity(grid.getEntryKey(), row).getPkValue());
        value.put(IS_FROM_SUB_ENTRY, grid instanceof SubEntryGrid);
        formShowParameter.setCustomParams(value);
        this.getView().showForm(formShowParameter);
    }

    public void openEntryUploadView(int row) {
        this.openEntryUploadView(row, false);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (ATT_ENTRYGRID_CLOSEBACK_KEY.equals(e.getActionId())) {
            Map v = (Map)e.getReturnData();
            if (v == null) {
                return;
            }
            boolean dataChanged = Boolean.parseBoolean(String.valueOf(v.get(ISCHANGED)));
            if (dataChanged) {
                int row = (Integer)v.get("r");
                int attIndex = this.getModel().getProperty(this.getFieldKey()).getOrdinal();
                String entryName = this.getModel().getProperty(this.getFieldKey()).getParent().getName();
                DynamicObjectCollection oldAttDys = (DynamicObjectCollection)this.getModel().getEntryRowEntity(entryName, row).get(attIndex);
                List<Object> oldAttPks = oldAttDys.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
                if (this.key.equals(v.get("k"))) {
                    List data = (List)v.get("data");
                    this.getModel().setValue(this.getFieldKey(), (Object)data.toArray(), row);
                    this.getView().updateView(this.key, row);
                }
                DynamicObjectCollection newAttDys = (DynamicObjectCollection)this.getModel().getValue(this.getFieldKey());
                List<Object> newAttPks = oldAttDys.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
                if (this.hasDelete && this.notHasAdd(oldAttPks, newAttPks)) {
                    DynamicObjectCollection attDys = (DynamicObjectCollection)this.getModel().getEntryRowEntity(entryName, row).get(attIndex);
                    if (attDys.isEmpty()) {
                        this.getModel().getEntryRowEntity(entryName, row).getDataEntityState().setRemovedItems(Boolean.valueOf(false));
                        return;
                    }
                    for (DynamicObject attDy : attDys) {
                        attDy.getDataEntityState().setBizChanged(false);
                    }
                }
            }
        }
    }

    private boolean notHasAdd(List<Object> oldAttPks, List<Object> newAttPks) {
        if (oldAttPks == null || newAttPks == null) {
            return false;
        }
        if (newAttPks.size() > oldAttPks.size()) {
            return false;
        }
        return oldAttPks.contains(newAttPks);
    }

    private List<Map<String, Object>> deleteAttachments(List<Map<String, Object>> value, String cacheKey, int row) {
        Object billPkId;
        Map<String, Object> deleteAtts = null;
        for (Map<String, Object> att : value) {
            if (att.get(ATT_DELETE) == null || !Boolean.parseBoolean(att.get(ATT_DELETE).toString())) continue;
            deleteAtts = att;
            break;
        }
        if (deleteAtts == null) {
            return value;
        }
        String entityNum = AttachmentKit.getPermissionEntityNum(this.getView());
        boolean hasPermission = FilePremissionUtil.hasAttachmentOpPermission(null, (String)entityNum, (Object)(billPkId = AttachmentKit.getPermissionBillPkId(this.getView())), (String)"2NJ5YJOIS+MJ", (IFormView)this.getView(), (boolean)true, (String)this.getKey(), (IClientViewProxy)this.clientViewProxy);
        if (!hasPermission) {
            return value;
        }
        IAttachmentManagerService managerService = (IAttachmentManagerService)ServiceFactory.getService((String)I_ATTACHMENT_MANAGER_SERVICE);
        ArrayList<Map<String, Object>> deleteList = new ArrayList<Map<String, Object>>();
        deleteList.add(deleteAtts);
        List<AttachmentInfo> infos = this.packageAttachmentInfoList(deleteList);
        Map result = managerService.beforeDoOperation(infos, AttachmentOpType.Remove);
        boolean enable = (Boolean)result.get("enable");
        if (!enable) {
            this.getView().showErrorNotification((String)result.get("cancleMsg"));
            return value;
        }
        if (this.getView() instanceof IBillView) {
            if (this.isAnyEntryGridField()) {
                this.deletePlainAtt(row, deleteAtts);
            } else {
                this.getAttachmentModel().deleteAttachments(this.getModel().getDataEntityType().getName(), this.getTableName(), deleteAtts);
            }
        } else {
            this.getAttachmentModel().deleteAttachments(this.getModel().getDataEntityType().getName(), null, deleteAtts);
        }
        this.delSuccessUploadIdsCache(deleteAtts, cacheKey);
        value.remove(deleteAtts);
        if (!value.contains(deleteAtts)) {
            this.hasDelete = true;
        }
        managerService.afterDoOperation(infos, AttachmentOpType.Remove);
        return value;
    }

    private void deletePlainAtt(int row, Map<String, Object> deleteAtts) {
        IDataEntityProperty entry = this.getModel().getProperty(this.getEntryKey());
        EntryGrid grid = this.getEntryGrid();
        if (entry.getParent() == null || grid == null) {
            return;
        }
        Object entryPkId = this.getModel().getEntryRowEntity(grid.getEntryKey(), row).getPkValue();
        List<Object> deleteIds = this.genDeleteAttIds(deleteAtts);
        if (entry.getParent().getParent() == null) {
            AttachmentFieldServiceHelper.batchRemoveAtt(this.getModel().getDataEntityType().getName(), this.getTableName(), deleteIds.toArray(), new Object[]{entryPkId}, AttachmentRemoveSource.ENTRY, false);
            return;
        }
        AttachmentFieldServiceHelper.batchRemoveAtt(this.getModel().getDataEntityType().getName(), this.getTableName(), deleteIds.toArray(), new Object[]{entryPkId}, AttachmentRemoveSource.SUB_ENTRY, false);
    }

    private List<Object> genDeleteAttIds(Map<String, Object> deleteAtts) {
        ArrayList<Object> deleteIds = new ArrayList<Object>(10);
        QFilter[] filters = new QFilter[]{new QFilter(ATT_UID, "=", deleteAtts.get(ATT_UID))};
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)ATT_ENTITYID, (String)"id,url", (QFilter[])filters);
        if (null != obj) {
            deleteIds.add(obj.getPkValue());
        }
        return deleteIds;
    }

    private void setAttachmentIdString(Object value, List<DynamicObject> attObjs, int rowIndex, String cacheKey) {
        Object[] attIds = this.getCacheAttachIds(value, attObjs, cacheKey);
        IDataEntityProperty property = this.getProperty();
        if (this.isEntryProperty(property)) {
            this.getModel().setValue(this.getFieldKey(), (Object)attIds, rowIndex);
            return;
        }
        this.getModel().setValue(this.getFieldKey(), (Object)attIds);
    }

    private Object[] getCacheAttachIds(Object value, List<DynamicObject> attObjs, String cacheKey) {
        ArrayList res = new ArrayList(10);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        Map successAttIdsMap = new LinkedHashMap();
        Map<Object, Integer> nameToDragSeqMap = value != null ? ((List)value).stream().collect(Collectors.toMap(item -> item.get(ATT_UID), item -> Optional.ofNullable(item.get(DRAG_SEQ)).orElse(-1), (v1, v2) -> v1)) : attObjs.stream().collect(Collectors.toMap(item -> item.getString(ATT_UID), item -> (Integer)Optional.ofNullable(item.get(DRAG_SEQ)).orElse(-1), (v1, v2) -> v1));
        String successAttIdsMapJson = (String)proxy.getViewState(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)successAttIdsMapJson)) {
            if (MapUtils.isNotEmpty(nameToDragSeqMap) && nameToDragSeqMap.values().stream().filter(i -> i == 0).limit(2L).count() == 2L) {
                successAttIdsMap = (Map)JSON.parseObject((String)successAttIdsMapJson, HashMap.class);
            } else {
                successAttIdsMap = new TreeMap((o1, o2) -> {
                    if (nameToDragSeqMap.get(o1) != null && nameToDragSeqMap.get(o2) != null) {
                        return (Integer)nameToDragSeqMap.get(o1) - (Integer)nameToDragSeqMap.get(o2);
                    }
                    return 0;
                });
                successAttIdsMap.putAll((Map)JSON.parseObject((String)successAttIdsMapJson, TreeMap.class));
            }
        }
        for (int i2 = 0; i2 < attObjs.size(); ++i2) {
            Object uid = attObjs.get(i2).get(ATT_UID);
            if (successAttIdsMap.get(uid) != null) continue;
            successAttIdsMap.put(uid, attObjs.get(i2).getPkValue());
        }
        for (Map.Entry entry : successAttIdsMap.entrySet()) {
            res.add(entry.getValue());
        }
        proxy.postBack(cacheKey, (Object)JSON.toJSONString((Object)successAttIdsMap));
        return res.toArray();
    }

    private String getCacheKey(int parentIndex, int currRowIndex) {
        String fieldKey = this.getFieldKey();
        CacheKey key = new CacheKey(parentIndex, currRowIndex, fieldKey, this.getView().getPageId(), "SuccessAttIds");
        String cacheKey = SerializationUtils.toJsonString((Object)key);
        this.cacheKey(fieldKey, cacheKey);
        return cacheKey;
    }

    private void cacheKey(String fieldKey, String key) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        Object jsonString = proxy.getViewState("attach_" + fieldKey);
        Set<String> cacheKeySet = new HashSet<String>(16);
        if (StringUtils.isNotBlank((Object)jsonString)) {
            cacheKeySet = (Set)SerializationUtils.fromJsonString((String)String.valueOf(jsonString), Set.class);
        }
        if (cacheKeySet.add(key)) {
            proxy.postBack("attach_" + fieldKey, (Object)SerializationUtils.toJsonString(cacheKeySet));
        }
    }

    private void delSuccessUploadIdsCache(Map<String, Object> deleteAtts, String cacheKey) {
        if (deleteAtts.size() == 0) {
            return;
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        Map successAttIdsMap = new HashMap();
        String successAttIdsMapJson = (String)proxy.getViewState(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)successAttIdsMapJson)) {
            successAttIdsMap = (Map)JSON.parseObject((String)successAttIdsMapJson, Map.class);
        }
        Object uid = deleteAtts.get(ATT_UID);
        successAttIdsMap.remove(uid);
        proxy.postBack(cacheKey, (Object)JSON.toJSONString(successAttIdsMap));
    }

    public Object getBindingValue(BindingContext bctx) {
        Map customParameterFromCache;
        Object v = super.getFieldValue(bctx);
        IPageCache pageCache = this.getView().getPageCache();
        long currUserId = RequestContext.get().getCurrUserId();
        String entityNum = AttachmentKit.getPermissionEntityNum(this.getView());
        boolean hasPermission = true;
        if (this.isAnyEntryGridField()) {
            if (bctx.getRowIndex() == 0) {
                FilePremissionUtil.allPermissionQuery((IPageCache)pageCache, (String)this.getKey(), (Long)currUserId, (String)entityNum, (IClientViewProxy)this.clientViewProxy, (IFormView)this.getView());
                hasPermission = FilePremissionUtil.hasAttachmentOpPermission((String)entityNum, (String)"2NJ6+I0X0CJ8", (IFormView)this.getView(), (boolean)false, (String)this.getKey(), (IClientViewProxy)this.clientViewProxy);
                pageCache.put("ENTRYATT_QUERY_PERMISSION:" + this.getKey(), String.valueOf(hasPermission));
            }
        } else {
            FilePremissionUtil.allPermissionQuery((IPageCache)pageCache, (String)this.getKey(), (Long)currUserId, (String)entityNum, (IClientViewProxy)this.clientViewProxy, (IFormView)this.getView());
            hasPermission = FilePremissionUtil.hasAttachmentOpPermission((String)entityNum, (String)"2NJ6+I0X0CJ8", (IFormView)this.getView(), (boolean)false, (String)this.getKey(), (IClientViewProxy)this.clientViewProxy);
        }
        IAttachmentManagerService managerService = (IAttachmentManagerService)ServiceFactory.getService((String)I_ATTACHMENT_MANAGER_SERVICE);
        List<Map<String, Object>> attachmentList = new ArrayList<Map<String, Object>>();
        if (v == null || ((DynamicObjectCollection)v).size() == 0) {
            HashMap attMap = new HashMap(1);
            attachmentList.add(attMap);
            attachmentList = this.setBillProperty(attachmentList);
            ArrayList<AttachmentInfo> infos = new ArrayList<AttachmentInfo>(1);
            AttachmentInfo attachmentInfo = new AttachmentInfo();
            attachmentInfo.setAttSourceType(AttachmentType.attachmentfield);
            attachmentInfo.setEntityNum((String)attMap.get(ENTITY_NUM));
            attachmentInfo.setAttKey((String)attMap.get(ATT_KEY));
            attachmentInfo.setBillPkId((String)attMap.get(BILL_PK_ID));
            attachmentInfo.setClient((String)attMap.get("client"));
            attachmentInfo.setWriteMapping(false);
            infos.add(attachmentInfo);
            infos = managerService.beforeSendData(infos);
            this.packageAttachmentMapList(infos, attachmentList);
            return new DynamicObjectCollection();
        }
        DynamicObjectCollection attachmentObjs = this.getAttObjs((DynamicObjectCollection)v, entityNum);
        boolean enableYzjPreview = this.enableYzjPreview();
        boolean isMobileView = this.getView() instanceof IMobileView;
        if (this.isAnyEntryGridField()) {
            String queryPermission = pageCache.get("ENTRYATT_QUERY_PERMISSION:" + this.getKey());
            hasPermission = StringUtils.isBlank((CharSequence)queryPermission) ? FilePremissionUtil.hasAttachmentOpPermission((String)entityNum, (String)"2NJ6+I0X0CJ8", (IFormView)this.getView(), (boolean)false, (String)this.getKey(), (IClientViewProxy)this.clientViewProxy) : Boolean.parseBoolean(queryPermission);
        }
        for (DynamicObject attachment : attachmentObjs) {
            if (!hasPermission) continue;
            HashMap<String, Object> attMap = new HashMap<String, Object>(16);
            attMap.put("createtime", attachment.getDate("createtime").getTime());
            String createTimeStr = KDDateFormatUtils.getDateTimeFormat((TimeZone)KDDateUtils.getUserTimeZone()).format(attachment.getDate("createtime"));
            attMap.put("createtimestr", createTimeStr);
            attMap.put(ATT_DESCRIPTION, attachment.get(ATT_DESCRIPTION));
            attMap.put(ATT_CREATOR, attachment.get(ATT_CREATOR));
            attMap.put(ATT_NAME, attachment.get(ATT_NAME));
            attMap.put("filesource", attachment.get("filesource"));
            ILocaleString fileName = (ILocaleString)attachment.get(ATT_NAME);
            if (fileName != null && StringUtils.isBlank((CharSequence)((CharSequence)fileName.getItem(Lang.get().toString())))) {
                LocaleString newString = new LocaleString();
                Iterator iterator = fileName.values().iterator();
                if (iterator.hasNext()) {
                    newString.put((Object)Lang.get().toString(), iterator.next());
                    attMap.put(ATT_NAME, newString);
                }
            }
            String type = String.valueOf(attachment.get(ATT_TYPE));
            attMap.put(ATT_TYPE, type);
            attMap.put(ATT_SIZE, attachment.get(ATT_SIZE));
            Object previewUrl = attachment.get("previewurl");
            if (StringUtils.isBlank((Object)previewUrl) && this.getAttachmentModel().ablePreView(attMap)) {
                String previewUrlStr = this.getAttachmentModel().getTempFilePreviewUrl(String.valueOf(attachment.get(ATT_URL)));
                previewUrl = isMobileView && StringUtils.isNotBlank((CharSequence)previewUrlStr) && !previewUrlStr.contains("&kdedcba=") ? EncreptSessionUtils.encryptSession((String)previewUrlStr) : previewUrlStr;
            }
            previewUrl = this.genPreviewUrl(enableYzjPreview, isMobileView, previewUrl);
            attMap.put("previewurl", previewUrl);
            attMap.put(ATT_SIZE, attachment.get(ATT_SIZE));
            attMap.put(ATT_STATUS, attachment.get(ATT_STATUS));
            attMap.put(ATT_TEMPFILE, attachment.get(ATT_TEMPFILE));
            attMap.put(ATT_UID, attachment.get(ATT_UID));
            attMap.put(ATT_URL, attachment.get(ATT_URL));
            if (AttachmentPreviewUtil.isOnlyOfficePreView()) {
                String onlyOfficeDownloadUrl = AttachmentPreviewUtil.addFileIdParam(attachment.getString(ATT_URL), String.valueOf(attachment.getPkValue()));
                attMap.put("onlyOfficeDownloadUrl", AttachmentPreviewUtil.getReplaceUrl(onlyOfficeDownloadUrl, "0", true));
            }
            attMap.put("attPkId", attachment.getPkValue());
            attMap.put("attPkIdStr", String.valueOf(attachment.getPkValue()));
            String billEntryPkId = this.isEntryGridField() ? this.getModel().getEntryRowEntity(this.getEntryKey(), bctx.getRowIndex()).getPkValue().toString() : "";
            attMap.put(BILL_ENTRY_PKID, billEntryPkId);
            attMap.put(DRAG_SEQ, attachment.get(DRAG_SEQ));
            String downloadUrl = attachment.getString(ATT_URL);
            attMap.put("downloadFilePath", AttachmentManageUtil.getPath(downloadUrl, true));
            attMap.put("previewFilePath", AttachmentManageUtil.getPath(StringUtils.isNotBlank((Object)previewUrl) ? previewUrl.toString() : "", false));
            if (this.getView() instanceof IMobileView) {
                String url = (String)attMap.get(ATT_URL);
                try {
                    attMap.put(ATT_MD5, AttachmentManageUtil.getAttMd5(attMap, FileSource.ATTACHMENT_FIELD.getCode()));
                }
                catch (IOException e) {
                    log.error("\u83b7\u53d6\u6587\u4ef6MD5\u503c\u5931\u8d25 \uff1a " + url);
                }
            }
            attachmentList.add(attMap);
        }
        if (attachmentList.size() > 0) {
            attachmentList = this.setBillProperty(attachmentList);
            List infos = this.packageAttachmentInfoList(attachmentList);
            infos = managerService.beforeSendData(infos);
            attachmentList = this.packageAttachmentMapList(infos, attachmentList);
        }
        if (Boolean.parseBoolean((String)(customParameterFromCache = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam())).get("Attachment_LOG_EXT"))) {
            log.info("kd.bos.form.field.AttachmentEdit.getBindingValue --- " + SerializationUtils.toJsonString(attachmentList));
        }
        if (this.needEncrypt()) {
            AttachmentManageUtil.addAction(this.clientViewProxy, this.getView());
        }
        return attachmentList;
    }

    private Object genPreviewUrl(boolean enableYzjPrevier, boolean mobileView, Object url) {
        if (StringUtils.isNotBlank((Object)url) && enableYzjPrevier && mobileView) {
            return url + "&isMobClient=true";
        }
        return url;
    }

    private boolean enableYzjPreview() {
        IAttachmentService service = (IAttachmentService)ServiceFactory.getService(IAttachmentService.class);
        Map setting = service.getAttSetting();
        return Boolean.parseBoolean(String.valueOf(setting.get("yzjpreview")));
    }

    private boolean isEntryGridField() {
        boolean result = false;
        if (StringUtils.isNotBlank((CharSequence)this.getEntryKey())) {
            if (this.getView().getControl(this.getEntryKey()) instanceof CardEntry) {
                result = false;
            } else if (this.getView().getControl(this.getEntryKey()) instanceof EntryGrid) {
                result = true;
            }
        }
        return result;
    }

    private boolean isAnyEntryGridField() {
        boolean result = false;
        if (StringUtils.isNotBlank((CharSequence)this.getEntryKey()) && this.getView().getControl(this.getEntryKey()) instanceof EntryGrid) {
            result = true;
        }
        return result;
    }

    public void mark(String uid, String description) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ATT_UID, uid);
        params.put("content", description);
        this.mark(params);
    }

    public void mark(Map<String, Object> params) {
        List<AttachmentInfo> infos;
        Object billPkId;
        String entityNum = AttachmentKit.getPermissionEntityNum(this.getView());
        boolean hasPermission = FilePremissionUtil.hasAttachmentOpPermission(null, (String)entityNum, (Object)(billPkId = AttachmentKit.getPermissionBillPkId(this.getView())), (String)"2NJ5ZK67OB2T", (IFormView)this.getView(), (boolean)true, (String)this.getKey(), (IClientViewProxy)this.clientViewProxy);
        if (!hasPermission) {
            return;
        }
        String uid = params.get(ATT_UID).toString();
        String description = params.get("content").toString();
        String attPkId = null;
        if (null != params.get("attPkId")) {
            attPkId = params.get("attPkId").toString();
        }
        Map<Object, DynamicObject> markMap = this.getAttCreatorByUids(Collections.singletonList(uid));
        LocaleString descriptionL = new LocaleString(description);
        ArrayList<DynamicObject> markList = new ArrayList<DynamicObject>(10);
        for (Map.Entry<Object, DynamicObject> markEntry : markMap.entrySet()) {
            DynamicObject dynamicObject = markEntry.getValue();
            dynamicObject.set(ATT_DESCRIPTION, (Object)descriptionL);
            markList.add(dynamicObject);
        }
        IAttachmentManagerService managerService = (IAttachmentManagerService)ServiceFactory.getService((String)I_ATTACHMENT_MANAGER_SERVICE);
        Map result = managerService.beforeDoOperation(infos = this.packageDynAttachmentInfoList(markList), AttachmentOpType.Mark);
        boolean enable = (Boolean)result.get("enable");
        if (!enable) {
            this.getView().showErrorNotification((String)result.get("cancleMsg"));
            return;
        }
        AttachmentMarkEvent evt = new AttachmentMarkEvent((Object)this, uid, description);
        for (AttachmentMarkListener l : this.markListeners) {
            l.mark(evt);
        }
        DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)this.getModel().getValue(this.key);
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            DynamicObject attObj = (DynamicObject)dynamicObject.get("fbasedataid");
            if (!uid.equals(attObj.getString(ATT_UID))) continue;
            attObj.set(ATT_DESCRIPTION, (Object)descriptionL);
            this.getAttachmentModel().mark(uid, descriptionL, attPkId);
        }
        this.getView().updateView(this.getKey());
        managerService.afterDoOperation(infos, AttachmentOpType.Mark);
    }

    public void rename(String uid, String name) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ATT_UID, uid);
        params.put("content", name);
        this.rename(params);
    }

    public void rename(Map<String, Object> params) {
        List<AttachmentInfo> list;
        Object billPkId;
        String entityNum = AttachmentKit.getPermissionEntityNum(this.getView());
        boolean hasPermission = FilePremissionUtil.hasAttachmentOpPermission(null, (String)entityNum, (Object)(billPkId = AttachmentKit.getPermissionBillPkId(this.getView())), (String)"2NJ5W8AA040D", (IFormView)this.getView(), (boolean)true, (String)this.getKey(), (IClientViewProxy)this.clientViewProxy);
        if (!hasPermission) {
            return;
        }
        String name = params.get("content").toString();
        String uid = params.get(ATT_UID).toString();
        String attPkId = null;
        if (null != params.get("attPkId")) {
            attPkId = params.get("attPkId").toString();
        }
        if (!name.contains(".")) {
            return;
        }
        String speSymbol = this.getAttachmentModel().checkSpeSymbol(name);
        if (StringUtils.isNotBlank((CharSequence)speSymbol)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u540d\u4e0d\u80fd\u5305\u542b\u4e0b\u5217\u4efb\u4f55\u5b57\u7b26\uff1a%s\u3002", (String)"AttachmentPanel_18", (String)BOS_SVC_METADATA, (Object[])new Object[0]), speSymbol));
            return;
        }
        String ext = name.substring(name.lastIndexOf(46) + 1);
        String fileName = name.substring(0, name.lastIndexOf(46));
        fileName = fileName.trim();
        for (String symbol : SPECIAL_SYMBOLARRAY) {
            if (!fileName.contains(symbol)) continue;
            return;
        }
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return;
        }
        if (name.length() > 255) {
            fileName = fileName.substring(0, 255 - ext.length() - 1);
            name = fileName + "." + ext;
        }
        Map<Object, DynamicObject> nameMap = this.getAttCreatorByUids(Collections.singletonList(uid));
        LocaleString nameL = new LocaleString(name);
        ArrayList<DynamicObject> nameList = new ArrayList<DynamicObject>(10);
        for (Map.Entry entry : nameMap.entrySet()) {
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            dynamicObject.set(ATT_NAME, (Object)nameL);
            String oldExt = "." + dynamicObject.get(ATT_TYPE);
            if (!name.endsWith(oldExt)) {
                return;
            }
            nameList.add(dynamicObject);
        }
        IAttachmentManagerService managerService = (IAttachmentManagerService)ServiceFactory.getService((String)I_ATTACHMENT_MANAGER_SERVICE);
        Map result = managerService.beforeDoOperation(list = this.packageDynAttachmentInfoList(nameList), AttachmentOpType.Rename);
        boolean enable = (Boolean)result.get("enable");
        if (!enable) {
            this.getView().showErrorNotification((String)result.get("cancleMsg"));
            return;
        }
        DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)this.getModel().getValue(this.getFieldKey());
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            DynamicObject attObj = (DynamicObject)dynamicObject.get("fbasedataid");
            if (!uid.equals(attObj.getString(ATT_UID))) continue;
            attObj.set(ATT_NAME, (Object)nameL);
            this.getAttachmentModel().rename(uid, name, attPkId);
        }
        if (ATT_ENTRYGRID_UPLOADVIEW_FORMID.equals(this.getView().getEntityId())) {
            this.getView().getPageCache().put(ISCHANGED, "true");
        }
        try {
            this.getView().updateView(this.getKey());
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.getView().updateView();
        }
        managerService.afterDoOperation(list, AttachmentOpType.Rename);
    }

    private DynamicObjectCollection getAttObjs(DynamicObjectCollection objs, String entityNum) {
        DynamicObjectCollection returnObjs = new DynamicObjectCollection();
        for (DynamicObject obj : objs) {
            boolean entryUploadNotSuccess;
            DynamicObject attObj = (DynamicObject)obj.get("fbasedataid");
            if (attObj == null || (entryUploadNotSuccess = !ATT_SUCCESS_STATUS.equals(attObj.get(ATT_STATUS)) && !ATT_SUCCESS.equals(attObj.get(ATT_STATUS)) && ATT_ENTRYGRID_UPLOADVIEW_FORMID.equals(this.getView().getEntityId()))) continue;
            String path = attObj.getString(ATT_URL);
            if (path.contains("path=")) {
                path = StringUtils.substringAfter((String)path, (String)"path=");
                try {
                    path = URLDecoder.decode(path, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"URL\u7f16\u7801\u5931\u8d25%s", (String)"AttachmentEdit_0", (String)BOS_SVC_METADATA, (Object[])new Object[0]), e.getMessage()));
                }
                if (path.contains("&")) {
                    path = StringUtils.substringBefore((String)path, (String)"&");
                }
            }
            String type = attObj.getString(ATT_TYPE);
            int tempfile = attObj.getInt(ATT_TEMPFILE);
            if (tempfile == 1) {
                String url = null;
                try {
                    url = URLEncoder.encode(path, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"URL\u7f16\u7801\u5931\u8d25%s", (String)"AttachmentEdit_0", (String)BOS_SVC_METADATA, (Object[])new Object[0]), e.getMessage()));
                }
                boolean isWeb = !"mobile".equals(RequestContext.get().getClient()) && !(this.getView() instanceof IMobileView) && (!ATT_FIELD_MOB.equals(this.getView().getEntityId()) || !(this.getView().getParentView() instanceof IMobileView)) && !AttachmentPreviewUtil.isOnlyOfficePreView();
                String attUrl = isWeb ? UrlService.getAttachmentDownloadUrl((String)url) : EncreptSessionUtils.encryptSession((String)UrlService.getAttachmentDownloadUrl((String)url));
                attObj.set(ATT_URL, (Object)attUrl);
                HashMap<String, Object> attMap = new HashMap<String, Object>(16);
                attMap.put(ATT_SIZE, attObj.getLong(ATT_SIZE));
                attMap.put(ATT_TYPE, type);
                if (this.getAttachmentModel().ablePreView(attMap)) {
                    attObj.set("previewurl", (Object)attUrl.replace(DOWNLOAD_DO, PREVIEW_DO));
                }
            }
            if (ATT_SUCCESS_STATUS.equals(attObj.get(ATT_STATUS))) {
                attObj.set(ATT_STATUS, (Object)ATT_SUCCESS);
            } else if (ATT_UPLOADING_STATUS.equals(attObj.get(ATT_STATUS))) {
                attObj.set(ATT_STATUS, (Object)ATT_UPLOADING);
            } else if (ATT_ERROR_STATUS.equals(attObj.get(ATT_STATUS))) {
                attObj.set(ATT_STATUS, (Object)ATT_ERROR);
            } else if (ATT_CANCEL_STATUS.equals(attObj.get(ATT_STATUS))) {
                attObj.set(ATT_STATUS, (Object)ATT_CANCEL);
            }
            DynamicObject attclone = (DynamicObject)OrmUtils.clone((IDataEntityBase)attObj, (boolean)false, (boolean)false);
            DynamicObject userinfo = attObj.getDynamicObject(ATT_CREATOR);
            if (userinfo != null) {
                attclone.set(ATT_CREATOR, (Object)userinfo.getLocaleString(ATT_NAME));
            } else {
                attclone.set(ATT_CREATOR, (Object)new Locale(""));
            }
            attclone.set(ATT_DESCRIPTION, attObj.getLocaleString(ATT_DESCRIPTION) != null ? attObj.getLocaleString(ATT_DESCRIPTION) : new Locale(""));
            returnObjs.add((Object)attclone);
        }
        return returnObjs;
    }

    private List<DynamicObject> saveTempAttachments(List<Map<String, Object>> attachs) {
        return this.getAttachmentModel().saveAttachments(this.getModel(), this.getView().getPageId(), this.getModel().getDataEntityType().getName(), attachs);
    }

    protected boolean isEntryProperty(IDataEntityProperty property) {
        IDataEntityType propParentType = property.getParent();
        return propParentType instanceof EntryType;
    }

    private int getCurrentRowIndex() {
        int rowIndex = -1;
        if (this.isEntryProperty(this.getProperty())) {
            rowIndex = this.getModel().getEntryCurrentRowIndex(this.getProperty().getParent().getName());
        }
        return rowIndex;
    }

    private Map<Object, DynamicObject> getAttCreatorByUids(List<String> uids) {
        QFilter[] filters = new QFilter[]{new QFilter(ATT_UID, "in", uids)};
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)ATT_ENTITYID);
        ArrayList idList = new ArrayList();
        try (DataSet ds = ORM.create().queryDataSet("BusinessDataServiceHelper.LoadFromCache", type.getName(), ATT_ID, filters, null, -1, (Distinctable)WithEntityEntryDistinctable.get());){
            ds.forEach(row -> idList.add(row.get(0)));
        }
        return BusinessDataReader.loadFromCache((Object[])idList.toArray(), (DynamicObjectType)type);
    }

    public void attachOperationCount(Map<String, Object> args) {
        String entityNum = AttachmentKit.getPermissionEntityNum(this.getView());
        Object billPkId = AttachmentKit.getPermissionBillPkId(this.getView());
        String operationType = (String)args.get("operationType");
        List uids = (List)args.get(ATT_UID);
        Map<Object, DynamicObject> targetAttachments = this.getAttCreatorByUids(uids);
        AttachmentOpType attachmentOpType = AttachmentOpType.Download;
        switch (operationType) {
            case "preview": {
                attachmentOpType = AttachmentOpType.PreView;
                break;
            }
        }
        ArrayList<DynamicObject> opList = new ArrayList<DynamicObject>(10);
        for (Object o : targetAttachments.keySet()) {
            DynamicObject dynamicObject = targetAttachments.get(o);
            opList.add(dynamicObject);
        }
        IAttachmentManagerService managerService = (IAttachmentManagerService)ServiceFactory.getService((String)I_ATTACHMENT_MANAGER_SERVICE);
        List<AttachmentInfo> infos = this.packageDynAttachmentInfoList(opList);
        if (operationType.contains("download")) {
            boolean hasPermission = FilePremissionUtil.hasAttachmentOpPermission(null, (String)entityNum, (Object)billPkId, (String)"2NJ5XVVCMBCL", (IFormView)this.getView(), (boolean)true, (String)this.getKey(), (IClientViewProxy)this.clientViewProxy);
            if (!hasPermission) {
                return;
            }
            AttachmentDownLoadEvent evt = new AttachmentDownLoadEvent((Object)this, targetAttachments);
            for (AttachmentDownloadListener l : this.downloadListener) {
                l.attachmentAfterDownload(evt);
            }
        } else if ("preview".equals(operationType)) {
            boolean hasPermission = FilePremissionUtil.hasAttachmentOpPermission(null, (String)entityNum, (Object)billPkId, (String)"2NJ5VA7D2ONF", (IFormView)this.getView(), (boolean)true, (String)this.getKey(), (IClientViewProxy)this.clientViewProxy);
            if (!hasPermission) {
                return;
            }
            AttachmentPreviewEvent evt = new AttachmentPreviewEvent((Object)this, targetAttachments);
            for (AttachmentPreviewListener l : this.previewListener) {
                l.attachmentAfterPreview(evt);
            }
        }
        managerService.afterDoOperation(infos, attachmentOpType);
    }

    private List<AttachmentInfo> packageAttachmentInfoList(List<Map<String, Object>> attachs) {
        ArrayList<AttachmentInfo> resultList = new ArrayList<AttachmentInfo>(attachs.size());
        Date now = new Date();
        RequestContext rc = RequestContext.get();
        for (int i = 0; i < attachs.size(); ++i) {
            Map<String, Object> attMap = attachs.get(i);
            AttachmentInfo attachmentInfo = new AttachmentInfo();
            attachmentInfo.setAttSourceType(AttachmentType.attachmentfield);
            attachmentInfo.setAttKey((String)attMap.get(ATT_KEY));
            attachmentInfo.setEntityNum((String)attMap.get(ENTITY_NUM));
            attachmentInfo.setBillPkId((String)attMap.get(BILL_PK_ID));
            attachmentInfo.setAttPkId((Long)attMap.get("attPkId"));
            attachmentInfo.setExt((String)attMap.get(ATT_TYPE));
            Object name = attMap.get(ATT_NAME);
            attachmentInfo.setFileName(name == null ? "" : name.toString());
            attachmentInfo.setFileSize(Long.valueOf(Long.parseLong(attMap.get(ATT_SIZE).toString())));
            attachmentInfo.setDownloadUrl((String)attMap.get(ATT_URL));
            attachmentInfo.setPreviewUrl(attachmentInfo.getDownloadUrl().replace(DOWNLOAD_DO, PREVIEW_DO));
            OrmLocaleValue description = (OrmLocaleValue)attMap.get(ATT_DESCRIPTION);
            attachmentInfo.setMark(description == null ? "" : description.getLocaleValue());
            attachmentInfo.setCreateTime(now);
            if (attMap.containsKey("uploadTime")) {
                attachmentInfo.setCreateTime(new Date((Long)attMap.get("uploadTime")));
            }
            attachmentInfo.setCreateUserId(rc.getUserId());
            attachmentInfo.setModifyTime(now);
            attachmentInfo.setBillno((String)attMap.get(ATT_BILLNO));
            boolean isWeb = !"mobile".equals(RequestContext.get().getClient()) && !(this.getView() instanceof IMobileView) && (!ATT_FIELD_MOB.equals(this.getView().getEntityId()) || !(this.getView().getParentView() instanceof IMobileView));
            attachmentInfo.setClient(isWeb ? "web" : "mobile");
            attachmentInfo.setAppId((String)attMap.get(APPID));
            attachmentInfo.setFieldType(FieldType.AttachmentEdit);
            attachmentInfo.setFieldKey((String)attMap.get(ATT_KEY));
            attachmentInfo.setBillEntryPkId((String)attMap.get(BILL_ENTRY_PKID));
            resultList.add(attachmentInfo);
        }
        return resultList;
    }

    private List<AttachmentInfo> packageDynAttachmentInfoList(List<DynamicObject> attachs) {
        ArrayList<AttachmentInfo> resultList = new ArrayList<AttachmentInfo>(attachs.size());
        Date today = new Date();
        for (int i = 0; i < attachs.size(); ++i) {
            DynamicObject attObj = attachs.get(i);
            String entityNum = "";
            String billPkId = "";
            String attKey = "";
            String billno = "";
            String entityId = this.getView().getEntityId();
            if (ATT_ENTRYGRID_UPLOADVIEW_FORMID.equals(entityId) || ATT_FIELD_MOB.equals(entityId)) {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                entityNum = (String)formShowParameter.getCustomParam(LOG_ENTITY_NUM);
                billPkId = (String)formShowParameter.getCustomParam(BILL_PK_ID);
                attKey = (String)formShowParameter.getCustomParam(ATT_KEY);
                billno = (String)formShowParameter.getCustomParam(ATT_BILLNO);
            } else {
                entityNum = FormMetadataCache.getFormConfig((String)this.getModel().getDataEntityType().getName()).getEntityTypeId();
                Object pkValue = this.getModel().getDataEntity().getPkValue();
                billPkId = pkValue == null ? "" : pkValue.toString();
                MainEntityType dataEntityType = this.getModel().getDataEntityType();
                if (dataEntityType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)((BillEntityType)dataEntityType).getBillNo())) {
                    billno = this.getModel().getDataEntity().getString(((BillEntityType)dataEntityType).getBillNo());
                }
                attKey = this.getKey();
            }
            AttachmentInfo attachmentInfo = new AttachmentInfo();
            attachmentInfo.setAttSourceType(AttachmentType.attachmentfield);
            attachmentInfo.setAttKey(attKey);
            attachmentInfo.setAttPkId(Long.valueOf(attObj.getLong(ATT_ID)));
            attachmentInfo.setEntityNum(entityNum);
            attachmentInfo.setBillPkId(billPkId);
            attachmentInfo.setBillno(billno);
            attachmentInfo.setExt(attObj.getString(ATT_TYPE));
            attachmentInfo.setFileName(attObj.getString(ATT_NAME));
            attachmentInfo.setFileSize(Long.valueOf(attObj.getLong(ATT_SIZE)));
            attachmentInfo.setDownloadUrl(attObj.getString(ATT_URL));
            attachmentInfo.setPreviewUrl(attachmentInfo.getDownloadUrl().replace(DOWNLOAD_DO, PREVIEW_DO));
            attachmentInfo.setMark(attObj.getString(ATT_DESCRIPTION));
            attachmentInfo.setCreateTime(today);
            attachmentInfo.setCreateUserId(RequestContext.get().getUserId());
            attachmentInfo.setModifyTime(today);
            boolean isWeb = !"mobile".equals(RequestContext.get().getClient()) && !(this.getView() instanceof IMobileView) && (!ATT_FIELD_MOB.equals(this.getView().getEntityId()) || !(this.getView().getParentView() instanceof IMobileView));
            attachmentInfo.setClient(isWeb ? "web" : "mobile");
            resultList.add(attachmentInfo);
        }
        return resultList;
    }

    private List<Map<String, Object>> packageAttachmentMapList(List<AttachmentInfo> attachmentInfoList, List<Map<String, Object>> data) {
        boolean visible = true;
        boolean enable = true;
        for (int i = 0; i < attachmentInfoList.size(); ++i) {
            AttachmentInfo attachmentInfo = attachmentInfoList.get(i);
            if (data != null && data.size() == attachmentInfoList.size()) {
                Map<String, Object> attachmentMap = data.get(i);
                String visiablePreview = attachmentInfo.isVisiablePreview() ? "1" : "0";
                String visiableDownload = attachmentInfo.isVisiableDownload() ? "1" : "0";
                String visiableRename = attachmentInfo.isVisiableRename() ? "1" : "0";
                String visiableDelete = attachmentInfo.isVisiableDelete() ? "1" : "0";
                attachmentMap.put("visible", visiablePreview + visiableDownload + visiableRename + visiableDelete);
                attachmentMap.put("hiddenBtn", attachmentInfo.getHiddenBtn());
            }
            if (visible && !attachmentInfo.isVisible()) {
                visible = false;
                if (ATT_ENTRYGRID_UPLOADVIEW_FORMID.equals(this.getView().getEntityId())) {
                    this.getView().setVisible(Boolean.valueOf(visible), new String[]{"attachmentfield"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(visible), new String[]{attachmentInfo.getAttKey()});
                }
            }
            if (!enable || attachmentInfo.isEnable()) continue;
            enable = false;
            if (ATT_ENTRYGRID_UPLOADVIEW_FORMID.equals(this.getView().getEntityId())) {
                this.getView().setEnable(Boolean.valueOf(enable), new String[]{"attachmentfield"});
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{attachmentInfo.getAttKey()});
        }
        return data;
    }

    public void permissionQuery(Map<String, Object> args) {
        AttachmentKit.permissionQuery(this.getKey(), args, this.getView(), this.clientViewProxy);
    }

    public void beforeDownload(Map<String, Object> attach) {
        if (this.needEncrypt()) {
            FormShowParameter showParameter = AttachmentManageUtil.getFormParameterForEncrypt("0");
            Object fileInfo = attach.get("fileInfo");
            if (null != fileInfo) {
                showParameter.setCloseCallBack(new CloseCallBack("kd.bos.form.field.AttachmentEditEncrypt", "encryptDownloadAll"));
                showParameter.setCustomParam("encryptType", (Object)"3");
            } else {
                Object uid = attach.get(ATT_UID);
                showParameter.setCloseCallBack(new CloseCallBack("kd.bos.form.field.AttachmentEditEncrypt", "encryptDownload"));
                showParameter.setCustomParam(ATT_UID, uid);
            }
            showParameter.setCustomParam("methodKey", (Object)this.getKey());
            this.getView().showForm(showParameter);
        }
    }

    private boolean needEncrypt() {
        boolean needEncrypt;
        if (StringUtils.equals((CharSequence)this.getView().getEntityId(), (CharSequence)ATT_ENTRYGRID_UPLOADVIEW_FORMID)) {
            String parentPageId = this.getView().getFormShowParameter().getParentPageId();
            if (StringUtils.isBlank((CharSequence)parentPageId)) {
                log.error("get parent page id is empty");
                return false;
            }
            IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
            needEncrypt = AttachmentManageUtil.needEncrypt(parentView, false);
        } else {
            needEncrypt = AttachmentManageUtil.needEncrypt(this.getView(), false);
        }
        return needEncrypt;
    }

    public void previewByNewTab(Map<String, Object> params) {
        int activedIndex = (Integer)params.get("activedIndex");
        ArrayList sortedUidList = (ArrayList)params.get("sortedUids");
        DynamicObjectCollection dynamicObjects = this.getAttachColl(params);
        DynamicObjectCollection attObjs = this.getAttObjs(dynamicObjects, this.getView().getModel().getDataEntity().getDataEntityType().getName());
        for (DynamicObject att : attObjs) {
            String url;
            String type = String.valueOf(att.get(ATT_TYPE));
            Object size = att.get(ATT_SIZE);
            Map<String, Object> param = AttachmentKit.ablePreViewParam(type, size);
            if (!this.getAttachmentModel().ablePreView(param) || !(url = String.valueOf(att.get(ATT_URL))).contains("tempfile/download.do?configKey") && !StringUtils.isBlank((Object)att.get("previewurl"))) continue;
            String previewUrl = this.getAttachmentModel().getTempFilePreviewUrl(url);
            att.set("previewurl", (Object)previewUrl);
        }
        boolean hasPermission = FilePremissionUtil.hasAttachmentOpPermission(null, (String)AttachmentKit.getPermissionEntityNum(this.getView()), (Object)AttachmentKit.getPermissionBillPkId(this.getView()), (String)"2NJ5XVVCMBCL", (IFormView)this.getView(), (boolean)false, (String)this.getKey(), (IClientViewProxy)this.clientViewProxy);
        this.sortAtt(attObjs, sortedUidList);
        FormShowParameter formParameterForNewTab = AttachmentKit.getFormParameterForNewTab(attObjs, activedIndex, hasPermission);
        this.getView().showForm(formParameterForNewTab);
    }

    private void sortAtt(DynamicObjectCollection attObjs, ArrayList<String> sortedUidList) {
        Collections.sort(attObjs, (d1, d2) -> {
            int uid1 = sortedUidList.indexOf(d1.get(ATT_UID));
            int uid2 = sortedUidList.indexOf(d2.get(ATT_UID));
            return uid1 - uid2;
        });
    }

    public void getDisposableUrl(Map<String, Object> params) {
        String url = (String)params.get(ATT_URL);
        try {
            url = AttachmentControlUtil.generateDisposableUrl(url, AttachmentKit.getPermissionEntityNum(this.getView()), AttachmentKit.getPermissionBillPkId(this.getView()));
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u4e00\u6b21\u6027\u94fe\u63a5\u51fa\u9519\u3002", (Throwable)e);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put(ATT_URL, url);
        resultMap.put(ATT_UID, params.get(ATT_UID));
        this.clientViewProxy.invokeControlMethod(this.getKey(), "setDisposableUrl", new Object[]{resultMap});
    }
}

