/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.attachment.util.AttachExceptionHandler;
import kd.bos.attachment.util.AttachmentOpLogUtil;
import kd.bos.attachment.util.BillFileMappingWriter;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ThumbnailsParameter;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.PictureProp;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.BindingContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.attachment.common.AttachmentKit;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ISuportClick;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.WaterMarkEvent;
import kd.bos.form.control.events.WaterMarkListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.picture.common.PictureKit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.AttachmentInfo;
import kd.bos.mservice.attachment.AttachmentOpType;
import kd.bos.mservice.attachment.AttachmentType;
import kd.bos.mservice.attachment.FieldType;
import kd.bos.mservice.attachment.IAttachmentManagerService;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.bos.svc.util.ImageUrlUtil;
import kd.bos.web.actions.utils.FilePathUtil;

@KSObject
@DataEntityTypeAttribute(name="kd.bos.form.field.PictureEdit")
public class PictureEdit
extends FieldEdit
implements ISuportClick {
    private static final Log log = LogFactory.getLog(PictureEdit.class);
    private static final String I_ATTACHMENT_MANAGER_SERVICE = "IAttachmentManagerService";
    private static final String ENTITY_NUM = "entityNum";
    private static final String BILL_PK_ID = "billPkId";
    private static final String DESCRIPTION = "description";
    private String operationKey;
    private static final String UPLOADING_KEY = "UploadingImg:";
    private static final String IMG_UID = "uid";
    protected List<ClickListener> clickListeners = new ArrayList<ClickListener>();
    protected List<ItemClickListener> itemClickListeners = new ArrayList<ItemClickListener>();
    protected List<WaterMarkListener> waterMarkListeners = new ArrayList<WaterMarkListener>();

    public void addWaterMarkListener(WaterMarkListener listener) {
        this.waterMarkListeners.add(listener);
    }

    public Object getBindingValue(BindingContext bctx) {
        Object pathObj = super.getFieldValue(bctx);
        if (pathObj instanceof String) {
            ArrayList<AttachmentInfo> attachmentInfoList = new ArrayList<AttachmentInfo>(1);
            AttachmentInfo attachInfo = BillFileMappingWriter.createAttachInfoForPicture((IDataModel)this.getModel(), (String)this.getKey(), (FieldType)FieldType.PictureEdit, (String)((String)pathObj));
            attachmentInfoList.add(attachInfo);
            BillFileMappingWriter.syncWriteFileBillMapping(attachmentInfoList);
        }
        return super.getBindingValue(bctx);
    }

    public void beforeUpload(List<Map<String, Object>> images) {
        if (CollectionUtils.isEmpty(images)) {
            return;
        }
        String cacheKey = UPLOADING_KEY + this.getView().getPageId();
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        String uploadingImgJson = cache.get(cacheKey);
        ArrayList<String> uploadingImgList = uploadingImgJson != null ? SerializationUtils.fromJsonStringToList((String)uploadingImgJson, String.class) : new ArrayList<String>(images.size());
        for (Map<String, Object> image : images) {
            String imgUid = (String)image.get(IMG_UID);
            if (imgUid == null) continue;
            uploadingImgList.add(imgUid);
        }
        cache.put(cacheKey, SerializationUtils.toJsonString(uploadingImgList));
    }

    public void uploadResult(List<Map<String, Object>> images) {
        if (CollectionUtils.isEmpty(images)) {
            return;
        }
        String cacheKey = UPLOADING_KEY + this.getView().getPageId();
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        String uploadingImgJson = cache.get(cacheKey);
        if (StringUtils.isBlank((CharSequence)uploadingImgJson)) {
            return;
        }
        List uploadingImgList = SerializationUtils.fromJsonStringToList((String)uploadingImgJson, String.class);
        for (Map<String, Object> image : images) {
            Object imgUid = image.get(IMG_UID);
            if (imgUid == null) continue;
            uploadingImgList.remove(imgUid);
        }
        if (uploadingImgList.size() == 0) {
            cache.remove(cacheKey);
            return;
        }
        cache.put(cacheKey, SerializationUtils.toJsonString((Object)uploadingImgList));
    }

    public void remove(HashMap<String, Object> params) {
        Object pkId;
        block3: {
            String path = String.valueOf(params.get("url"));
            pkId = this.getView().getModel().getDataEntity().getPkValue();
            String entityNum = AttachmentKit.getPermissionEntityNum(this.getView());
            try {
                path = FilePathUtil.dealPath((String)path, (String)"image");
            }
            catch (KDException e) {
                if (!AttachExceptionHandler.dealException((KDException)e, (IFormView)this.getView(), (String)entityNum, (String)"permItem").booleanValue()) break block3;
                return;
            }
        }
        if (!this.getView().getModel().getDataEntity().getDataEntityState().getFromDatabase()) {
            PictureKit.removePicture(params, pkId, this.getView());
            return;
        }
        this.cacheRemoveData(params);
    }

    private void cacheRemoveData(HashMap<String, Object> removeMap) {
        IPageCache pageCache = this.getView().getPageCache();
        String removeKey = "TempRemoveCache" + this.getView().getPageId();
        List<HashMap<String, Object>> cacheList = new ArrayList<HashMap<String, Object>>(16);
        String removeStr = pageCache.get(removeKey);
        if (StringUtils.isNotBlank((CharSequence)removeStr)) {
            cacheList = (List)SerializationUtils.fromJsonString((String)removeStr, List.class);
        }
        cacheList.add(removeMap);
        String cacheMapToString = SerializationUtils.toJsonString(cacheList);
        pageCache.put(removeKey, cacheMapToString);
    }

    public void postBack(Object value, int rowIndex, int parentRowIndex) {
        super.postBack(value, rowIndex, parentRowIndex);
        if (StringUtils.isNotBlank((Object)value) && FileServiceFactory.getImageFileService().exists(String.valueOf(value))) {
            ArrayList<AttachmentInfo> infos = new ArrayList<AttachmentInfo>();
            String path = String.valueOf(value);
            IAttachmentManagerService managerService = (IAttachmentManagerService)ServiceFactory.getService((String)I_ATTACHMENT_MANAGER_SERVICE);
            AttachmentInfo info = AttachmentOpLogUtil.packageAttachmentInfo((IFormView)this.getView(), (String)this.getKey(), (FieldType)FieldType.Image, (AttachmentType)AttachmentType.toolbar, (String)path);
            infos.add(info);
            managerService.afterDoOperation(infos, AttachmentOpType.Upload);
        }
    }

    public void addClickListener(ClickListener listener) {
        this.clickListeners.add(listener);
    }

    public void addItemClickListener(ItemClickListener listener) {
        this.itemClickListeners.add(listener);
    }

    @KSMethod
    @SimplePropertyAttribute
    public String getOperationKey() {
        return this.operationKey;
    }

    public void setOperationKey(String operationKey) {
        this.operationKey = operationKey;
    }

    public void showPic() {
        String value = (String)this.getModel().getValue(this.getFieldKey());
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_showPic");
        parameter.setCustomParam("value", (Object)value);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    public void click() {
        BeforeClickEvent e = new BeforeClickEvent((Object)this);
        this.fireBeforeClick(e);
        if (!e.isCancel()) {
            ClickEvent e1 = new ClickEvent((Object)this);
            this.fireClick(e1);
        }
    }

    public List<ThumbnailsParameter> getThumbnailsParams() {
        PictureProp pictureProp = (PictureProp)this.getModel().getProperty(this.getFieldKey());
        return pictureProp.getThumbnailsParams();
    }

    public String getOriginalPictrue() {
        String url = (String)this.getModel().getValue(this.getFieldKey());
        if (StringUtils.isNotBlank((CharSequence)url) && StringUtils.contains((CharSequence)url, (CharSequence)"_thumbnails_")) {
            url = StringUtils.replacePattern((String)url, (String)"_thumbnails_.*\\.", (String)".");
        }
        return url;
    }

    public Map<String, String> getThumbnailsURLs() {
        String url;
        HashMap<String, String> map = new HashMap<String, String>();
        List<ThumbnailsParameter> thumbnailsParams = this.getThumbnailsParams();
        if (thumbnailsParams != null && !thumbnailsParams.isEmpty() && StringUtils.isNotBlank((CharSequence)(url = (String)this.getModel().getValue(this.getFieldKey())))) {
            String originalPictrue = this.getOriginalPictrue();
            for (ThumbnailsParameter thumbnailsParameter : thumbnailsParams) {
                String thumbnailsTag = thumbnailsParameter.getThumbnailsTag();
                String thumbnailsURL = PictureEdit.processPathString(originalPictrue, thumbnailsTag);
                map.put(thumbnailsTag, thumbnailsURL);
            }
        }
        return map;
    }

    private static String processPathString(String srcPath, String thumbnailsTag) {
        String distPath = srcPath;
        if (StringUtils.isNotBlank((CharSequence)thumbnailsTag)) {
            String prefix = distPath.substring(0, StringUtils.lastIndexOf((CharSequence)srcPath, (CharSequence)"."));
            String suffix = distPath.substring(StringUtils.lastIndexOf((CharSequence)srcPath, (CharSequence)"."));
            distPath = String.format("%s_thumbnails_%s%s", prefix, thumbnailsTag, suffix);
        }
        return distPath;
    }

    private void fireBeforeClick(BeforeClickEvent e) {
        for (ClickListener l : this.clickListeners) {
            l.beforeClick(e);
        }
    }

    private void fireClick(ClickEvent e) {
        if (this.clickListeners != null) {
            for (ClickListener l : this.clickListeners) {
                l.click((EventObject)e);
            }
        }
    }

    public void setShowWaterMark(boolean isShowWaterMark) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("show", isShowWaterMark);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(this.getKey(), "setShowWaterMark", new Object[]{map});
    }

    public void getWaterMarkInfos() {
        if (this.waterMarkListeners != null) {
            WaterMarkEvent evt = new WaterMarkEvent((Object)this);
            for (WaterMarkListener l : this.waterMarkListeners) {
                l.getWaterMarkInfos(evt);
            }
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
            clientViewProxy.invokeControlMethod(this.getKey(), "setWaterMarkInfos", new Object[]{evt.getMap()});
        }
    }

    public void getImagePreviewUrl(List<String> urlList) {
        urlList = ImageUrlUtil.getImageFreeUrl(urlList);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        log.info("kd.bos.form.control.ImageList#getImagePreviewUrl imageFreeUrl--- " + SerializationUtils.toJsonString((Object)urlList));
        clientViewProxy.invokeControlMethod(this.getKey(), "imageFreeUrl", new Object[]{urlList});
    }
}

