/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.mcontrol.mobtable.tablecolumn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.mcontrol.mobtable.tablecolumn.MobTableColumn;
import kd.bos.mservice.svc.attach.IAttachmentMobTableColumn;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class AttachmentMobTableColumn
extends MobTableColumn
implements IAttachmentMobTableColumn {
    private static final String ATT_FIELD_MOB = "bos_mobtb_attfield_upload";
    private static final String LOG_APPID = "logAppId";
    private static final String LOG_ENTITY_NUM = "logEntityNum";
    private static final String BILL_PK_ID = "billPkId";
    private static final String ATT_KEY = "attKey";
    private static final String ATT_BILLNO = "billno";

    protected Map<String, Object> createEditor() {
        Map editor = super.createEditor();
        editor.putIfAbsent("type", "attachmentfield");
        return editor;
    }

    public void openMobEntryUploadView(int row, boolean lock) {
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setFormId(ATT_FIELD_MOB);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        Map<String, Object> value = this.builderCusMap(row, lock);
        formShowParameter.setCustomParams(value);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private Map<String, Object> builderCusMap(int row, boolean lock) {
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("lock", lock);
        DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)this.getModel().getValue(this.getMobTableField(), row);
        ArrayList<Object> list = new ArrayList<Object>();
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            list.add(dynamicObject.get("fbasedataid_id"));
        }
        value.put("attIds", list);
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)this.getModel().getDataEntityType().getName());
        String logEntityNum = formConfig.getEntityTypeId();
        value.put(LOG_ENTITY_NUM, logEntityNum);
        value.put(LOG_APPID, formConfig.getAppId());
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        value.put(BILL_PK_ID, pkValue == null ? "" : pkValue.toString());
        value.put(ATT_KEY, this.getKey());
        String billno = "";
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        if (dataEntityType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)((BillEntityType)dataEntityType).getBillNo())) {
            billno = this.getModel().getDataEntity().getString(((BillEntityType)dataEntityType).getBillNo());
        }
        value.put(ATT_BILLNO, billno);
        IDataEntityProperty property = this.getModel().getProperty(this.getMobTableField());
        if (property instanceof AttachmentProp) {
            AttachmentProp prop = (AttachmentProp)property;
            value.put("maxAtmCount", prop.getMaxAtmCount());
            value.put("maxAtmSize", prop.getMaxAtmSize());
            value.put("extendName", prop.getExtendName());
            value.put("sortField", prop.getSortField());
            value.put("sortType", prop.getSortType());
            value.put("checkDuplicateFileName", prop.getCheckDuplicateFileName());
        }
        return value;
    }
}

