/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import java.net.URL;
import java.sql.ResultSet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ksql.util.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.dao.IMetadataDaoPlugIn;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployScriptBinder;
import kd.bos.metadata.form.PrintFormAp;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.svc.util.print.UpdateLocalNameUtil;

public class PrintmetaDaoPlugin
implements IMetadataDaoPlugIn {
    private static final Log logger = LogFactory.getLog(PrintmetaDaoPlugin.class);
    private static final String EXISTED_SQL = "select top 1 %s from %s where %s = ? ";
    private static final String INSERT_SQL = "insert into %s (fid, fprinttplid, fbillformid, fcreatetime, fmodifytime,fmodifierid,fcreatorid, fenable) values (?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_SQL = "update %s set  fmodifytime = ?,fmodifierid= ?,fcreatetime = ?,fcreatorid = ? where fprinttplid = ?";
    private static final String DELETE_SQL = "delete from %s where fprinttplid = ?";
    private static final String TABLENAME = "t_bas_printtplinfo";
    private static final String FIELD_PRINT_TP_LID = "fprinttplid";
    private static final String FIX_TIME = "2018-08-08 18:08:08";
    private static final String ERROR_STR_PLACEHOLDER = "Error:%s.";
    private static final String BOS_METADATA = "bos-metadata";

    public void save(AbstractMetadata[] metadatas) {
        PrintMetadata printMeta = null;
        for (AbstractMetadata metadata : metadatas) {
            if (!(metadata instanceof PrintMetadata)) continue;
            PrintMetadata printMetadata = (PrintMetadata)metadata;
            if (this.isExistedInfo(metadata)) {
                this.updatePrintInfo(printMetadata);
            } else {
                this.insertPrintInfo(printMetadata);
            }
            UpdateLocalNameUtil.updateManageOldTplNameAndNumber((String)printMetadata.getId(), (Map)printMetadata.getName(), (String)printMetadata.getKey());
        }
        if (printMeta != null) {
            this.updateRelationOfPageAndScript(printMeta);
        }
    }

    public void saveRuntimeMeta(AbstractMetadata[] metadatas) {
        for (AbstractMetadata metadata : metadatas) {
            if (!(metadata instanceof PrintMetadata)) continue;
            PrintMetadata printMetadata = (PrintMetadata)metadata;
            if (this.isExistedInfo(metadata)) {
                this.updatePrintInfo(printMetadata);
            } else {
                this.insertPrintInfo(printMetadata);
            }
            UpdateLocalNameUtil.updateManageOldTplNameAndNumber((String)printMetadata.getId(), (Map)printMetadata.getName(), (String)printMetadata.getKey());
        }
    }

    private void updateRelationOfPageAndScript(PrintMetadata printMeta) {
        PrintFormAp printFormAp = printMeta.getRootAp();
        if (StringUtils.equals((CharSequence)"bos_devp_pagerelscript", (CharSequence)printFormAp.getKey())) {
            return;
        }
        HashMap<String, Plugin> ksIds = new HashMap<String, Plugin>();
        this.addKSRefId(ksIds, printFormAp.getPlugins());
        String delSql = String.format("delete from t_meta_scriptrelpage where fpageid = '%s';", printMeta.getId());
        DB.execute((DBRoute)DBRoute.meta, (String)delSql, null);
        if (ksIds.size() == 0) {
            return;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((URL)DeployScriptBinder.class.getResource("/SystemEntity/ScriptRelPageEntity.xml"));
        Object[] newObject = new DynamicObject[ksIds.size()];
        int i = 0;
        for (Map.Entry entry : ksIds.entrySet()) {
            DynamicObject obj = new DynamicObject((DynamicObjectType)mainEntityType);
            obj.set("id", (Object)DB.genGlobalLongId());
            obj.set("pageid", (Object)printMeta.getId());
            obj.set("scriptid", entry.getKey());
            obj.set("enable", (Object)(((Plugin)entry.getValue()).isEnabled() ? "1" : "0"));
            newObject[i] = obj;
            ++i;
        }
        BusinessDataWriter.save((IDataEntityType)mainEntityType, (Object[])newObject);
    }

    public void addKSRefId(Map<String, Plugin> ksIds, List<Plugin> list) {
        for (int i = 0; i < list.size(); ++i) {
            Plugin plugin = list.get(i);
            if (1 != plugin.getType()) continue;
            ksIds.put(plugin.getFpk(), plugin);
        }
    }

    public void delete(String id) {
        this.deletePrintInfo(id);
    }

    private boolean isExistedInfo(AbstractMetadata meta) {
        String sql = String.format(EXISTED_SQL, "fid", TABLENAME, FIELD_PRINT_TP_LID);
        Object[] params = new SqlParameter[]{new SqlParameter(FIELD_PRINT_TP_LID, 12, (Object)meta.getId())};
        boolean isExistedInfo = (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                return rs.next();
            }
        });
        return isExistedInfo;
    }

    private void insertPrintInfo(PrintMetadata meta) {
        String formNumber = MetadataDao.getNumberById((String)meta.getEntityId());
        String sql = String.format(INSERT_SQL, TABLENAME);
        long id = DB.genLongId((String)TABLENAME);
        Object[] params = new SqlParameter[8];
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date createdate = new Date();
        Date modifydate = new Date();
        String creator = RequestContext.get().getUserId();
        if (StringUtil.isEmpty((String)meta.getIsv()) || "kingdee".equals(meta.getIsv())) {
            try {
                createdate = dateformat.parse(FIX_TIME);
                modifydate = dateformat.parse(FIX_TIME);
            }
            catch (ParseException e) {
                throw new KDException(e.getCause(), BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u683c\u5f0f\u5316\u5931\u8d25\u3002", (String)"PrintmetaDaoPlugin_1", (String)"bos-svc-metadata", (Object[])new Object[0])});
            }
            creator = "1";
        }
        params[0] = new SqlParameter("fid", -5, (Object)id);
        params[1] = new SqlParameter(FIELD_PRINT_TP_LID, 12, (Object)meta.getId());
        params[2] = new SqlParameter("fbillformid", 12, (Object)formNumber);
        params[3] = new SqlParameter("fcreatetime", 91, (Object)createdate);
        params[4] = new SqlParameter("fmodifytime", 91, (Object)modifydate);
        params[5] = new SqlParameter("fmodifierid", -5, (Object)0);
        params[6] = new SqlParameter("fcreatorid", -5, (Object)creator);
        params[7] = new SqlParameter("fenable", 12, (Object)"1");
        try (TXHandle h = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
        }
        catch (Throwable e) {
            if (e instanceof KDException) {
                throw (KDException)e;
            }
            if (e instanceof OrmException) {
                throw (OrmException)e;
            }
            throw new KDException(e, BosErrorCode.sQL, new Object[]{String.format(ERROR_STR_PLACEHOLDER, e.getMessage())});
        }
    }

    private void updatePrintInfo(PrintMetadata meta) {
        Object[] params;
        boolean updateCreateTime = false;
        String sql = String.format(UPDATE_SQL, TABLENAME);
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date createdate = new Date();
        Date modifydate = new Date();
        String creator = RequestContext.get().getUserId();
        String modifier = RequestContext.get().getUserId();
        Long creatorId = Long.parseLong(creator);
        Long modifierId = Long.parseLong(modifier);
        if (StringUtil.isEmpty((String)meta.getIsv()) || "kingdee".equals(meta.getIsv())) {
            try {
                createdate = dateformat.parse(FIX_TIME);
                modifydate = dateformat.parse(FIX_TIME);
                updateCreateTime = true;
            }
            catch (ParseException e) {
                throw new KDException(e.getCause(), BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u683c\u5f0f\u5316\u5931\u8d25\u3002", (String)"PrintmetaDaoPlugin_1", (String)"bos-svc-metadata", (Object[])new Object[0])});
            }
            creatorId = 1L;
            modifierId = 0L;
        }
        if (updateCreateTime) {
            params = new SqlParameter[]{new SqlParameter("fmodifytime", 91, (Object)modifydate), new SqlParameter("fmodifierid", -5, (Object)modifierId), new SqlParameter("fcreatetime", 91, (Object)createdate), new SqlParameter("fcreatorid", -5, (Object)creatorId), new SqlParameter(FIELD_PRINT_TP_LID, 12, (Object)meta.getId())};
        } else {
            params = new SqlParameter[4];
            sql = sql.replace("fcreatetime = ?,", "");
            params[0] = new SqlParameter("fmodifytime", 91, (Object)modifydate);
            params[1] = new SqlParameter("fmodifierid", -5, (Object)modifierId);
            params[2] = new SqlParameter("fcreatorid", -5, (Object)creatorId);
            params[3] = new SqlParameter(FIELD_PRINT_TP_LID, 12, (Object)meta.getId());
        }
        try (TXHandle h = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
        }
        catch (Throwable e) {
            if (e instanceof KDException) {
                throw (KDException)e;
            }
            if (e instanceof OrmException) {
                throw (OrmException)e;
            }
            throw new KDException(e, BosErrorCode.sQL, new Object[]{String.format(ERROR_STR_PLACEHOLDER, e.getMessage())});
        }
    }

    private void deletePrintInfo(String id) {
        String sql = String.format(DELETE_SQL, TABLENAME);
        Object[] params = new SqlParameter[]{new SqlParameter(FIELD_PRINT_TP_LID, 12, (Object)id)};
        try (TXHandle h = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
        }
        catch (Throwable e) {
            if (e instanceof KDException) {
                throw (KDException)e;
            }
            if (e instanceof OrmException) {
                throw (OrmException)e;
            }
            throw new KDException(e, BosErrorCode.sQL, new Object[]{String.format(ERROR_STR_PLACEHOLDER, e.getMessage())});
        }
    }
}

