/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.commonfield;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.entity.ThumbnailsParameter;
import kd.bos.entity.property.PictureProp;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.PictureEdit;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.list.PictureListColumnAp;
import kd.bos.mservice.svc.picture.IPictureField;

public class PictureField
extends Field<PictureProp>
implements IPictureField {
    private List<ThumbnailsParameter> thumbnailsParam = new ArrayList<ThumbnailsParameter>();
    private boolean lockPreview = true;
    private String backgroundImgKey;
    private String defaultImgKey;
    private boolean allowCropper = false;
    private boolean encryptStorage = false;
    private int imgSourceNew = 0;
    private int maxImgSize = 0;
    private boolean canUpload = false;
    private String cropperProportion = "0";
    private boolean entryLockPreview;
    private boolean editPreview;
    private boolean displayTitle;

    @SimplePropertyAttribute(name="EditPreview")
    @DefaultValueAttribute(value="false")
    public boolean isEditPreview() {
        return this.editPreview;
    }

    public void setEditPreview(boolean editPreview) {
        this.editPreview = editPreview;
    }

    public void setEntryLockPreview(boolean entryLockPreview) {
        this.entryLockPreview = entryLockPreview;
    }

    @SimplePropertyAttribute(name="DisplayTitle")
    @DefaultValueAttribute(value="false")
    public boolean isDisplayTitle() {
        return this.displayTitle;
    }

    public void setDisplayTitle(boolean displayTitle) {
        this.displayTitle = displayTitle;
    }

    @SimplePropertyAttribute(name="EntryLockPreview")
    @DefaultValueAttribute(value="false")
    public boolean isEntryLockPreview() {
        return this.entryLockPreview;
    }

    public PictureField() {
        this.defValueType = 1;
    }

    @SimplePropertyAttribute
    public String getBackgroundImgKey() {
        return this.backgroundImgKey;
    }

    public void setBackgroundImgKey(String backgroundImgKey) {
        this.backgroundImgKey = backgroundImgKey;
    }

    @SimplePropertyAttribute
    public String getDefaultImgKey() {
        return this.defaultImgKey;
    }

    public void setDefaultImgKey(String defaultImgKey) {
        this.defaultImgKey = defaultImgKey;
    }

    @SimplePropertyAttribute(name="LockPreview")
    @DefaultValueAttribute(value="true")
    public boolean isLockPreview() {
        return this.lockPreview;
    }

    public void setLockPreview(boolean lockPreview) {
        this.lockPreview = lockPreview;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=ThumbnailsParameter.class)
    public List<ThumbnailsParameter> getThumbnailsParam() {
        return this.thumbnailsParam;
    }

    public void setThumbnailsParam(List<ThumbnailsParameter> thumbnailsParam) {
        this.thumbnailsParam = thumbnailsParam;
    }

    @SimplePropertyAttribute(name="AllowCropper")
    @DefaultValueAttribute(value="false")
    public boolean isAllowCropper() {
        return this.allowCropper;
    }

    public void setAllowCropper(boolean allowCropper) {
        this.allowCropper = allowCropper;
    }

    @SimplePropertyAttribute(name="EncryptStorage")
    @DefaultValueAttribute(value="false")
    public boolean isEncryptStorage() {
        return this.encryptStorage;
    }

    public void setEncryptStorage(boolean encryptStorage) {
        this.encryptStorage = encryptStorage;
    }

    @SimplePropertyAttribute(name="ImgSourceNew")
    @DefaultValueAttribute(value="0")
    public int getImgSourceNew() {
        return this.imgSourceNew;
    }

    public void setImgSourceNew(int imgSourceNew) {
        this.imgSourceNew = imgSourceNew;
    }

    @SimplePropertyAttribute(name="MaxImgSize")
    public int getMaxImgSize() {
        return this.maxImgSize;
    }

    public void setMaxImgSize(int maxImgSize) {
        this.maxImgSize = maxImgSize;
    }

    protected PictureProp createDynamicProperty() {
        PictureProp pictureProp = new PictureProp();
        pictureProp.setThumbnailsParams(this.thumbnailsParam);
        pictureProp.setBackgroundImgKey(this.backgroundImgKey);
        pictureProp.setDefaultImgKey(this.defaultImgKey);
        pictureProp.setMaxImgSize(this.maxImgSize);
        return pictureProp;
    }

    @DefaultValueAttribute(value="false")
    @SimplePropertyAttribute(name="canUpload")
    public boolean getCanUpload() {
        return this.canUpload;
    }

    public void setCanUpload(boolean canUpload) {
        this.canUpload = canUpload;
    }

    public int getFieldDBType() {
        return -9;
    }

    @SimplePropertyAttribute(name="CropperProportion")
    @DefaultValueAttribute(value="0")
    public String getCropperProportion() {
        return this.cropperProportion;
    }

    public void setCropperProportion(String cropperProportion) {
        this.cropperProportion = cropperProportion;
    }

    public Map<String, Object> createEditor() {
        Map editor = super.createEditor();
        editor.put("type", "picture");
        if (this.thumbnailsParam != null && !this.thumbnailsParam.isEmpty()) {
            Function<ThumbnailsParameter, Map> mapper = param -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("thumbnailsTag", param.getThumbnailsTag());
                map.put("scale", param.getScale());
                return map;
            };
            List paramList = this.thumbnailsParam.stream().map(mapper).collect(Collectors.toList());
            editor.put("thumbparam", paramList);
        }
        editor.put("lp", this.isLockPreview());
        editor.put("lockPreview", this.isEntryLockPreview());
        editor.put("bgik", this.getBackgroundImgKey());
        editor.put("dik", this.getDefaultImgKey());
        editor.put("imgSource", this.getImgSourceNew());
        editor.put("maximgsize", this.getMaxImgSize());
        editor.put("canUpload", this.getCanUpload());
        editor.put("editPreview", this.isEditPreview());
        editor.put("displayTitle", this.isDisplayTitle());
        if (this.allowCropper && this.getCropperProportion() != null) {
            editor.put("cropperProportion", this.getCropperProportion());
        }
        if (this.allowCropper) {
            editor.put("allowcropper", this.allowCropper);
        }
        if (this.encryptStorage) {
            editor.put("encryptStorage", this.encryptStorage);
        }
        return editor;
    }

    protected FieldEdit createServerEditor() {
        return new PictureEdit();
    }

    protected void setServerEditorProperties(FieldEdit editor) {
        super.setServerEditorProperties(editor);
    }

    public Map<String, Object> createEntityTreeNode() {
        Map col = super.createEntityTreeNode();
        col.put("Type", PictureListColumnAp.class.getSimpleName());
        col.put("ThumbnailsParam", this.thumbnailsParam);
        col.put("ShowStyle", 1);
        return col;
    }

    public int getFieldLen() {
        return 255;
    }
}

