/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form.control;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.attachment.extend.service.FileServiceExtensionUtil;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.form.ControlAp;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class AttachmentPanelAp
extends ControlAp<AttachmentPanel> {
    private boolean collapsible = false;
    private boolean defaultcollapse = false;
    private String attachmentCount;
    private String extendName;
    private String entityId;
    private boolean showCreator = true;
    private boolean showCreateDate = true;
    private boolean showMark = true;
    private int maxAtmSize = 20;
    private int maxAtmCount = 0;
    private String attachmentFileSource;
    private boolean showAttachmentCount;
    private boolean imgShowThumbnail;
    private boolean checkDuplicateFileName = false;
    private boolean showTitle = true;
    private boolean showAttachmentTips = true;
    private boolean expandMore = false;
    private String sortField = "uploadTime";
    private String uploadButtonPosition = "default";
    private int compressionThreshold = 0;
    private String sortType = "ASC";
    private boolean dragAtm = false;
    private static final String ATTACHMENT_FILE_SOURCE = "afs";
    private static final String SHOW_ATTACHMENT_COUNT = "san";
    private static final String IMG_SHOW_THUMBNAIL = "istn";
    private static final String IS_DRAG_ATM = "dragAtm";
    private static final String UPLOAD_DOMAIN_URL = "uploadDomainUrl";
    private Tips ctlTips;

    @ComplexPropertyAttribute
    public Tips getCtlTips() {
        return this.ctlTips;
    }

    public void setCtlTips(Tips ctlTips) {
        this.ctlTips = ctlTips;
    }

    @SimplePropertyAttribute(name="ShowAttachmentCount")
    public boolean isShowAttachmentCount() {
        return this.showAttachmentCount;
    }

    public void setShowAttachmentCount(boolean showAttachmentCount) {
        this.showAttachmentCount = showAttachmentCount;
    }

    @SimplePropertyAttribute(name="ImgShowThumbnail")
    @DefaultValueAttribute(value="false")
    public boolean isImgShowThumbnail() {
        return this.imgShowThumbnail;
    }

    public void setImgShowThumbnail(boolean imgShowThumbnail) {
        this.imgShowThumbnail = imgShowThumbnail;
    }

    @SimplePropertyAttribute(name="Collapsible")
    public boolean isCollapsible() {
        return this.collapsible;
    }

    public void setCollapsible(boolean collapsible) {
        this.collapsible = collapsible;
    }

    @SimplePropertyAttribute(name="ShowTitle")
    @DefaultValueAttribute(value="true")
    public boolean isShowTitle() {
        return this.showTitle;
    }

    public void setShowTitle(boolean showTitle) {
        this.showTitle = showTitle;
    }

    @SimplePropertyAttribute(name="ShowAttachmentTips")
    @DefaultValueAttribute(value="true")
    public boolean isShowAttachmentTips() {
        return this.showAttachmentTips;
    }

    public void setShowAttachmentTips(boolean showAttachmentTips) {
        this.showAttachmentTips = showAttachmentTips;
    }

    @SimplePropertyAttribute
    public int getCompressionThreshold() {
        return this.compressionThreshold;
    }

    public void setCompressionThreshold(int compressionThreshold) {
        this.compressionThreshold = compressionThreshold;
    }

    @SimplePropertyAttribute(name="ExpandMore")
    @DefaultValueAttribute(value="false")
    public boolean isExpandMore() {
        return this.expandMore;
    }

    public void setExpandMore(boolean expandMore) {
        this.expandMore = expandMore;
    }

    @SimplePropertyAttribute(name="UploadButtonPosition")
    @DefaultValueAttribute(value="default")
    public String getUploadButtonPosition() {
        return this.uploadButtonPosition;
    }

    public void setUploadButtonPosition(String uploadButtonPosition) {
        this.uploadButtonPosition = uploadButtonPosition;
    }

    @SimplePropertyAttribute(name="DefaultCollapse")
    public boolean isDefaultCollapse() {
        return this.defaultcollapse;
    }

    public void setDefaultCollapse(boolean defaultcollapse) {
        this.defaultcollapse = defaultcollapse;
    }

    @SimplePropertyAttribute
    public String getAttachmentCount() {
        return this.attachmentCount;
    }

    public void setAttachmentCount(String attachmentCount) {
        this.attachmentCount = attachmentCount;
    }

    @SimplePropertyAttribute
    public String getExtendName() {
        return this.extendName;
    }

    public void setExtendName(String extendName) {
        this.extendName = extendName;
    }

    @SimplePropertyAttribute(name="ShowCreator")
    @DefaultValueAttribute(value="true")
    public boolean isShowCreator() {
        return this.showCreator;
    }

    public void setShowCreator(boolean showCreator) {
        this.showCreator = showCreator;
    }

    @SimplePropertyAttribute(name="ShowCreateDate")
    @DefaultValueAttribute(value="true")
    public boolean isShowCreateDate() {
        return this.showCreateDate;
    }

    public void setShowCreateDate(boolean showCreateDate) {
        this.showCreateDate = showCreateDate;
    }

    @SimplePropertyAttribute(name="ShowMark")
    @DefaultValueAttribute(value="true")
    public boolean isShowMark() {
        return this.showMark;
    }

    public void setShowMark(boolean showMark) {
        this.showMark = showMark;
    }

    @SimplePropertyAttribute
    public int getMaxAtmSize() {
        return this.maxAtmSize;
    }

    public void setMaxAtmSize(int maxAtmSize) {
        this.maxAtmSize = maxAtmSize;
    }

    @SimplePropertyAttribute
    public int getMaxAtmCount() {
        return this.maxAtmCount;
    }

    public void setMaxAtmCount(int maxAtmCount) {
        this.maxAtmCount = maxAtmCount;
    }

    @SimplePropertyAttribute(name="checkDuplicateFileName")
    public boolean getCheckDuplicateFileName() {
        return this.checkDuplicateFileName;
    }

    public void setCheckDuplicateFileName(boolean checkDuplicateFileName) {
        this.checkDuplicateFileName = checkDuplicateFileName;
    }

    @SimplePropertyAttribute
    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    @SimplePropertyAttribute
    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public Map<String, Object> createControl() {
        Map ctl = super.createControl();
        ctl.put("type", "attachmentpanel");
        ctl.put("text", this.getName());
        ctl.put("ext", this.getExtendName());
        ctl.put(ATTACHMENT_FILE_SOURCE, this.getFileSourceValue());
        ctl.put("sortField", this.getSortField());
        ctl.put("sortType", this.getSortType());
        ctl.put("checkDuplicateFileName", this.getCheckDuplicateFileName());
        ctl.put(UPLOAD_DOMAIN_URL, FileServiceExtensionUtil.getUploadDomainUrl());
        ctl.put("btnpos", this.getUploadButtonPosition());
        if (this.isCollapsible()) {
            ctl.put("collapsible", Boolean.TRUE);
        }
        if (this.isShowCreator()) {
            ctl.put("sct", Boolean.TRUE);
        }
        if (this.isShowCreateDate()) {
            ctl.put("scd", Boolean.TRUE);
        }
        if (this.isShowMark()) {
            ctl.put("smk", Boolean.TRUE);
        }
        if (this.getCtlTips() != null) {
            ctl.put("tips", this.getCtlTips());
        }
        if (this.getMaxAtmSize() != 0 && this.getMaxAtmSize() != 20) {
            ctl.put("maxatmsize", this.getMaxAtmSize());
        }
        if (this.isShowAttachmentCount()) {
            ctl.put(SHOW_ATTACHMENT_COUNT, this.isShowAttachmentCount());
        }
        if (this.getMaxAtmCount() != 0) {
            ctl.put("maxatmcount", this.getMaxAtmCount());
        }
        if (this.isImgShowThumbnail()) {
            ctl.put(IMG_SHOW_THUMBNAIL, this.isImgShowThumbnail());
        }
        if (this.getDragAtm()) {
            ctl.put(IS_DRAG_ATM, this.getDragAtm());
        }
        ctl.put("sti", this.isShowTitle());
        ctl.put("sat", this.isShowAttachmentTips());
        ctl.put("emo", this.isExpandMore());
        ctl.put("imgCompThr", this.getCompressionThreshold());
        return ctl;
    }

    private int getFileSourceValue() {
        if (StringUtils.isBlank((CharSequence)this.getAttachmentFileSource())) {
            return 7;
        }
        HashMap<String, Integer> mapFileSource = new HashMap<String, Integer>(5);
        mapFileSource.put("clouddrive", 1);
        mapFileSource.put("album", 2);
        mapFileSource.put("photo", 4);
        mapFileSource.put("localfile", 8);
        mapFileSource.put("recordvideo", 16);
        Iterator it = mapFileSource.keySet().iterator();
        while (it.hasNext()) {
            if (this.getAttachmentFileSource().contains((CharSequence)it.next())) continue;
            it.remove();
        }
        if (mapFileSource.size() > 0) {
            int v = 0;
            Collection values = mapFileSource.values();
            Iterator it2 = values.iterator();
            while (it2.hasNext()) {
                v += ((Integer)it2.next()).intValue();
            }
            return v;
        }
        return 7;
    }

    protected AttachmentPanel createRuntimeControl() {
        EntityItem entityItem;
        AttachmentPanel panel = new AttachmentPanel();
        if (StringUtils.isNotBlank((CharSequence)this.getAttachmentCount()) && (entityItem = this.formMetadata.getEntityMetadata().getItemById(this.getAttachmentCount())) != null) {
            panel.setAttachmentCountField(entityItem.getKey());
        }
        panel.setDefaultCollapse(this.isDefaultCollapse());
        if (StringUtils.isNotBlank((CharSequence)this.getEntityId())) {
            panel.setEntityId(MetadataDao.getNumberById((String)this.getEntityId()));
        }
        panel.setDragAtm(this.dragAtm);
        return panel;
    }

    @SimplePropertyAttribute
    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="clouddrive,album,photo")
    public String getAttachmentFileSource() {
        if (this.attachmentFileSource == null) {
            this.attachmentFileSource = "clouddrive,album,photo";
        }
        return this.attachmentFileSource;
    }

    public void setAttachmentFileSource(String attachmentFileSource) {
        this.attachmentFileSource = StringUtils.isNotBlank((CharSequence)attachmentFileSource) ? attachmentFileSource : "clouddrive,album,photo";
    }

    @SimplePropertyAttribute(name="DragAtm")
    public boolean getDragAtm() {
        return this.dragAtm;
    }

    public void setDragAtm(boolean dragAtm) {
        this.dragAtm = dragAtm;
    }
}

