/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.attachment;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IAttachmentFieldModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.url.UrlService;

public class AttachmentFieldModel
implements IAttachmentFieldModel {
    private static final Log log = LogFactory.getLog(AttachmentFieldModel.class);

    @Override
    public List<DynamicObject> saveAttachments(IDataModel model, String pageId, String entityId, List<Map<String, Object>> attachs) {
        if (model != null) {
            String formId = StringUtils.isBlank((CharSequence)entityId) ? model.getDataEntityType().getName() : entityId;
            return AttachmentFieldServiceHelper.saveAttachments(formId, pageId, attachs);
        }
        return new ArrayList<DynamicObject>();
    }

    @Override
    public void deleteAttachments(String formId, String tableName, Map<String, Object> attachs) {
        AttachmentFieldServiceHelper.removeAttachments(formId, tableName, attachs);
    }

    @Override
    public void mark(String uid, LocaleString description) {
        AttachmentFieldServiceHelper.saveMark(uid, description);
    }

    @Override
    public void mark(String uid, LocaleString description, String attPkId) {
        AttachmentFieldServiceHelper.saveMark(uid, description, attPkId);
    }

    @Override
    public void rename(String uid, String name) {
        AttachmentFieldServiceHelper.rename(uid, name);
    }

    @Override
    public void rename(String uid, String name, String attPkId) {
        AttachmentFieldServiceHelper.rename(uid, name, attPkId);
    }

    @Override
    public void setDragSeq(Integer dragSeq, String attPkId) {
        AttachmentFieldServiceHelper.saveDragSeq(dragSeq, attPkId);
    }

    @Override
    public boolean ablePreView(String type) {
        return AttachmentFieldServiceHelper.ablePreView(type);
    }

    @Override
    public String getTempFilePreviewUrl(String path) {
        try {
            if (StringUtils.isBlank((CharSequence)path) || !path.contains("tempfile/download.do?configKey")) {
                return path;
            }
            String url = UrlService.getAttachmentPreviewUrl((String)"");
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            return url + URLEncoder.encode(path, "utf-8") + "&isFromCache=true";
        }
        catch (Exception e) {
            log.error("\u4e34\u65f6\u6587\u4ef6\u7f16\u7801\u8def\u5f84\u5931\u8d25,path = " + path);
            return null;
        }
    }

    @Override
    public String checkSpeSymbol(String fileName) {
        return AttachmentServiceHelper.checkSpeSymbol(fileName);
    }

    @Override
    public boolean ablePreView(Map attMap) {
        return AttachmentServiceHelper.ablePreView(attMap);
    }
}

