/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import kd.bos.attachment.DisposableUrlParam;
import kd.bos.attachment.manage.AttachmentManageUtils;
import kd.bos.attachment.util.BillFileMappingWriter;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.TempTransResult;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.param.CustomParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.fileservice.utils.FileUtil;
import kd.bos.form.attachment.common.AttachmentKit;
import kd.bos.form.attachment.util.AttachmentManageUtil;
import kd.bos.form.attachment.util.ParamUtil;
import kd.bos.form.attachment.util.SupportPreviewTypeConstant;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.commonfield.AttachmentField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.mservice.attachment.AttachmentInfo;
import kd.bos.mservice.attachment.AttachmentOpType;
import kd.bos.mservice.attachment.AttachmentType;
import kd.bos.mservice.attachment.IAttachmentManagerService;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.param.service.IParameterReaderService;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.service.attachment.FileItemExt;
import kd.bos.service.attachment.FileSource;
import kd.bos.servicehelper.AttDto;
import kd.bos.servicehelper.AttachmentDto;
import kd.bos.servicehelper.BindingAttachmentInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.svc.util.PermissionParam;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.math.NumberUtils;

@SdkPublic
@KSObject
public class AttachmentServiceHelper {
    private static final String AttachmentPanelEntityNumber = "bos_attachment";
    private static final String CREATE_DATE = "createdate";
    private static final String CREATOR = "creator";
    private static final String CREATOR_ID = "createUserId";
    private static final String FNUMBER = "FNUMBER";
    private static final String F_INTER_ID = "FInterID";
    private static final String F_BILL_TYPE = "FBillType";
    private static final String F_MODIFY_TIME = "FModifyTime";
    private static final String FALIAS_FILE_NAME = "FaliasFileName";
    private static final String FATTACHMENT_PANEL = "fattachmentpanel";
    private static final String F_EXT_NAME = "FExtName";
    private static final String F_FILE_ID = "FFileId";
    private static final String F_ID_FILEID = "ID,FInterId,FFileId";
    private static final String FDESCRIPTION = "fdescription";
    private static final String F_ATTACHMENT_NAME = "FAttachmentName";
    private static final String LAST_MODIFIED = "lastModified";
    private static final String FATTACHMENTSIZE = "FATTACHMENTSIZE";
    private static final String CONFIG_KEY = "tempfile/download.do?configKey";
    private static final String FCREATEMEN = "FCREATEMEN";
    private static final String SUCCESS = "success";
    private static final String FEXTNAME = "FEXTNAME";
    private static final String DESCRIPTION = "description";
    private static final String FCREATETIME = "fcreatetime";
    private static final String LOCAL_ID = "localId";
    private static final String SORT = "sort";
    private static final String FNUMBER_ASC = "FNUMBER ASC";
    private static final String FDRAGSEQ_ASC = "DRAGSEQ ASC";
    private static final String UTF_8 = "UTF-8";
    private static final String STATUS = "status";
    private static final String BILL_PK_ID = "billPkId";
    private static final String FORM_NUMBER = "formNumber";
    private static final String FILESOURCE = "filesource";
    private static final String IS_LOSE_EFFICACY = "is_Lose_Efficacy";
    private static final String BOS_SVC_METADATA = "bos-svc-metadata";
    private static final String DRAGSEQ = "dragseq";
    private static DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));
    public static final String PLUS = "+";
    public static final String DIV = "/";
    public static final String QUES = "?";
    public static final String PER = "%";
    public static final String WELL = "#";
    public static final String AND = "&";
    public static final String EQUAL = "=";
    public static final String[] SPECIAL_SYMBOLS = new String[]{"%", "=", "+"};
    public static final String[] SPECIAL_CHARACTERS = new String[]{"+", "/", "?", "%", "#", "&", "="};
    private static Log log = LogFactory.getLog(AttachmentServiceHelper.class);
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"AttachmentServiceHelper", (int)5);
    public static final String IMAGE_TYPE = "jpg,jpeg,png,gif,bmp,tiff,tga,ico,dib,rle,emf,jpe,jfif,pcx,dcx,pic,tif,wmf";
    private static String defaultSpeSymbol = "/\\*\"?:<>|";

    public static String getCacheJsonString(String attachKey, List<Map<String, Object>> attachments, String cacheJsonString) {
        Map attachmentInfo = null;
        attachmentInfo = StringUtils.isEmpty((CharSequence)cacheJsonString) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)cacheJsonString, Map.class);
        if (attachmentInfo.get(attachKey) == null) {
            attachmentInfo.put(attachKey, attachments);
        } else {
            List oldAttachments = (List)attachmentInfo.get(attachKey);
            oldAttachments.addAll(attachments);
            attachmentInfo.put(attachKey, oldAttachments);
        }
        AttachmentServiceHelper.setAttCreatedateAndCreators((List)attachmentInfo.get(attachKey));
        cacheJsonString = SerializationUtils.toJsonString(attachmentInfo);
        AttachmentServiceHelper.setAttCreatedateAndCreators(attachments);
        return cacheJsonString;
    }

    private static void setAttCreatedateAndCreators(List<Map<String, Object>> attachments) {
        for (Map<String, Object> attachment : attachments) {
            AttachmentServiceHelper.setAttCreatedateAndCreator(attachment);
        }
    }

    private static void setAttCreatedateAndCreator(Map<String, Object> attachment) {
        long createTime = new Date().getTime();
        if (attachment.containsKey("uploadTime")) {
            createTime = (Long)attachment.get("uploadTime");
        }
        attachment.put(CREATE_DATE, createTime);
        DynamicObject name = UserServiceHelper.getCurrentUser((String)RequestContext.get().getUserName());
        attachment.put(CREATOR, name == null ? new LocaleString(RequestContext.get().getUserName()) : name.getLocaleString("name"));
        attachment.put("endProgress", Boolean.TRUE);
    }

    public static boolean isTempAttachment(Map<String, Object> attachInfo) {
        return ((String)attachInfo.getOrDefault("url", "")).contains(CONFIG_KEY) || Boolean.TRUE.equals(attachInfo.get("tempBotpAttachment"));
    }

    @KSMethod
    public static DynamicObjectCollection saveTempAttachments(String formId, Object pkId, String appId, Map<String, Object> attachmentMap) {
        return AttachmentServiceHelper.doSaveTempAttachments(null, formId, pkId, appId, attachmentMap);
    }

    @KSMethod
    public static DynamicObjectCollection saveTempAttachments(String billNo, String formId, Object pkId, String appId, Map<String, Object> attachmentMap) {
        return AttachmentServiceHelper.doSaveTempAttachments(billNo, formId, pkId, appId, attachmentMap);
    }

    private static DynamicObjectCollection doSaveTempAttachments(String billNo, String formId, Object pkId, String appId, Map<String, Object> attachmentMap) {
        log.info("kd.bos.servicehelper.AttachmentServiceHelper.saveTempAttachments - attachmentMap = " + SerializationUtils.toJsonString(attachmentMap));
        pkId = pkId instanceof String ? pkId : "" + pkId;
        ORM orm = ORM.create();
        DynamicObjectType entityType = (DynamicObjectType)orm.getDataEntityType(AttachmentPanelEntityNumber);
        HashMap<Object, Map<String, Object>> uidAttachs = new HashMap<Object, Map<String, Object>>();
        HashMap<Object, String> attachKeys = new HashMap<Object, String>();
        HashMap<String, List<Map<String, Object>>> triggerDoOperationAttachs = new HashMap<String, List<Map<String, Object>>>();
        AttachmentServiceHelper.groupBillAttachments(attachmentMap, uidAttachs, attachKeys, triggerDoOperationAttachs);
        DynamicObjectCollection dynColl = AttachmentServiceHelper.loadBillAttachments(orm, formId, pkId, uidAttachs.keySet());
        long compressPicSize = AttachmentServiceHelper.getCompressPicSize();
        Date today = new Date();
        if (dynColl == null) {
            dynColl = new DynamicObjectCollection(entityType, null);
        } else if (!dynColl.isEmpty()) {
            AttachmentServiceHelper.updateExistTempAttachments(dynColl, uidAttachs, attachKeys, compressPicSize, appId, formId, pkId);
        }
        if (!uidAttachs.isEmpty()) {
            AttachmentServiceHelper.createNewAttachments(orm, dynColl, entityType, uidAttachs, attachKeys, triggerDoOperationAttachs, compressPicSize, appId, formId, pkId, today);
        }
        try (TXHandle h = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])dynColl.toArray((Object[])new DynamicObject[0])));
        }
        if (!triggerDoOperationAttachs.isEmpty()) {
            AttachmentServiceHelper.triggerAfterDoOperation(triggerDoOperationAttachs, appId, formId, pkId, today, billNo);
        }
        return dynColl;
    }

    private static void triggerAfterDoOperation(Map<String, List<Map<String, Object>>> triggerDoOperationAttachs, String appId, String formId, Object pkId, Date today, String billNo) {
        IAttachmentManagerService managerService = (IAttachmentManagerService)ServiceFactory.getService(IAttachmentManagerService.class);
        ArrayList<AttachmentInfo> infos = new ArrayList<AttachmentInfo>(10);
        for (Map.Entry<String, List<Map<String, Object>>> entry : triggerDoOperationAttachs.entrySet()) {
            List<Map<String, Object>> attachs = entry.getValue();
            if (attachs == null || attachs.isEmpty()) continue;
            String attachKey = entry.getKey();
            for (Map<String, Object> attach : attachs) {
                Long id = (Long)attach.get("id");
                String name = (String)attach.get("name");
                String extName = (String)attach.get("extName");
                Long size = Long.parseLong(attach.get("size").toString());
                String url = (String)attach.get("url");
                AttachmentInfo attachmentInfo = new AttachmentInfo();
                attachmentInfo.setAttSourceType(AttachmentType.attachmentpanel);
                attachmentInfo.setAttKey(attachKey);
                attachmentInfo.setEntityNum((String)attach.get("entityNum"));
                attachmentInfo.setBillPkId(pkId.toString());
                attachmentInfo.setAttPkId(id);
                attachmentInfo.setExt(extName);
                attachmentInfo.setFileName(name);
                attachmentInfo.setFileSize(size);
                attachmentInfo.setDownloadUrl(url);
                attachmentInfo.setPreviewUrl(url.replace("download.do", "preview.do"));
                attachmentInfo.setMark((String)attach.get(DESCRIPTION));
                if (attach.containsKey("uploadTime")) {
                    attachmentInfo.setCreateTime(new Date((Long)attach.get("uploadTime")));
                } else {
                    attachmentInfo.setCreateTime(today);
                }
                attachmentInfo.setCreateUserId(RequestContext.get().getUserId());
                attachmentInfo.setModifyTime(today);
                attachmentInfo.setClient((String)attach.get("client"));
                if (StringUtils.isBlank((CharSequence)billNo)) {
                    attachmentInfo.setBillno((String)attach.get("billno"));
                } else {
                    attachmentInfo.setBillno(billNo);
                }
                infos.add(attachmentInfo);
            }
            managerService.afterDoOperation(infos, AttachmentOpType.Save);
            infos.clear();
        }
    }

    private static void createNewAttachments(ORM orm, DynamicObjectCollection dynColl, DynamicObjectType entityType, Map<Object, Map<String, Object>> uidAttachs, Map<Object, String> attachKeys, Map<String, List<Map<String, Object>>> triggerDoOperationAttachs, long compressPicSize, String appId, String formId, Object pkId, Date today) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        long[] ids = orm.genLongIds((IDataEntityType)entityType, uidAttachs.size());
        int i = 0;
        for (Map.Entry<Object, Map<String, Object>> entry : uidAttachs.entrySet()) {
            Object dragSeq;
            String attachKey = attachKeys.remove(entry.getKey());
            Map<String, Object> attach = entry.getValue();
            DynamicObject dynamicObject = new DynamicObject(entityType);
            dynamicObject.set("id", (Object)ids[i]);
            attach.put("id", ids[i]);
            dynamicObject.set(FNUMBER, attach.get("uid"));
            dynamicObject.set(F_BILL_TYPE, (Object)formId);
            dynamicObject.set(F_INTER_ID, pkId);
            Object lastModified = attach.get(LAST_MODIFIED);
            if (lastModified instanceof Date) {
                dynamicObject.set(F_MODIFY_TIME, lastModified);
            } else if (lastModified instanceof Long) {
                dynamicObject.set(F_MODIFY_TIME, (Object)new Date((Long)lastModified));
            } else {
                dynamicObject.set(F_MODIFY_TIME, (Object)today);
            }
            if (attach.containsKey("uploadTime")) {
                dynamicObject.set(FCREATETIME, (Object)new Date((Long)attach.get("uploadTime")));
            } else {
                dynamicObject.set(FCREATETIME, (Object)today);
            }
            String name = (String)attach.get("name");
            dynamicObject.set(FALIAS_FILE_NAME, (Object)name);
            dynamicObject.set(F_ATTACHMENT_NAME, (Object)name);
            String extName = name != null ? name.substring(name.lastIndexOf(46) + 1) : "";
            dynamicObject.set(F_EXT_NAME, (Object)extName);
            attach.put("extName", extName);
            dynamicObject.set(FCREATEMEN, StringUtils.isBlank((Object)attach.get(CREATOR_ID)) ? RequestContext.get().getUserId() : attach.get(CREATOR_ID));
            dynamicObject.set(FATTACHMENT_PANEL, (Object)attachKey);
            dynamicObject.set(FDESCRIPTION, attach.get(DESCRIPTION));
            dynamicObject.set(FILESOURCE, attach.get(FILESOURCE));
            Object sortObj = attach.get(SORT);
            if (sortObj != null) {
                dynamicObject.set(SORT, sortObj);
            }
            if ((dragSeq = attach.get(DRAGSEQ)) != null) {
                dynamicObject.set(DRAGSEQ, dragSeq);
            }
            String tempUrl = (String)attach.get("url");
            String url = "";
            url = StringUtils.isNotBlank((CharSequence)tempUrl) && tempUrl.contains(CONFIG_KEY) ? AttachmentServiceHelper.saveTempToFileService(tempUrl, appId, formId, pkId, name) : tempUrl;
            long size = Long.parseLong(attach.get("size").toString());
            if (IMAGE_TYPE.contains(extName.toLowerCase()) && compressPicSize != 0L && size > compressPicSize * 1024L) {
                size = fileService.getFileSize(url);
            }
            dynamicObject.set(FATTACHMENTSIZE, (Object)size);
            attach.put("size", size);
            while (url.startsWith("//")) {
                url = url.substring(1);
            }
            dynamicObject.set(F_FILE_ID, (Object)url);
            attach.put("url", url);
            dynamicObject.set(LOCAL_ID, attach.get(LOCAL_ID));
            dynColl.add((Object)dynamicObject);
            List<Map<String, Object>> attachs = triggerDoOperationAttachs.get(attachKey);
            if (attachs == null) {
                attachs = new ArrayList<Map<String, Object>>();
                triggerDoOperationAttachs.put(attachKey, attachs);
            }
            attachs.add(attach);
            ++i;
        }
    }

    private static void updateExistTempAttachments(DynamicObjectCollection dynColl, Map<Object, Map<String, Object>> uidAttachs, Map<Object, String> attachKeys, long compressPicSize, String appId, String formId, Object pkId) {
        for (DynamicObject dyn : dynColl) {
            String attachKey = attachKeys.remove(dyn.get(FNUMBER));
            Map<String, Object> attach = uidAttachs.remove(dyn.get(FNUMBER));
            Object lastModified = attach.get(LAST_MODIFIED);
            if (lastModified != null) {
                if (lastModified.toString().contains(":")) {
                    dyn.set(F_MODIFY_TIME, (Object)DateUtils.parseDate((Object)lastModified));
                } else {
                    dyn.set(F_MODIFY_TIME, (Object)new Date((Long)lastModified));
                }
            } else {
                dyn.set(F_MODIFY_TIME, (Object)new Date());
            }
            String name = (String)attach.get("name");
            dyn.set(FALIAS_FILE_NAME, (Object)name);
            dyn.set(F_ATTACHMENT_NAME, (Object)name);
            String extName = name != null ? name.substring(name.lastIndexOf(46) + 1) : "";
            dyn.set(F_EXT_NAME, (Object)extName);
            if (IMAGE_TYPE.contains(extName.toLowerCase()) && compressPicSize != 0L && Long.parseLong(attach.get("size").toString()) > compressPicSize * 1024L) {
                dyn.set(FATTACHMENTSIZE, (Object)(compressPicSize * 1024L));
            } else {
                dyn.set(FATTACHMENTSIZE, attach.get("size"));
            }
            dyn.set(FATTACHMENT_PANEL, (Object)attachKey);
            dyn.set(FDESCRIPTION, attach.get(DESCRIPTION));
            Object sortObj = attach.get(SORT);
            if (sortObj != null) {
                dyn.set(SORT, sortObj);
            }
            String tempUrl = (String)attach.get("url");
            String url = "";
            url = StringUtils.isNotBlank((CharSequence)tempUrl) && tempUrl.contains(CONFIG_KEY) ? AttachmentServiceHelper.saveTempToFileService(tempUrl, appId, formId, pkId, name) : tempUrl;
            dyn.set(F_FILE_ID, (Object)url);
        }
    }

    private static void groupBillAttachments(Map<String, Object> attachmentMap, Map<Object, Map<String, Object>> uidAttachs, Map<Object, String> attachKeys, Map<String, List<Map<String, Object>>> triggerDoOperationAttachs) {
        for (Map.Entry<String, Object> info : attachmentMap.entrySet()) {
            List attachments = (List)info.getValue();
            for (Map attach : attachments) {
                if (AttachmentServiceHelper.isTempAttachment(attach)) {
                    Object uid = attach.get("uid");
                    uidAttachs.put(uid, attach);
                    attachKeys.put(uid, info.getKey());
                    continue;
                }
                if (triggerDoOperationAttachs == null) continue;
                List<Map<String, Object>> attachs = triggerDoOperationAttachs.get(info.getKey());
                if (attachs == null) {
                    attachs = new ArrayList<Map<String, Object>>();
                    triggerDoOperationAttachs.put(info.getKey(), attachs);
                }
                attachs.add(attach);
            }
        }
    }

    private static DynamicObjectCollection loadBillAttachments(ORM orm, String formId, Object pkId, Set<Object> set) {
        if (pkId != null) {
            pkId = pkId instanceof String ? pkId : "" + pkId;
        }
        QFilter[] filters = new QFilter[]{new QFilter(FNUMBER, "in", set), new QFilter(F_INTER_ID, EQUAL, pkId), new QFilter(F_BILL_TYPE, EQUAL, (Object)formId)};
        return orm.getByFilter(AttachmentPanelEntityNumber, filters);
    }

    public static String getAttUrlWithVersion(String url) {
        return url + "?v=1";
    }

    public static String removeUrlVersion(String versionUrl) {
        return versionUrl.replace("?v=1", "");
    }

    public static String saveTempToFileService(String tempUrl, String appId, String formId, Object pkId, String fileName) {
        return AttachmentServiceHelper.saveTempToFileService(tempUrl, appId, formId, pkId, fileName, false);
    }

    public static String saveTempToFileService(String tempUrl, String appId, String formId, Object pkId, String fileName, boolean isDeleteTempFile) {
        return AttachmentServiceHelper.saveTempToFileService(tempUrl, appId, formId, pkId, fileName, isDeleteTempFile, true);
    }

    public static String saveTempToFileService(String tempUrl, String appId, String formId, Object pkId, String fileName, boolean isDeleteTempFile, boolean createNewFileWhenExists) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String path = FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (String)appId, (String)formId, (Object)AttachmentServiceHelper.replaceSpeChar(String.valueOf(pkId)), (String)(uuid + DIV + AttachmentServiceHelper.replaceSpeSymbol(fileName)));
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        FileItemExt fileItem = new FileItemExt(fileName, path, null);
        fileItem.setSource(FileSource.ATTACHMENT_PANEL);
        fileItem.setComputeDigest(true);
        fileItem.setCreateNewFileWhenExists(createNewFileWhenExists);
        fileItem.setAppId(appId);
        fileItem.setVerified(true);
        if (!tempFileCache.supportTempToData(tempUrl)) {
            InputStream inputStream;
            TempFileCacheDownloadable downloadable = (TempFileCacheDownloadable)tempFileCache;
            try {
                Map<String, String> params = AttachmentServiceHelper.parseUrl(tempUrl);
                TempFileCacheDownloadable.Content content = downloadable.download(params);
                inputStream = content.getInputStream();
            }
            catch (Exception e) {
                log.error((Throwable)e);
                throw new KDException(new ErrorCode("GET_TEMP_FILE_ERROR", ResManager.loadKDString((String)"\u4e34\u65f6\u6587\u4ef6\u83b7\u53d6\u5931\u8d25\u3002", (String)"AttachmentServiceHelper_0", (String)BOS_SVC_METADATA, (Object[])new Object[0])), new Object[0]);
            }
            fileItem.setInputStream(inputStream);
            String url = service.upload((FileItem)fileItem);
            if (isDeleteTempFile) {
                tempFileCache.remove(tempUrl);
            }
            return url;
        }
        fileItem.setTempFileUrl(tempUrl);
        ArrayList<FileItemExt> fileItemList = new ArrayList<FileItemExt>(1);
        fileItemList.add(fileItem);
        List tempTransResults = service.moveTempFile(fileItemList);
        return ((TempTransResult)tempTransResults.get(0)).getPath();
    }

    public static long getCompressPicSize() {
        Map cache = SystemParamServiceHelper.loadPublicParametersFromCache();
        if (cache != null && cache.size() > 0 && cache.get("compresspicsize") != null) {
            return Long.parseLong(cache.get("compresspicsize").toString());
        }
        return 0L;
    }

    public static long getDownloadNeedFreeSpace() {
        Map customParameterFromCache = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam());
        String attachmentDownloadAllFreeSpace = (String)customParameterFromCache.get("ATTACHMENT_DOWNLOAD_ALL_FREE_SPACE");
        if (StringUtils.isNotEmpty((CharSequence)attachmentDownloadAllFreeSpace)) {
            try {
                return Long.parseLong(attachmentDownloadAllFreeSpace);
            }
            catch (NumberFormatException e) {
                log.error("[\u9644\u4ef6\u5168\u90e8\u4e0b\u8f7d\uff1a]\u83b7\u53d6\u81ea\u5b9a\u4e49\u53c2\u6570\u503c\uff1a\u201d\u78c1\u76d8\u5269\u4f59\u7a7a\u95f4\u201c \u5f02\u5e38 " + e);
                return 0xC800000L;
            }
        }
        return 0xC800000L;
    }

    public static String getSpeSymbol() {
        Map cache = SystemParamServiceHelper.loadPublicParametersFromCache();
        log.info("kd.bos.servicehelper.AttachmentServiceHelper.getSpeSymbol SystemParamServiceHelper.loadPublicParametersFromCache()--- " + SerializationUtils.toJsonString((Object)cache));
        if (cache != null && cache.size() > 0 && cache.get("spesymbol") != null) {
            return cache.get("spesymbol").toString();
        }
        return "";
    }

    public static String checkSpeSymbol(String fileFullName) {
        String res;
        log.info("kd.bos.web.actions.AttachmentAction.checkSpeSymbol fileName ---- " + fileFullName);
        String speSymbol = AttachmentServiceHelper.getSpeSymbol();
        if (speSymbol == null) {
            speSymbol = "";
        }
        if (StringUtils.isNotBlank((CharSequence)(res = AttachmentServiceHelper.checkSpeSymbol(fileFullName, AttachmentServiceHelper.getSpeSymbol(defaultSpeSymbol, speSymbol = speSymbol.replaceAll("\\s*", "")))))) {
            return res;
        }
        return "";
    }

    private static String checkSpeSymbol(String fileFullName, String speSymbol) {
        String fileName = fileFullName.substring(0, fileFullName.lastIndexOf(46));
        for (int i = 0; i < speSymbol.length(); ++i) {
            char speSymbolChar = speSymbol.charAt(i);
            if (!fileName.contains(speSymbolChar + "")) continue;
            return speSymbol + "";
        }
        return "";
    }

    private static String getSpeSymbol(String defaultSpeSymbol, String speSymbol) {
        char[] chars = speSymbol.toCharArray();
        StringBuilder tempSpeSymbol = new StringBuilder();
        for (char aChar : chars) {
            if (defaultSpeSymbol.contains(aChar + "")) continue;
            tempSpeSymbol.append(aChar);
        }
        return defaultSpeSymbol + tempSpeSymbol;
    }

    private static String replaceSpeChar(String str) {
        for (int i = 0; i < SPECIAL_CHARACTERS.length; ++i) {
            if (!str.contains(SPECIAL_CHARACTERS[i])) continue;
            str = str.replace(SPECIAL_CHARACTERS[i], "");
        }
        return str;
    }

    public static String replaceSpeSymbol(String str) {
        for (int i = 0; i < SPECIAL_SYMBOLS.length; ++i) {
            if (!str.contains(SPECIAL_SYMBOLS[i])) continue;
            str = str.replace(SPECIAL_SYMBOLS[i], "_");
        }
        return str;
    }

    @KSMethod
    public static List<Map<String, Object>> getAttachments(String formId, Object pkId, String attachKey) {
        return AttachmentServiceHelper.getAttachments(formId, pkId, attachKey, true);
    }

    @KSMethod
    public static List<Map<String, Object>> getAttachments(String formId, Object pkId, String attachKey, boolean enableTempAccess) {
        return AttachmentServiceHelper.getAttachments(formId, new Object[]{pkId}, attachKey, enableTempAccess).getOrDefault(String.valueOf(pkId), new ArrayList());
    }

    @KSMethod
    public static Map<String, List<Map<String, Object>>> getAttachments(String formId, Object[] pkIds, String attachKey, boolean enableTempAccess) {
        return AttachmentServiceHelper.getAttachments(formId, pkIds, attachKey, enableTempAccess, false);
    }

    @KSMethod
    public static Map<String, List<Map<String, Object>>> getAttachments(String formId, Object[] pkIds, String attachKey, boolean enableTempAccess, boolean dragAtm) {
        QFilter[] filters;
        ORM orm;
        DynamicObjectCollection dynColl;
        HashMap<String, List<Map<String, Object>>> datas = new HashMap<String, List<Map<String, Object>>>();
        List<String> attachBillPks = AttachmentServiceHelper.rebuildBillPkIds(pkIds);
        if (!attachBillPks.isEmpty() && (dynColl = (orm = ORM.create()).getByFilter(AttachmentPanelEntityNumber, filters = new QFilter[]{new QFilter(F_BILL_TYPE, EQUAL, (Object)formId), new QFilter(F_INTER_ID, "in", attachBillPks), new QFilter(FATTACHMENT_PANEL, EQUAL, (Object)attachKey)}, dragAtm ? FDRAGSEQ_ASC : FNUMBER_ASC)) != null && !dynColl.isEmpty()) {
            ArrayList<DynamicObject> upd = new ArrayList<DynamicObject>();
            for (DynamicObject obj : dynColl) {
                DynamicObject creator;
                HashMap<String, Object> map = new HashMap<String, Object>(32);
                String billPkId = obj.getString(F_INTER_ID);
                String name = (String)obj.get(F_ATTACHMENT_NAME);
                String url = null;
                try {
                    url = URLEncoder.encode(AttachmentServiceHelper.removeUrlVersion(String.valueOf(obj.get(F_FILE_ID))), UTF_8);
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Throwable)e);
                }
                String attUrl = UrlService.getAttachmentFullUrl(url);
                if (enableTempAccess) {
                    attUrl = AttachmentServiceHelper.getEncreptURL(attUrl);
                }
                map.put(LAST_MODIFIED, obj.get(F_MODIFY_TIME));
                map.put("name", name);
                map.put("size", Long.parseLong((String)obj.get(FATTACHMENTSIZE)));
                map.put("uid", obj.get(FNUMBER));
                if (dragAtm) {
                    map.put(DRAGSEQ, obj.get(DRAGSEQ));
                }
                map.put("url", attUrl);
                map.put("relativeUrl", String.valueOf(obj.get(F_FILE_ID)));
                map.put("attPkId", obj.getPkValue());
                map.put("entityNum", obj.get("FBILLTYPE"));
                map.put("fileSource", obj.get(FILESOURCE));
                map.put("downloadFilePath", AttachmentManageUtil.getPath(attUrl, true));
                map.put(LOCAL_ID, obj.get(LOCAL_ID));
                map.put(BILL_PK_ID, billPkId);
                Object sort = obj.get(SORT);
                if (sort != null) {
                    map.put(SORT, sort);
                }
                String type = (String)obj.get(FEXTNAME);
                map.put("type", type);
                if (AttachmentServiceHelper.ablePreView(map)) {
                    String previewUrl = attUrl.replace("download.do", "preview.do");
                    map.put("previewurl", previewUrl);
                    map.put("previewFilePath", AttachmentManageUtil.getPath(previewUrl, false));
                }
                map.put(DESCRIPTION, obj.get(FDESCRIPTION));
                map.put(STATUS, SUCCESS);
                Object attachmentKey = obj.get(FATTACHMENT_PANEL);
                if (StringUtils.isBlank((Object)attachmentKey)) {
                    obj.set(FATTACHMENT_PANEL, (Object)attachKey);
                    upd.add(obj);
                }
                map.put(FATTACHMENT_PANEL, attachKey);
                Timestamp createdate = (Timestamp)obj.get(FCREATETIME);
                if (createdate != null) {
                    map.put(CREATE_DATE, createdate.getTime());
                }
                if ((creator = (DynamicObject)obj.get(FCREATEMEN)) != null) {
                    map.put(CREATOR, creator.get(((BasedataEntityType)creator.getDataEntityType()).getNameProperty()));
                    map.put(CREATOR_ID, creator.get("id"));
                }
                datas.computeIfAbsent(billPkId, k -> new ArrayList()).add(map);
            }
            if (!upd.isEmpty()) {
                orm.update(upd);
            }
        }
        return datas;
    }

    private static boolean isDragAtm(String formId, String attachKey) {
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        if (formMeta != null) {
            List aps = formMeta.getItems();
            for (ControlAp ap : aps) {
                if (!StringUtils.equals((CharSequence)ap.getKey(), (CharSequence)attachKey) || !(ap instanceof AttachmentPanelAp)) continue;
                return ((AttachmentPanelAp)ap).getDragAtm();
            }
        }
        return false;
    }

    private static List<String> rebuildBillPkIds(Object[] pkIds) {
        ArrayList<String> pkList = new ArrayList<String>();
        if (pkIds == null) {
            return pkList;
        }
        for (Object pk : pkIds) {
            if (pk == null) continue;
            pkList.add(String.valueOf(pk));
        }
        return pkList;
    }

    @Deprecated
    public static boolean ablePreView(String type) {
        boolean enablePreView = AttachmentServiceHelper.isEnablePreView();
        return FileUtil.isExtExist((String)type) && enablePreView;
    }

    private static boolean isEnablePreView() {
        Map securityParam = ((IParameterReaderService)ServiceSvcFactory.getService(IParameterReaderService.class)).loadPublicParameterFromCache("bos_filesecurityparam");
        String canPreview = securityParam.size() == 0 ? System.getProperty("fileserver.attachment.preview") : String.valueOf(securityParam.get("attpreviewable"));
        boolean isEnablePreView = false;
        try {
            isEnablePreView = Boolean.parseBoolean(canPreview);
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
        return isEnablePreView;
    }

    public static boolean ablePreView(Map attMap) {
        Map customParameterFromCache = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam());
        if (Boolean.parseBoolean((String)customParameterFromCache.get("Attachment_LOG_EXT"))) {
            log.info("kd.bos.servicehelper.AttachmentServiceHelper.ablePreview : " + SerializationUtils.toJsonString((Object)attMap));
        }
        String extName = attMap.get("type") instanceof String ? (String)attMap.get("type") : "";
        Object size = attMap.get("size");
        long fileSize = 0L;
        if (size != null && NumberUtils.isParsable((String)String.valueOf(size))) {
            fileSize = Long.parseLong(String.valueOf(size));
        }
        if (StringUtils.isBlank((CharSequence)extName) || fileSize == 0L) {
            return false;
        }
        boolean enablePreView = AttachmentServiceHelper.isEnablePreView();
        if (!enablePreView) {
            return false;
        }
        boolean extCheck = FileUtil.isExtExist((String)extName);
        if (!(extCheck = AttachmentKit.isCustomExtExist(extCheck, extName))) {
            return AttachmentServiceHelper.checkCanPreviewByPreviewType(extName);
        }
        return true;
    }

    private static boolean checkCanPreviewByPreviewType(String extName) {
        String[] supportTypeArray;
        String[] previewType = ParamUtil.getPreviewType();
        boolean isV3 = ParamUtil.isWpsV3();
        if ("21".equals(previewType) && isV3) {
            previewType = "211";
        }
        switch (previewType) {
            case "3": {
                supportTypeArray = SupportPreviewTypeConstant.onlyOfficeSupportPreview;
                break;
            }
            case "21": {
                supportTypeArray = SupportPreviewTypeConstant.wpsPublicSupportPreview;
                break;
            }
            case "211": {
                supportTypeArray = SupportPreviewTypeConstant.wpsPublicV3SupportPreview;
                break;
            }
            case "22": {
                supportTypeArray = SupportPreviewTypeConstant.wpsPrivateSupportPreview;
                break;
            }
            case "4": {
                supportTypeArray = SupportPreviewTypeConstant.yozoSupportPreview;
                break;
            }
            case "6": {
                supportTypeArray = SupportPreviewTypeConstant.kkFileViewSupportPreview;
                break;
            }
            default: {
                supportTypeArray = new String[]{};
            }
        }
        for (String ext : supportTypeArray) {
            if (!ext.equalsIgnoreCase(extName)) continue;
            return true;
        }
        return false;
    }

    public static String getEncreptURL(String url) {
        return EncreptSessionUtils.encryptSession((String)url);
    }

    public static void remove(String formId, Object pkId, Object fileUid) {
        if (pkId != null) {
            pkId = pkId instanceof String ? pkId : "" + pkId;
        }
        QFilter[] filters = new QFilter[]{new QFilter(FNUMBER, EQUAL, fileUid), new QFilter(F_INTER_ID, EQUAL, pkId), new QFilter(F_BILL_TYPE, EQUAL, (Object)formId)};
        AttachmentServiceHelper.removeAttachByQFilter(filters);
    }

    public static void remove(String formId, Object pkId) {
        if (pkId != null) {
            pkId = pkId instanceof String ? pkId : "" + pkId;
        }
        QFilter[] filters = new QFilter[]{new QFilter(F_INTER_ID, EQUAL, pkId), new QFilter(F_BILL_TYPE, EQUAL, (Object)formId)};
        AttachmentServiceHelper.removeAttachByQFilter(filters);
    }

    public static void batchRemove(String formId, List<Object> pkIds) {
        if (CollectionUtils.isEmpty(pkIds)) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter(F_INTER_ID, "in", (Object)pkIds.stream().map(String::valueOf).toArray()), new QFilter(F_BILL_TYPE, EQUAL, (Object)formId)};
        AttachmentServiceHelper.removeAttachByQFilter(filters);
    }

    private static void removeAttachByQFilter(QFilter[] filters) {
        ORM orm = ORM.create();
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)AttachmentPanelEntityNumber, (String)F_ID_FILEID, (QFilter[])filters);
        if (null != dynamicObjectCollection && dynamicObjectCollection.size() > 0) {
            HashSet<String> urlSet = new HashSet<String>();
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                String url = dynamicObject.getString(F_FILE_ID);
                if (StringUtils.isBlank((CharSequence)url)) continue;
                if (url.contains(CONFIG_KEY)) {
                    CacheFactory.getCommonCacheFactory().getTempFileCache().remove(url);
                    continue;
                }
                urlSet.add(url);
            }
            threadPool.execute(() -> {
                orm.delete(AttachmentPanelEntityNumber, filters);
                for (String url : urlSet) {
                    boolean canDelte = !AttachmentServiceHelper.checkRefByPath(url);
                    if (!canDelte) continue;
                    FileServiceFactory.getAttachmentFileService().delete(url);
                    BillFileMappingWriter.removeMappingRecord((String)url, (String)"attach");
                    AttachmentServiceHelper.removeYzjPreviewFile(url);
                }
            });
        }
    }

    private static void removeYzjPreviewFile(String path) {
        if ("1".equals(ParamUtil.getPreviewType())) {
            try {
                FileServiceFactory.getAttachmentFileService().deletePreviewWps(path, ParamUtil.getYzjParam());
            }
            catch (Exception e) {
                log.error("\u79fb\u9664\u5143\u4e4b\u5bb6\u9884\u89c8\u6587\u4ef6\u5931\u8d25,meg:" + e.getMessage());
            }
        }
    }

    public static Map<String, Object> bindingAttachment(Map<String, Object> params) throws Exception {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        try {
            BindingAttachmentInfo bindAttachemnt = new BindingAttachmentInfo();
            AttachmentServiceHelper.prepareProperty(params, bindAttachemnt);
            AttachmentServiceHelper.doSyncData(bindAttachemnt);
        }
        catch (Exception e) {
            resultMap.put(SUCCESS, Boolean.FALSE);
            resultMap.put("message", e.getMessage());
            throw e;
        }
        resultMap.put(SUCCESS, Boolean.TRUE);
        resultMap.put("message", ResManager.loadKDString((String)"\u8bf7\u6c42\u6210\u529f", (String)"AttachmentPanel_5", (String)BOS_SVC_METADATA, (Object[])new Object[0]));
        return resultMap;
    }

    private static void prepareProperty(Map<String, Object> reqParams, BindingAttachmentInfo bindAttachemnt) throws Exception {
        String validResult = AttachmentServiceHelper.doParamsValid(reqParams, bindAttachemnt);
        if (!"true".equalsIgnoreCase(validResult)) {
            throw new Exception(validResult);
        }
    }

    protected static String doParamsValid(Map<String, Object> params, BindingAttachmentInfo bindAttachemnt) throws IOException {
        if (params == null) {
            return ResManager.loadKDString((String)"\u83b7\u53d6\u4e0d\u5230\u53c2\u6570", (String)"AttachmentPanel_6", (String)BOS_SVC_METADATA, (Object[])new Object[0]);
        }
        if (params.get(FORM_NUMBER) == null) {
            return ResManager.loadKDString((String)"\u7f3a\u5c11formNumber\u53c2\u6570", (String)"AttachmentPanel_7", (String)BOS_SVC_METADATA, (Object[])new Object[0]);
        }
        bindAttachemnt.setFormNumber(params.get(FORM_NUMBER).toString());
        if (StringUtils.isBlank((Object)params.get(BILL_PK_ID))) {
            return ResManager.loadKDString((String)"\u7f3a\u5c11billPkId\u53c2\u6570", (String)"AttachmentPanel_8", (String)BOS_SVC_METADATA, (Object[])new Object[0]);
        }
        bindAttachemnt.setBillPkId(params.get(BILL_PK_ID).toString());
        Map data = (Map)params.get("data");
        if (data == null || data.size() == 0) {
            return ResManager.loadKDString((String)"data\u53c2\u6570\u4e3a\u7a7a", (String)"AttachmentPanel_9", (String)BOS_SVC_METADATA, (Object[])new Object[0]);
        }
        bindAttachemnt.setAttInfos(data);
        String id = MetadataDao.getIdByNumber((String)bindAttachemnt.getFormNumber(), (MetaCategory)MetaCategory.Form);
        if (id == null) {
            return String.format(ResManager.loadKDString((String)"formNumber\u53c2\u6570\u6709\u8bef\uff1a%s\u3002", (String)"AttachmentPanel_10", (String)BOS_SVC_METADATA, (Object[])new Object[0]), bindAttachemnt.getFormNumber());
        }
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        if (StringUtils.isBlank((CharSequence)formMeta.getEntityId())) {
            return String.format(ResManager.loadKDString((String)"formNumber\u53c2\u6570\u6709\u8bef\uff1a%s\u3002", (String)"AttachmentPanel_10", (String)BOS_SVC_METADATA, (Object[])new Object[0]), bindAttachemnt.getFormNumber());
        }
        String entityId = formMeta.getEntityId();
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        bindAttachemnt.setEntityNumber(entityMeta.getKey());
        DynamicObject dynamicObject = null;
        try {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)bindAttachemnt.getBillPkId(), (String)bindAttachemnt.getEntityNumber());
        }
        catch (Exception e) {
            return String.format(ResManager.loadKDString((String)"formNumber\u53c2\u6570\u6709\u8bef\uff1a%s\u3002", (String)"AttachmentPanel_10", (String)BOS_SVC_METADATA, (Object[])new Object[0]), bindAttachemnt.getBillPkId());
        }
        if (dynamicObject == null) {
            return String.format(ResManager.loadKDString((String)"formNumber\u53c2\u6570\u6709\u8bef\uff1a%s\u3002", (String)"AttachmentPanel_10", (String)BOS_SVC_METADATA, (Object[])new Object[0]), bindAttachemnt.getBillPkId());
        }
        for (ControlAp control : formMeta.getItems()) {
            if (!(control instanceof AttachmentPanelAp)) continue;
            bindAttachemnt.getAttPanels().add(control.getKey());
        }
        for (Entity entry : entityMeta.getEntitys()) {
            for (EntityItem item : entry.getItems()) {
                if (!(item instanceof AttachmentField)) continue;
                String entryKey = entry instanceof SubEntryEntity ? entityMeta.getItemById(((SubEntryEntity)entry).getParentEntryId()).getKey() + "." + entry.getKey() : entry.getKey();
                bindAttachemnt.getAttFieldEntryMapping().put(item.getKey(), entryKey);
            }
        }
        FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
        for (Map.Entry attData : bindAttachemnt.getAttInfos().entrySet()) {
            String attKey = (String)attData.getKey();
            List value = (List)attData.getValue();
            ArrayList<AttDto> attDtoList = new ArrayList<AttDto>(value.size());
            int i = 1;
            for (Object attValue : value) {
                AttDto attDto = (AttDto)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(attValue), AttDto.class);
                String path = attDto.getPath();
                if (StringUtils.isBlank((CharSequence)path)) {
                    return String.format(ResManager.loadKDString((String)"data\u53c2\u6570\uff1a%1$s\u7b2c%2$s\u4e2a\u9644\u4ef6\u7f3a\u5c11path\u53c2\u6570\u3002", (String)"AttachmentPanel_2", (String)BOS_SVC_METADATA, (Object[])new Object[0]), attKey, i);
                }
                Long size = attDto.getSize();
                if (size == null || size <= 0L) {
                    return String.format(ResManager.loadKDString((String)"data\u53c2\u6570\uff1a%1$s\u7b2c%2$s\u4e2a\u9644\u4ef6size\u53c2\u6570\u5fc5\u586b\u4e14\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"AttachmentPanel_3", (String)BOS_SVC_METADATA, (Object[])new Object[0]), attKey, i);
                }
                String usableUrl = path;
                try {
                    path = URLDecoder.decode(path, UTF_8);
                    while (path.startsWith("//")) {
                        path = path.replaceFirst("//", DIV);
                    }
                    usableUrl = path;
                    path = FileServiceFactory.getAttachmentFileService().getFileServiceExt().getRealPath(path);
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Throwable)e);
                }
                if (!(path.contains(".") && path.contains(DIV) && attachmentFileService.exists(path))) {
                    return String.format(ResManager.loadKDString((String)"data\u53c2\u6570\uff1a%1$s\u7b2c%2$s\u4e2a\u9644\u4ef6path\u53c2\u6570\u9519\u8bef\uff08%3$s\uff09", (String)"AttachmentPanel_4", (String)BOS_SVC_METADATA, (Object[])new Object[0]), attKey, i, attDto.getPath());
                }
                attDto.setPath(usableUrl);
                String extName = path.substring(path.lastIndexOf(46) + 1);
                String fileName = path.substring(path.lastIndexOf(47) + 1);
                attDto.setExtName(extName);
                attDto.setFileName(fileName);
                attDtoList.add(attDto);
                ++i;
            }
            bindAttachemnt.getAttInfos().put(attKey, attDtoList);
            boolean errorAttKey = true;
            if (bindAttachemnt.getAttFieldEntryMapping().containsKey(attKey)) {
                errorAttKey = false;
                List attDtos = (List)data.get(attKey);
                if (!bindAttachemnt.getEntityNumber().equals(bindAttachemnt.getAttFieldEntryMapping().get(attKey))) {
                    int j = 1;
                    for (Object attValue : attDtos) {
                        AttDto attDto = (AttDto)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(attValue), AttDto.class);
                        if (StringUtils.isBlank((CharSequence)attDto.getEntryPkId())) {
                            return String.format(ResManager.loadKDString((String)"\u9644\u4ef6\u5b57\u6bb5 : %1$s \u7b2c %2$s \u4e2a\u9644\u4ef6\u7f3a\u5c11entryPkId\u53c2\u6570", (String)"AttachmentFieldServiceHelper_4", (String)BOS_SVC_METADATA, (Object[])new Object[0]), attKey, j);
                        }
                        String entryKey = (String)bindAttachemnt.getAttFieldEntryMapping().get(attKey);
                        boolean subEntry = entryKey.contains(".");
                        DynamicObjectCollection entryDynCollection = subEntry ? dynamicObject.getDynamicObjectCollection(entryKey.split("\\.")[0]) : dynamicObject.getDynamicObjectCollection(entryKey);
                        boolean errorEntryPkId = true;
                        block11: for (DynamicObject obj : entryDynCollection) {
                            if (subEntry) {
                                DynamicObjectCollection subEntryDynCollection = obj.getDynamicObjectCollection(entryKey.split("\\.")[1]);
                                for (DynamicObject object : subEntryDynCollection) {
                                    if (!attDto.getEntryPkId().equals(String.valueOf(object.getPkValue()))) continue;
                                    errorEntryPkId = false;
                                    continue block11;
                                }
                                continue;
                            }
                            if (!attDto.getEntryPkId().equals(String.valueOf(obj.getPkValue()))) continue;
                            errorEntryPkId = false;
                            break;
                        }
                        if (errorEntryPkId) {
                            return String.format(ResManager.loadKDString((String)"\u9644\u4ef6\u5b57\u6bb5\uff1a%1$s\u7b2c %2$s \u4e2a\u9644\u4ef6entryPkId\u53c2\u6570\u9519\u8bef\uff08%3$s\uff09", (String)"AttachmentPanel_12", (String)BOS_SVC_METADATA, (Object[])new Object[0]), attKey, j, attDto.getEntryPkId());
                        }
                        ++j;
                    }
                }
            }
            if (bindAttachemnt.getAttPanels().contains(attKey) || !errorAttKey) continue;
            return String.format(ResManager.loadKDString((String)"%1$s\u6ca1\u6709\u6b64\u9644\u4ef6\u9762\u677f\u6216\u9644\u4ef6\u5b57\u6bb5\uff1a%2$s", (String)"AttachmentPanel_13", (String)BOS_SVC_METADATA, (Object[])new Object[0]), bindAttachemnt.getFormNumber(), attKey);
        }
        return "true";
    }

    private static void doSyncData(BindingAttachmentInfo bindAttachemnt) throws Exception {
        try {
            for (Map.Entry data : bindAttachemnt.getAttInfos().entrySet()) {
                if (bindAttachemnt.getAttPanels().contains(data.getKey())) {
                    AttachmentServiceHelper.doSyncAttPanel((List)data.getValue(), (String)data.getKey(), bindAttachemnt);
                    continue;
                }
                if (!bindAttachemnt.getAttFieldEntryMapping().containsKey(data.getKey())) continue;
                AttachmentServiceHelper.doSyncAttField((List)data.getValue(), (String)data.getKey(), bindAttachemnt);
            }
        }
        catch (ParseException e) {
            log.error((Throwable)e);
            throw new Exception(ResManager.loadKDString((String)"\u9644\u4ef6\u6570\u636e\u4fdd\u5b58\u5931\u8d25", (String)"AttachmentPanel_14", (String)BOS_SVC_METADATA, (Object[])new Object[0]), e);
        }
    }

    private static List<DynamicObject> doSyncAttPanel(List<AttDto> dtos, String attKey, BindingAttachmentInfo bindAttachemnt) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int size = dtos.size();
        DynamicObjectType entityType = (DynamicObjectType)ORM.create().getDataEntityType(AttachmentPanelEntityNumber);
        long[] ids = DB.genLongIds((String)AttachmentPanelEntityNumber, (int)size);
        long[] numbers = DB.genLongIds((String)"bos_attachment_uid", (int)size);
        ArrayList<DynamicObject> objects = new ArrayList<DynamicObject>(size);
        for (int i = 0; i < size; ++i) {
            AttDto data = dtos.get(i);
            AttDto dto = (AttDto)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)data), AttDto.class);
            DynamicObject dynamicObject = new DynamicObject(entityType, null);
            dynamicObject.set("id", (Object)ids[i]);
            dynamicObject.set(FNUMBER, (Object)numbers[i]);
            dynamicObject.set(F_BILL_TYPE, (Object)bindAttachemnt.getEntityNumber());
            dynamicObject.set(F_INTER_ID, (Object)bindAttachemnt.getBillPkId());
            Date today = new Date();
            String lastModified = dto.getLastModified();
            if (StringUtils.isBlank((CharSequence)lastModified)) {
                dynamicObject.set(F_MODIFY_TIME, (Object)today);
            } else {
                dynamicObject.set(F_MODIFY_TIME, (Object)sdf.parse(dto.getCreateTime()));
            }
            if (StringUtils.isBlank((CharSequence)dto.getCreateTime())) {
                dynamicObject.set(FCREATETIME, (Object)today);
            } else {
                dynamicObject.set(FCREATETIME, (Object)sdf.parse(dto.getCreateTime()));
            }
            String name = dto.getFileName();
            dynamicObject.set(FALIAS_FILE_NAME, (Object)name);
            dynamicObject.set(F_ATTACHMENT_NAME, (Object)name);
            dynamicObject.set(F_EXT_NAME, (Object)(name != null ? name.substring(name.lastIndexOf(46) + 1) : ""));
            dynamicObject.set(FATTACHMENTSIZE, (Object)dto.getSize());
            dynamicObject.set(FCREATEMEN, (Object)(StringUtils.isNotBlank((CharSequence)dto.getCreateUserId()) ? dto.getCreateUserId() : RequestContext.get().getUserId()));
            dynamicObject.set(FATTACHMENT_PANEL, (Object)attKey);
            dynamicObject.set(FDESCRIPTION, (Object)dto.getDescription());
            dynamicObject.set(F_FILE_ID, (Object)dto.getPath());
            objects.add(dynamicObject);
        }
        if (objects.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])objects.toArray(new DynamicObject[objects.size()]));
        }
        return objects;
    }

    private static Map<String, Object> doSyncAttField(List<AttDto> dtos, String attKey, BindingAttachmentInfo bindAttachemnt) throws ParseException {
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)bindAttachemnt.getBillPkId(), (String)bindAttachemnt.getEntityNumber());
        HashMap map = new HashMap();
        for (AttDto attDto : dtos) {
            AttDto attDto2 = (AttDto)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)attDto), AttDto.class);
            if (map.containsKey(attDto2.getEntryPkId())) {
                ((List)map.get(attDto2.getEntryPkId())).add(attDto2);
                continue;
            }
            ArrayList<AttDto> list = new ArrayList<AttDto>();
            list.add(attDto2);
            map.put(attDto2.getEntryPkId(), list);
        }
        ArrayList attFieldObjList = new ArrayList();
        for (Map.Entry entry : map.entrySet()) {
            if (((List)entry.getValue()).size() == 0) continue;
            Map resultMap = AttachmentServiceHelper.createAttFieldBaseData((List)entry.getValue());
            List baseDataIds = (List)resultMap.get("pkIdList");
            List attFieldObjList_new = (List)resultMap.get("dynObjList");
            attFieldObjList.addAll(attFieldObjList_new);
            if (StringUtils.isBlank((CharSequence)((CharSequence)entry.getKey())) || bindAttachemnt.getBillPkId().equals(entry.getKey())) {
                DynamicObjectCollection dCollection = bill.getDynamicObjectCollection(attKey);
                for (Object baseId : baseDataIds) {
                    DynamicObject newObj = new DynamicObject(dCollection.getDynamicCollectionItemPropertyType());
                    newObj.set("fbasedataid_id", baseId);
                    dCollection.add((Object)newObj);
                }
                continue;
            }
            String entryKey = (String)bindAttachemnt.getAttFieldEntryMapping().get(attKey);
            Boolean subEntry = entryKey.contains(".");
            DynamicObjectCollection entryDynCollection = subEntry != false ? bill.getDynamicObjectCollection(entryKey.split("\\.")[0]) : bill.getDynamicObjectCollection(entryKey);
            for (DynamicObject dynamicObject : entryDynCollection) {
                if (subEntry.booleanValue()) {
                    DynamicObjectCollection subEntryDynCollection = dynamicObject.getDynamicObjectCollection(entryKey.split("\\.")[1]);
                    for (DynamicObject object : subEntryDynCollection) {
                        if (!StringUtils.equals((CharSequence)((CharSequence)entry.getKey()), (CharSequence)String.valueOf(object.getPkValue()))) continue;
                        DynamicObjectCollection dCollection = object.getDynamicObjectCollection(attKey);
                        for (Object baseId : baseDataIds) {
                            DynamicObject newObj = new DynamicObject(dCollection.getDynamicCollectionItemPropertyType());
                            newObj.set("fbasedataid_id", baseId);
                            dCollection.add((Object)newObj);
                        }
                    }
                    continue;
                }
                if (!StringUtils.equals((CharSequence)((CharSequence)entry.getKey()), (CharSequence)String.valueOf(dynamicObject.getPkValue()))) continue;
                DynamicObjectCollection dCollection = dynamicObject.getDynamicObjectCollection(attKey);
                for (Object baseId : baseDataIds) {
                    DynamicObject newObj = new DynamicObject(dCollection.getDynamicCollectionItemPropertyType());
                    newObj.set("fbasedataid_id", baseId);
                    dCollection.add((Object)newObj);
                }
            }
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        hashMap.put("attFieldObjList", attFieldObjList);
        hashMap.put("billObj", bill);
        if (attFieldObjList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])attFieldObjList.toArray(new DynamicObject[0]));
        }
        if (bill != null) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
        }
        return hashMap;
    }

    private static Map createAttFieldBaseData(List<AttDto> dtos) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int size = dtos.size();
        long[] ids = ORM.create().genLongIds("bd_attachment", size);
        ArrayList<Long> idList = new ArrayList<Long>(ids.length);
        for (long id : ids) {
            idList.add(id);
        }
        ArrayList<DynamicObject> dys = new ArrayList<DynamicObject>(size);
        int i = 0;
        Date now = new Date();
        for (AttDto dto : dtos) {
            DynamicObject attObj = BusinessDataServiceHelper.newDynamicObject((String)"bd_attachment");
            String fileName = dto.getFileName();
            String type = fileName != null ? fileName.substring(fileName.lastIndexOf(46) + 1) : "";
            attObj.set("name", (Object)fileName);
            attObj.set("size", (Object)dto.getSize());
            attObj.set("url", (Object)dto.getPath());
            attObj.set("type", (Object)type);
            attObj.set(DESCRIPTION, (Object)dto.getDescription());
            attObj.set("tempfile", (Object)"1");
            attObj.set("pageid", (Object)"");
            attObj.set("number", (Object)UUID.randomUUID().toString());
            attObj.set(STATUS, (Object)"B");
            if (StringUtils.isBlank((CharSequence)dto.getCreateTime())) {
                attObj.set("createtime", (Object)now.getTime());
            } else {
                attObj.set("createtime", (Object)sdf.parse(dto.getCreateTime()).getTime());
            }
            if (StringUtils.isBlank((CharSequence)dto.getLastModified())) {
                attObj.set("modifytime", (Object)now.getTime());
            } else {
                attObj.set("modifytime", (Object)sdf.parse(dto.getLastModified()).getTime());
            }
            attObj.set(CREATOR, (Object)(StringUtils.isNotBlank((CharSequence)dto.getCreateUserId()) ? dto.getCreateUserId() : RequestContext.get().getUserId()));
            attObj.set("id", (Object)ids[i]);
            attObj.set("uid", (Object)("rc-import-" + ids[i] + "-" + ++i));
            dys.add(attObj);
        }
        HashMap<String, ArrayList<Long>> resultMap = new HashMap<String, ArrayList<Long>>(2);
        resultMap.put("pkIdList", idList);
        resultMap.put("dynObjList", dys);
        return resultMap;
    }

    public static Map<String, Object> genBindingParam(String formNumber, String billPkId, List<AttDto> attDtoList) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        HashMap attMap = new HashMap();
        params.put(FORM_NUMBER, formNumber);
        params.put(BILL_PK_ID, billPkId);
        for (AttDto attDto : attDtoList) {
            if (StringUtils.isBlank((CharSequence)attDto.getAttKey())) {
                throw new Exception(ResManager.loadKDString((String)"\u7f3a\u5c11attKey\u53c2\u6570", (String)"AttachmentPanel_15", (String)BOS_SVC_METADATA, (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)attDto.getPath())) {
                throw new Exception(ResManager.loadKDString((String)"\u7f3a\u5c11path\u53c2\u6570", (String)"AttachmentPanel_16", (String)BOS_SVC_METADATA, (Object[])new Object[0]));
            }
            if (attMap.containsKey(attDto.getAttKey())) {
                ((List)attMap.get(attDto.getAttKey())).add(attDto);
                continue;
            }
            ArrayList<AttDto> dtoList = new ArrayList<AttDto>();
            dtoList.add(attDto);
            attMap.put(attDto.getAttKey(), dtoList);
        }
        params.put("data", attMap);
        return params;
    }

    public static int getFileSizeByPath(String path) throws Exception {
        try {
            path = URLDecoder.decode(path, UTF_8);
            while (path.startsWith("//")) {
                path = path.replaceFirst("//", DIV);
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error((Throwable)e);
        }
        FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
        if (!(path.contains(".") && path.contains(DIV) && attachmentFileService.exists(path))) {
            throw new Exception(String.format(ResManager.loadKDString((String)"path\u53c2\u6570\u9519\u8bef\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a%s\u3002", (String)"AttachmentPanel_17", (String)BOS_SVC_METADATA, (Object[])new Object[0]), path));
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        attachmentFileService.download(path, (OutputStream)outStream, null);
        int fileSize = outStream.toByteArray().length;
        return fileSize;
    }

    public static DynamicObjectCollection getRefCollectionByPath(String path) {
        while (path.startsWith("//")) {
            path = path.replace("//", DIV);
        }
        QFilter[] filters = new QFilter[]{new QFilter(F_FILE_ID, EQUAL, (Object)path)};
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)AttachmentPanelEntityNumber, (String)F_ID_FILEID, (QFilter[])filters);
        return dynamicObjectCollection;
    }

    public static boolean checkRefByPath(String path) {
        Set<String> relationPaths;
        QFilter[] filters;
        DynamicObjectCollection attachmentPanelCollection;
        while (path.startsWith("//")) {
            path = path.replace("//", DIV);
        }
        if (!path.contains(".")) {
            path = path.replace(DIV, "");
        }
        if ((attachmentPanelCollection = QueryServiceHelper.query((String)AttachmentPanelEntityNumber, (String)F_ID_FILEID, (QFilter[])(filters = new QFilter(F_FILE_ID, "in", relationPaths = AttachmentServiceHelper.getRelationPaths(path)).toArray()))).size() >= 1) {
            return true;
        }
        filters = new QFilter("url", "in", relationPaths).toArray();
        Map attachmentFieldMap = BusinessDataServiceHelper.loadFromCache((String)"bd_attachment", (QFilter[])filters);
        if (attachmentFieldMap.size() > 1) {
            return true;
        }
        for (Map.Entry entry : attachmentFieldMap.entrySet()) {
            DynamicObject attachmentField = (DynamicObject)entry.getValue();
            Object pkValue = attachmentField.getPkValue();
            List<Map> refMapList = AttachmentFieldServiceHelper.getAttachmentRefList(pkValue);
            if (refMapList.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static Set<String> getRelationPaths(String path) {
        Map svcAttachments;
        HashSet<String> relationPaths = new HashSet<String>(4);
        List<String> extPaths = AttachmentServiceHelper.getExtPaths(path);
        relationPaths.addAll(extPaths);
        boolean enableAttachmentCenter = AttachmentManageUtils.enableAttachmentCenter();
        if (enableAttachmentCenter && MapUtils.isNotEmpty((Map)(svcAttachments = BusinessDataServiceHelper.loadFromCache((String)"bos_svc_attachment", (String)"id,number,path", (QFilter[])new QFilter("number", "in", extPaths).or(new QFilter("path", "in", extPaths)).toArray())))) {
            for (DynamicObject value : svcAttachments.values()) {
                String realPath;
                String number = value.getString("number");
                if (StringUtils.isNotBlank((CharSequence)number)) {
                    relationPaths.addAll(AttachmentServiceHelper.getExtPaths(number));
                }
                if (!StringUtils.isNotBlank((CharSequence)(realPath = value.getString("path")))) continue;
                relationPaths.addAll(AttachmentServiceHelper.getExtPaths(realPath));
            }
            return relationPaths;
        }
        if (!enableAttachmentCenter || relationPaths.size() <= 2) {
            Object[] params = new SqlParameter[2];
            String extPath = StringUtils.join(extPaths, (char)',');
            String sql = "select ffileid,fpath from t_bas_filepathmapping where ffileid in (?) or fpath in (?)";
            params[0] = new SqlParameter("ffileid", 12, (Object)extPath);
            params[1] = new SqlParameter("fpath", 12, (Object)extPath);
            DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, rs -> {
                while (rs.next()) {
                    String fileId;
                    String fPath = rs.getString("fpath");
                    if (StringUtils.isNotBlank((CharSequence)fPath)) {
                        relationPaths.addAll(AttachmentServiceHelper.getExtPaths(fPath));
                    }
                    if (!StringUtils.isNotBlank((CharSequence)(fileId = rs.getString("ffileid")))) continue;
                    relationPaths.addAll(AttachmentServiceHelper.getExtPaths(fileId));
                }
                return null;
            });
        }
        return relationPaths;
    }

    private static List<String> getExtPaths(String path) {
        ArrayList<String> paths = new ArrayList<String>(2);
        paths.add(path);
        if (path.startsWith(DIV)) {
            paths.add(path.substring(1));
        } else {
            paths.add(DIV + path);
        }
        return paths;
    }

    public static void upload(String formId, Object pkId, String attachKey, List<Map<String, Object>> attachments) {
        if (pkId != null) {
            pkId = pkId instanceof String ? pkId : "" + pkId;
        }
        HashMap<Object, Map<String, Object>> uidAttachs = new HashMap<Object, Map<String, Object>>();
        AttachmentServiceHelper.remappingBillAttachments(attachments, uidAttachs);
        Date today = new Date();
        ORM orm = ORM.create();
        DynamicObjectType entityType = (DynamicObjectType)orm.getDataEntityType(AttachmentPanelEntityNumber);
        DynamicObjectCollection dynColl = AttachmentServiceHelper.loadBillAttachments(orm, formId, pkId, uidAttachs.keySet());
        if (dynColl == null) {
            dynColl = new DynamicObjectCollection(entityType, null);
        } else if (!dynColl.isEmpty()) {
            AttachmentServiceHelper.updateExistAttachments(dynColl, uidAttachs, attachKey, today);
        }
        if (!uidAttachs.isEmpty()) {
            AttachmentServiceHelper.createNewAttachments(orm, dynColl, entityType, uidAttachs, attachKey, formId, pkId, today);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])dynColl.toArray((Object[])new DynamicObject[0])));
    }

    private static void createNewAttachments(ORM orm, DynamicObjectCollection dynColl, DynamicObjectType entityType, Map<Object, Map<String, Object>> uidAttachs, String attachKey, String formId, Object pkId, Date today) {
        long[] ids = orm.genLongIds((IDataEntityType)entityType, uidAttachs.size());
        int i = 0;
        for (Map.Entry<Object, Map<String, Object>> entry : uidAttachs.entrySet()) {
            Map<String, Object> attach = entry.getValue();
            DynamicObject dynamicObject = new DynamicObject(entityType);
            dynamicObject.set("id", (Object)ids[i]);
            dynamicObject.set(FNUMBER, attach.get("uid"));
            dynamicObject.set(F_BILL_TYPE, (Object)formId);
            dynamicObject.set(F_INTER_ID, pkId);
            Object lastModified = attach.get(LAST_MODIFIED);
            if (lastModified instanceof Date) {
                dynamicObject.set(F_MODIFY_TIME, lastModified);
            } else if (lastModified instanceof Long) {
                dynamicObject.set(F_MODIFY_TIME, (Object)new Date((Long)lastModified));
            } else {
                dynamicObject.set(F_MODIFY_TIME, (Object)today);
            }
            dynamicObject.set(FCREATETIME, attach.getOrDefault("uploadTime", today));
            String name = (String)attach.get("name");
            dynamicObject.set(FALIAS_FILE_NAME, (Object)name);
            dynamicObject.set(F_ATTACHMENT_NAME, (Object)name);
            dynamicObject.set(F_EXT_NAME, (Object)(name != null ? name.substring(name.lastIndexOf(46) + 1) : ""));
            dynamicObject.set(FATTACHMENTSIZE, attach.get("size"));
            dynamicObject.set(F_FILE_ID, attach.get("url"));
            dynamicObject.set(FCREATEMEN, (Object)RequestContext.get().getUserId());
            dynamicObject.set(FATTACHMENT_PANEL, (Object)attachKey);
            dynamicObject.set("fbillstatus", (Object)"1");
            if (attach.containsKey(DESCRIPTION)) {
                dynamicObject.set(FDESCRIPTION, attach.get(DESCRIPTION));
            }
            dynColl.add((Object)dynamicObject);
            attach.put("id", ids[i]);
            attach.put(CREATE_DATE, today.getTime());
            attach.put(CREATOR, new LocaleString(RequestContext.get().getUserName()));
            ++i;
        }
    }

    private static void remappingBillAttachments(List<Map<String, Object>> attachments, Map<Object, Map<String, Object>> uidAttachs) {
        for (Map<String, Object> attach : attachments) {
            Object uid = attach.get("uid");
            uidAttachs.put(uid, attach);
        }
    }

    private static void updateExistAttachments(DynamicObjectCollection dynColl, Map<Object, Map<String, Object>> uidAttachs, String attachKey, Date today) {
        for (DynamicObject dyn : dynColl) {
            Map<String, Object> attach = uidAttachs.remove(dyn.get(FNUMBER));
            Object lastModified = attach.get(LAST_MODIFIED);
            if (lastModified instanceof Date) {
                dyn.set(F_MODIFY_TIME, lastModified);
            } else if (lastModified instanceof Long) {
                dyn.set(F_MODIFY_TIME, (Object)new Date((Long)lastModified));
            } else {
                dyn.set(F_MODIFY_TIME, (Object)today);
            }
            String name = (String)attach.get("name");
            dyn.set(FALIAS_FILE_NAME, (Object)name);
            dyn.set(F_ATTACHMENT_NAME, (Object)name);
            dyn.set(F_EXT_NAME, (Object)(name != null ? name.substring(name.lastIndexOf(46) + 1) : ""));
            dyn.set(FATTACHMENTSIZE, attach.get("size"));
            dyn.set(F_FILE_ID, attach.get("url"));
            dyn.set(FATTACHMENT_PANEL, (Object)attachKey);
            dyn.set("fbillstatus", (Object)"1");
        }
    }

    public static void uploadTemp(String formId, String pageId, String attachKey, List<Map<String, Object>> attachments) {
        HashMap<Object, Map<String, Object>> uidAttachs = new HashMap<Object, Map<String, Object>>();
        AttachmentServiceHelper.remappingBillAttachments(attachments, uidAttachs);
        Date today = new Date();
        ORM orm = ORM.create();
        DynamicObjectType entityType = (DynamicObjectType)orm.getDataEntityType(AttachmentPanelEntityNumber);
        DynamicObjectCollection dynColl = AttachmentServiceHelper.loadTempBillAttachments(orm, formId, pageId, uidAttachs.keySet());
        if (dynColl == null) {
            dynColl = new DynamicObjectCollection(entityType, null);
        } else if (!dynColl.isEmpty()) {
            AttachmentServiceHelper.updateExistTempAttachments(dynColl, uidAttachs, attachKey, pageId, today);
        }
        if (!uidAttachs.isEmpty()) {
            AttachmentServiceHelper.createNewTempAttachments(orm, dynColl, entityType, uidAttachs, attachKey, pageId, formId, today);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])dynColl.toArray((Object[])new DynamicObject[0])));
    }

    private static void createNewTempAttachments(ORM orm, DynamicObjectCollection dynColl, DynamicObjectType entityType, Map<Object, Map<String, Object>> uidAttachs, String attachKey, String pageId, String formId, Date today) {
        long[] ids = orm.genLongIds((IDataEntityType)entityType, uidAttachs.size());
        int i = 0;
        for (Map.Entry<Object, Map<String, Object>> entry : uidAttachs.entrySet()) {
            Map<String, Object> attach = entry.getValue();
            DynamicObject dynamicObject = new DynamicObject(entityType);
            dynamicObject.set("id", (Object)ids[i]);
            dynamicObject.set(FNUMBER, attach.get("uid"));
            dynamicObject.set(F_BILL_TYPE, (Object)formId);
            Object lastModified = attach.get(LAST_MODIFIED);
            if (lastModified instanceof Date) {
                dynamicObject.set(F_MODIFY_TIME, lastModified);
            } else if (lastModified instanceof Long) {
                dynamicObject.set(F_MODIFY_TIME, (Object)new Date((Long)lastModified));
            } else {
                dynamicObject.set(F_MODIFY_TIME, (Object)today);
            }
            dynamicObject.set(FCREATETIME, (Object)today);
            String name = (String)attach.get("name");
            dynamicObject.set(FALIAS_FILE_NAME, (Object)name);
            dynamicObject.set(F_ATTACHMENT_NAME, (Object)name);
            dynamicObject.set(F_EXT_NAME, (Object)(name != null ? name.substring(name.lastIndexOf(46) + 1) : ""));
            dynamicObject.set(FATTACHMENTSIZE, attach.get("size"));
            dynamicObject.set(F_FILE_ID, attach.get("url"));
            dynamicObject.set(FCREATEMEN, (Object)Long.parseLong(RequestContext.get().getUserId()));
            dynamicObject.set("FTEMPPAGEID", (Object)pageId);
            dynamicObject.set(FATTACHMENT_PANEL, (Object)attachKey);
            if (attach.containsKey(DESCRIPTION)) {
                dynamicObject.set(FDESCRIPTION, attach.get(DESCRIPTION));
            }
            dynColl.add((Object)dynamicObject);
            attach.put(CREATE_DATE, today.getTime());
            attach.put(CREATOR, new LocaleString(RequestContext.get().getUserName()));
            ++i;
        }
    }

    private static void updateExistTempAttachments(DynamicObjectCollection dynColl, Map<Object, Map<String, Object>> uidAttachs, String attachKey, String pageId, Date today) {
        for (DynamicObject dyn : dynColl) {
            Map<String, Object> attach = uidAttachs.remove(dyn.get(FNUMBER));
            Object lastModified = attach.get(LAST_MODIFIED);
            if (lastModified instanceof Date) {
                dyn.set(F_MODIFY_TIME, lastModified);
            } else if (lastModified instanceof Long) {
                dyn.set(F_MODIFY_TIME, (Object)new Date((Long)lastModified));
            } else {
                dyn.set(F_MODIFY_TIME, (Object)new Date());
            }
            String name = (String)attach.get("name");
            dyn.set(FALIAS_FILE_NAME, (Object)name);
            dyn.set(F_ATTACHMENT_NAME, (Object)name);
            dyn.set(F_EXT_NAME, (Object)(name != null ? name.substring(name.lastIndexOf(46) + 1) : ""));
            dyn.set(FATTACHMENTSIZE, attach.get("size"));
            dyn.set(F_FILE_ID, attach.get("url"));
            dyn.set("FTEMPPAGEID", (Object)pageId);
            dyn.set(FATTACHMENT_PANEL, (Object)attachKey);
        }
    }

    private static DynamicObjectCollection loadTempBillAttachments(ORM orm, String formId, String pageId, Set<Object> keySet) {
        QFilter[] filters = new QFilter[]{new QFilter(FNUMBER, "in", keySet), new QFilter("FTEMPPAGEID", EQUAL, (Object)pageId), new QFilter(F_BILL_TYPE, EQUAL, (Object)formId)};
        DynamicObjectCollection dynColl = orm.getByFilter(AttachmentPanelEntityNumber, filters);
        return dynColl;
    }

    @Deprecated
    public static DynamicObjectCollection saveTempAttachments(String formId, String pageId, Object pkId) {
        QFilter[] filters;
        ORM orm;
        DynamicObjectCollection dynColl;
        if (pkId != null) {
            pkId = pkId instanceof String ? pkId : "" + pkId;
        }
        if ((dynColl = (orm = ORM.create()).getByFilter(AttachmentPanelEntityNumber, filters = new QFilter[]{new QFilter("FTEMPPAGEID", EQUAL, (Object)pageId).or(new QFilter(F_INTER_ID, EQUAL, pkId)), new QFilter(F_BILL_TYPE, EQUAL, (Object)formId)})) != null && !dynColl.isEmpty()) {
            log.info("......saveTempAttachments @Deprecated  filter-> (FTEMPPAGEID=" + pageId + " or pkId=" + pkId + "), FBillType=" + formId);
            FileService service = FileServiceFactory.getAttachmentFileService();
            TempFileCache downLoad = null;
            String tenantId = CacheKeyUtil.getAcctId();
            FileItemExt fileItem = null;
            ArrayList<DynamicObject> updateAttachs = new ArrayList<DynamicObject>(dynColl.size());
            for (DynamicObject dyn : dynColl) {
                String tempUrl;
                if (StringUtils.isBlank((CharSequence)((String)dyn.get(F_INTER_ID)))) {
                    dyn.set(F_INTER_ID, pkId);
                    dyn.set("FTEMPPAGEID", null);
                }
                if ((tempUrl = (String)dyn.get("FFILEID")).contains("/public/attachment/") || tempUrl.contains("/eas/attachment/")) continue;
                if (downLoad == null) {
                    downLoad = CacheFactory.getCommonCacheFactory().getTempFileCache();
                }
                String attacmentName = (String)dyn.get("FATTACHMENTNAME");
                String path = "/public/attachment/" + tenantId + DIV + formId + DIV + UUID.randomUUID() + DIV + attacmentName;
                String url = null;
                if (downLoad != null) {
                    fileItem = new FileItemExt(attacmentName, path, downLoad.getInputStream(tempUrl));
                    fileItem.setSource(FileSource.ATTACHMENT_PANEL);
                    fileItem.setComputeDigest(true);
                    url = service.upload((FileItem)fileItem);
                    downLoad.remove(tempUrl);
                }
                if (StringUtils.isNotBlank(url)) {
                    dyn.set("ffileid", url);
                }
                updateAttachs.add(dyn);
            }
            if (!updateAttachs.isEmpty()) {
                orm.update(updateAttachs);
            }
        }
        return dynColl;
    }

    @KSMethod
    public static DynamicObject[] saveTempAttachments(String pageId, Object pkId) {
        QFilter[] filters;
        DynamicObject[] dynColl;
        if (pkId != null) {
            Object object = pkId = pkId instanceof String ? pkId : "" + pkId;
        }
        if ((dynColl = BusinessDataServiceHelper.load((String)AttachmentPanelEntityNumber, (String)"finterid,ftemppageid,ffileid,fattachmentname,fextname", (QFilter[])(filters = new QFilter[]{new QFilter("FTEMPPAGEID", EQUAL, (Object)pageId).or(new QFilter(F_INTER_ID, EQUAL, pkId))}))) != null && dynColl.length > 0) {
            log.info("......saveTempAttachments  filter-> (FTEMPPAGEID=" + pageId + " or pkId=" + pkId + ")");
            for (int i = 0; i < dynColl.length; ++i) {
                if (StringUtils.isBlank((CharSequence)((String)dynColl[i].get(F_INTER_ID)))) {
                    dynColl[i].set(F_INTER_ID, pkId);
                    dynColl[i].set("FTEMPPAGEID", null);
                }
                String uuid = UUID.randomUUID().toString();
                FileService service = FileServiceFactory.getAttachmentFileService();
                String tempUrl = (String)dynColl[i].get("FFILEID");
                String attacmentName = (String)dynColl[i].get("FATTACHMENTNAME");
                String tenantId = CacheKeyUtil.getAcctId();
                String filetype = (String)dynColl[i].get(FEXTNAME);
                String path = "/public/attachment/" + tenantId + DIV + pageId + DIV + uuid + DIV + attacmentName;
                FileItemExt fileItem = null;
                TempFileCache downLoad = null;
                if (!tempUrl.contains("/public/attachment/") && !tempUrl.contains("/eas/attachment/")) {
                    downLoad = CacheFactory.getCommonCacheFactory().getTempFileCache();
                    fileItem = new FileItemExt(attacmentName, path, downLoad.getInputStream(tempUrl));
                    fileItem.setSource(FileSource.ATTACHMENT_PANEL);
                    fileItem.setComputeDigest(true);
                }
                if (fileItem == null) continue;
                String url = service.upload(fileItem);
                if (downLoad != null) {
                    downLoad.remove(tempUrl);
                }
                if (!StringUtils.isNotBlank((CharSequence)url)) continue;
                dynColl[i].set("ffileid", (Object)url);
            }
            SaveServiceHelper.save((DynamicObject[])dynColl);
        }
        return dynColl;
    }

    public static void removeTemp(String formId, String pageId, Object fileUid) {
        ORM orm = ORM.create();
        QFilter[] filters = new QFilter[]{new QFilter(FNUMBER, EQUAL, fileUid), new QFilter("FTEMPPAGEID", EQUAL, (Object)pageId), new QFilter(F_BILL_TYPE, EQUAL, (Object)formId)};
        orm.delete(AttachmentPanelEntityNumber, filters);
    }

    @KSMethod
    public static Map<String, String> getAttachmentsForApi(String formId, Object pkId1) {
        QFilter[] filters;
        String pkId = null;
        if (pkId1 != null) {
            pkId = pkId1.toString();
        }
        if (StringUtils.isEmpty(pkId)) {
            throw new IllegalArgumentException("pkId");
        }
        HashMap<String, String> ret = new HashMap<String, String>(16);
        ORM orm = ORM.create();
        DynamicObjectCollection dynColl = orm.getByFilter(AttachmentPanelEntityNumber, filters = new QFilter[]{new QFilter(F_INTER_ID, EQUAL, (Object)pkId), new QFilter(F_BILL_TYPE, EQUAL, (Object)formId)}, "fattachmentpanel ASC");
        if (dynColl != null && !dynColl.isEmpty()) {
            for (DynamicObject obj : dynColl) {
                String panel = obj.getString(FATTACHMENT_PANEL);
                String url = null;
                try {
                    url = AttachmentServiceHelper.getEncreptURL(UrlService.getAttachmentFullUrl((String)URLEncoder.encode(String.valueOf(obj.get(F_FILE_ID)), UTF_8)));
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Throwable)e);
                }
                String panelStr = (String)ret.get(panel);
                if (null != panelStr) {
                    url = (String)ret.get(panel) + "," + url;
                }
                ret.put(panel, url);
            }
        }
        return ret;
    }

    public static Set<Object> filterExistAttachmentByExport(String formId, Set<Object> pkIds) {
        HashMap<String, String> pks = new HashMap<String, String>(16);
        for (Object pk : pkIds) {
            String key = pk != null && !(pk instanceof String) ? "" + pk : (String)pk;
            String value = null == pk ? "" : pk.toString();
            pks.put(key, value);
        }
        QFilter[] filters = new QFilter[]{new QFilter(F_INTER_ID, "in", pks.values()), new QFilter(F_BILL_TYPE, EQUAL, (Object)formId)};
        DynamicObjectCollection coll = QueryServiceHelper.query((String)AttachmentPanelEntityNumber, (String)F_INTER_ID, (QFilter[])filters);
        HashSet<Object> retData = new HashSet<Object>();
        for (DynamicObject obj : coll) {
            Object key = pks.get(obj.getString(F_INTER_ID));
            if (retData.contains(key)) continue;
            retData.add(key);
        }
        return retData;
    }

    @KSMethod
    public static List<Map<String, Object>> getAttachmentsByExport(String formId, Object pkId) {
        QFilter[] filters;
        ORM orm;
        DynamicObjectCollection dynColl;
        if (pkId != null) {
            pkId = pkId instanceof String ? pkId : "" + pkId;
        }
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        if (!(StringUtils.isBlank((Object)pkId) || pkId instanceof Long && (Long)pkId == 0L || (dynColl = (orm = ORM.create()).getByFilter(AttachmentPanelEntityNumber, filters = new QFilter[]{new QFilter(F_INTER_ID, EQUAL, pkId), new QFilter(F_BILL_TYPE, EQUAL, (Object)formId)}, FNUMBER_ASC)) == null || dynColl.isEmpty())) {
            for (DynamicObject obj : dynColl) {
                DynamicObject creator;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(LAST_MODIFIED, obj.get(F_MODIFY_TIME));
                map.put("name", obj.get(F_ATTACHMENT_NAME));
                map.put("size", Long.parseLong((String)obj.get(FATTACHMENTSIZE)));
                map.put("uid", obj.get(FNUMBER));
                map.put("url", obj.get(F_FILE_ID));
                map.put("type", obj.get(FEXTNAME));
                map.put(DESCRIPTION, obj.get(FDESCRIPTION));
                map.put(STATUS, SUCCESS);
                map.put(FATTACHMENT_PANEL, obj.get(FATTACHMENT_PANEL));
                Timestamp createdate = (Timestamp)obj.get(FCREATETIME);
                if (createdate != null) {
                    map.put(CREATE_DATE, createdate.getTime());
                }
                if ((creator = (DynamicObject)obj.get(FCREATEMEN)) != null) {
                    map.put(CREATOR, creator.get(((BasedataEntityType)creator.getDataEntityType()).getNameProperty()));
                }
                data.add(map);
            }
        }
        return data;
    }

    @KSMethod
    public static Map<String, List<Map<String, Object>>> getAttachmentsByExport(String formId, Object[] pkIds, String attachKey) {
        boolean dragAtm;
        QFilter[] filters;
        ORM orm;
        DynamicObjectCollection dynColl;
        List<String> attachBillPks = AttachmentServiceHelper.rebuildBillPkIds(pkIds);
        HashMap<String, List<Map<String, Object>>> datas = new HashMap<String, List<Map<String, Object>>>();
        if (!attachBillPks.isEmpty() && (dynColl = (orm = ORM.create()).getByFilter(AttachmentPanelEntityNumber, filters = new QFilter[]{new QFilter(F_INTER_ID, "in", attachBillPks), new QFilter(F_BILL_TYPE, EQUAL, (Object)formId), new QFilter(FATTACHMENT_PANEL, EQUAL, (Object)attachKey)}, (dragAtm = AttachmentServiceHelper.isDragAtm(formId, attachKey)) ? FDRAGSEQ_ASC : FNUMBER_ASC)) != null && !dynColl.isEmpty()) {
            for (DynamicObject obj : dynColl) {
                DynamicObject creator;
                HashMap<String, Object> map = new HashMap<String, Object>();
                String billPkId = obj.getString(F_INTER_ID);
                map.put(LAST_MODIFIED, obj.get(F_MODIFY_TIME));
                map.put("name", obj.get(F_ATTACHMENT_NAME));
                map.put("size", Long.parseLong((String)obj.get(FATTACHMENTSIZE)));
                map.put("uid", obj.get(FNUMBER));
                map.put("url", obj.get(F_FILE_ID));
                map.put("type", obj.get(FEXTNAME));
                map.put(DESCRIPTION, obj.get(FDESCRIPTION));
                map.put(STATUS, SUCCESS);
                map.put(FATTACHMENT_PANEL, obj.get(FATTACHMENT_PANEL));
                map.put(BILL_PK_ID, billPkId);
                Timestamp createdate = (Timestamp)obj.get(FCREATETIME);
                if (createdate != null) {
                    map.put(CREATE_DATE, createdate.getTime());
                }
                if ((creator = (DynamicObject)obj.get(FCREATEMEN)) != null) {
                    map.put(CREATOR, creator.get(((BasedataEntityType)creator.getDataEntityType()).getNameProperty()));
                }
                datas.computeIfAbsent(billPkId, k -> new ArrayList()).add(map);
            }
        }
        return datas;
    }

    public static List<Map<String, Object>> getTempAttachments(String formId, String pageId, String attachKey) {
        QFilter[] filters;
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        ORM orm = ORM.create();
        DynamicObjectCollection dynColl = orm.getByFilter(AttachmentPanelEntityNumber, filters = new QFilter[]{new QFilter("FTEMPPAGEID", EQUAL, (Object)pageId), new QFilter(F_BILL_TYPE, EQUAL, (Object)formId), new QFilter(FATTACHMENT_PANEL, EQUAL, (Object)attachKey)}, FNUMBER_ASC);
        if (dynColl != null && !dynColl.isEmpty()) {
            ArrayList<DynamicObject> upd = new ArrayList<DynamicObject>();
            for (DynamicObject obj : dynColl) {
                Object attachmentKey;
                DynamicObject creator;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(LAST_MODIFIED, obj.get(F_MODIFY_TIME));
                map.put("name", obj.get(F_ATTACHMENT_NAME));
                map.put("size", Long.parseLong((String)obj.get(FATTACHMENTSIZE)));
                map.put("uid", obj.get(FNUMBER));
                try {
                    map.put("url", AttachmentServiceHelper.getEncreptURL(UrlService.getAttachmentFullUrl((String)URLEncoder.encode(String.valueOf(obj.get(F_FILE_ID)), UTF_8))));
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Throwable)e);
                }
                map.put(DESCRIPTION, obj.get(FDESCRIPTION));
                map.put(STATUS, SUCCESS);
                Timestamp createdate = (Timestamp)obj.get(FCREATETIME);
                if (createdate != null) {
                    map.put(CREATE_DATE, createdate.getTime());
                    String createTimeStr = KDDateFormatUtils.getDateTimeFormat((TimeZone)KDDateUtils.getUserTimeZone()).format(new Date(createdate.getTime()));
                    map.put("createtimestr", createTimeStr);
                }
                if ((creator = (DynamicObject)obj.get(FCREATEMEN)) != null) {
                    map.put(CREATOR, creator.get(((BasedataEntityType)creator.getDataEntityType()).getNameProperty()));
                }
                if (StringUtils.isBlank((Object)(attachmentKey = obj.get(FATTACHMENT_PANEL)))) {
                    obj.set(FATTACHMENT_PANEL, (Object)attachKey);
                    upd.add(obj);
                }
                map.put(FATTACHMENT_PANEL, attachKey);
                data.add(map);
            }
            if (!upd.isEmpty()) {
                orm.update(upd);
            }
        }
        return data;
    }

    public static void mark(String uid, String description) {
        AttachmentServiceHelper.mark(uid, description, null);
    }

    public static void mark(String uid, String description, String attPkId) {
        QFilter[] filters;
        ORM orm = ORM.create();
        if (StringUtils.isBlank((CharSequence)attPkId)) {
            filters = new QFilter[]{new QFilter("fnumber", EQUAL, (Object)uid)};
        } else {
            Long pkId = Long.parseLong(attPkId);
            filters = new QFilter[]{new QFilter("id", EQUAL, (Object)pkId)};
        }
        DynamicObjectCollection dynColl = orm.getByFilter(AttachmentPanelEntityNumber, filters);
        if (dynColl != null && !dynColl.isEmpty()) {
            DynamicObject dyn = (DynamicObject)dynColl.get(0);
            dyn.set(FDESCRIPTION, (Object)description);
            orm.update(dyn);
        }
    }

    public static void rename(String uid, String name) {
        AttachmentServiceHelper.rename(uid, name, null);
    }

    public static void rename(String uid, String name, String attPkId) {
        QFilter[] filters;
        ORM orm = ORM.create();
        if (StringUtils.isBlank((CharSequence)attPkId)) {
            filters = new QFilter[]{new QFilter("fnumber", EQUAL, (Object)uid)};
        } else {
            Long pkId = Long.parseLong(attPkId);
            filters = new QFilter[]{new QFilter("id", EQUAL, (Object)pkId)};
        }
        DynamicObjectCollection dynColl = orm.getByFilter(AttachmentPanelEntityNumber, filters);
        if (dynColl != null && !dynColl.isEmpty()) {
            DynamicObject dyn = (DynamicObject)dynColl.get(0);
            dyn.set(F_ATTACHMENT_NAME, (Object)name);
            orm.update(dyn);
        }
    }

    public static void saveDragSeq(List<Map<String, Object>> data) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        HashMap<Long, Integer> tmpMap = new HashMap<Long, Integer>(data.size());
        for (Map<String, Object> datum : data) {
            if (datum.get("attPkId") == null || !(datum.get("attPkId") instanceof Long) || datum.get(DRAGSEQ) == null || !(datum.get(DRAGSEQ) instanceof Integer)) continue;
            tmpMap.put((Long)datum.get("attPkId"), (Integer)datum.get(DRAGSEQ));
        }
        if (MapUtils.isEmpty(tmpMap)) {
            return;
        }
        Long[] pks = tmpMap.keySet().toArray(new Long[0]);
        QFilter qFilter = new QFilter("id", "in", (Object)pks);
        Map toUpdateDynMap = BusinessDataServiceHelper.loadFromCache((String)AttachmentPanelEntityNumber, (String)"id,dragseq", (QFilter[])new QFilter[]{qFilter});
        toUpdateDynMap.forEach((k, v) -> {
            Integer dragSeq = (Integer)tmpMap.get(k);
            v.set(DRAGSEQ, (Object)dragSeq);
        });
        DynamicObject[] toUpdateDynArr = toUpdateDynMap.values().toArray(new DynamicObject[0]);
        SaveServiceHelper.update((DynamicObject[])toUpdateDynArr);
    }

    public static DynamicObject getAttCreatorByUID(String uid) {
        QFilter[] filters = new QFilter[]{new QFilter("fnumber", EQUAL, (Object)uid)};
        DynamicObject att = BusinessDataServiceHelper.loadSingleFromCache((String)AttachmentPanelEntityNumber, (QFilter[])filters);
        return att;
    }

    public static AttachmentDto getAttachmentInfoByAttPk(Object pkId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)AttachmentPanelEntityNumber);
        if (dynamicObject == null) {
            return new AttachmentDto();
        }
        AttachmentDto attachmentDto = new AttachmentDto();
        attachmentDto.setAttPk(pkId);
        attachmentDto.setAttachmentType(AttachmentType.attachmentpanel);
        attachmentDto.setCreateTime(dynamicObject.getDate(FCREATETIME));
        attachmentDto.setFilename(dynamicObject.getString("fattachmentname"));
        attachmentDto.setSize(dynamicObject.getInt("fattachmentsize"));
        Object userId = dynamicObject.get(FCREATEMEN);
        attachmentDto.setCreateUserId(userId == null ? "" : userId.toString());
        attachmentDto.setResourcePath(dynamicObject.getString(F_FILE_ID));
        return attachmentDto;
    }

    public static String generateUid() {
        return "rc-upload-" + ID.genLongId();
    }

    public static String genCustomAttachUrl(DisposableUrlParam disposableUrlParam) {
        String path = disposableUrlParam.getPath();
        String entityNum = disposableUrlParam.getEntityNum();
        Object pkId = disposableUrlParam.getPkId();
        String permItem = disposableUrlParam.getPermItem();
        log.info("kd.bos.servicehelper.AttachmentServiceHelper.genCustomAttachUrl --- params --- path = " + path + "\uff0centityNum = " + entityNum + "\uff0cpkId = " + pkId + "\uff0cpermItem = " + permItem);
        if (StringUtils.isBlank((CharSequence)path) || StringUtils.isBlank((CharSequence)entityNum) || StringUtils.isBlank((Object)pkId)) {
            throw new KDException(new ErrorCode("params can not be null!", ResManager.loadKDString((String)"\u7f3a\u5c11\u4e00\u6b21\u6027\u94fe\u63a5\u53c2\u6570\uff01", (String)"AttachmentFieldServiceHelper_1", (String)BOS_SVC_METADATA, (Object[])new Object[0])), new Object[0]);
        }
        if (path.contains(CONFIG_KEY)) {
            return AttachmentServiceHelper.genTempCustomAttachUrl(disposableUrlParam) + "&disposable=disposable";
        }
        disposableUrlParam.setPath(FileServiceExtFactory.getAttachFileServiceExt().getRealPath(path));
        String customAttachId = PermissionParam.genCustomAttacId((DisposableUrlParam)disposableUrlParam);
        return UrlService.getDomainContextUrl() + "/attachment/download.do?customAttachId=" + customAttachId;
    }

    private static String genTempCustomAttachUrl(DisposableUrlParam disposableUrlParam) {
        Map<String, String> paramMap = AttachmentServiceHelper.parseURLParams(disposableUrlParam.getPath());
        if (!paramMap.containsKey("id")) {
            throw new KDException(new ErrorCode("error path!", ResManager.loadKDString((String)"\u4e34\u65f6\u6587\u4ef6\u8def\u5f84\u683c\u5f0f\u9519\u8bef\uff0c\u7f3a\u5c11id\u53c2\u6570\uff01", (String)"AttachmentFieldServiceHelper_2", (String)BOS_SVC_METADATA, (Object[])new Object[0])), new Object[0]);
        }
        String tempFileId = paramMap.get("id");
        Map permissionParam = PermissionParam.createPermissionParam((DisposableUrlParam)disposableUrlParam);
        redisCache.put(IS_LOSE_EFFICACY + tempFileId + "disposable", (Object)SerializationUtils.toJsonString((Object)permissionParam), 7200);
        HashMap<String, Object> refEntitiyMap = new HashMap<String, Object>(2);
        refEntitiyMap.put("entityNum", disposableUrlParam.getEntityNum());
        refEntitiyMap.put(BILL_PK_ID, disposableUrlParam.getPkId());
        refEntitiyMap.put("permissionItemId", disposableUrlParam.getPermItem());
        redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), 7200);
        return disposableUrlParam.getPath();
    }

    public static Map<String, String> parseUrl(String url) {
        String[] parseStr = url.split("\\?");
        String[] pairs = parseStr[1].split(AND);
        HashMap<String, String> params = new HashMap<String, String>(pairs.length);
        for (String pair : pairs) {
            String[] p = pair.split(EQUAL);
            params.put(p[0], p[1]);
        }
        return params;
    }

    private static Map<String, String> parseURLParams(String urlString) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            URL url = new URL(urlString);
            String query = url.getQuery();
            if (query != null) {
                String[] pairs;
                for (String pair : pairs = query.split(AND)) {
                    int idx = pair.indexOf(EQUAL);
                    String key = pair.substring(0, idx);
                    String value = pair.substring(idx + 1);
                    params.put(key, value);
                }
            }
        }
        catch (Exception e) {
            log.error("kd.bos.servicehelper.AttachmentServiceHelper.parseURLParams", (Throwable)e);
            throw new KDException(new ErrorCode("parse error!", ResManager.loadKDString((String)"url\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5url\u683c\u5f0f\u662f\u5426\u7b26\u5408\u89c4\u8303\uff01", (String)"AttachmentFieldServiceHelper_3", (String)BOS_SVC_METADATA, (Object[])new Object[0])), new Object[0]);
        }
        return params;
    }
}

