/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.attachment;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.attachment.util.BillFileMappingWriter;
import kd.bos.basedataref.BaseDataRefenceKey;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.TempTransResult;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.utils.FileUtil;
import kd.bos.form.attachment.util.ParamUtil;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.AttachmentInfo;
import kd.bos.mservice.attachment.AttachmentOpType;
import kd.bos.mservice.attachment.AttachmentRemoveSource;
import kd.bos.mservice.attachment.AttachmentType;
import kd.bos.mservice.attachment.IAttachmentManagerService;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.param.service.IParameterReaderService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.service.attachment.FileItemExt;
import kd.bos.service.attachment.FileSource;
import kd.bos.servicehelper.AttachmentDto;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class AttachmentFieldServiceHelper {
    private static final String ATT_ID = "id";
    private static final String BILL_NUMBER = "number";
    private static final String BILL_PAGEID = "pageid";
    private static final String ATT_NAME = "name";
    private static final String ATT_SIZE = "size";
    private static final String ATT_UID = "uid";
    private static final String ATT_URL = "url";
    private static final String ATT_TYPE = "type";
    private static final String ATT_CREATOR = "creator";
    private static final String ATT_CREATETIME = "createtime";
    private static final String ATT_MODIFYTIME = "modifytime";
    private static final String ATT_DECRIPTION = "description";
    private static final String ATT_STATUS = "status";
    private static final String ATT_TEMPFILE = "tempfile";
    private static final String ATT_SORT = "sort";
    private static final String FILESOURCE = "filesource";
    private static final String DRAGSEQ = "dragseq";
    private static final String ATT_UPLOADING = "uploading";
    private static final String ATT_SUCCESS = "success";
    private static final String ATT_ERROR = "error";
    private static final String ATT_CANCEL = "canceled";
    private static final String ATT_UPLOADING_STATUS = "A";
    private static final String ATT_SUCCESS_STATUS = "B";
    private static final String ATT_ERROR_STATUS = "C";
    private static final String ATT_CANCEL_STATUS = "D";
    private static final String ATT_ENTITYID = "bd_attachment";
    private static final int ATT_TEMP = 0;
    private static final String ATT_TEMP_CHAR = "0";
    private static final int ATT_OFFICIAL = 1;
    private static final String[] SPECIAL_SYMBOLS = new String[]{"%", "=", "+", "&"};
    private static final String CONFIG_KEY = "tempfile/download.do?configKey";
    private static final String ENABLE_PRE_VIEW = "enablePreView";
    private static final String ERR_MSG = "errMsg";
    private static final String BOS_SERVICEHELPER = "bos-servicehelper";
    private static final String ENTITY_BOS_ATTACH_OPLOG = "bos_attachment_oplog";
    private static Log log = LogFactory.getLog(AttachmentFieldServiceHelper.class);
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"AttachmentFieldServiceHelper", (int)5);
    private static final String BOS_SVC_METADATA = "bos-svc-metadata";

    public static List<DynamicObject> saveAttachments(String formId, String pageId, List<Map<String, Object>> attachments) {
        DynamicObjectType entityType = (DynamicObjectType)ORM.create().getDataEntityType(ATT_ENTITYID);
        DynamicObjectCollection attObjs = new DynamicObjectCollection(entityType, null);
        ArrayList<DynamicObject> allAttObjs = new ArrayList<DynamicObject>(attachments.size());
        HashMap uidAttachs = Maps.newHashMapWithExpectedSize((int)attachments.size());
        for (Map<String, Object> attachment : attachments) {
            uidAttachs.put(attachment.get(ATT_UID), attachment);
        }
        Map dyColl = BusinessDataServiceHelper.loadFromCache((String)ATT_ENTITYID, (QFilter[])new QFilter[]{new QFilter(ATT_UID, "in", uidAttachs.keySet())});
        if (dyColl != null && dyColl.size() > 0) {
            Map<Object, Integer> nameToDragSeqMap = attachments.stream().filter(item -> item.get(ATT_NAME) != null).collect(Collectors.toMap(item -> item.get(ATT_NAME).toString(), item -> Optional.ofNullable(item.get(DRAGSEQ)).orElse(-1), (v1, v2) -> v1));
            ArrayList<DynamicObject> dyList = new ArrayList<DynamicObject>(dyColl.values());
            dyList.sort((o1, o2) -> {
                if (nameToDragSeqMap.get(o1.getString(ATT_NAME)) != null && nameToDragSeqMap.get(o2.getString(ATT_NAME)) != null) {
                    return (Integer)nameToDragSeqMap.get(o1.getString(ATT_NAME)) - (Integer)nameToDragSeqMap.get(o2.getString(ATT_NAME));
                }
                return 0;
            });
            AttachmentFieldServiceHelper.updateExistAttachments(dyList, uidAttachs, attObjs, allAttObjs);
        }
        ArrayList<AttachmentInfo> triggerAfterDoOperationAttachs = new ArrayList<AttachmentInfo>(uidAttachs.size());
        if (!uidAttachs.isEmpty()) {
            AttachmentFieldServiceHelper.createNewAttachments(uidAttachs, attObjs, allAttObjs, triggerAfterDoOperationAttachs, pageId);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])attObjs.stream().filter(item -> item.getPkValue() instanceof Long && (Long)item.getPkValue() == 0L).toArray(DynamicObject[]::new)));
        SaveServiceHelper.update((DynamicObject[])((DynamicObject[])attObjs.stream().filter(item -> item.getPkValue() instanceof Long && (Long)item.getPkValue() != 0L).toArray(DynamicObject[]::new)));
        if (!triggerAfterDoOperationAttachs.isEmpty()) {
            for (int i = 0; i < triggerAfterDoOperationAttachs.size(); ++i) {
                ((AttachmentInfo)triggerAfterDoOperationAttachs.get(i)).setAttPkId(Long.valueOf(((DynamicObject)attObjs.get(i)).getLong(ATT_ID)));
            }
            IAttachmentManagerService managerService = (IAttachmentManagerService)ServiceFactory.getService((String)"IAttachmentManagerService");
            managerService.afterDoOperation(triggerAfterDoOperationAttachs, AttachmentOpType.Upload);
        }
        return allAttObjs;
    }

    private static void createNewAttachments(Map<Object, Map<String, Object>> uidAttachs, DynamicObjectCollection attObjs, List<DynamicObject> allAttObjs, List<AttachmentInfo> triggerAfterDoOperationAttachs, String pageId) {
        Date now = new Date();
        for (Map.Entry<Object, Map<String, Object>> entry : uidAttachs.entrySet()) {
            Object modifyTime;
            Map<String, Object> attachment = entry.getValue();
            DynamicObject attObj = BusinessDataServiceHelper.newDynamicObject((String)ATT_ENTITYID);
            String fileName = (String)attachment.get(ATT_NAME);
            String type = fileName != null ? fileName.substring(fileName.lastIndexOf(46) + 1) : "";
            long size = attachment.get(ATT_SIZE) == null ? 0L : Long.parseLong(attachment.get(ATT_SIZE).toString());
            attObj.set(ATT_NAME, (Object)fileName);
            attObj.set(ATT_SIZE, (Object)size);
            attObj.set(ATT_UID, attachment.get(ATT_UID));
            attObj.set(ATT_URL, attachment.get(ATT_URL));
            attObj.set(ATT_TYPE, (Object)type);
            attObj.set(ATT_DECRIPTION, attachment.get(ATT_DECRIPTION));
            attObj.set(FILESOURCE, attachment.get(FILESOURCE));
            attObj.set(DRAGSEQ, attachment.get(DRAGSEQ));
            Object attSortObj = attachment.get(ATT_SORT);
            if (attSortObj != null) {
                attObj.set(ATT_SORT, attSortObj);
            }
            if (attachment.get(ATT_URL) instanceof String && !String.valueOf(attachment.get(ATT_URL)).contains(CONFIG_KEY)) {
                attObj.set(ATT_TEMPFILE, (Object)1);
            } else {
                attObj.set(ATT_TEMPFILE, (Object)0);
            }
            attObj.set(BILL_PAGEID, (Object)pageId);
            attObj.set(BILL_NUMBER, (Object)UUID.randomUUID().toString());
            AttachmentFieldServiceHelper.setAttStatus(attObj, attachment);
            attObj.set(ATT_CREATETIME, (Object)now.getTime());
            if (attachment.containsKey("uploadTime")) {
                attObj.set(ATT_CREATETIME, (Object)new Date((Long)attachment.get("uploadTime")));
            }
            if ((modifyTime = attachment.get(ATT_MODIFYTIME)) == null) {
                attObj.set(ATT_MODIFYTIME, (Object)now.getTime());
            } else {
                attObj.set(ATT_MODIFYTIME, (Object)new Date((Long)modifyTime));
            }
            attObj.set(ATT_CREATOR, (Object)RequestContext.get().getUserId());
            try {
                attObjs.add((Object)attObj);
                allAttObjs.add(attObj);
            }
            catch (Exception e) {
                log.error("attobj ***** attObj.getDataEntityType() is null ? *** " + (attObj.getDataEntityType() == null));
                log.error("attobj ***** type is *** " + attObj.getDataEntityType().getDisplayName());
                log.error("attObjs ***** type is *** " + attObjs.getDynamicObjectType().getDisplayName());
                log.error("attobj ***** type is *** " + attObj.getDataEntityType().getExtendName());
                log.error("attObjs ***** type is *** " + attObjs.getDynamicObjectType().getExtendName());
                throw e;
            }
            AttachmentInfo attachmentInfo = AttachmentFieldServiceHelper.attFileldObjToAttachmentInfo(attObj);
            attachmentInfo.setEntityNum((String)attachment.get("entityNum"));
            attachmentInfo.setBillPkId((String)attachment.get("billPkId"));
            attachmentInfo.setAttKey((String)attachment.get("attKey"));
            attachmentInfo.setClient((String)attachment.get("client"));
            attachmentInfo.setBillno((String)attachment.get("billno"));
            triggerAfterDoOperationAttachs.add(attachmentInfo);
        }
    }

    private static void updateExistAttachments(Collection<DynamicObject> dyColl, Map<Object, Map<String, Object>> uidAttachs, DynamicObjectCollection attObjs, List<DynamicObject> allAttObjs) {
        for (DynamicObject att : dyColl) {
            Map<String, Object> attachment = uidAttachs.remove(att.get(ATT_UID));
            if (attachment == null) continue;
            if (!StringUtils.equals((CharSequence)attachment.get(ATT_STATUS).toString(), (CharSequence)AttachmentFieldServiceHelper.getAttStatus(att.get(ATT_STATUS).toString()))) {
                AttachmentFieldServiceHelper.setAttStatus(att, attachment);
                att.set(ATT_URL, attachment.get(ATT_URL));
                Object attSortObj = attachment.get(ATT_SORT);
                if (attSortObj != null) {
                    att.set(ATT_SORT, attSortObj);
                }
                attObjs.add((Object)att);
            }
            allAttObjs.add(att);
        }
    }

    private static AttachmentInfo attFileldObjToAttachmentInfo(DynamicObject attObj) {
        AttachmentInfo attachmentInfo = new AttachmentInfo();
        Date today = new Date();
        attachmentInfo.setAttSourceType(AttachmentType.attachmentfield);
        attachmentInfo.setExt(attObj.getString(ATT_TYPE));
        attachmentInfo.setFileName(attObj.getString(ATT_NAME));
        attachmentInfo.setFileSize(Long.valueOf(attObj.getLong(ATT_SIZE)));
        attachmentInfo.setDownloadUrl(attObj.getString(ATT_URL));
        attachmentInfo.setPreviewUrl(attachmentInfo.getDownloadUrl().replace("download.do", "preview.do"));
        attachmentInfo.setMark(attObj.getString(ATT_DECRIPTION));
        attachmentInfo.setCreateTime(attObj.getDate(ATT_CREATETIME));
        attachmentInfo.setCreateUserId(RequestContext.get().getUserId());
        attachmentInfo.setModifyTime(today);
        return attachmentInfo;
    }

    public static void saveTempAttachments(String attachmentFieldString) {
        Object tempUrl;
        String pageId = attachmentFieldString;
        String pkId = ATT_TEMP_CHAR;
        String billNo = "";
        try {
            Map attachmentField = (Map)SerializationUtils.fromJsonString((String)attachmentFieldString, Map.class);
            Object pkIdObj = attachmentField.get("PkId");
            pkId = pkIdObj == null ? ATT_TEMP_CHAR : pkIdObj.toString();
            pageId = attachmentField.get("PageId").toString();
            billNo = String.valueOf(attachmentField.get("BillNo"));
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
        QFilter[] filters = new QFilter[]{new QFilter(ATT_TEMPFILE, "=", (Object)ATT_TEMP_CHAR), new QFilter(BILL_PAGEID, "=", (Object)pageId), new QFilter(ATT_STATUS, "=", (Object)ATT_SUCCESS_STATUS)};
        String selectFields = "id,name,tempfile,url,pageid,size,type,description,createtime";
        DynamicObject[] att = BusinessDataServiceHelper.load((String)ATT_ENTITYID, (String)selectFields, (QFilter[])filters);
        long compressPicSize = AttachmentServiceHelper.getCompressPicSize();
        HashMap attPkMap = Maps.newHashMapWithExpectedSize((int)att.length);
        ArrayList<AttachmentInfo> infos = new ArrayList<AttachmentInfo>(10);
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        for (int i = 0; i < att.length; ++i) {
            String extName;
            tempUrl = (String)att[i].get(ATT_URL);
            String name = String.valueOf(att[i].get(ATT_NAME));
            Object object = att[i].getPkValue();
            attPkMap.put(object, att[i]);
            if (!((String)tempUrl).contains(CONFIG_KEY)) continue;
            String path = AttachmentFieldServiceHelper.saveTempToFileService((String)tempUrl, object, name);
            att[i].set(ATT_URL, (Object)path);
            att[i].set(ATT_TEMPFILE, (Object)1);
            att[i].set(BILL_PAGEID, (Object)"");
            String string = extName = name != null ? name.substring(name.lastIndexOf(46) + 1) : "";
            if (!"jpg,jpeg,png,gif,bmp,tiff,tga,ico,dib,rle,emf,jpe,jfif,pcx,dcx,pic,tif,wmf".contains(extName.toLowerCase()) || compressPicSize == 0L || Long.parseLong(att[i].get(ATT_SIZE).toString()) <= compressPicSize * 1024L) continue;
            att[i].set(ATT_SIZE, (Object)fileService.getFileSize(path));
        }
        TXHandle h = TX.requiresNew();
        tempUrl = null;
        try {
            SaveServiceHelper.save((DynamicObject[])att);
        }
        catch (Throwable name) {
            tempUrl = name;
            throw name;
        }
        finally {
            if (h != null) {
                if (tempUrl != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable name) {
                        ((Throwable)tempUrl).addSuppressed(name);
                    }
                } else {
                    h.close();
                }
            }
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("OPTYPE", "=", (Object)"1").and(new QFilter("ATTPKID", "in", attPkMap.keySet()))};
        Map opLogObjCol = BusinessDataServiceHelper.loadFromCache((String)ENTITY_BOS_ATTACH_OPLOG, (QFilter[])qFilters);
        for (Map.Entry entry : opLogObjCol.entrySet()) {
            DynamicObject opLogObj = (DynamicObject)entry.getValue();
            long attpkid = opLogObj.getLong("ATTPKID");
            if (attPkMap.get(attpkid) == null) continue;
            AttachmentInfo attachmentInfo = AttachmentFieldServiceHelper.attFileldObjToAttachmentInfo((DynamicObject)attPkMap.get(attpkid));
            attachmentInfo.setAttPkId(Long.valueOf(opLogObj.getLong("ATTPKID")));
            attachmentInfo.setAttKey(opLogObj.getString("ATTKEY"));
            DynamicObject bizobj = opLogObj.getDynamicObject("BIZOBJ");
            if (bizobj == null || bizobj.getString("NUMBER") == null) {
                attachmentInfo.setEntityNum("");
            } else {
                attachmentInfo.setEntityNum(bizobj.getString("NUMBER"));
            }
            attachmentInfo.setBillPkId(pkId);
            attachmentInfo.setClient(opLogObj.getString("CLIENTTYPE"));
            attachmentInfo.setBillno(billNo);
            infos.add(attachmentInfo);
        }
        if (!infos.isEmpty()) {
            IAttachmentManagerService managerService = (IAttachmentManagerService)ServiceFactory.getService((String)"IAttachmentManagerService");
            managerService.afterDoOperation(infos, AttachmentOpType.Save);
        }
    }

    public static String saveTempToFileService(String tempUrl, Object AttPk, String fileName) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String path = FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (Object)AttPk, (String)(uuid + "/" + AttachmentFieldServiceHelper.replaceSpeSymbol(fileName)));
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        TempFileCacheDownloadable downloadable = (TempFileCacheDownloadable)tempFileCache;
        FileItemExt fileItem = new FileItemExt(fileName, path, null);
        fileItem.setSource(FileSource.ATTACHMENT_FIELD);
        fileItem.setComputeDigest(true);
        fileItem.setCreateNewFileWhenExists(true);
        fileItem.setVerified(true);
        if (!tempFileCache.supportTempToData(tempUrl)) {
            InputStream inputStream;
            try {
                Map<String, String> params = AttachmentServiceHelper.parseUrl(tempUrl);
                TempFileCacheDownloadable.Content content = downloadable.download(params);
                inputStream = content.getInputStream();
            }
            catch (Exception e) {
                log.error((Throwable)e);
                throw new KDException(new ErrorCode("GET_TEMP_FILE_ERROR", ResManager.loadKDString((String)"\u4e34\u65f6\u6587\u4ef6\u83b7\u53d6\u5931\u8d25\u3002", (String)"AttachmentServiceHelper_0", (String)BOS_SVC_METADATA, (Object[])new Object[0])), new Object[0]);
            }
            fileItem.setInputStream(inputStream);
            String url = service.upload((FileItem)fileItem);
            tempFileCache.remove(tempUrl);
            return url;
        }
        fileItem.setTempFileUrl(tempUrl);
        ArrayList<FileItemExt> fileItemList = new ArrayList<FileItemExt>(1);
        fileItemList.add(fileItem);
        List tempTransResults = service.moveTempFile(fileItemList);
        TempTransResult tempTransResult = (TempTransResult)tempTransResults.get(0);
        return tempTransResult.getPath();
    }

    public static void removeAttachments(final String formId, final String tableName, Map<String, Object> attachments) {
        QFilter[] filters = new QFilter[]{new QFilter(ATT_UID, "=", attachments.get(ATT_UID))};
        final DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)ATT_ENTITYID, (String)"id,url", (QFilter[])filters);
        if (null != obj) {
            final Object attPkId = obj.getPkValue();
            final Object billPkId = attachments.get("billPkId");
            threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    boolean canDelete;
                    MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)AttachmentFieldServiceHelper.ATT_ENTITYID);
                    String path = obj.getString(AttachmentFieldServiceHelper.ATT_URL);
                    if (!StringUtils.isNotEmpty((CharSequence)tableName)) {
                        return;
                    }
                    AttachmentFieldServiceHelper.removeRelateTableByAttIdAndBillPkId(formId, tableName, attPkId, billPkId);
                    boolean bl = canDelete = !AttachmentServiceHelper.checkRefByPath(path);
                    if (canDelete) {
                        DeleteServiceHelper.delete((IDataEntityType)entityType, (Object[])new Object[]{attPkId});
                        if (path.contains(AttachmentFieldServiceHelper.CONFIG_KEY)) {
                            CacheFactory.getCommonCacheFactory().getTempFileCache().remove(path);
                        } else {
                            FileServiceFactory.getAttachmentFileService().delete(path);
                            BillFileMappingWriter.removeMappingRecord((String)path, (String)"attach");
                        }
                        AttachmentFieldServiceHelper.removeYzjPreviewFile(path);
                    }
                }
            });
        }
    }

    private static void removeYzjPreviewFile(String path) {
        if (path == null || path.contains(CONFIG_KEY)) {
            return;
        }
        if ("1".equals(ParamUtil.getPreviewType())) {
            try {
                FileServiceFactory.getAttachmentFileService().deletePreviewWps(path, ParamUtil.getYzjParam());
            }
            catch (Exception e) {
                log.error("\u79fb\u9664\u5143\u4e4b\u5bb6\u9884\u89c8\u6587\u4ef6\u5931\u8d25,meg:" + e.getMessage());
            }
        }
    }

    @Deprecated
    public static void removeAttachmentsByAttPkIds(String entityNum, String tableName, Object[] attPkIds) {
        AttachmentFieldServiceHelper.removeAttachmentsByAttPkIds(entityNum, tableName, attPkIds, null);
    }

    @Deprecated
    public static void removeAttachmentsByAttPkIds(String entityNum, String tableName, Object[] attPkIds, Object entryPkId) {
        AttachmentFieldServiceHelper.removeAttachmentsByAttPkIds(entityNum, tableName, attPkIds, entryPkId, false);
    }

    @Deprecated
    public static void removeAttachmentsByAttPkIds(String entityNum, String tableName, Object[] attPkIds, Object entryPkId, boolean isHead) {
        Object[] entryPkIds = new Object[]{entryPkId};
        if (isHead) {
            AttachmentFieldServiceHelper.asynRemove(entityNum, tableName, attPkIds, entryPkIds, AttachmentRemoveSource.HEAD, false);
            return;
        }
        AttachmentFieldServiceHelper.asynRemove(entityNum, tableName, attPkIds, entryPkIds, AttachmentRemoveSource.ENTRY, false);
    }

    @Deprecated
    public static void removeAttachmentsByAttPkIdsAndFId(String entityNum, String tableName, Object[] attPkIds, Object fid, boolean isHead) {
        Object[] fids = new Object[]{fid};
        if (isHead) {
            AttachmentFieldServiceHelper.asynRemove(entityNum, tableName, attPkIds, fids, AttachmentRemoveSource.HEAD, false);
            return;
        }
        AttachmentFieldServiceHelper.asynRemove(entityNum, tableName, attPkIds, fids, AttachmentRemoveSource.ENTRY, false);
    }

    public static void batchRemoveAtt(String entityNum, String tableName, Object[] attPkIds, Object[] targetIds, AttachmentRemoveSource removeSource, boolean isFormList) {
        AttachmentFieldServiceHelper.asynRemove(entityNum, tableName, attPkIds, targetIds, removeSource, isFormList);
    }

    private static void asynRemove(String entityNum, String tableName, Object[] attPkIds, Object[] targetIds, AttachmentRemoveSource removeSource, boolean isFormList) {
        threadPool.execute(() -> AttachmentFieldServiceHelper.doRemove(entityNum, tableName, attPkIds, targetIds, removeSource, isFormList));
    }

    private static void doRemove(String entityNum, String tableName, Object[] attPkIds, Object[] targetIds, AttachmentRemoveSource removeSource, boolean isFormList) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)ATT_ENTITYID);
        ArrayList<Object> deleteIds = new ArrayList<Object>(16);
        ArrayList<String> deletePaths = new ArrayList<String>(16);
        DynamicObject[] deleteAttList = BusinessDataServiceHelper.load((Object[])attPkIds, (DynamicObjectType)entityType);
        for (DynamicObject att : deleteAttList) {
            String path;
            boolean canDelte;
            if (!StringUtils.isNotEmpty((CharSequence)tableName)) continue;
            if (removeSource == AttachmentRemoveSource.HEAD) {
                AttachmentFieldServiceHelper.removeHeadAtt(entityNum, tableName, att, targetIds, isFormList);
            }
            if (removeSource == AttachmentRemoveSource.ENTRY) {
                AttachmentFieldServiceHelper.removeEntryAtt(entityNum, tableName, att, targetIds, isFormList);
            }
            if (removeSource == AttachmentRemoveSource.SUB_ENTRY) {
                AttachmentFieldServiceHelper.removeSubEntryAtt(entityNum, tableName, att, targetIds, isFormList);
            }
            boolean bl = canDelte = !AttachmentServiceHelper.checkRefByPath(path = att.getString(ATT_URL));
            if (!canDelte) continue;
            deleteIds.add(att.getPkValue());
            deletePaths.add(att.getString(ATT_URL));
        }
        if (!deleteIds.isEmpty()) {
            DeleteServiceHelper.delete((IDataEntityType)entityType, (Object[])deleteIds.toArray());
        }
        for (String path : deletePaths) {
            if (path.contains(CONFIG_KEY)) {
                CacheFactory.getCommonCacheFactory().getTempFileCache().remove(path);
            } else {
                FileServiceFactory.getAttachmentFileService().delete(path);
                BillFileMappingWriter.removeMappingRecord((String)path, (String)"attach");
            }
            AttachmentFieldServiceHelper.removeYzjPreviewFile(path);
        }
    }

    private static void removeHeadAtt(String entityNum, String tableName, DynamicObject att, Object[] fid, boolean isFormList) {
        if (StringUtils.isBlank((Object)fid[0])) {
            AttachmentFieldServiceHelper.removeRelateTable(entityNum, tableName, att.getPkValue());
            return;
        }
        if (isFormList) {
            AttachmentFieldServiceHelper.removeRelateTableByBillPkId(entityNum, tableName, fid);
            return;
        }
        AttachmentFieldServiceHelper.removeRelateTableByAttIdAndBillPkId(entityNum, tableName, att.getPkValue(), fid[0]);
    }

    private static void removeEntryAtt(String entityNum, String tableName, DynamicObject att, Object[] entryPkId, boolean isFormList) {
        if (StringUtils.isBlank((Object)entryPkId[0])) {
            AttachmentFieldServiceHelper.removeRelateTable(entityNum, tableName, att.getPkValue());
            return;
        }
        if (isFormList) {
            AttachmentFieldServiceHelper.removeRelateTableByEntryId(entityNum, tableName, entryPkId);
            return;
        }
        AttachmentFieldServiceHelper.removeRelateTableByAttIdAndEntryId(entityNum, tableName, att.getPkValue(), entryPkId[0]);
    }

    private static void removeSubEntryAtt(String entityNum, String tableName, DynamicObject att, Object[] detailIds, boolean isFormList) {
        if (StringUtils.isBlank((Object)detailIds[0])) {
            AttachmentFieldServiceHelper.removeRelateTable(entityNum, tableName, att.getPkValue());
            return;
        }
        if (isFormList) {
            AttachmentFieldServiceHelper.removeRelateTableByDetailIds(entityNum, tableName, detailIds);
            return;
        }
        AttachmentFieldServiceHelper.removeRelateTableByAttIdAndDetailId(entityNum, tableName, att.getPkValue(), detailIds[0]);
    }

    private static void removeRelateTableByBillPkId(String formId, String tableName, Object[] billPkIds) {
        String sql = "DELETE FROM " + tableName + " WHERE FId = ?";
        AttachmentFieldServiceHelper.doExecuteBatch(sql, formId, tableName, billPkIds, ":FId");
    }

    private static void removeRelateTableByEntryId(String formId, String tableName, Object[] entryPkIds) {
        String sql = "DELETE FROM " + tableName + " WHERE FEntryId = ?";
        AttachmentFieldServiceHelper.doExecuteBatch(sql, formId, tableName, entryPkIds, ":FEntryId");
    }

    private static void removeRelateTableByDetailIds(String formId, String tableName, Object[] fDetailIds) {
        String sql = "DELETE FROM " + tableName + " WHERE FDetailId = ?";
        AttachmentFieldServiceHelper.doExecuteBatch(sql, formId, tableName, fDetailIds, ":FDetailId");
    }

    private static void doExecuteBatch(String sql, String formId, String tableName, Object[] ids, String deleteField) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)formId);
        DBRoute dBRoute = new DBRoute(type.getDBRouteKey());
        ArrayList<SqlParameter[]> list = new ArrayList<SqlParameter[]>(ids.length);
        for (Object id : ids) {
            SqlParameter[] params = new SqlParameter[]{new SqlParameter(deleteField, -5, id)};
            list.add(params);
        }
        log.info("deleteSql --- DELETE FROM " + tableName + " WHERE " + deleteField + " = " + list);
        DB.executeBatch((DBRoute)dBRoute, (String)sql, list);
    }

    public static void removeTempAttachments(String pageId) {
        QFilter[] filters = new QFilter[]{new QFilter(BILL_PAGEID, "=", (Object)pageId), new QFilter(ATT_TEMPFILE, "=", (Object)ATT_TEMP_CHAR)};
        DeleteServiceHelper.delete((String)ATT_ENTITYID, (QFilter[])filters);
    }

    private static void setAttStatus(DynamicObject att, Map<String, Object> attachment) {
        if (ATT_SUCCESS.equals(attachment.get(ATT_STATUS).toString())) {
            att.set(ATT_STATUS, (Object)ATT_SUCCESS_STATUS);
        } else if (ATT_UPLOADING.equals(attachment.get(ATT_STATUS).toString())) {
            att.set(ATT_STATUS, (Object)ATT_UPLOADING_STATUS);
        } else if (ATT_ERROR.equals(attachment.get(ATT_STATUS).toString())) {
            att.set(ATT_STATUS, (Object)ATT_ERROR_STATUS);
        } else {
            att.set(ATT_STATUS, (Object)ATT_CANCEL_STATUS);
        }
    }

    private static String getAttStatus(String attDbStatus) {
        if (attDbStatus.equals(ATT_SUCCESS_STATUS)) {
            return ATT_SUCCESS;
        }
        if (attDbStatus.equals(ATT_UPLOADING_STATUS)) {
            return ATT_UPLOADING;
        }
        if (attDbStatus.equals(ATT_ERROR_STATUS)) {
            return ATT_ERROR;
        }
        return ATT_CANCEL;
    }

    private static void removeRelateTableByAttIdAndBillPkId(String formId, String tableName, Object AttPkId, Object billPkId) {
        String sql = "DELETE FROM " + tableName + " WHERE FBasedataId = ? AND FId = ?";
        SqlParameter[] params = new SqlParameter[]{new SqlParameter(":FBasedataId", -5, AttPkId), new SqlParameter(":FId", -5, billPkId)};
        log.info("deleteSql --- DELETE FROM " + tableName + " WHERE FBasedataId = " + params[0] + " AND FId =" + params[1]);
        AttachmentFieldServiceHelper.executeDeleteSql(formId, sql, params);
    }

    private static void removeRelateTable(String formId, String tableName, Object pkId) {
        SqlParameter[] params = new SqlParameter[]{new SqlParameter(":FBasedataId", -5, pkId)};
        String sql = "DELETE FROM " + tableName + " WHERE FBasedataId = ?";
        log.info("deleteSql --- DELETE FROM " + tableName + " WHERE FBasedataId = " + params[0]);
        AttachmentFieldServiceHelper.executeDeleteSql(formId, sql, params);
    }

    private static void removeRelateTableByAttIdAndEntryId(String formId, String tableName, Object attPkId, Object entryPkId) {
        SqlParameter[] params = new SqlParameter[]{new SqlParameter(":FBasedataId", -5, attPkId), new SqlParameter(":FEntryId", -5, entryPkId)};
        String sql = "DELETE FROM " + tableName + " WHERE FBasedataId = ? AND FEntryId = ?";
        log.info("deleteSql --- DELETE FROM " + tableName + " WHERE FBasedataId = " + params[0] + " AND FEntryId =" + params[1]);
        AttachmentFieldServiceHelper.executeDeleteSql(formId, sql, params);
    }

    private static void removeRelateTableByAttIdAndDetailId(String formId, String tableName, Object AttPkId, Object fDetailId) {
        SqlParameter[] params = new SqlParameter[]{new SqlParameter(":FBasedataId", -5, AttPkId), new SqlParameter(":FDetailId", -5, fDetailId)};
        String sql = "DELETE FROM " + tableName + " WHERE FBasedataId = ? AND FDetailId = ?";
        log.info("deleteSql --- DELETE FROM " + tableName + " WHERE FBasedataId = " + params[0] + " AND FDetailId =" + params[1]);
        AttachmentFieldServiceHelper.executeDeleteSql(formId, sql, params);
    }

    private static void executeDeleteSql(String formId, String sql, SqlParameter[] params) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)formId);
        DBRoute dBRoute = new DBRoute(type.getDBRouteKey());
        DB.execute((DBRoute)dBRoute, (String)sql, (Object[])params);
    }

    private static String replaceSpeSymbol(String str) {
        for (int i = 0; i < SPECIAL_SYMBOLS.length; ++i) {
            if (!str.contains(SPECIAL_SYMBOLS[i])) continue;
            str = str.replace(SPECIAL_SYMBOLS[i], "_");
        }
        return str;
    }

    public static boolean checkIfHasAttProp(String formId) {
        Map propCollections = EntityMetadataCache.getDataEntityType((String)formId).getAllFields();
        for (Map.Entry propMap : propCollections.entrySet()) {
            if (!(propMap.getValue() instanceof AttachmentProp)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkIfTempAttTimeOut(String pageId) {
        QFilter[] filters = new QFilter[]{new QFilter(ATT_TEMPFILE, "=", (Object)ATT_TEMP_CHAR), new QFilter(BILL_PAGEID, "=", (Object)pageId), new QFilter(ATT_STATUS, "=", (Object)ATT_SUCCESS_STATUS)};
        String selectFields = "id,url,tempfile";
        DynamicObject[] att = BusinessDataServiceHelper.load((String)ATT_ENTITYID, (String)selectFields, (QFilter[])filters);
        for (int i = 0; i < att.length; ++i) {
            TempFileCache downLoad;
            String tempUrl = (String)att[i].get(ATT_URL);
            String filestatus = att[i].getString(ATT_TEMPFILE);
            if (!tempUrl.contains(CONFIG_KEY) || !ATT_TEMP_CHAR.equals(filestatus) || (downLoad = CacheFactory.getCommonCacheFactory().getTempFileCache()).exists(tempUrl)) continue;
            return true;
        }
        return false;
    }

    public static List<DynamicObject> getTimeOutAttList(String pageId) {
        ArrayList<DynamicObject> timeOutAttList = new ArrayList<DynamicObject>(10);
        QFilter[] filters = new QFilter[]{new QFilter(ATT_TEMPFILE, "=", (Object)ATT_TEMP_CHAR), new QFilter(BILL_PAGEID, "=", (Object)pageId), new QFilter(ATT_STATUS, "=", (Object)ATT_SUCCESS_STATUS)};
        String selectFields = "id,url,tempfile,name";
        DynamicObject[] att = BusinessDataServiceHelper.load((String)ATT_ENTITYID, (String)selectFields, (QFilter[])filters);
        for (int i = 0; i < att.length; ++i) {
            TempFileCache downLoad;
            String tempUrl = (String)att[i].get(ATT_URL);
            String filestatus = att[i].getString(ATT_TEMPFILE);
            if (!tempUrl.contains(CONFIG_KEY) || !ATT_TEMP_CHAR.equals(filestatus) || (downLoad = CacheFactory.getCommonCacheFactory().getTempFileCache()).exists(tempUrl)) continue;
            ILocaleString fileName = (ILocaleString)att[i].get(ATT_NAME);
            if (fileName != null && StringUtils.isBlank((CharSequence)((CharSequence)fileName.getItem(Lang.get().toString())))) {
                LocaleString newString = new LocaleString();
                Iterator iterator = fileName.values().iterator();
                if (iterator.hasNext()) {
                    newString.put((Object)Lang.get().toString(), iterator.next());
                    att[i].set(ATT_NAME, (Object)newString);
                }
            }
            timeOutAttList.add(att[i]);
        }
        return timeOutAttList;
    }

    public static DynamicObject getAttCreatorByUID(String Uid) {
        QFilter[] filters = new QFilter[]{new QFilter(ATT_UID, "=", (Object)Uid)};
        DynamicObject att = BusinessDataServiceHelper.loadSingleFromCache((String)ATT_ENTITYID, (QFilter[])filters);
        return att;
    }

    public static Map<String, Object> getBatchAttPreUrlByIds(long[] ids) {
        QFilter[] filters = new QFilter[]{new QFilter(ATT_ID, "in", (Object)ids)};
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)ATT_ENTITYID, (String)"id,tempfile,type,url", (QFilter[])filters);
        HashMap<String, Object> returnObjs = new HashMap<String, Object>();
        for (DynamicObject obj : objs) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String path = obj.getString(ATT_URL);
            if (path.contains("path=")) {
                path = StringUtils.substringAfter((String)path, (String)"path=");
                if ((path = URLDecoder.decode(path)).contains("&")) {
                    path = StringUtils.substringBefore((String)path, (String)"&");
                }
            }
            String type = obj.getString(ATT_TYPE);
            String id = obj.getString(ATT_ID);
            int tempfile = obj.getInt(ATT_TEMPFILE);
            if (tempfile == 1) {
                boolean enablePreView;
                String url = null;
                try {
                    url = URLEncoder.encode(path, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    map.put(ENABLE_PRE_VIEW, Boolean.FALSE);
                    map.put(ERR_MSG, String.format(ResManager.loadKDString((String)"URL\u7f16\u7801\u5931\u8d25\uff1a%s\u3002", (String)"AttachmentFieldServiceHelper_0", (String)BOS_SVC_METADATA, (Object[])new Object[0]), e.getMessage()));
                    returnObjs.put(id, map);
                    continue;
                }
                String attUrl = EncreptSessionUtils.encryptSession((String)UrlService.getAttachmentFullUrl((String)url));
                Map securityParam = ((IParameterReaderService)ServiceSvcFactory.getService(IParameterReaderService.class)).loadPublicParameterFromCache("bos_filesecurityparam");
                boolean bl = enablePreView = securityParam.size() == 0 ? Boolean.parseBoolean(System.getProperty("fileserver.attachment.preview")) : Boolean.parseBoolean(String.valueOf(securityParam.get("attpreviewable")));
                if (!enablePreView) {
                    map.put(ENABLE_PRE_VIEW, Boolean.FALSE);
                    map.put(ERR_MSG, ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u672a\u5f00\u542f\u9884\u89c8\u529f\u80fd", (String)"AttachmentFieldServiceHelper_1", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
                } else if (AttachmentFieldServiceHelper.ablePreView(type)) {
                    attUrl = attUrl.replace("download.do", "preview.do");
                    map.put(ENABLE_PRE_VIEW, Boolean.TRUE);
                    map.put("preViewUrl", attUrl);
                } else {
                    map.put(ENABLE_PRE_VIEW, Boolean.FALSE);
                    map.put(ERR_MSG, ResManager.loadKDString((String)"\u8be5\u6587\u4ef6\u7c7b\u578b\u4e0d\u652f\u6301\u9884\u89c8", (String)"AttachmentFieldServiceHelper_2", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
                }
            } else {
                map.put(ENABLE_PRE_VIEW, Boolean.FALSE);
                map.put(ERR_MSG, ResManager.loadKDString((String)"\u4e34\u65f6\u6587\u4ef6\u4e0d\u652f\u6301\u9884\u89c8", (String)"AttachmentFieldServiceHelper_3", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
            }
            returnObjs.put(id, map);
        }
        return returnObjs;
    }

    public static void saveMark(String uid, LocaleString description) {
        AttachmentFieldServiceHelper.saveMark(uid, description, null);
    }

    public static void saveMark(String uid, LocaleString description, String attPkId) {
        QFilter[] filters = AttachmentFieldServiceHelper.getQFilters(uid, attPkId);
        DynamicObject att = BusinessDataServiceHelper.loadSingle((String)ATT_ENTITYID, (QFilter[])filters);
        att.set(ATT_DECRIPTION, (Object)description);
        SaveServiceHelper.update((DynamicObject)att);
    }

    public static void saveDragSeq(Integer dragSeq, String attPkId) {
        if (StringUtils.isEmpty((CharSequence)attPkId)) {
            return;
        }
        QFilter[] filters = AttachmentFieldServiceHelper.getQFilters(null, attPkId);
        DynamicObject att = BusinessDataServiceHelper.loadSingle((String)ATT_ENTITYID, (QFilter[])filters);
        att.set(DRAGSEQ, (Object)dragSeq);
        SaveServiceHelper.update((DynamicObject)att);
    }

    private static QFilter[] getQFilters(String uid, String attPkId) {
        QFilter[] filters;
        if (StringUtils.isBlank((CharSequence)attPkId)) {
            filters = new QFilter[]{new QFilter(ATT_UID, "=", (Object)uid)};
        } else {
            Long pkId = Long.parseLong(attPkId);
            filters = new QFilter[]{new QFilter(ATT_ID, "=", (Object)pkId)};
        }
        return filters;
    }

    public static void rename(String uid, String name) {
        AttachmentFieldServiceHelper.rename(uid, name, null);
    }

    public static void rename(String uid, String name, String attPkId) {
        QFilter[] filters = AttachmentFieldServiceHelper.getQFilters(uid, attPkId);
        DynamicObject att = BusinessDataServiceHelper.loadSingleFromCache((String)ATT_ENTITYID, (QFilter[])filters);
        att.set(ATT_NAME, (Object)new LocaleString(name));
        SaveServiceHelper.update((DynamicObject)att);
    }

    public static boolean ablePreView(String type) {
        Map securityParam = ((IParameterReaderService)ServiceSvcFactory.getService(IParameterReaderService.class)).loadPublicParameterFromCache("bos_filesecurityparam");
        boolean enablePreView = securityParam.size() == 0 ? Boolean.parseBoolean(System.getProperty("fileserver.attachment.preview")) : Boolean.parseBoolean(String.valueOf(securityParam.get("attpreviewable")));
        return FileUtil.isExtExist((String)type) && enablePreView;
    }

    public static AttachmentDto getAttachmentInfoByAttPk(Object pkId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)ATT_ENTITYID);
        if (dynamicObject == null) {
            return new AttachmentDto();
        }
        String pageid = dynamicObject.getString(BILL_PAGEID);
        String billPkId = "";
        String entityNum = "";
        if (pageid != null && pageid.contains("_")) {
            String[] entityArr = pageid.split("_");
            if (entityArr.length == 3) {
                entityNum = entityArr[1];
            }
            billPkId = entityArr[entityArr.length - 1];
        }
        AttachmentDto attachmentDto = new AttachmentDto();
        attachmentDto.setAttPk(pkId);
        attachmentDto.setEntityNum(entityNum);
        attachmentDto.setBillPkId(billPkId);
        attachmentDto.setAttachmentType(AttachmentType.attachmentfield);
        attachmentDto.setCreateTime(dynamicObject.getDate(ATT_CREATETIME));
        attachmentDto.setFilename(dynamicObject.getString(ATT_NAME));
        attachmentDto.setSize(dynamicObject.getInt(ATT_SIZE));
        Object userId = dynamicObject.get(ATT_CREATOR);
        attachmentDto.setCreateUserId(userId == null ? "" : userId.toString());
        attachmentDto.setResourcePath(dynamicObject.getString(ATT_URL));
        return attachmentDto;
    }

    public static List<Map> getAttachmentRefList(Object pkId) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)ATT_ENTITYID);
        List allRefs = BaseDataRefrenceHelper.getAllRefs((BasedataEntityType)((BasedataEntityType)entityType), (Object)pkId);
        ArrayList<Map> refMapList = new ArrayList<Map>(allRefs.size());
        for (BaseDataRefenceKey ref : allRefs) {
            HashMap<String, Object> refMap = new HashMap<String, Object>(5);
            refMap.put("refEntityKey", ref.getRefEntityKey());
            refMap.put("basePKValue", ref.getBasePKValue());
            refMap.put("refCol", ref.getRefCol());
            refMap.put("baseTableName", ref.getBaseTableName());
            refMap.put("refTable", ref.getRefTable());
            Map allFields = EntityMetadataCache.getDataEntityType((String)ref.getRefEntityKey()).getAllFields();
            String entityNum = ref.getRefEntityKey();
            Object attPkId = pkId;
            String attKey = "";
            Long billPkId = 0L;
            Long entryPkId = 0L;
            String attTableName = ref.getRefTable();
            String entryTableName = "";
            for (Map.Entry entry : allFields.entrySet()) {
                String alias;
                IDataEntityProperty entityProperty = (IDataEntityProperty)entry.getValue();
                if (!(entityProperty instanceof AttachmentProp) || (alias = entityProperty.getAlias()) == null || !alias.equals(ref.getRefTable())) continue;
                attKey = entityProperty.getName();
                IDataEntityType attParentProperty = entityProperty.getParent();
                if (attParentProperty instanceof EntryType) {
                    entryTableName = attParentProperty.getAlias();
                    entryPkId = AttachmentFieldServiceHelper.queryIdByAttPkId(entityNum, attTableName, attPkId, Boolean.TRUE);
                    billPkId = AttachmentFieldServiceHelper.queryBillPkIdByEntryPkId(entityNum, entryTableName, entryPkId);
                    continue;
                }
                billPkId = AttachmentFieldServiceHelper.queryIdByAttPkId(entityNum, attTableName, attPkId, Boolean.FALSE);
            }
            refMap.put("attKey", attKey);
            refMap.put("billPkId", billPkId);
            refMap.put("entryPkId", entryPkId);
            refMap.put("attPkId", attPkId);
            refMapList.add(refMap);
        }
        return refMapList;
    }

    private static Long queryIdByAttPkId(String entityNum, String attTableName, Object attPkId, Boolean entryField) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityNum);
        DBRoute dbRoute = new DBRoute(type.getDBRouteKey());
        Object[] params = new SqlParameter[]{new SqlParameter(":FBasedataId", -5, attPkId)};
        String selectField = entryField != false ? "FENTRYID" : "FID";
        String sql = "SELECT " + selectField + " FROM " + attTableName + " WHERE FBasedataId = ?";
        return (Long)DB.query((DBRoute)dbRoute, (String)sql, (Object[])params, rs -> {
            if (rs.next()) {
                return rs.getLong(selectField);
            }
            return null;
        });
    }

    private static Long queryBillPkIdByEntryPkId(String entityNum, String entryTableName, Object entryPkId) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityNum);
        DBRoute dbRoute = new DBRoute(type.getDBRouteKey());
        Object[] params = new SqlParameter[]{new SqlParameter(":FENTRYId", -5, entryPkId)};
        String sql = "SELECT FID FROM " + entryTableName + " WHERE FENTRYId = ?";
        return (Long)DB.query((DBRoute)dbRoute, (String)sql, (Object[])params, rs -> {
            if (rs.next()) {
                return rs.getLong("FID");
            }
            return null;
        });
    }
}

