/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.report.attachfileservice.AttachFileService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import org.apache.commons.lang3.time.DateUtils;

public class ReportClearTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(ReportClearTask.class);
    private static final String FORMID_BOS_REPORT_RECORD = "bos_report_record";
    protected static final int BATCH_COUNT = 1000;
    protected static final String STORAGE_DAYS_KEY = "storageDays";
    protected static final int STORAGE_DAYS_DEFAULT = 30;
    private int storageDays;

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        LOG.info("\u6e05\u7406\u76d1\u63a7\u62a5\u544a\uff1a\u5f00\u59cb");
        Date startTime = TimeServiceHelper.now();
        Object storageDaysParam = params.get(STORAGE_DAYS_KEY);
        if (StringUtils.isNotBlank((Object)storageDaysParam)) {
            this.storageDays = Integer.parseInt(storageDaysParam.toString());
        }
        if (this.storageDays <= 0) {
            this.storageDays = 30;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)FORMID_BOS_REPORT_RECORD);
        String selectPropertys = "id,url";
        QFilter qFilter = new QFilter("createtime", "<", (Object)DateUtils.addDays((Date)new Date(), (int)(-this.storageDays)));
        QFilter[] filters = new QFilter[]{qFilter};
        int count = 0;
        while (true) {
            DataSet ds = QueryServiceHelper.queryDataSet((String)"ReportClearTaskbos_report_record", (String)FORMID_BOS_REPORT_RECORD, (String)selectPropertys, (QFilter[])filters, (String)"", (int)1000);
            Throwable throwable = null;
            try {
                if (!ds.hasNext()) break;
                ArrayList<Object> deleteIds = new ArrayList<Object>(1000);
                for (Row row : ds) {
                    deleteIds.add(row.get("id"));
                    if (!StringUtils.isNotBlank((Object)row.get("url"))) continue;
                    AttachFileService.removeFile((String)String.valueOf(row.get("url")));
                    LOG.info("\u5220\u9664\u6587\u4ef6\u6210\u529f\uff0c\u6587\u4ef6\u5730\u5740\uff1a" + row.get("url"));
                }
                int currentCount = deleteIds.size();
                DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])deleteIds.toArray(new Object[currentCount]));
                count += currentCount;
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
                continue;
            }
            break;
        }
        Date endTime = TimeServiceHelper.now();
        long ms = (endTime.getTime() - startTime.getTime()) / 1000L;
        LOG.info(String.format("\u6e05\u7406\u76d1\u63a7\u62a5\u544a\u7ed3\u675f\uff0c\u8017\u65f6%s\u79d2\uff0c\u5220\u9664%s\u6761", ms, count));
    }
}

