/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.constant.StatusEnum;
import kd.bos.entity.registcenter.ReportRecord;
import kd.bos.entity.registcenter.ReportRegist;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.report.IFileReport;
import kd.bos.service.report.ReportMessage;
import kd.bos.service.report.WordNoDownLoadReport;
import kd.bos.service.report.WordReport;
import kd.bos.service.report.attachfileservice.AttachFileService;
import kd.bos.service.report.callback.CallbackService;
import kd.bos.service.report.local.LogcalReportImpl;
import kd.bos.service.report.local.QueueConsumer;
import kd.bos.service.report.local.QueueProducer;
import kd.bos.service.report.local.SyncLocalReport;
import kd.bos.service.report.regist.ReportRecordService;
import kd.bos.service.report.regist.ReportRegistService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class ReportService {
    private Log logger = LogFactory.getLog(ReportService.class);
    private static final String BOS_SVC_MSERVICE_REPORT = "bos-svc-mservice-report";

    /*
     * Loose catch block
     */
    public void forceCreateReportByStatus(List<String> statusList) {
        List<ReportRegist> reportRegists = ReportRegistService.getAllRegistInfo();
        block12: for (ReportRegist reportRegist : reportRegists) {
            Throwable throwable;
            DataSet ds;
            String moudleKey = reportRegist.getMoudleKey();
            Integer overtime = reportRegist.getOverTime();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("moudlekey", "=", (Object)moudleKey));
            qFilters.add(new QFilter("createtime", "<", (Object)DateUtils.addSeconds((Date)new Date(), (int)(-overtime.intValue()))));
            qFilters.add(new QFilter("status", "in", statusList));
            String fields = "id, moudlekey, uniquekey, status, url, urltemp, modifytime, createtime";
            ReportService reportService = new ReportService();
            block13: while (true) {
                ds = QueryServiceHelper.queryDataSet((String)"ReportForceCreateTaskbos_report_record", (String)"bos_report_record", (String)fields, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"", (int)1000);
                throwable = null;
                if (!ds.hasNext()) continue block12;
                Iterator iterator2 = ds.iterator();
                while (true) {
                    if (!iterator2.hasNext()) continue block13;
                    Row row = (Row)iterator2.next();
                    ReportRecord reportRecord = new ReportRecord();
                    reportRecord.setId(row.getLong("id"));
                    reportRecord.setMoudleKey(row.getString("moudlekey"));
                    reportRecord.setUniquekey(row.getString("uniquekey"));
                    reportRecord.setStatus(row.getString("status"));
                    reportRecord.setUrl(row.getString("url"));
                    reportRecord.setUrltemp(row.getString("urltemp"));
                    reportRecord.setModifyTime(row.getDate("modifytime"));
                    reportRecord.setCreateTime(row.getDate("createtime"));
                    reportService.createWordByStatus(reportRecord);
                }
                break;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
    }

    public void createWordByStatus(ReportRecord reportRecord) {
        try {
            if (!this.isFileExist(reportRecord)) {
                ReportRecordService.updateStatusAndUrl(StatusEnum.F.name(), reportRecord.getMoudleKey(), reportRecord.getUniquekey(), null, null);
                CallbackService.callBack(this.buildReportMessage(reportRecord), null, StatusEnum.F, ResManager.loadKDString((String)"\u672a\u751f\u6210\u672c\u5730\u4e34\u65f6\u6587\u4ef6\u3002", (String)"ReportService_1", (String)BOS_SVC_MSERVICE_REPORT, (Object[])new Object[0]));
                this.deleteStaticMap(reportRecord);
                return;
            }
            IFileReport iFileReport = null;
            switch (reportRecord.getStatus()) {
                case "A": 
                case "B": {
                    iFileReport = new WordNoDownLoadReport(reportRecord.getMoudleKey(), reportRecord.getUniquekey());
                    if (!StringUtils.isEmpty((String)reportRecord.getUrltemp())) break;
                    LogcalReportImpl logcalReport = new LogcalReportImpl();
                    reportRecord.setUrltemp(logcalReport.getFilePath(reportRecord.getMoudleKey(), reportRecord.getUniquekey()));
                    break;
                }
                case "C": 
                case "D": {
                    iFileReport = new WordReport(reportRecord.getMoudleKey(), reportRecord.getUniquekey());
                    break;
                }
            }
            if (iFileReport == null) {
                return;
            }
            String url = iFileReport.creteReport(reportRecord.getUrltemp());
            this.removeFile(reportRecord);
            this.deleteStaticMap(reportRecord);
            ReportRecordService.updateStatusAndUrl(StatusEnum.S.name(), reportRecord.getMoudleKey(), reportRecord.getUniquekey(), url, null);
            CallbackService.callBack(this.buildReportMessage(reportRecord), url, StatusEnum.S, null);
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
    }

    private ReportMessage buildReportMessage(ReportRecord reportRecord) {
        ReportMessage reportMessage = new ReportMessage();
        reportMessage.setMoudleKey(reportRecord.getMoudleKey());
        reportMessage.setUniqueKey(reportRecord.getUniquekey());
        return reportMessage;
    }

    private void removeFile(ReportRecord reportRecord) {
        String status;
        switch (status = reportRecord.getStatus()) {
            case "A": 
            case "B": {
                LogcalReportImpl iLocalReport = new LogcalReportImpl();
                iLocalReport.deleteFile(reportRecord.getMoudleKey(), reportRecord.getUniquekey());
                break;
            }
            case "C": 
            case "D": {
                AttachFileService.removeFile(reportRecord.getUrltemp());
                break;
            }
        }
    }

    private void deleteStaticMap(ReportRecord reportRecord) {
        String key = reportRecord.getMoudleKey() + reportRecord.getUniquekey();
        QueueConsumer.consumerCountMap.remove(key);
        SyncLocalReport.firstConsumer.remove(key);
        SyncLocalReport.doAfterMap.remove(key);
        QueueProducer.reportDateMap.remove(key);
    }

    private boolean isFileExist(ReportRecord reportRecord) {
        if ("A".equals(reportRecord.getStatus()) || "B".equals(reportRecord.getStatus())) {
            LogcalReportImpl iLocalReport = new LogcalReportImpl();
            return iLocalReport.isFileExist(reportRecord.getMoudleKey(), reportRecord.getUniquekey());
        }
        return true;
    }
}

