/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.report;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.report.attachfileservice.AttachFileService;

public class AbstractReport {
    private Log log = LogFactory.getLog(AbstractReport.class);
    public String moudleKey;
    public String uniqueKey;

    public AbstractReport(String moudleKey, String uniqueKey) {
        this.moudleKey = moudleKey;
        this.uniqueKey = uniqueKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReportData> resolveTxt(String path) {
        ArrayList<ReportData> cotents = new ArrayList(10);
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            String value;
            inputStream = AttachFileService.downLoadFile(path);
            inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            while (!StringUtils.isEmpty((CharSequence)(value = bufferedReader.readLine()))) {
                ReportData reportData = (ReportData)SerializationUtils.fromJsonString((String)value, ReportData.class);
                cotents.add(reportData);
            }
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                this.log.error((Throwable)e);
            }
        }
        cotents = cotents.stream().sorted(Comparator.comparing(a -> a.getReportItems().getOrder())).collect(Collectors.toList());
        return cotents;
    }
}

