/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.report;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPRow;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportData;
import kd.bos.entity.report.ReportItems;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.report.AbstractReport;
import kd.bos.service.report.IFileReport;
import kd.bos.service.report.attachfileservice.AttachFileService;

public class PdfReport
extends AbstractReport
implements IFileReport {
    private static final Log log = LogFactory.getLog(PdfReport.class);

    public PdfReport(String moudleKey, String uniqueKey) {
        super(moudleKey, uniqueKey);
    }

    @Override
    public String creteReport(String path) {
        List<ReportData> reportDataList = this.resolveTxt(path);
        InputStream inputStream = this.creteFile(reportDataList);
        String url = AttachFileService.upLoadWordFile(inputStream, this.moudleKey, this.uniqueKey);
        return url;
    }

    @Override
    public List<ReportData> resolveTxt(String path) {
        InputStream inputStream = AttachFileService.downLoadFile(path);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        ArrayList<ReportData> cotents = new ArrayList<ReportData>();
        while (true) {
            try {
                String value;
                while (!StringUtils.isEmpty((CharSequence)(value = bufferedReader.readLine()))) {
                    ReportData reportData = (ReportData)SerializationUtils.fromJsonString((String)value, ReportData.class);
                    cotents.add(reportData);
                }
            }
            catch (IOException e) {
                log.error((Throwable)e);
                continue;
            }
            break;
        }
        cotents = cotents.stream().sorted(Comparator.comparing(a -> a.getReportItems().getOrder())).collect(Collectors.toList());
        return cotents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream creteFile(List<ReportData> reportDataList) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PdfWriter writer = null;
        ByteArrayInputStream inputStream = null;
        Document doc = new Document();
        try {
            writer = PdfWriter.getInstance((Document)doc, (OutputStream)outputStream);
            doc.open();
            int i = 0;
            for (ReportData reportData : reportDataList) {
                if (i == 0) {
                    this.createParagraph(doc, reportData.getReportTitle());
                }
                this.createParagraph(doc, reportData.getReportItems().getPartTitle());
                this.createTable(doc, reportData.getReportItems());
                ++i;
            }
            inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
            if (writer != null) {
                writer.close();
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return inputStream;
    }

    public void createTable(Document doc, ReportItems reportItems) throws DocumentException {
        int rows = reportItems.getCells().size();
        int cols = ((List)reportItems.getCells().get(0)).size();
        PdfPTable table = new PdfPTable(cols);
        table.setWidthPercentage(100.0f);
        table.setSpacingBefore(10.0f);
        table.setSpacingAfter(10.0f);
        ArrayList listRow = table.getRows();
        for (int i = 0; i < rows; ++i) {
            PdfPCell[] cells = new PdfPCell[cols];
            for (int j = 0; j < cols; ++j) {
                cells[j] = new PdfPCell((Phrase)new Paragraph((String)((List)reportItems.getCells().get(i)).get(j)));
                cells[j].setPaddingLeft(20.0f);
                cells[j].setHorizontalAlignment(1);
                cells[j].setVerticalAlignment(5);
            }
            PdfPRow row = new PdfPRow(cells);
            listRow.add(row);
        }
        doc.add((Element)table);
    }

    public void createParagraph(Document doc, String title) throws DocumentException {
        doc.add((Element)new Paragraph(title));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream docWriteFileInputStream(Document document) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (PdfWriter writer = null;){
            writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        return inputStream;
    }

    @Override
    public String getFileName(String moudleKey, String uniqueKey) {
        StringBuilder fileName = new StringBuilder();
        fileName.append(moudleKey);
        fileName.append(uniqueKey);
        fileName.append(".pdf");
        return fileName.toString();
    }
}

