/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.report;

import kd.bos.entity.constant.StatusEnum;
import kd.bos.entity.registcenter.ReportRecord;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.service.report.ReportMessage;
import kd.bos.service.report.WordReport;
import kd.bos.service.report.attachfileservice.AttachFileService;
import kd.bos.service.report.callback.CallbackService;
import kd.bos.service.report.regist.ReportRecordService;
import kd.bos.util.StringUtils;

public class ReportConsumer
implements MessageConsumer {
    private Log logger = LogFactory.getLog(ReportConsumer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        try {
            this.logger.info("\u63a5\u6536\u5230\u6d88\u606f\uff1amessage:" + body + " resend:" + resend);
            if (body == null) {
                this.logger.warn("\u62a5\u544a\u6d88\u606f\u4f53\u4e3a\u7a7a\uff0c\u9000\u51fa\u6d88\u8d39\u3002body\uff1a" + body);
                return;
            }
            this.logger.info("\u5f00\u59cb\u6d88\u8d39\u751f\u6210\u62a5\u544a.......");
            ReportMessage reportMessage = (ReportMessage)body;
            ReportRecord reportRecord = ReportRecordService.getReportRecord(reportMessage.getMoudleKey(), reportMessage.getUniqueKey());
            if (reportRecord == null) {
                this.logger.info("\u672a\u67e5\u8be2\u5230\u62a5\u544a\u8bb0\u5f55\uff0cbody\uff1a" + body);
                return;
            }
            WordReport wordReport = new WordReport(reportMessage.getMoudleKey(), reportMessage.getUniqueKey());
            if (StringUtils.isEmpty((String)reportRecord.getUrltemp())) {
                this.logger.info("\u62a5\u544a\u8bb0\u5f55urltemp\u4e3a\u7a7a\uff0cbody\uff1a" + body);
                return;
            }
            String url = wordReport.creteReport(reportRecord.getUrltemp());
            if (StringUtils.isEmpty((String)url)) {
                this.logger.info("\u751f\u6210\u62a5\u544aurl\u4e3a\u7a7a\uff0cbody\uff1a" + body);
                return;
            }
            AttachFileService.removeFile(reportRecord.getUrltemp());
            ReportRecordService.updateStatusAndUrl(StatusEnum.S.name(), reportRecord.getMoudleKey(), reportRecord.getUniquekey(), url, null);
            CallbackService.callBack(reportMessage, url, StatusEnum.S, null);
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
        finally {
            acker.ack(messageId);
        }
    }
}

