/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.report;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.ReportData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.report.WordReport;

public class WordNoDownLoadReport
extends WordReport {
    private static Log LOGGER = LogFactory.getLog(WordNoDownLoadReport.class);

    public WordNoDownLoadReport(String moudleKey, String uniqueKey) {
        super(moudleKey, uniqueKey);
    }

    @Override
    public List<ReportData> resolveTxt(String filePath) {
        List<Object> cotents = new ArrayList<ReportData>(10);
        File file = new File(filePath);
        if (!file.exists()) {
            return Collections.emptyList();
        }
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String lineTxt = null;
            while ((lineTxt = br.readLine()) != null) {
                ReportData reportData = (ReportData)SerializationUtils.fromJsonString((String)lineTxt, ReportData.class);
                cotents.add(reportData);
            }
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
        }
        if (!cotents.isEmpty()) {
            cotents = cotents.stream().sorted(Comparator.comparing(a -> a.getReportItems().getOrder())).collect(Collectors.toList());
        }
        return cotents;
    }
}

