/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.report;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import kd.bos.entity.report.ReportData;
import kd.bos.entity.report.ReportItems;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.report.AbstractReport;
import kd.bos.service.report.IFileReport;
import kd.bos.service.report.attachfileservice.AttachFileService;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblLayoutType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblLayoutType;

public class WordReport
extends AbstractReport
implements IFileReport {
    private static Log log = LogFactory.getLog(WordReport.class);

    public WordReport(String moudleKey, String uniqueKey) {
        super(moudleKey, uniqueKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String creteReport(String path) {
        String url = null;
        XWPFDocument xwpfDocument = null;
        InputStream inputStream = null;
        try {
            List<ReportData> reportDataList = this.resolveTxt(path);
            xwpfDocument = this.creteFile(reportDataList);
            inputStream = this.docWriteFileInputStream(xwpfDocument);
            url = AttachFileService.upLoadWordFile(inputStream, this.moudleKey, this.uniqueKey);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        finally {
            try {
                if (xwpfDocument != null) {
                    xwpfDocument.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
        return url;
    }

    public XWPFDocument creteFile(List<ReportData> reportDataList) {
        XWPFDocument doc = new XWPFDocument();
        int i = 0;
        for (ReportData reportData : reportDataList) {
            if (i == 0) {
                this.createParagraph(doc, reportData.getReportTitle(), 20, ParagraphAlignment.CENTER);
            }
            this.createParagraph(doc, reportData.getReportItems().getPartTitle(), 18, ParagraphAlignment.LEFT);
            this.createTable(doc, reportData.getReportItems());
            ++i;
        }
        return doc;
    }

    public void createTable(XWPFDocument doc, ReportItems reportItems) {
        if (reportItems == null || reportItems.getCells() == null || reportItems.getCells().size() == 0) {
            return;
        }
        int rows = reportItems.getCells().size();
        int cols = ((List)reportItems.getCells().get(0)).size();
        XWPFTable table = doc.createTable(rows, cols);
        this.setTableWidthFixed(table);
        table.setCellMargins(3, 5, 3, cols);
        for (int j = 0; j < rows; ++j) {
            XWPFTableRow row = table.getRow(j);
            row.setHeight(400);
            for (int i = 0; i < cols; ++i) {
                XWPFTableCell cell = row.getCell(i);
                XWPFParagraph xwpfParagraph = (XWPFParagraph)cell.getParagraphs().get(0);
                xwpfParagraph.setAlignment(ParagraphAlignment.CENTER);
                XWPFRun run = xwpfParagraph.createRun();
                run.setFontSize(11);
                if (j == 0) {
                    run.setBold(true);
                    run.setText((String)((List)reportItems.getCells().get(j)).get(i));
                    continue;
                }
                run.setText((String)((List)reportItems.getCells().get(j)).get(i));
            }
        }
    }

    public void setTableWidthFixed(XWPFTable table) {
        CTTblPr tblPr = table.getCTTbl().getTblPr();
        CTTblLayoutType tblLayout = tblPr.isSetTblLayout() ? tblPr.getTblLayout() : tblPr.addNewTblLayout();
        tblLayout.setType(STTblLayoutType.FIXED);
        table.setWidth(7000);
    }

    public void createParagraph(XWPFDocument doc, String title, int fontSize, ParagraphAlignment paragraphAlignment) {
        XWPFParagraph partTitlePara = doc.createParagraph();
        partTitlePara.setAlignment(ParagraphAlignment.valueOf((String)paragraphAlignment.name()));
        XWPFRun partRun = partTitlePara.createRun();
        partRun.setFontSize(fontSize);
        partRun.setText(title);
        partRun.setBold(true);
    }

    public InputStream docWriteFileInputStream(XWPFDocument document) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            document.write((OutputStream)baos);
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(baos.toByteArray());
        return inputStream;
    }

    @Override
    public String getFileName(String moudleKey, String uniqueKey) {
        StringBuilder fileName = new StringBuilder();
        fileName.append(moudleKey);
        fileName.append(uniqueKey);
        fileName.append(".docx");
        return fileName.toString();
    }
}

