/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.report.attachfileservice;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import kd.bos.context.RequestContext;
import kd.bos.entity.report.ReportCotent;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.attachment.FileItemExt;
import kd.bos.service.attachment.FileSource;
import kd.bos.service.report.WordReport;
import kd.bos.service.report.local.LogcalReportImpl;
import kd.bos.util.FileNameUtils;
import kd.bos.util.StringUtils;

public class AttachFileService {
    private static Log log = LogFactory.getLog(AttachFileService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String upLoadFile(ReportCotent reportCotent, LogcalReportImpl iLocalReport) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        RequestContext requestContext = RequestContext.get();
        String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)"report", (String)iLocalReport.getFileName(reportCotent.getMoudleKey(), reportCotent.getUniqueKey()));
        File file = iLocalReport.getFile(reportCotent.getMoudleKey(), reportCotent.getUniqueKey());
        FileInputStream fileInputStream = null;
        String path = null;
        try {
            fileInputStream = new FileInputStream(file);
            FileItemExt item = new FileItemExt(iLocalReport.getFileName(reportCotent.getMoudleKey(), reportCotent.getUniqueKey()), pathParam, (InputStream)fileInputStream);
            item.setSource(FileSource.ATTACHMENT_BOTP);
            path = fileService.upload((FileItem)item);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String upLoadWordFile(InputStream inputStream, String moudleKey, String uniqueKey) {
        String path = null;
        try {
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            RequestContext requestContext = RequestContext.get();
            WordReport wordReport = new WordReport(moudleKey, uniqueKey);
            String fileName = wordReport.getFileName(moudleKey, uniqueKey);
            String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)"reportWord", (String)fileName);
            path = null;
            if (inputStream != null) {
                FileItemExt item = new FileItemExt(fileName, pathParam, inputStream);
                item.setSource(FileSource.ATTACHMENT_BOTP);
                path = fileService.upload((FileItem)item);
            }
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
        }
        return path;
    }

    public static void removeFile(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return;
        }
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        fileService.delete(path);
    }

    public static InputStream downLoadFile(String path) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        return fileService.getInputStream(path);
    }
}

