/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.report.local;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportCotent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.report.local.ILocalReport;
import kd.bos.service.report.local.QueueProducer;
import kd.bos.util.FileUtils;

public class LogcalReportImpl
implements ILocalReport {
    private static Log log = LogFactory.getLog(LogcalReportImpl.class);
    String property = System.getProperty("user.home");
    String FILEPATH = FileUtils.cleanString((String)(this.property + File.separator + "watchreport" + File.separator));

    @Override
    public void creLocalReport(ReportCotent reportCotent) {
        File file = this.getFile(reportCotent.getMoudleKey(), reportCotent.getUniqueKey());
        long fileMaxSize = 0x3200000L;
        if (file.length() > fileMaxSize) {
            log.info("\u6587\u4ef6\u8fc7\u5927\uff0c\u4e0d\u518d\u8ffd\u52a0\uff0ckey:" + reportCotent.getUniqueKey());
            return;
        }
        try (BufferedWriter br = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file, true)));){
            String dataJson = this.getDataJson(reportCotent);
            if (StringUtils.isNotEmpty((CharSequence)dataJson)) {
                br.write(dataJson + "\r\n");
            }
        }
        catch (IOException ioException) {
            log.error((Throwable)ioException);
        }
    }

    private String getDataJson(ReportCotent reportCotent) {
        if (reportCotent != null && reportCotent.getData() != null) {
            return SerializationUtils.toJsonString((Object)reportCotent.getData());
        }
        return null;
    }

    @Override
    public String getFilePath(String moudleKey, String uniqueKey) {
        StringBuilder path = new StringBuilder();
        path.append(this.FILEPATH);
        if (QueueProducer.reportDateMap.get(moudleKey + uniqueKey) != null) {
            path.append(new SimpleDateFormat("yyyyMMdd").format(QueueProducer.reportDateMap.get(moudleKey + uniqueKey)));
            path.append(File.separator);
        }
        path.append(moudleKey);
        path.append(uniqueKey);
        path.append(".txt");
        return path.toString();
    }

    public String getFileName(String moudleKey, String uniqueKey) {
        StringBuilder fileName = new StringBuilder();
        fileName.append(moudleKey);
        fileName.append(uniqueKey);
        fileName.append(".txt");
        return fileName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getFile(String moudleKey, String uniqueKey) {
        String filePath;
        File fileItem;
        String dateStr = new SimpleDateFormat("yyyyMMdd").format(QueueProducer.reportDateMap.get(moudleKey + uniqueKey));
        String filePathHead = this.FILEPATH + dateStr + File.separator;
        File file = new File(filePathHead);
        if (!file.exists()) {
            try {
                File file2 = file;
                synchronized (file2) {
                    file.mkdirs();
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        if (!(fileItem = new File(filePath = this.getFilePath(moudleKey, uniqueKey))).exists()) {
            try {
                File file3 = fileItem;
                synchronized (file3) {
                    boolean status = fileItem.createNewFile();
                    if (status) {
                        log.info("createNewFile success!");
                    }
                }
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
        return fileItem;
    }

    public boolean isFileExist(String moudleKey, String uniqueKey) {
        String filePath = this.getFilePath(moudleKey, uniqueKey);
        File file = new File(filePath);
        return file.exists();
    }

    @Override
    public void deleteFile(String moudleKey, String uniqueKey) {
        try {
            String filePath = this.getFilePath(moudleKey, uniqueKey);
            Files.delete(Paths.get(filePath, new String[0]));
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
    }

    public void deleteFile(String filePath) {
        try {
            Files.delete(Paths.get(filePath, new String[0]));
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
    }
}

